/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.test;

import com.integratedgraphics.extractor.DOICrawler;
import java.util.HashMap;
import java.util.Map;
import org.iupac.fairdata.common.IFDUtil;

public class ICLDOICrawler
extends DOICrawler {
    public ICLDOICrawler() {
        super(new String[0]);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"10.14469/hpc/10386", "c:/temp/iupac/crawler"};
        }
        ICLDOICrawler crawler = new ICLDOICrawler();
        crawler.setCustomizer(new ICLCustomizer(crawler));
        crawler.crawl();
    }

    public static class ICLCustomizer
    implements DOICrawler.DOICustomizer {
        private static String[] ignoreURLs = new String[0];
        private static Map<String, String> hackMap = new HashMap<String, String>();
        private ICLDOICrawler crawler;

        public ICLCustomizer(DOICrawler crawler) {
            hackMap.put("INCHI", "IFD.representation.structure.inchi");
            hackMap.put("SMILES", "IFD.representation.structure.smiles");
            hackMap.put("INCHIKEY", "IFD.representation.structure.inchikey");
            hackMap.put("NMR_SOLVENT", "IFD.property.dataobject.fairspec.nmr.expt_solvent");
            hackMap.put("NMR_NUCLEUS", "IFD.property.dataobject.fairspec.nmr.expt_nucl1");
            hackMap.put("NMR_NUCLEUS1", "IFD.property.dataobject.fairspec.nmr.expt_nucl1");
            hackMap.put("NMR_NUCLEUS2", "IFD.property.dataobject.fairspec.nmr.expt_nucl2");
            hackMap.put("NMR_EXPT", "IFD.property.dataobject.fairspec.nmr.expt_name");
            hackMap.put("IFD.IR", "IFD.property.dataobject.fairspec.ir.description");
            hackMap.put("IFD.XRAY", "IFD.property.dataobject.fairspec.xrd.description");
            hackMap.put("IFD.COMP", "IFD.property.dataobject.fairspec.comp.description");
            this.crawler = (ICLDOICrawler)crawler;
        }

        @Override
        public boolean ignoreURL(String url) {
            int i = ignoreURLs.length;
            while (--i >= 0) {
                if (!url.equalsIgnoreCase(ignoreURLs[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String customizeSubjectKey(String key) {
            String mappedKey = hackMap.get(key.toUpperCase());
            return mappedKey == null ? key : mappedKey;
        }

        @Override
        public boolean customizeText(String key, String val) {
            if (val.length() < 3) {
                return false;
            }
            block6 : switch (key) {
                case "References": {
                    this.crawler.addError("!RelatedIdentifier.References value ignored: " + val + " in " + this.crawler.doiRecord);
                    break;
                }
                case "subject": {
                    switch (val) {
                        case "Crystal Structure": {
                            this.crawler.setDataObjectType("xrd");
                        }
                    }
                    break;
                }
                case "description": {
                    break;
                }
                case "title": {
                    switch (val.substring(0, 3)) {
                        default: {
                            if (val.indexOf("-ray") < 0 && val.indexOf("rystal") < 0) break block6;
                            this.crawler.setDataObjectType("xrd");
                            break block6;
                        }
                        case "IR ": {
                            this.crawler.setDataObjectType("ir");
                            break block6;
                        }
                        case "Com": 
                    }
                    if (!val.startsWith("Compound ")) break;
                    String id = this.crawler.newCompound("" + IFDUtil.parsePositiveInt(val.substring(9)));
                    this.crawler.addAttr("IFD.property.fairspec.compound.id", id);
                }
            }
            return false;
        }
    }
}

