/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;

public class ByteBlockReader {
    public static boolean testing = false;
    public static boolean showInts = false;
    public static boolean showChars = false;
    private RewindableInputStream in;
    private byte[] buf = new byte[1];
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private long position = 0L;
    private ByteBuffer buffer;
    private long mark;

    public ByteBlockReader(InputStream in) throws IOException {
        this(FAIRSpecUtilities.getLimitedStreamBytes(in, -1L, null, true, true));
    }

    public ByteBlockReader(byte[] bytes) {
        this.in = new RewindableInputStream(bytes);
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        if (this.buffer != null) {
            this.buffer.order(byteOrder);
        }
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public long readPosition() {
        return this.position;
    }

    public byte[] setBuf(int len) throws IOException {
        if (this.buf.length < len) {
            this.buf = new byte[len << 1];
            this.buffer = ByteBuffer.wrap(this.buf);
            this.buffer.order(this.byteOrder);
        }
        this.buffer.rewind();
        int n = this.in.read(this.buf, 0, len);
        if (n != len) {
            throw new EOFException("Tried to read " + len + " bytes but read only " + n);
        }
        this.position += (long)len;
        return this.buf;
    }

    public int readAvailable() throws IOException {
        return this.in.available();
    }

    private void markIn(int n) {
        this.mark = this.position;
        this.in.mark(n);
    }

    public void resetIn() throws IOException {
        this.position = this.mark;
        this.in.reset();
    }

    public void skipIn(int n) throws IOException {
        if (n > 0) {
            this.position += this.in.skip(n);
        }
        if (testing) {
            System.out.println("skip from " + (this.position - (long)n) + " by " + n + " to " + this.position);
        }
    }

    public void seekIn(long loc) throws IOException {
        if (this.readPosition() > loc) {
            this.rewindIn();
        }
        this.skipIn((int)(loc - this.readPosition()));
    }

    public long readPointer() throws IOException {
        int len = this.readInt();
        long pos = this.readPosition();
        return pos + (long)len;
    }

    public long readLongPtr() throws IOException {
        long len = this.readLong();
        long pos = this.readPosition();
        return pos + len;
    }

    public boolean checkMagicNumber(int magicNumber) throws IOException {
        int nAvail = this.readAvailable();
        if (nAvail < 4) {
            return false;
        }
        return this.peekInt() == magicNumber;
    }

    public int readByte() throws IOException {
        ++this.position;
        int b = this.in.read();
        if (testing && showInts) {
            this.dump("Byte", b, 1, Integer.toHexString(b).toUpperCase(), "");
        }
        return b;
    }

    public int readShort() throws IOException {
        this.setBuf(2);
        short i = this.buffer.getShort();
        if (testing && showInts) {
            this.dump("Short", i, 2, Integer.toHexString(i).toUpperCase(), "");
        }
        return i;
    }

    public int readInt() throws IOException {
        this.setBuf(4);
        int i = this.buffer.getInt();
        if (testing && showInts) {
            this.dump("Int", i, 4, this.toHex(i), showChars ? this.showString(this.getBuf(), 0, 4) : "");
        }
        return i;
    }

    private String showString(byte[] buf, int pt, int len) {
        String st = new String(buf, pt, len);
        String s = "";
        for (int i = 0; i < st.length(); ++i) {
            int c = st.codePointAt(i);
            s = c >= 32 && c <= 125 ? s + st.substring(i, i + 1) : s + " <" + Integer.toHexString(c) + "> ";
        }
        return s;
    }

    public long readLong() throws IOException {
        this.setBuf(8);
        long l = this.buffer.getLong();
        if (testing && showInts) {
            this.dump("Long", l, 8, this.toHex(l), "");
        }
        return l;
    }

    private void dump(String type, long val, int len, String hex, String s) {
        System.out.println("read" + type + " " + (this.position - (long)len) + ": " + hex + " = " + val + (type == "Int" ? " -> " + (this.position + val) : "") + " " + s);
    }

    private String toHex(int i) {
        String s = "00000000" + Integer.toHexString(i).toUpperCase();
        return "0x" + s.substring(s.length() - 8);
    }

    private String toHex(long i) {
        String s = "0000000000000000" + Long.toHexString(i).toUpperCase();
        return "0x" + s.substring(s.length() - 16);
    }

    public double readDouble() throws IOException {
        this.setBuf(8);
        double d = this.buffer.getDouble();
        this.buffer.position(this.buffer.position() - 8);
        long l = this.buffer.getLong();
        if (testing) {
            System.out.println("ReadDouble 0x" + Long.toHexString(l).toUpperCase() + "\t" + d);
        }
        return d;
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        int n = this.in.read(b, offset, len);
        this.position += (long)n;
        return n;
    }

    public byte[] readBytes(long len) throws IOException {
        int l = (int)len;
        byte[] bytes = new byte[l];
        this.read(bytes, 0, l);
        return bytes;
    }

    public String readSimpleString(int len) throws IOException {
        String s = new String(this.setBuf(len), 0, len);
        if (testing) {
            System.out.println("readString >" + s + "<");
        }
        return s.trim();
    }

    public String readLenStringSafely() throws IOException {
        int len = this.readInt();
        long b = this.peekInt();
        return (b & 0xFFFFFFFFFF00FF00L) == 0L ? this.readUTF16String(len) : this.readSimpleString(len);
    }

    public String readUTF16String() throws IOException {
        return this.readUTF16String(this.readInt());
    }

    public String readUTF16String(int len) throws IOException {
        long p = this.readPosition();
        this.setBuf(len);
        String s = new String(this.buf, 0, len, "utf16");
        if (testing) {
            System.out.println("ReadUTF16 " + p + "(" + len + ") >" + s + "<");
        }
        return s;
    }

    public void readInts(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (testing) {
                System.out.print(i + " ");
            }
            this.readInt();
        }
    }

    public int peekByte() throws IOException {
        this.markIn(1);
        int n = this.readByte();
        this.resetIn();
        if (testing) {
            System.out.println("peekByte " + n);
        }
        return n;
    }

    public int peekInt() throws IOException {
        this.markIn(4);
        int n = this.readInt();
        this.resetIn();
        if (testing && showInts) {
            System.out.println("peekInt " + n);
        }
        return n;
    }

    public int findInts(int[] key, int length, boolean isAll) throws IOException {
        if (length < 0) {
            length = this.readAvailable();
        }
        this.markIn(length);
        this.setBuf(length);
        this.resetIn();
        int keylen = key.length;
        ByteBuffer b = this.buffer;
        this.buf = new byte[0];
        int found = -1;
        int i = 0;
        int n = length - keylen * 4;
        block0: while (i < n) {
            int j = 0;
            do {
                int test;
                if ((test = b.getInt()) == key[j]) continue;
                b.position(++i);
                continue block0;
            } while (++j != keylen);
            if (isAll) {
                if (found == -1) {
                    found = i;
                }
                b.position(++i);
                System.out.println("byteBlock found pos=" + i);
                continue;
            }
            return i;
        }
        return found;
    }

    public int findBytes(byte[] key, int length, boolean isAll, int nPre0) throws IOException {
        if (length < 0) {
            length = this.readAvailable();
        }
        this.markIn(length);
        this.setBuf(length);
        this.resetIn();
        int keylen = key.length;
        ByteBuffer b = this.buffer;
        this.buf = new byte[0];
        int found = -1;
        byte b0 = key[0];
        int i = 0;
        int n = length - keylen;
        block0: while (i < n) {
            int j = 0;
            int ptb0 = 0;
            do {
                byte test;
                if ((test = b.get()) == b0 && ptb0 == 0) {
                    ptb0 = j;
                }
                if (test == key[j]) continue;
                b.position(i += ptb0 == 0 ? j + 1 : ptb0);
                continue block0;
            } while (++j != keylen);
            if (nPre0 > 0) {
                boolean isOK;
                boolean bl = isOK = i >= nPre0;
                if (isOK) {
                    for (int k = 1; k <= nPre0; ++k) {
                        if (b.get(i - k) == 0) continue;
                        isOK = false;
                        break;
                    }
                }
                if (!isOK) {
                    b.position(++i);
                    continue;
                }
            }
            if (isAll) {
                if (found == -1) {
                    found = i;
                }
                System.out.println("byteBlock found pos=" + i);
                b.position(i += ptb0 == 0 ? j + 1 : ptb0);
                continue;
            }
            return i;
        }
        return found;
    }

    public int getBufferPosition() {
        return this.buffer.position();
    }

    public void markBuffer() {
        this.buffer.mark();
    }

    public void resetBuffer() {
        this.buffer.reset();
    }

    public void close() throws IOException {
        this.position = -1L;
        this.in.close();
    }

    public byte getByte() {
        return this.buffer.get();
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public int getShort() {
        return this.buffer.getShort();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public ByteBuffer get(byte[] b, int offset, int len) {
        return this.buffer.get(b, offset, len);
    }

    public void peekInts(int n) throws IOException {
        if (this.readAvailable() == 0) {
            return;
        }
        System.out.println("PeekInts " + n + " pos=" + this.readPosition() + " navail=" + this.readAvailable());
        boolean bt = testing;
        boolean bi = showInts;
        boolean bc = showChars;
        showChars = true;
        showInts = true;
        testing = true;
        this.markIn(n * 4);
        this.readInts(n);
        this.resetIn();
        testing = bt;
        showInts = bi;
        showChars = bc;
    }

    public void peekIntsAt(long pos, int n) throws IOException {
        boolean l = testing;
        boolean l1 = showInts;
        showInts = true;
        testing = true;
        long pos0 = this.readPosition();
        this.setPosition(pos);
        this.readInts(n);
        this.setPosition(pos0);
        testing = l;
        showInts = l1;
    }

    public int findDouble(double d, int length, boolean isAll) throws IOException {
        long l = Double.doubleToLongBits(d);
        int high = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int low = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        return this.findInts(new int[]{high, low}, length, isAll);
    }

    public int findDoubleApprox(double d, int nBytes, int length, boolean isAll) throws IOException {
        ByteBuffer dbuf = ByteBuffer.allocate(8);
        dbuf.putDouble(d);
        byte[] bytes = dbuf.array();
        nBytes = Math.max(2, Math.min(nBytes, 8));
        if (length < 0) {
            length = this.readAvailable();
        }
        this.markIn(length);
        this.setBuf(length);
        this.resetIn();
        ByteBuffer b = this.buffer;
        this.buf = new byte[0];
        int found = -1;
        int i = 0;
        int n = length - 8;
        block0: while (i < n) {
            int j = 0;
            do {
                byte test;
                if ((test = b.get()) == bytes[j]) continue;
                b.position(++i);
                continue block0;
            } while (++j != nBytes);
            if (isAll) {
                if (found == -1) {
                    found = i;
                }
                System.out.println(i);
                b.position(++i);
                continue;
            }
            return i;
        }
        return found;
    }

    public void findRef(int loc) throws IOException {
        int n = this.readAvailable() - 4;
        if (n < 0) {
            return;
        }
        this.markIn(n + 4);
        this.setBuf(n + 4);
        int i = 0;
        while (i < n) {
            this.buffer.mark();
            int val = this.buffer.getInt();
            this.buffer.reset();
            if (i >= loc) break;
            if (i + 4 + val == loc && testing) {
                System.out.println(i + "\t0x" + this.toHex(i) + "\t+\t" + val + "\t0x" + this.toHex(val) + "\t=\t" + loc);
            }
            this.buffer.position(++i);
        }
        this.resetIn();
    }

    public List<Object> traceRef(int loc, boolean isTop) throws IOException {
        ArrayList<Object> nextLevel = new ArrayList<Object>();
        nextLevel.add(loc);
        int n = this.readAvailable() - 4;
        this.markIn(n + 4);
        this.setBuf(n + 4);
        int i = 0;
        while (i < n) {
            this.buffer.mark();
            int val = this.buffer.getInt();
            this.buffer.reset();
            if (i >= loc) break;
            if (i + 4 + val == loc) {
                if (testing) {
                    System.out.println(i + "\t0x" + this.toHex(i) + "\t+\t" + val + "\t0x" + this.toHex(val) + "\t=\t" + loc);
                }
                nextLevel.add(i);
            }
            this.buffer.position(++i);
        }
        this.resetIn();
        for (i = 1; i < nextLevel.size(); ++i) {
            loc = (Integer)nextLevel.get(i);
            List<Object> tree = this.traceRef(loc, false);
            if (tree.size() <= 1) continue;
            nextLevel.set(i, tree);
        }
        if (isTop) {
            System.out.println(loc);
            this.dumpList(nextLevel, "");
        }
        return nextLevel;
    }

    private void dumpList(List<Object> nextLevel, String indent) {
        indent = indent + nextLevel.get(0) + " ";
        for (int i = 1; i < nextLevel.size(); ++i) {
            Object o = nextLevel.get(i);
            if (o instanceof List) {
                this.dumpList((List)o, indent);
                continue;
            }
            System.out.println(indent + o);
        }
    }

    public void checkDoubles(int loc, int n, int offset) throws IOException {
        int i1;
        this.markIn(loc + n * 8 + 8);
        this.seekIn(loc);
        this.setBuf(n * 8 + 8);
        int i = offset == -1 ? 0 : offset;
        int n2 = i1 = offset == -1 ? 8 : offset + 1;
        while (i < i1) {
            this.markBuffer();
            for (int j = 0; j < n; ++j) {
                double d = this.buffer.getDouble();
                if (d == 0.0 || !(Math.abs(d) > 1.0E-10) || !(Math.abs(d) < 1.0E10)) continue;
                this.buffer.position(this.buffer.position() - 8);
                if (!testing) continue;
                System.out.println(i + " " + (loc + i + j * 8) + " : " + Long.toHexString(this.buffer.getLong()) + "\t" + d);
            }
            this.resetBuffer();
            this.buffer.position(++i);
        }
        this.resetIn();
    }

    public void readDoubleBox() throws IOException {
        this.readDouble();
        this.readDouble();
        this.readDouble();
        this.readDouble();
    }

    public boolean nextBlock() throws IOException {
        long navail = this.readAvailable();
        if (navail == 0L) {
            return false;
        }
        long pos = this.readPosition();
        int len = this.readInt();
        if (len < 0 || (long)len > navail) {
            throw new IOException("invalid length " + len + " for nextBlock where pos=" + pos + " navail=" + navail);
        }
        this.skipIn(len);
        return true;
    }

    public boolean nextSubblock(int n) throws IOException {
        this.readInts(n);
        return this.nextBlock();
    }

    public static void doubleTest() {
        double d;
        int i;
        for (i = -20; i <= 20; ++i) {
            d = Math.pow(10.0, (double)i / 2.0);
            ByteBlockReader.showDoubleLong(d);
        }
        for (i = -20; i <= 20; ++i) {
            d = -Math.pow(10.0, (double)i / 2.0);
            ByteBlockReader.showDoubleLong(d);
        }
        ByteBlockReader.showDoubleLong(Double.NaN);
    }

    public static void showDoubleLong(double d) {
        System.out.println(Long.toHexString(Double.doubleToLongBits(d)).toUpperCase() + "\t" + d);
    }

    public void rewindIn() throws IOException {
        this.setPosition(0L);
    }

    private void setPosition(long pos) throws IOException {
        this.position = pos;
        this.in.setPosition(this.position);
    }

    public String peekBlockAsString(boolean doblock) throws IOException {
        long ptr = this.readPosition();
        int len = this.peekInt();
        StringBuffer sb = new StringBuffer();
        boolean t = testing;
        testing = false;
        int p = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.readByte();
            if (b < 60 || b > 122) continue;
            sb.append((char)b);
            if (!doblock || ++p % 80 != 0) continue;
            sb.append('\n');
        }
        this.seekIn(ptr);
        testing = t;
        String s = sb.toString();
        if (doblock) {
            System.out.println(s);
        }
        return s;
    }

    public Stack<BlockData> getObjectStack() throws IOException {
        Stack<Long> ptrStack = new Stack<Long>();
        Stack<BlockData> objStack = new Stack<BlockData>();
        while (this.peekInt() > 0) {
            ptrStack.push(this.readPointer());
        }
        this.readInt();
        long pt = this.readPosition();
        while (ptrStack.size() > 0) {
            long ptr = (Long)ptrStack.pop();
            int len = (int)(ptr - pt);
            objStack.push(new BlockData(pt, len));
            pt = ptr;
        }
        this.seekIn(pt);
        return objStack;
    }

    public void showStack(Stack<?> stack) {
        Enumeration e = stack.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            System.out.print(o + " ");
        }
        System.out.println();
    }

    public void peekBufferInts(int n) {
        this.markBuffer();
        for (int i = 0; i < n; ++i) {
            this.getInt();
        }
        this.resetBuffer();
    }

    public void extractDoubles(long loc, int len, String fname) throws IOException {
        boolean t = testing;
        testing = false;
        this.seekIn(loc);
        long ptr = this.readPosition();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(this.readDouble()).append('\n');
        }
        File f = new File(fname);
        try (FileOutputStream fis = new FileOutputStream(f);){
            byte[] bytes = sb.toString().getBytes();
            fis.write(bytes);
            System.out.println(bytes.length + " bytes written to " + f.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.seekIn(ptr);
        testing = t;
    }

    public void extractInts(long loc, int len, String fname) throws IOException {
        boolean t = testing;
        testing = false;
        this.seekIn(loc);
        long ptr = this.readPosition();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(Integer.toHexString(this.readInt())).append('\n');
        }
        File f = new File(fname);
        try (FileOutputStream fis = new FileOutputStream(f);){
            byte[] bytes = sb.toString().getBytes();
            fis.write(bytes);
            System.out.println(bytes.length + " bytes written to " + f.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.seekIn(ptr);
        testing = t;
    }

    public class BlockData {
        public long loc;
        public int len;

        public BlockData(long loc, int len) {
            this.loc = loc;
            this.len = len;
        }

        public void seek() throws IOException {
            ByteBlockReader.this.seekIn(this.loc);
        }

        public void skip() throws IOException {
            ByteBlockReader.this.seekIn(this.loc + (long)this.len);
        }

        public byte[] getData() throws IOException {
            long pt = ByteBlockReader.this.readPosition();
            ByteBlockReader.this.seekIn(this.loc);
            byte[] bytes = ByteBlockReader.this.readBytes(this.len);
            ByteBlockReader.this.seekIn(pt);
            return bytes;
        }

        public String toString() {
            return "[Block loc=" + this.loc + " len=" + this.len + " to " + (this.loc + (long)this.len) + "]";
        }
    }

    public static class RewindableInputStream
    extends ByteArrayInputStream {
        public RewindableInputStream(byte[] buf) {
            super(buf);
        }

        public void setPosition(long pt) {
            this.pos = this.mark = (int)pt;
        }
    }
}

