/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.html;

import java.io.File;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;

public class PageCreator {
    private static final String ifdConfigJS = "_IFD_config.js";
    private static final String ifdFindingAidsJS = "_IFD_findingaids.js";
    private static final String[] files = new String[]{"assets/FAIRSpec.css", "assets/FAIRSpec-config.js", "assets/FAIRSpec-get.js", "assets/FAIRSpec-gui.js", "assets/FAIRSpec-jmol.js", "_IFD_config.js", "_IFD_findingaids.js", "index.htm"};

    private PageCreator() {
    }

    public static void buildSite(File htmlPath, boolean isLocal, boolean doLaunch) throws Exception {
        if (htmlPath == null) {
            return;
        }
        new File(htmlPath, "assets").mkdirs();
        for (int i = 0; i < files.length; ++i) {
            byte[] bytes = FAIRSpecUtilities.getResourceBytes(PageCreator.class, "site/" + files[i]);
            if (!isLocal && files[i] == ifdConfigJS) {
                bytes = new String(bytes).replace("true", "false").getBytes();
            }
            File f = new File(htmlPath + "/" + files[i]);
            System.out.println("PageCreator creating " + f.getAbsolutePath());
            FAIRSpecUtilities.writeBytesToFile(bytes, f);
        }
        System.out.println("PageCreater created " + files.length + " files in " + htmlPath.getAbsolutePath());
        if (doLaunch) {
            String path = htmlPath.getAbsolutePath().replace('\\', '/') + "/index.htm";
            try {
                FAIRSpecUtilities.showUrl(path);
            }
            catch (Exception e) {
                System.out.println("PageCreator could not launch " + path);
            }
        }
    }

    public static final void main(String[] args) {
        try {
            PageCreator.buildSite(new File("C:/temp/tpc"), true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

