/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.ExtractorUtils;
import com.integratedgraphics.extractor.IFDExtractorLayer1;
import com.integratedgraphics.ifd.api.VendorPluginI;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundAssociation;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.core.IFDRepresentableObject;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.derived.IFDSampleStructureAssociation;
import org.iupac.fairdata.extract.DefaultStructureHelper;
import org.iupac.fairdata.extract.PropertyManagerI;
import org.iupac.fairdata.sample.IFDSample;
import org.iupac.fairdata.structure.IFDStructure;

abstract class IFDExtractorLayer2
extends IFDExtractorLayer1 {
    private static final String PHASE_2A = "2a";
    private static final String PHASE_2C = "2c";
    private static final String PHASE_2E = "2e";
    protected FAIRSpecExtractorHelper.FileList lstManifest;
    protected ExtractorUtils.ExtractorResource extractorResource;
    private Map<String, IFDRepresentableObject<?>> htLocalizedNameToObject = new LinkedHashMap();
    private Map<String, IFDRepresentableObject<?>> htCloneMap = new HashMap();
    private List<Object[]> deferredPropertyList;
    private int deferredPropertyPointer;
    private static final String NEW_RESOURCE_KEY = "*NEW_RESOURCE*";
    private ExtractorUtils.CacheRepresentation currentRezipRepresentation;
    private String currentRezipPath;
    private VendorPluginI currentRezipVendor;
    private String lastRezipPath;
    private List<ExtractorUtils.CacheRepresentation> rezipCache;
    private Map<String, String> htZipRenamed = new LinkedHashMap<String, String>();
    private Map<ExtractorUtils.AWrap, IFDStructure> htStructureRepCache;
    private File currentZipFile;
    private boolean allowMultipleObjectsForRepresentations = true;

    IFDExtractorLayer2() {
    }

    protected void processPhase2(File targetDir) throws IFDException, IOException {
        if (this.haveExtracted) {
            throw new IFDException("Only one extraction per instance of Extractor is allowed (for now).");
        }
        this.haveExtracted = true;
        if (targetDir == null) {
            throw new IFDException("The target directory may not be null.");
        }
        this.setupTargetDir(targetDir);
        this.log("=====");
        if (IFDExtractorLayer2.logging()) {
            if (this.localSourceDir != null) {
                this.log("extractObjects from " + this.localSourceDir);
            }
            this.log("extractObjects to " + targetDir.getAbsolutePath());
        }
        this.deferredPropertyList = new ArrayList<Object[]>();
        this.rezipCache = new ArrayList<ExtractorUtils.CacheRepresentation>();
        LinkedHashMap<String, Map<String, ExtractorUtils.ArchiveEntry>> htArchiveContents = new LinkedHashMap<String, Map<String, ExtractorUtils.ArchiveEntry>>();
        this.phase2aIterate(htArchiveContents);
        this.checkStopAfter(PHASE_2A);
        this.phase2bIterate(htArchiveContents);
        this.checkStopAfter("2b");
        this.deferredPropertyPointer = 0;
        if (this.rezipCache != null && this.rezipCache.size() > 0) {
            this.phase2cGetNextRezipName();
            this.lastRezipPath = null;
            this.phase2cIterate();
        }
        this.checkStopAfter(PHASE_2C);
        this.phase2dProcessDeferredObjectProperties(null);
        this.checkStopAfter("2d");
        this.log("!Phase 2e check rejected files and update lists");
        this.phase2eIterate();
    }

    private void phase2aIterate(Map<String, Map<String, ExtractorUtils.ArchiveEntry>> contents) throws IOException, IFDException {
        ParserIterator iter = new ParserIterator();
        this.log("!Phase 2a initializing data sources ");
        while (iter.hasNext()) {
            Map<String, ExtractorUtils.ArchiveEntry> zipFileMap;
            String source;
            ExtractorUtils.ExtractorResource currentSource = this.extractorResource;
            this.nextParser(iter);
            if (this.extractorResource == currentSource) continue;
            currentSource = this.extractorResource;
            if (this.cleanCollectionDir) {
                File dir = new File(this.targetDir + "/" + this.extractorResource.rootPath);
                this.log("!Phase 2a cleaning directory " + dir);
                FileUtils.cleanDirectory(dir);
            }
            if (!this.rootPaths.contains(source = this.targetDir + "/" + this.extractorResource.rootPath)) {
                this.rootPaths.add(source);
            }
            if ((zipFileMap = contents.get(this.localizedTopLevelZipURL)) != null) continue;
            this.log("!retrieving " + this.localizedTopLevelZipURL);
            URL url = new URL(this.localizedTopLevelZipURL);
            long[] retLength = new long[1];
            InputStream is = this.openLocalFileInputStream(url, retLength);
            long len = retLength[0];
            if (len > 0L) {
                this.faHelper.setCurrentResourceByteLength(len);
            }
            zipFileMap = this.phase2ReadZipContentsIteratively(is, "", PHASE_2A, new LinkedHashMap<String, ExtractorUtils.ArchiveEntry>());
            contents.put(this.localizedTopLevelZipURL, zipFileMap);
        }
    }

    private Map<String, ExtractorUtils.ArchiveEntry> phase2ReadZipContentsIteratively(InputStream is, String baseOriginPath, String phase, Map<String, ExtractorUtils.ArchiveEntry> originToEntryMap) throws IOException, IFDException {
        boolean first;
        if (this.debugging && baseOriginPath.length() > 0) {
            this.log("! opening " + baseOriginPath);
        }
        boolean isTopLevel = baseOriginPath.length() == 0;
        ExtractorUtils.ArchiveInputStream ais = new ExtractorUtils.ArchiveInputStream(is, isTopLevel ? this.extractorResource.getSourceFile() : null);
        ExtractorUtils.ArchiveEntry zipEntry = null;
        ExtractorUtils.ArchiveEntry nextEntry = null;
        ExtractorUtils.ArchiveEntry nextRealEntry = null;
        int n = 0;
        boolean bl = first = phase != PHASE_2E;
        block10: while ((nextEntry != null ? nextEntry : (zipEntry = nextRealEntry != null ? nextRealEntry : ais.getNextEntry())) != null) {
            ++n;
            nextEntry = null;
            String name = zipEntry.getName();
            if (name == null) continue;
            boolean isDir = zipEntry.isDirectory();
            if (first) {
                int pt;
                first = false;
                if (!isDir && (pt = name.lastIndexOf(47)) >= 0) {
                    nextEntry = new ExtractorUtils.ArchiveEntry(name.substring(0, pt + 1));
                    nextRealEntry = zipEntry;
                    continue;
                }
            }
            if (!isDir) {
                nextRealEntry = null;
            }
            String oPath = baseOriginPath + name;
            boolean accepted = false;
            if (isDir) {
                if (IFDExtractorLayer2.logging()) {
                    this.log("Phase " + phase + " checking zip directory: " + n + " " + oPath);
                }
            } else {
                if (zipEntry.getSize() == 0L) continue;
                if (this.lstRejected.accept(oPath)) {
                    if (phase != PHASE_2A) continue;
                    this.addFileToFileLists(oPath, 0, zipEntry.getSize(), null);
                    continue;
                }
                if (phase == PHASE_2A && this.lstAccepted.accept(oPath)) {
                    this.addFileToFileLists(oPath, 3, zipEntry.getSize(), null);
                    accepted = true;
                }
                if (this.lstIgnored.accept(oPath)) {
                    if (phase != PHASE_2A) continue;
                    this.addFileToFileLists(oPath, 1, zipEntry.getSize(), ais);
                    continue;
                }
            }
            if (this.debugging) {
                this.log("reading zip entry: " + n + " " + oPath);
            }
            if (originToEntryMap != null) {
                originToEntryMap.put(oPath, zipEntry);
            }
            if (FAIRSpecUtilities.isZip(oPath)) {
                this.phase2ReadZipContentsIteratively(ais, oPath + "|", phase, originToEntryMap);
            } else {
                switch (phase) {
                    case "2a": {
                        if (isDir) break;
                        this.phase2aProcessEntry(baseOriginPath, oPath, ais, zipEntry, accepted);
                        break;
                    }
                    case "2c": {
                        if (!oPath.equals(this.currentRezipPath)) break;
                        nextEntry = this.phase2cRezipEntry(baseOriginPath, oPath, ais, zipEntry, nextRealEntry, this.currentRezipVendor);
                        nextRealEntry = null;
                        this.phase2cGetNextRezipName();
                        continue block10;
                    }
                    case "2e": {
                        if (isDir) break;
                        this.phase2eCheckOrReject(ais, oPath, zipEntry.getSize());
                    }
                }
            }
            nextEntry = null;
        }
        if (isTopLevel) {
            ais.close();
        }
        return originToEntryMap;
    }

    private void phase2aProcessEntry(String baseOriginPath, String originPath, InputStream ais, ExtractorUtils.ArchiveEntry zipEntry, boolean accept) throws FileNotFoundException, IOException {
        PropertyManagerI v;
        long len = zipEntry.getSize();
        Matcher m = null;
        boolean isFound = false;
        if (this.vendorCachePattern != null && (isFound = (m = this.vendorCachePattern.matcher(originPath)).find()) || accept) {
            boolean doExtract;
            v = isFound ? this.getPropertyManager(m) : null;
            boolean doCheck = v != null;
            boolean bl = doExtract = !doCheck || v.doExtract(originPath);
            if (doExtract) {
                OutputStream os;
                String ext = isFound ? m.group("ext") : originPath.substring(originPath.lastIndexOf(".") + 1);
                File f = this.getAbsoluteFileTarget(originPath);
                boolean toByteArray = doCheck || this.noOutput || this.insitu;
                OutputStream outputStream = os = toByteArray ? new ByteArrayOutputStream() : new FileOutputStream(f);
                if (os != null) {
                    FAIRSpecUtilities.getLimitedStreamBytes(ais, len, os, false, true);
                }
                String localizedName = IFDExtractorLayer2.localizePath(originPath);
                String type = null;
                byte[] bytes = null;
                if (toByteArray) {
                    bytes = ((ByteArrayOutputStream)os).toByteArray();
                    len = bytes.length;
                    if (doCheck) {
                        if (!this.insitu) {
                            this.writeOriginToCollection(originPath, bytes, 0L);
                        }
                        String oldOriginPath = this.originPath;
                        String oldLocal = this.localizedName;
                        this.originPath = originPath;
                        this.localizedName = localizedName;
                        type = v.accept(this, originPath, bytes);
                        if (type == IFDConst.IFD_PROPERTY_FLAG) {
                            List<String[]> props = FAIRSpecUtilities.getIFDPropertyMap(new String(bytes));
                            int n = props.size();
                            for (int i = 0; i < n; ++i) {
                                String[] p = props.get(i);
                                this.addDeferredPropertyOrRepresentation(p[0].substring(3), p[1], false, null, null, null);
                            }
                        } else {
                            this.deferredPropertyList.add(null);
                            this.localizedName = oldLocal;
                            this.originPath = oldOriginPath;
                            if (type == null) {
                                this.logWarn("Failed to read " + originPath + " (ignored)", v.getClass().getName());
                            } else if (IFDConst.isStructure(type) || type.startsWith("_struc.")) {
                                return;
                            }
                        }
                    }
                } else {
                    len = f.length();
                    this.writeOriginToCollection(originPath, null, len);
                }
                this.addFileAndCacheRepresentation(originPath, localizedName, (byte[])(this.insitu ? bytes : null), len, type, ext, null);
            }
        }
        if (this.rezipCachePattern != null && (m = this.rezipCachePattern.matcher(originPath)).find()) {
            v = this.phase2aGetVendorForRezip(m);
            originPath = m.group("path" + v.getIndex());
            if (originPath.equals(this.lastRezipPath)) {
                if (IFDExtractorLayer2.logging()) {
                    this.log("duplicate path " + originPath);
                }
            } else {
                ExtractorUtils.CacheRepresentation r;
                String basePath;
                this.lastRezipPath = originPath;
                String localPath = IFDExtractorLayer2.localizePath(originPath);
                ExtractorUtils.CacheRepresentation rep = new ExtractorUtils.CacheRepresentation(new IFDReference(this.faHelper.getCurrentSource().getID(), originPath, this.extractorResource.rootPath, localPath), v, len, null, "application/zip");
                String string = basePath = baseOriginPath.endsWith("|") ? baseOriginPath.substring(0, baseOriginPath.length() - 1) : new File(originPath).getParent() + "/";
                if (basePath == null) {
                    basePath = originPath;
                }
                rep.setRezipOrigin(basePath);
                if (this.rezipCache.size() > 0 && (r = this.rezipCache.get(this.rezipCache.size() - 1)).getRezipOrigin().equals(basePath)) {
                    rep.setIsMultiple();
                    r.setIsMultiple();
                }
                this.rezipCache.add(rep);
                this.log("!rezip pattern found " + originPath + " " + rep);
            }
        }
    }

    private VendorPluginI phase2aGetVendorForRezip(Matcher m) {
        int i = this.bsRezipVendors.nextSetBit(0);
        while (i >= 0) {
            String ret = m.group("rezip" + i);
            if (ret != null && ret.length() > 0) {
                return VendorPluginI.activeVendors.get((int)i).vendor;
            }
            i = this.bsRezipVendors.nextSetBit(i + 1);
        }
        return null;
    }

    private void phase2bIterate(Map<String, Map<String, ExtractorUtils.ArchiveEntry>> htArchiveContents) throws IOException, IFDException {
        ParserIterator iter = new ParserIterator();
        while (iter.hasNext()) {
            ExtractorUtils.ObjectParser parser = this.nextParser(iter);
            this.log("!Phase 2b \n" + this.localizedTopLevelZipURL + "\n" + parser.getStringData());
            this.phase2bParseZipFileNamesForObjects(parser, htArchiveContents.get(this.localizedTopLevelZipURL));
        }
    }

    private IFDObject<?> phase2bAddIFDObjectsForName(ExtractorUtils.ObjectParser parser, List<String> keyList, String originPath, String localizedName, long len) throws IFDException, IOException {
        Matcher m = parser.match(originPath);
        if (!m.find()) {
            return null;
        }
        this.helper.beginAddingObjects(originPath);
        if (this.debugging) {
            this.log("adding IFDObjects for " + originPath);
        }
        int i = keyList.size();
        while (--i >= 0) {
            String s;
            String key = keyList.get(i);
            String param = parser.getKeys().get(key);
            if (param.length() <= 0) continue;
            String id = m.group(key);
            this.log("!found " + param + " " + id);
            if (IFDConst.isDataObject(param) && this.htLocalizedNameToObject.containsKey(s = IFDConst.IFD_DATAOBJECT_FLAG + localizedName)) continue;
            IFDObject<?> obj = this.helper.addObject(this.extractorResource.rootPath, param, id, localizedName, len);
            if (obj instanceof IFDRepresentableObject) {
                this.linkLocalizedNameToObject(localizedName, param, (IFDRepresentableObject)obj);
                if (obj instanceof IFDDataObject) {
                    parser.setHasData(true);
                }
            } else if (obj instanceof FAIRSpecCompoundAssociation) {
                // empty if block
            }
            if (!this.debugging) continue;
            this.log("!found " + param + " " + id);
        }
        return this.helper.endAddingObjects();
    }

    private void phase2bParseZipFileNamesForObjects(ExtractorUtils.ObjectParser parser, Map<String, ExtractorUtils.ArchiveEntry> zipFileMap) throws IOException, IFDException {
        List<String> keyList = parser.getKeyList();
        for (Map.Entry<String, ExtractorUtils.ArchiveEntry> e : zipFileMap.entrySet()) {
            ExtractorUtils.ArchiveEntry zipEntry;
            long len;
            IFDObject<?> obj;
            String originPath = e.getKey();
            String localizedName = IFDExtractorLayer2.localizePath(originPath);
            if (!this.allowMultipleObjectsForRepresentations && this.htLocalizedNameToObject.containsKey(localizedName) || !((obj = this.phase2bAddIFDObjectsForName(parser, keyList, originPath, localizedName, len = (zipEntry = e.getValue()).getSize())) instanceof IFDRepresentableObject)) continue;
            this.addFileToFileLists(originPath, 2, len, null);
        }
    }

    private void phase2cIterate() throws MalformedURLException, IOException, IFDException {
        ParserIterator iter = new ParserIterator();
        while (iter.hasNext()) {
            ExtractorUtils.ObjectParser parser = this.nextParser(iter);
            if (!parser.hasData()) continue;
            this.phase2ReadZipContentsIteratively(this.getTopZipStream(), "", PHASE_2C, null);
        }
    }

    private void phase2cGetNextRezipName() {
        if (this.rezipCache.size() == 0) {
            this.currentRezipPath = null;
            this.currentRezipRepresentation = null;
        } else {
            this.currentRezipRepresentation = this.rezipCache.remove(0);
            Object path = this.currentRezipRepresentation.getRef().getOriginPath();
            this.currentRezipPath = (String)path;
            this.currentRezipVendor = (VendorPluginI)this.currentRezipRepresentation.getData();
        }
    }

    private ExtractorUtils.ArchiveEntry phase2cRezipEntry(String baseName, String oPath, ExtractorUtils.ArchiveInputStream ais, ExtractorUtils.ArchiveEntry entry, ExtractorUtils.ArchiveEntry firstEntry, VendorPluginI vendor) throws IOException, IFDException {
        IFDRepresentation r;
        String name;
        String entryName = entry.getName();
        String dirName = entry.isDirectory() ? entryName : entryName.substring(0, entryName.lastIndexOf(47) + 1);
        String parent = new File(entryName).getParent();
        int lenOffset = parent == null ? 0 : parent.length() + 1;
        String thisDir = dirName.substring(lenOffset, dirName.length() - 1);
        String newDir = vendor.getRezipPrefix(thisDir);
        Matcher m = null;
        String localizedName = IFDExtractorLayer2.localizePath(oPath);
        String lNameForObj = localizedName;
        IFDRepresentableObject<?> obj = this.getObjectFromLocalizedName(lNameForObj, IFDConst.IFD_DATAOBJECT_FLAG);
        if (obj == null && (obj = this.getObjectFromLocalizedName(IFDExtractorLayer2.localizePath(name = baseName.endsWith("|") ? baseName.substring(0, baseName.length() - 1) : parent + "/"), IFDConst.IFD_DATAOBJECT_FLAG)) == null) {
            throw new IFDException("phase2cRezipEntry could not find object for " + lNameForObj);
        }
        String basePath = baseName + (parent == null ? "" : parent);
        if (newDir == null) {
            newDir = "";
            boolean isMultiple = this.currentRezipRepresentation.isMultiple();
            if (isMultiple) {
                System.out.println("isMultiple!!" + this.currentRezipRepresentation);
            } else {
                String string = oPath = parent == null ? basePath.substring(0, basePath.length() - 1) : basePath;
            }
            if (oPath.endsWith(".zip") && lenOffset > 0) {
                this.htZipRenamed.put(IFDExtractorLayer2.localizePath(basePath), localizedName);
            }
            this.originPath = oPath;
            localizedName = IFDExtractorLayer2.localizePath(oPath);
            if (!localizedName.endsWith(".zip")) {
                oPath = oPath + ".zip";
                localizedName = localizedName + ".zip";
            }
            if (this.localizedName == null || isMultiple) {
                this.localizedName = localizedName;
            }
            if (isMultiple) {
                this.addDeferredPropertyOrRepresentation("*NEW_PAGE*", new Object[]{obj.getID().endsWith("/" + thisDir) ? null : "_" + thisDir, obj, localizedName}, false, null, null, "P2 rezip");
            }
        } else {
            newDir = newDir + "/";
            lenOffset = dirName.length();
            this.originPath = oPath;
            if (oPath.endsWith(".zip") && lenOffset > 0) {
                this.htZipRenamed.put(IFDExtractorLayer2.localizePath(basePath), localizedName);
            }
            if (this.localizedName == null) {
                this.localizedName = localizedName;
            }
            String msg = "Extractor correcting " + vendor.getVendorName() + " directory name to " + localizedName + "|" + newDir;
            this.addProperty(IFDConst.IFD_PROPERTY_DATAOBJECT_NOTE, msg);
            this.log("!" + msg);
        }
        localizedName = IFDExtractorLayer2.localizePath(oPath);
        this.htLocalizedNameToObject.put(localizedName, obj);
        this.localizedName = localizedName;
        File outFile = this.getAbsoluteFileTarget(oPath);
        this.log("!Extractor Phase 2c rezipping " + baseName + entry + " as " + outFile);
        OutputStream fos = this.insitu || this.noOutput ? new ByteArrayOutputStream() : new FileOutputStream(outFile);
        ZipOutputStream zos = this.insitu ? null : new ZipOutputStream(fos);
        vendor.startRezip(this);
        long len = 0L;
        while ((entry = firstEntry == null ? ais.getNextEntry() : firstEntry) != null) {
            byte[] bytes;
            boolean doCheck;
            Object[] typeData;
            firstEntry = null;
            entryName = entry.getName();
            String entryPath = baseName + entryName;
            boolean isDir = entry.isDirectory();
            if (this.lstRejected.accept(entryPath)) {
                if (this.lstRejected.contains(entryPath)) continue;
                this.addFileToFileLists(entryPath, 0, entry.getSize(), null);
                continue;
            }
            if (!entryName.startsWith(dirName)) break;
            if (isDir) continue;
            PropertyManagerI mgr = null;
            this.originPath = entryPath;
            String localName = IFDExtractorLayer2.localizePath(baseName + entryName);
            this.htLocalizedNameToObject.put(localName, obj);
            boolean isInlineBytes = false;
            boolean isBytesOnly = false;
            boolean isIFDMetadataFile = entryName.endsWith("/" + this.ifdMetadataFileName);
            Object[] objectArray = typeData = isIFDMetadataFile ? null : vendor.getExtractTypeInfo(this, baseName, entryName);
            if (typeData != null) {
                isInlineBytes = Boolean.TRUE.equals(typeData[1]);
                isBytesOnly = Boolean.FALSE.equals(typeData[1]);
            }
            boolean doInclude = isIFDMetadataFile || vendor == null || vendor.doRezipInclude(this, baseName, entryName);
            boolean doCache = !isIFDMetadataFile && this.vendorCachePattern != null && (m = this.vendorCachePattern.matcher(entryName)).find() && this.phase2cGetParamName(m) != null && ((mgr = this.getPropertyManager(m)) == null || mgr.doExtract(entryName));
            boolean bl = doCheck = doCache || mgr != null || isIFDMetadataFile;
            len = entry.getSize();
            if (len == 0L || !doInclude && !doCheck) continue;
            boolean getBytes = doCheck || isInlineBytes || this.insitu;
            OutputStream os = getBytes ? new ByteArrayOutputStream() : zos;
            String outName = newDir + entryName.substring(lenOffset);
            if (doInclude && !this.insitu) {
                zos.putNextEntry(new ZipEntry(outName));
            }
            FAIRSpecUtilities.getLimitedStreamBytes(ais.getStream(), len, os, false, false);
            byte[] byArray = bytes = getBytes ? ((ByteArrayOutputStream)os).toByteArray() : null;
            if (doCheck) {
                if (doInclude && !this.insitu) {
                    zos.write(bytes);
                }
                this.localizedName = localizedName;
                if (isIFDMetadataFile) {
                    this.addIFDMetadata(new String(bytes));
                } else {
                    (mgr == null ? vendor : mgr).accept(null, this.originPath, bytes);
                }
            }
            if (doInclude && !this.insitu) {
                zos.closeEntry();
            }
            if (typeData == null) continue;
            String key = (String)typeData[0];
            typeData[0] = isBytesOnly ? null : localName;
            typeData[1] = bytes;
            this.addDeferredPropertyOrRepresentation(key, isBytesOnly || isInlineBytes ? typeData : localName, isInlineBytes || this.insitu, null, null, "P2c rezipTD");
        }
        vendor.endRezip();
        if (zos != null) {
            zos.close();
        }
        fos.close();
        String dataType = vendor.processRepresentation(oPath + ".zip", null);
        long l = len = this.noOutput || this.insitu ? (long)((ByteArrayOutputStream)fos).size() : outFile.length();
        if (!this.insitu) {
            this.writeOriginToCollection(oPath, null, len);
        }
        if ((r = this.faHelper.getSpecDataRepresentation(localizedName)) != null && !this.insitu) {
            r.setLength(len);
        }
        if (oPath.endsWith(".zip")) {
            oPath = oPath.substring(0, oPath.length() - 4);
        }
        this.addFileAndCacheRepresentation(oPath, localizedName, null, len, dataType, null, "application/zip");
        if (obj != null && !localizedName.equals(lNameForObj)) {
            this.htLocalizedNameToObject.put(localizedName, obj);
        }
        return entry;
    }

    private String phase2cGetParamName(Matcher m) {
        try {
            if (this.cachePatternHasVendors) {
                return m.group("param");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void phase2dProcessDeferredObjectProperties(String phase2OriginPath) throws IFDException, IOException {
        void var7_8;
        IFDSample sample = null;
        IFDStructure struc = null;
        IFDDataObject cloneOriginObject = null;
        IFDDataObject localSpec = null;
        IFDDataObject spec = null;
        Object var7_7 = null;
        String lastLocal = null;
        String thisPageInvalidatedStructureRepKey = null;
        String pageCompoundID = null;
        boolean cloning = false;
        int n = this.deferredPropertyList.size();
        block10: for (int i = 0; i < n; ++i) {
            String propType;
            boolean isNew;
            boolean isStructure;
            Object[] a = this.deferredPropertyList.get(i);
            if (a == null) {
                sample = null;
                cloneOriginObject = null;
                continue;
            }
            Object var7_9 = null;
            String originPath = (String)a[0];
            String localizedName = (String)a[1];
            String key = (String)a[2];
            Object value = a[3];
            boolean isInline = a[4] == Boolean.TRUE;
            switch (key) {
                case "*NEW_RESOURCE*": {
                    this.initializeResource((ExtractorUtils.ExtractorResource)value, false);
                    continue block10;
                }
                case "*NEW_PAGE*": {
                    pageCompoundID = null;
                    thisPageInvalidatedStructureRepKey = null;
                    if (value == "\u0001") {
                        cloning = false;
                        cloneOriginObject = null;
                        continue block10;
                    }
                    cloning = true;
                    break;
                }
                case "*idf.property.compound.id.source*": {
                    if (pageCompoundID != null) continue block10;
                    pageCompoundID = IFDExtractorLayer2.inferCompoundID((String)value);
                    continue block10;
                }
            }
            boolean isStructureHelperStructureKey = key.startsWith("_struc.");
            boolean isRep = IFDConst.isRepresentation(key);
            boolean isStructureRep = isRep && IFDConst.isStructure(key);
            boolean isWritableRepresentation = isRep && !isInline && value instanceof Object[];
            String type = FAIRSpecFindingAidHelper.getObjectTypeForPropertyOrRepresentationKey(key, true);
            boolean isSample = type == "org.iupac.fairdata.sample.IFDSample";
            boolean bl = isStructure = type == "org.iupac.fairdata.structure.IFDStructure";
            if (isSample) {
                sample = this.faHelper.getSampleByName((String)value);
                continue;
            }
            boolean bl2 = isNew = !localizedName.equals(lastLocal);
            if (isNew) {
                lastLocal = localizedName;
            }
            if ((spec = this.getObjectFromLocalizedName(localizedName, propType = IFDConst.getObjectTypeFlag(key))) == null || !spec.isValid()) {
                // empty if block
            }
            if (spec == null && !cloning) {
                this.logDigitalItemIgnored(originPath, localizedName, "no spec data to associate this structure with", "processDeferredObjectProperties");
                continue;
            }
            if (spec instanceof IFDStructure) {
                struc = (IFDStructure)((Object)spec);
                spec = null;
            } else if (spec instanceof IFDSample) {
                sample = (IFDSample)((Object)spec);
                spec = null;
            } else if (isNew && spec instanceof IFDDataObject) {
                String label;
                localSpec = spec;
                String string = label = struc == null ? null : struc.getLabel();
                if (label != null && label.startsWith("Structure_")) {
                    struc = null;
                }
            }
            if (isRep) {
                Object data = null;
                String mediaType = (String)a[5];
                String note = (String)a[6];
                if (isWritableRepresentation) {
                    Object[] oval = (Object[])value;
                    byte[] bytes = (byte[])oval[0];
                    String oPath = (String)oval[1];
                    String localName = IFDExtractorLayer2.localizePath(oPath);
                    if (thisPageInvalidatedStructureRepKey != null && localName.startsWith(thisPageInvalidatedStructureRepKey)) continue;
                    if (!this.insitu) {
                        this.writeOriginToCollection(oPath, bytes, 0L);
                    }
                    this.addFileToFileLists(localName, 2, bytes.length, null);
                    value = localName;
                    if (this.insitu || "image/png".equals(mediaType)) {
                        data = bytes;
                    }
                }
                String keyPath = null;
                if (isInline) {
                    if (value instanceof Object[]) {
                        keyPath = ((Object[])value)[0].toString();
                        data = ((Object[])value)[1];
                    } else {
                        data = value;
                    }
                } else {
                    keyPath = value.toString();
                }
                if (isStructureRep && struc == null) {
                    struc = this.helper.addStructureForSpec(this.extractorResource.rootPath, spec, key, originPath, IFDExtractorLayer2.localizePath(keyPath), null);
                }
                IFDStructure obj = isStructureRep ? struc : this.phase2dGetClonedData(spec);
                this.linkLocalizedNameToObject(keyPath, null, obj);
                IFDRepresentation r = obj.findOrAddRepresentation(this.faHelper.getCurrentSource().getID(), originPath, this.extractorResource.rootPath, keyPath, data, key, mediaType);
                if (note != null) {
                    r.setNote(note);
                }
                if (isInline) continue;
                this.setLocalFileLength(r);
                continue;
            }
            if (cloning && key == "*NEW_PAGE*") {
                void var7_11;
                String newLocalName = null;
                boolean removeAllRepresentations = false;
                boolean replaceOld = true;
                IFDDataObject specToClone = null;
                if (value instanceof String) {
                    specToClone = cloneOriginObject == null ? (cloneOriginObject = localSpec) : (localSpec = cloneOriginObject);
                } else if (value instanceof Object[]) {
                    a = (Object[])value;
                    value = (String)a[0];
                    IFDDataObject sp = (IFDDataObject)a[1];
                    removeAllRepresentations = true;
                    replaceOld = sp.isValid();
                    specToClone = localSpec = sp;
                    newLocalName = (String)a[2];
                } else {
                    System.out.println("L2 ???? How can this be??");
                }
                String idExtension = (String)value;
                if (var7_9 == null && specToClone != null) {
                    FAIRSpecCompoundAssociation fAIRSpecCompoundAssociation = this.faHelper.findCompound(null, specToClone);
                }
                if (specToClone == null) {
                    specToClone = localSpec = (IFDDataObject)spec;
                    replaceOld = false;
                }
                IFDDataObject newSpec = this.faHelper.cloneData(specToClone, idExtension, replaceOld);
                this.htCloneMap.put(specToClone.getID(), newSpec);
                this.htCloneMap.put("$" + newSpec.getID(), specToClone);
                spec = localSpec = newSpec;
                struc = this.faHelper.getFirstStructureForSpec(localSpec, var7_11 == null);
                if (sample == null) {
                    sample = this.faHelper.getFirstSampleForSpec(localSpec, var7_11 == null);
                }
                if (var7_11 == null) {
                    if (struc != null) {
                        this.faHelper.createCompound(struc, newSpec);
                        this.log("!Structure " + struc + " found and associated with " + spec);
                    }
                    if (sample != null) {
                        this.faHelper.associateSampleSpec(sample, newSpec);
                        this.log("!Structure " + struc + " found and associated with " + spec);
                    }
                } else {
                    if (removeAllRepresentations) {
                        newSpec.clear();
                    }
                    ((FAIRSpecCompoundAssociation)var7_11).addDataObject(newSpec);
                }
                if (struc == null && sample == null) {
                    this.log("!SpecData " + spec + " added " + (var7_11 == null ? "" : "to " + var7_11));
                }
                if (newLocalName != null) {
                    localizedName = newLocalName;
                }
                this.htLocalizedNameToObject.put(localizedName, spec);
                ExtractorUtils.CacheRepresentation rep = (ExtractorUtils.CacheRepresentation)this.vendorCache.get(localizedName);
                if (newLocalName == localizedName) continue;
                String ckey = localizedName + idExtension.replace('_', '#') + "\u0000" + idExtension;
                this.vendorCache.put(ckey, rep);
                this.htLocalizedNameToObject.put(ckey, spec);
                continue;
            }
            if (isStructureHelperStructureKey) {
                void var7_17;
                String ifdRepType;
                Object[] oval = (Object[])value;
                byte[] bytes = (byte[])oval[0];
                String oPath = (String)oval[1];
                String localName = IFDExtractorLayer2.localizePath(oPath);
                String string = ifdRepType = oval.length > 2 ? (String)oval[2] : null;
                if (ifdRepType == null) {
                    ifdRepType = DefaultStructureHelper.getType(key.substring(key.lastIndexOf(".") + 1), bytes, true);
                }
                String name = oval.length > 2 ? null : IFDExtractorLayer2.phase2dGetStructureNameFromPath(oPath);
                ExtractorUtils.AWrap w = new ExtractorUtils.AWrap();
                String inchi = oval.length > 3 ? (String)oval[3] : null;
                struc = this.getCachedStructure(w, bytes, inchi);
                if (struc == null) {
                    thisPageInvalidatedStructureRepKey = null;
                    struc = this.faHelper.getFirstStructureForSpec(spec, false);
                    if (struc == null) {
                        struc = this.helper.addStructureForSpec(this.extractorResource.rootPath, spec, ifdRepType, oPath, localName, name);
                    }
                    this.htStructureRepCache.put(w, struc);
                    if (!this.insitu) {
                        this.writeOriginToCollection(oPath, bytes, 0L);
                    }
                    this.addFileAndCacheRepresentation(oPath, localName, (byte[])(this.insitu ? bytes : null), bytes.length, ifdRepType, null, null);
                    this.linkLocalizedNameToObject(localName, null, struc);
                    if (sample == null) {
                        FAIRSpecCompoundAssociation fAIRSpecCompoundAssociation = this.faHelper.findCompound(struc, spec);
                    } else {
                        IFDSampleStructureAssociation iFDSampleStructureAssociation = this.faHelper.associateSampleStructure(sample, struc);
                    }
                    this.log("!Structure " + struc + " created and associated with " + spec);
                } else {
                    thisPageInvalidatedStructureRepKey = localName + ".";
                    this.invalidateCachedRepresentation(oPath, localName, struc);
                    FAIRSpecCompoundAssociation fAIRSpecCompoundAssociation = this.faHelper.findCompound(struc, spec);
                    if (fAIRSpecCompoundAssociation == null) {
                        FAIRSpecCompoundAssociation fAIRSpecCompoundAssociation2 = this.faHelper.createCompound(struc, spec);
                        this.log("!Structure " + struc + " found and associated with " + spec);
                    }
                }
                if (pageCompoundID != null) {
                    var7_17.setID(pageCompoundID);
                    pageCompoundID = null;
                }
                if (struc.getID() != null) continue;
                String id = var7_17.getID();
                if (id == null && spec != null) {
                    id = spec.getID();
                    var7_17.setID(id);
                }
                struc.setID(id);
                continue;
            }
            if (isStructure) {
                if (struc == null) {
                    this.logErr("No structure found for " + lastLocal + " " + key, "processDeferredObjectProperies");
                    continue;
                }
                this.phase2dSetPropertyIfNotAlreadySet(struc, key, value, originPath);
                continue;
            }
            if (isSample) continue;
            if (key.equals(FAIRSpecExtractorHelper.DATAOBJECT_ORIGINATING_SAMPLE_ID)) {
                this.helper.addSpecOriginatingSampleRef(this.extractorResource.rootPath, localSpec, (String)value);
            }
            this.phase2dSetPropertyIfNotAlreadySet(localSpec, key, value, originPath);
        }
        if (var7_8 == null) {
            this.deferredPropertyList.clear();
            this.htStructureRepCache = null;
            return;
        }
        if (!cloning) return;
        this.vendorCache.remove(lastLocal);
    }

    private IFDStructure getCachedStructure(ExtractorUtils.AWrap w, byte[] bytes, String inchi) {
        bytes = inchi == null || inchi.length() < 2 ? bytes : inchi.getBytes();
        w.setBytes(bytes);
        if (this.htStructureRepCache == null) {
            this.htStructureRepCache = new HashMap<ExtractorUtils.AWrap, IFDStructure>();
        }
        return this.htStructureRepCache.get(w);
    }

    private static String inferCompoundID(String s) {
        int pt = (s = s.toUpperCase()).indexOf("COMPOUND ");
        if (pt < 0) {
            return null;
        }
        return (pt = (s = s.substring(pt + 9)).indexOf(" ")) < 0 ? s : s.substring(0, pt);
    }

    private static String phase2dGetStructureNameFromPath(String originPath) {
        String name = originPath.substring(originPath.lastIndexOf("/") + 1);
        int pt = (name = name.substring(name.indexOf(35) + 1)).indexOf(46);
        if (pt >= 0) {
            name = name.substring(0, pt);
        }
        return name;
    }

    private IFDRepresentableObject<?> phase2dGetClonedData(IFDRepresentableObject<?> spec) {
        if (this.htCloneMap.isEmpty()) {
            return spec;
        }
        IFDRepresentableObject<?> d = spec.isValid() ? null : this.htCloneMap.get(spec.getID());
        return d == null ? spec : d;
    }

    private void phase2dSetPropertyIfNotAlreadySet(IFDObject<?> obj, String key, Object value, String originPath) {
        Object currentValue = this.faHelper.setPropertyValueNotAlreadySet(obj, key, value, originPath);
        if (currentValue != null) {
            String msg = originPath + " property " + key + " can't set value '" + value + "', as it is already set to '" + currentValue + "' from " + obj.getPropertySource(key) + " for " + obj;
            if (key.endsWith("timestamp")) {
                this.log(msg);
            } else {
                this.logWarn(msg, "setPropertyIfNotAlreadySet");
            }
        }
    }

    private void phase2eIterate() throws MalformedURLException, IOException, IFDException {
        ParserIterator iter = new ParserIterator();
        while (iter.hasNext()) {
            this.nextParser(iter);
            this.phase2ReadZipContentsIteratively(this.getTopZipStream(), "", PHASE_2E, null);
        }
    }

    private void phase2eCheckOrReject(ExtractorUtils.ArchiveInputStream ais, String oPath, long len) throws IOException {
        String localizedName = IFDExtractorLayer2.localizePath(oPath);
        IFDRepresentableObject<?> obj = this.htLocalizedNameToObject.get(localizedName);
        if (obj == null) {
            if (!this.lstIgnored.contains(oPath) && !this.lstRejected.contains(oPath)) {
                if (this.lstRejected.accept(oPath)) {
                    this.addFileToFileLists(oPath, 0, len, null);
                } else {
                    this.addFileToFileLists(oPath, 1, len, ais);
                }
            }
        } else if (this.htZipRenamed.containsKey(localizedName)) {
            this.lstManifest.remove(localizedName, len);
        }
    }

    @Override
    public void addProperty(String key, Object val) {
        if (val != "\u0001") {
            this.log(this.localizedName + " addProperty " + key + "=" + val);
        }
        this.addDeferredPropertyOrRepresentation(key, val, false, null, null, "L0 vndaddprop");
    }

    @Override
    public void addDeferredPropertyOrRepresentation(String key, Object val, boolean isInline, String mediaType, String note, String method) {
        if (key == null) {
            this.deferredPropertyList.add(this.deferredPropertyPointer++, null);
            return;
        }
        this.deferredPropertyList.add(this.deferredPropertyPointer++, new Object[]{this.originPath, this.localizedName, key, val, isInline, mediaType, note, method});
        if (key.startsWith("_struc.")) {
            Object[] oval = (Object[])val;
            byte[] bytes = (byte[])oval[0];
            String name = (String)oval[1];
            String type = oval.length > 2 ? (String)oval[2] : null;
            String standardInChI = oval.length > 3 ? (String)oval[3] : null;
            standardInChI = this.getStructurePropertyManager().processStructureRepresentation(name, bytes, type, standardInChI, false, true);
            if (standardInChI != null) {
                oval[3] = standardInChI;
            }
        }
    }

    private ExtractorUtils.CacheRepresentation addFileAndCacheRepresentation(String originPath, String localizedName, Object data, long len, String ifdType, String fileNameForMediaType, String mediaType) throws IOException {
        if (localizedName == null) {
            localizedName = IFDExtractorLayer2.localizePath(originPath);
        }
        if (mediaType == null) {
            if (fileNameForMediaType == null) {
                fileNameForMediaType = localizedName;
            }
            if ((mediaType = FAIRSpecUtilities.mediaTypeFromFileName(fileNameForMediaType)) == null && fileNameForMediaType != null) {
                mediaType = FAIRSpecUtilities.mediaTypeFromFileName(localizedName);
            }
        }
        this.addFileToFileLists(localizedName, 2, len, null);
        ExtractorUtils.CacheRepresentation rep = new ExtractorUtils.CacheRepresentation(new IFDReference(this.faHelper.getCurrentSource().getID(), originPath, this.extractorResource.rootPath, localizedName), data, len, ifdType, mediaType);
        this.vendorCache.put(localizedName, rep);
        return rep;
    }

    private void invalidateCachedRepresentation(String originPath, String localizedName, IFDStructure struc) {
        ExtractorUtils.CacheRepresentation rep = new ExtractorUtils.CacheRepresentation(new IFDReference(this.faHelper.getCurrentSource().getID(), originPath, this.extractorResource.rootPath, localizedName), null, 0L, null, null);
        rep.isValid = false;
        this.vendorCache.put(localizedName, rep);
    }

    private void addIFDMetadata(String data) {
        List<String[]> list = FAIRSpecUtilities.getIFDPropertyMap(data);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String[] item = list.get(i);
            this.addProperty(item[0], item[1]);
        }
    }

    protected IFDRepresentableObject<?> getObjectFromLocalizedName(String name, String type) {
        IFDRepresentableObject<?> obj = type == null ? null : this.htLocalizedNameToObject.get(type + name);
        return obj == null ? this.htLocalizedNameToObject.get(name) : obj;
    }

    private PropertyManagerI getPropertyManager(Matcher m) {
        if (m == null) {
            return null;
        }
        if (m.group("struc") != null) {
            return this.getStructurePropertyManager();
        }
        int i = this.bsPropertyVendors.nextSetBit(0);
        while (i >= 0) {
            String ret = m.group("param" + i);
            if (ret != null && ret.length() > 0) {
                return VendorPluginI.activeVendors.get((int)i).vendor;
            }
            i = this.bsPropertyVendors.nextSetBit(i + 1);
        }
        return null;
    }

    private InputStream getTopZipStream() throws MalformedURLException, IOException {
        return this.localizedTopLevelZipURL.endsWith("/") ? new ExtractorUtils.DirectoryInputStream(this.localizedTopLevelZipURL) : new URL(this.localizedTopLevelZipURL).openStream();
    }

    private void initializeResource(ExtractorUtils.ExtractorResource resource, boolean isInit) throws IFDException, IOException {
        this.localizedTopLevelZipURL = this.localizeURL(resource.getSourceFile());
        String s = resource.getSourceFile();
        String zipPath = s.substring(s.lastIndexOf(":") + 1);
        if (isInit) {
            if (this.debugging) {
                this.log("opening " + this.localizedTopLevelZipURL);
            }
            String rootPath = resource.createZipRootPath(zipPath);
            if (!this.insitu) {
                new File(this.targetDir + "/" + rootPath).mkdir();
            }
            resource.setLists(rootPath, this.ignoreRegex, this.acceptRegex);
        }
        this.lstManifest = resource.lstManifest;
        this.lstIgnored = resource.lstIgnored;
        if (this.faHelper.getCurrentSource() != this.faHelper.addOrSetSource(resource.getRemoteSource(), resource.rootPath) && isInit) {
            this.addDeferredPropertyOrRepresentation(NEW_RESOURCE_KEY, resource, false, null, null, null);
        }
        this.extractorResource = resource;
        this.thisRootPath = resource.rootPath;
    }

    private void linkLocalizedNameToObject(String localizedName, String type, IFDRepresentableObject<?> obj) throws IOException {
        if (localizedName != null && (type == null || IFDConst.isRepresentation(type))) {
            String pre = obj.getObjectFlag();
            this.htLocalizedNameToObject.put(localizedName, obj);
            this.htLocalizedNameToObject.put(pre + localizedName, obj);
            String renamed = this.htZipRenamed.get(localizedName);
            if (renamed != null) {
                this.htLocalizedNameToObject.put(renamed, obj);
                this.htLocalizedNameToObject.put(pre + renamed, obj);
            }
        }
    }

    private ExtractorUtils.ObjectParser nextParser(ParserIterator iter) {
        ExtractorUtils.ObjectParser parser = iter.next();
        if (parser.getDataSource() != this.extractorResource) {
            try {
                this.initializeResource(parser.getDataSource(), true);
            }
            catch (IOException | IFDException e) {
                e.printStackTrace();
            }
        }
        return parser;
    }

    private InputStream openLocalFileInputStream(URL url, long[] retLength) throws IOException {
        InputStream is;
        if ("file".equals(url.getProtocol())) {
            this.currentZipFile = new File(url.getPath());
            if (this.currentZipFile.isDirectory()) {
                is = new ExtractorUtils.DirectoryInputStream(this.currentZipFile.toString());
            } else {
                retLength[0] = this.currentZipFile.length();
                is = url.openStream();
            }
        } else {
            File tempFile = this.currentZipFile = File.createTempFile("extract", ".zip");
            this.localizedTopLevelZipURL = "file:///" + tempFile.getAbsolutePath();
            this.log("!saving " + url + " as " + tempFile);
            FAIRSpecUtilities.getLimitedStreamBytes(url.openStream(), -1L, new FileOutputStream(tempFile), true, true);
            this.log("!saved " + tempFile.length() + " bytes");
            retLength[0] = tempFile.length();
            this.extractorResource.setTemp(this.localizedTopLevelZipURL);
            is = new BufferedInputStream(new FileInputStream(tempFile));
        }
        return is;
    }

    @Override
    public void setNewObjectMetadata(IFDObject<?> o, String param) {
        List<Object[]> metadata;
        Map map;
        String id;
        if (this.htSpreadsheetMetadata == null || (id = o.getID()) == null || (map = (Map)this.htSpreadsheetMetadata.get(param)) == null || !FAIRSpecUtilities.SpreadsheetReader.hasDataKey(map) || (metadata = FAIRSpecUtilities.SpreadsheetReader.getRowDataForIndex(map, id)) == null) {
            return;
        }
        this.log("!Extractor adding " + metadata.size() + " metadata items for " + param + "=" + id);
        FAIRSpecExtractorHelper.addProperties(o, metadata);
    }

    private void setupTargetDir(File dir) {
        dir.mkdir();
        new File(dir + "/_IFD_warnings.txt").delete();
        new File(dir + "/_IFD_rejected.json").delete();
        new File(dir + "/_IFD_ignored.json").delete();
        new File(dir + "/_IFD_manifest.json").delete();
        new File(dir + "/IFD.findingaid.json").delete();
        new File(dir + "/IFD.collection.zip").delete();
        this.targetDir = dir;
    }

    private byte[] writeOriginToCollection(String originPath, byte[] bytes, long len) throws IOException {
        this.lstWritten.add(IFDExtractorLayer2.localizePath(originPath), bytes == null ? len : (long)bytes.length);
        if (this.insitu) {
            return bytes;
        }
        if (!this.noOutput && bytes != null) {
            this.writeBytesToFile(bytes, this.getAbsoluteFileTarget(originPath));
        }
        return null;
    }

    protected void addFileToFileLists(String fileName, int mode, long len, ExtractorUtils.ArchiveInputStream ais) throws IOException {
        switch (mode) {
            case 1: {
                this.writeDigitalItem(fileName, ais, len, mode);
                break;
            }
            case 0: {
                this.lstRejected.add(fileName, len);
                break;
            }
            case 3: {
                this.lstAccepted.add(fileName, len);
                break;
            }
            case 2: {
                if (ais == null) {
                    this.lstManifest.add(fileName, len);
                    break;
                }
                this.writeDigitalItem(fileName, ais, len, mode);
            }
        }
    }

    private void writeDigitalItem(String originPath, ExtractorUtils.ArchiveInputStream ais, long len, int mode) throws IOException {
        String localizedName = IFDExtractorLayer2.localizePath(originPath);
        switch (mode) {
            case 1: {
                this.lstIgnored.add(localizedName, len);
                if (!this.noOutput && this.includeIgnoredFiles && ais != null) break;
                return;
            }
            case 2: {
                this.lstManifest.add(localizedName, len);
            }
        }
        if (this.insitu) {
            return;
        }
        File f = this.getAbsoluteFileTarget(localizedName);
        FAIRSpecUtilities.getLimitedStreamBytes(ais, len, new FileOutputStream(f), false, true);
    }

    protected void writeBytesToFile(byte[] bytes, File f) throws IOException {
        if (!this.noOutput) {
            FAIRSpecUtilities.writeBytesToFile(bytes, f);
        }
    }

    protected long setLocalFileLength(IFDRepresentation rep) {
        String name = rep.getRef().getLocalName();
        if (name.indexOf("#") >= 0) {
            return -1L;
        }
        long len = this.lstWritten.getLength(name);
        rep.setLength(len);
        return len;
    }

    private File getAbsoluteFileTarget(String originPath) {
        return new File(this.targetDir + "/" + this.extractorResource.rootPath + "/" + IFDExtractorLayer2.localizePath(originPath));
    }

    private static String localizePath(String path) {
        boolean isDir = (path = path.replace('\\', '/')).endsWith("/");
        if (isDir) {
            path = path.substring(0, path.length() - 1);
        }
        int pt = -1;
        while ((pt = path.indexOf(124, pt + 1)) >= 0) {
            path = path.substring(0, pt) + ".." + path.substring(++pt);
        }
        return path.replace('/', '_').replace('#', '_').replace(' ', '_') + (isDir ? ".zip" : "");
    }

    private class ParserIterator
    implements Iterator<ExtractorUtils.ObjectParser> {
        int i;

        ParserIterator() {
            IFDExtractorLayer2.this.extractorResource = null;
            IFDExtractorLayer2.this.thisRootPath = "";
        }

        @Override
        public boolean hasNext() {
            return this.i < IFDExtractorLayer2.this.objectParsers.size();
        }

        @Override
        public ExtractorUtils.ObjectParser next() {
            return (ExtractorUtils.ObjectParser)IFDExtractorLayer2.this.objectParsers.get(this.i++);
        }
    }
}

