/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.IFDExtractorLayer3;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;

public class IFDExtractor
extends IFDExtractorLayer3 {
    protected static final String codeSource = "https://github.com/IUPAC/IUPAC-FAIRSpec/blob/main/src/main/java/com/integratedgraphics/extractor/IFDExtractor.java";
    protected static final String version = "0.0.6-beta+2024.12.12";
    private static final String debugFlags = "-stopAfter=end";
    public static final String PAGE_ID_PROPERTY_SOURCE = "*idf.property.compound.id.source*";

    protected static String getCommandLineHelp() {
        return "\nformat: java -jar MetadataExtractor.jar [IFD-extract.json] [localSourceArchive] [targetDir] [flags]\n\nwhere\n\n[IFD-extract.json] is the IFD extraction template for this collection\n[localSourceArchive] is the source .zip, .tar.gz, .tar, .tgz, or .rar file\n[targetDir] is the target directory for the collection (which you are responsible to empty first)\n\n[flags] are one or more of:\n\n-addPublicationMetadata (only for post-publication-related collections; include ALL Crossref or DataCite metadata)\n-byID (order compounds by ID, not by index; overrides IFD_extract.json setting)\n-dataciteDown (only for post-publication-related collections)\n-debugging (lots of messages)\n-debugReadonly (readonly, no publicationmetadata)\n-findingAidOnly (only create a finding aid)\n-nolaunch (don't launch the landing page)\n-noclean (don't empty the destination collection directory before extraction; allows additional files to be zipped)\n-noignored (don't include ignored files -- treat them as REJECTED)\n-nolandingPage (don't create a landing page)\n-nopubinfo (ignore all publication info)\n-nostopOnFailure (continue if there is an error)\n-nozip (don't zip up the target directory)\n-readonly (just create a log file)\n-requirePubInfo (throw an error is datacite cannot be reached; post-publication-related collections only)";
    }

    public IFDExtractor() {
        this.initializeExtractor();
    }

    public void runExtraction(String ifdExtractFile, String localSourceArchive, String targetDir, String flags) {
        this.runExtraction(new String[]{ifdExtractFile, localSourceArchive, targetDir, flags});
    }

    public void runExtraction(String[] args) {
        String ifdExtractJSONFilename;
        System.out.println(Arrays.toString(args));
        String localSourceArchive = null;
        String targetDir = null;
        switch (args.length) {
            default: {
                targetDir = args[2];
            }
            case 2: {
                localSourceArchive = args[1];
                if ("-".equals(localSourceArchive)) {
                    localSourceArchive = null;
                }
            }
            case 1: {
                ifdExtractJSONFilename = args[0];
                break;
            }
            case 0: {
                ifdExtractJSONFilename = null;
            }
        }
        if (ifdExtractJSONFilename == null) {
            throw new NullPointerException("No IFD-extract.json or test set?");
        }
        if (targetDir == null) {
            targetDir = "site";
        }
        FAIRSpecUtilities.setLogging(targetDir + "/extractor.log");
        int failed = 0;
        this.logToSys("Extractor.runExtraction output to " + new File(targetDir).getAbsolutePath());
        long t0 = System.currentTimeMillis();
        this.processFlags(args, debugFlags);
        new File(targetDir).mkdirs();
        String flags = "\n" + this.dumpFlags() + "\n IFD version " + IFDConst.IFD_VERSION + "\n";
        try {
            File ifdExtractScriptFile = new File(ifdExtractJSONFilename).getAbsoluteFile();
            File targetPath = new File(targetDir).getAbsoluteFile();
            String sourcePath = localSourceArchive == null ? null : new File(localSourceArchive).getAbsolutePath();
            this.run(ifdExtractScriptFile, targetPath, sourcePath);
            this.logToSys("Extractor.runExtraction ok ");
        }
        catch (Exception e) {
            failed = 1;
            this.logErr("Exception " + e, "runExtraction");
            e.printStackTrace();
        }
        String warnings = "";
        if (failed == 0 || !this.stopOnAnyFailure) {
            this.logToSys("!Extractor.runExtraction time/sec=" + (double)(System.currentTimeMillis() - t0) / 1000.0);
            ifdExtractJSONFilename = null;
            if (this.warnings > 0) {
                warnings = warnings + "======== : " + this.warnings + " warnings for " + targetDir + "\n" + this.strWarnings;
                try {
                    FAIRSpecUtilities.writeBytesToFile(warnings.getBytes(), new File(targetDir + "/_IFD_warnings.txt"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String json = this.readOnly ? null : "{\"findingaids\":[\"" + targetDir + "/IFD.findingaid.json\"]}";
        this.finalizeExtraction(json, 1, failed, -1, -1, flags);
        FAIRSpecUtilities.setLogging(null);
    }

    @Override
    public String processFlags(String[] args, String moreFlags) {
        String flags = super.processFlags(args, moreFlags);
        this.stopAfter = IFDExtractor.getFlagEquals(flags, "-stopafter");
        return flags;
    }

    public String dumpFlags() {
        String s = " stopOnAnyFailure = " + this.stopOnAnyFailure + "\n debugging = " + this.debugging + "\n readOnly = " + this.readOnly + "\n debugReadOnly = " + this.debugReadOnly + "\n allowNoPubInfo = " + !this.allowNoPubInfo + "\n noLandingPage = " + !this.createLandingPage + "\n noLaunch = " + !this.launchLandingPage + "\n skipPubInfo = " + this.skipPubInfo + "\n localSourceArchive = " + this.localSourceDir + "\n targetDir = " + this.targetDir + "\n createZippedCollection = " + this.createZippedCollection;
        return s;
    }

    public final String extractAndCreateFindingAid(File ifdExtractScriptFile, String localArchive, File targetPath) throws IOException, IFDException {
        this.targetPath = targetPath;
        this.processPhase1(ifdExtractScriptFile, localArchive);
        FAIRSpecUtilities.refreshLog();
        this.checkStopAfter("1");
        this.processPhase2(targetPath);
        FAIRSpecUtilities.refreshLog();
        this.checkStopAfter("2");
        return this.processPhase3();
    }

    public void finalizeExtraction(String json, int n, int failed, int nWarnings, int nErrors, String flags) {
        if (failed == 0) {
            try {
                if (json != null) {
                    String dir = this.targetPath.getAbsolutePath().replace('\\', '/');
                    String s = FAIRSpecUtilities.rep(json, dir + "/", "./");
                    File f = new File(dir + "/_IFD_findingaids.json");
                    FAIRSpecUtilities.writeBytesToFile(s.getBytes(), f);
                    this.logToSys("Extractor.runExtraction File " + f.getAbsolutePath() + " created ");
                    f = new File(dir + "/_IFD_findingaids.js");
                    FAIRSpecUtilities.writeBytesToFile(("IFD.findingAids=" + s).getBytes(), f);
                    this.logToSys("Extractor.runExtraction File " + f.getAbsolutePath() + " created \n" + json);
                } else {
                    this.logToSys("Extractor.runExtraction _IFD_findingaids.json was not created for\n" + json);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nWarnings == -1) {
            nWarnings = this.warnings;
        }
        if (nErrors == -1) {
            nErrors = this.errors;
        }
        if (nWarnings > 0) {
            try {
                FAIRSpecUtilities.writeBytesToFile((this.warnings + nWarnings + " warnings\n" + this.strWarnings).getBytes(), new File(this.targetDir + "/_IFD_warnings.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.logToSys("");
        System.err.flush();
        System.out.flush();
        System.err.println(this.errorLog);
        System.err.flush();
        System.out.flush();
        this.logToSys("!Extractor.runExtraction flags " + flags);
        this.logToSys("!Extractor " + (failed == 0 ? "done" : "failed") + " total=" + n + " failed=" + failed + " errors=" + nErrors + " warnings=" + nWarnings);
    }

    @Override
    public String getCodeSource() {
        return codeSource;
    }

    @Override
    public String getVersion() {
        return version;
    }

    public void run(File ifdExtractScriptFile, File targetPath, String localsourceArchive) throws IOException, IFDException {
        File htmlPath;
        this.log("!Extractor\n ifdExtractScriptFile= " + ifdExtractScriptFile + "\n localsourceArchive = " + localsourceArchive + "\n targetDir = " + targetPath.getAbsolutePath());
        File file = htmlPath = this.insitu ? new File(localsourceArchive) : targetPath;
        if (this.assetsOnly) {
            this.buildSite(htmlPath);
            return;
        }
        String serializedFA = this.extractAndCreateFindingAid(ifdExtractScriptFile, localsourceArchive, targetPath);
        if (serializedFA == null) {
            if (!this.allowNoPubInfo) {
                throw new IFDException("Extractor failed");
            }
        } else if (this.createLandingPage) {
            if (this.insitu) {
                FAIRSpecUtilities.writeBytesToFile(serializedFA.getBytes(), new File(htmlPath, "IFD.findingaid.json"));
            }
            this.buildSite(htmlPath);
        }
        this.log("!Extractor extracted " + this.lstManifest.size() + " files (" + this.lstManifest.getByteCount() + " bytes); ignored " + this.lstIgnored.size() + " files (" + this.lstIgnored.getByteCount() + " bytes); rejected " + this.lstRejected.size() + " files (" + this.lstRejected.getByteCount() + " bytes)");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(IFDExtractor.getCommandLineHelp());
            return;
        }
        new IFDExtractor().runExtraction(args);
    }
}

