/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.graph.complete;

import com.actelion.research.util.datamodel.IntArray;
import com.actelion.research.util.graph.complete.AMemorizedObject;
import com.actelion.research.util.graph.complete.IFactory;
import java.util.ArrayList;
import java.util.List;

public class ContainerMemory<S extends AMemorizedObject> {
    private static int CAPACITY_ADD = 1024;
    private List<S> li;
    private IntArray arrAvailable;
    private IFactory<S> factory;

    public ContainerMemory(int n, IFactory<S> iFactory) {
        this.factory = iFactory;
        this.arrAvailable = new IntArray(n);
        this.li = new ArrayList<S>(n);
        this.initResources(n);
    }

    public void reset() {
        this.arrAvailable.reset();
        for (int i = 0; i < this.li.size(); ++i) {
            this.arrAvailable.add(i);
        }
    }

    private void initResources(int n) {
        int n2 = this.li.size();
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + i;
            S s = this.factory.createObject();
            ((AMemorizedObject)s).setPositionInContainer(n3);
            this.li.add(s);
            this.arrAvailable.add(n3);
        }
    }

    public S get() {
        if (this.arrAvailable.length() == 0) {
            this.initResources(CAPACITY_ADD);
        }
        int n = this.arrAvailable.removeLast();
        AMemorizedObject aMemorizedObject = (AMemorizedObject)this.li.get(n);
        aMemorizedObject.reset();
        return (S)aMemorizedObject;
    }

    public void back(S s) {
        this.arrAvailable.add(((AMemorizedObject)s).getPositionInContainer());
    }

    public S getWithCopy(S s) {
        S s2 = this.get();
        ((AMemorizedObject)s2).copyIntoThis((AMemorizedObject)s);
        return s2;
    }
}

