/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.Formatter;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ScorePoint
extends Point {
    private static final long serialVersionUID = 24052013L;
    private double score;

    public ScorePoint() {
        super(-1, -1);
    }

    public ScorePoint(Point point) {
        super(point);
    }

    public ScorePoint(Point point, double d) {
        super(point);
        this.score = d;
    }

    public ScorePoint(int n, int n2, double d) {
        super(n, n2);
        this.score = d;
    }

    public ScorePoint(int n, int n2) {
        super(n, n2);
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("x " + this.x);
        stringBuilder.append(" y " + this.y);
        stringBuilder.append(" " + Formatter.format3(this.score));
        return stringBuilder.toString();
    }

    public static List<ScorePoint> read(File file) throws IOException {
        ArrayList<ScorePoint> arrayList = new ArrayList<ScorePoint>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\\t");
            int n = Integer.parseInt(stringArray[0].trim());
            int n2 = Integer.parseInt(stringArray[1].trim());
            double d = Double.parseDouble(stringArray[2].trim());
            arrayList.add(new ScorePoint(n, n2, d));
        }
        bufferedReader.close();
        return arrayList;
    }

    public static int[] extractX(List<ScorePoint> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get((int)i).x;
        }
        return nArray;
    }

    public static Comparator<ScorePoint> getComparatorScore() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint scorePoint, ScorePoint scorePoint2) {
                if (scorePoint.score > scorePoint2.score) {
                    return 1;
                }
                if (scorePoint.score < scorePoint2.score) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<ScorePoint> getComparatorX() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint scorePoint, ScorePoint scorePoint2) {
                if (scorePoint.x > scorePoint2.x) {
                    return 1;
                }
                if (scorePoint.x < scorePoint2.x) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<ScorePoint> getComparatorY() {
        return new Comparator<ScorePoint>(){

            @Override
            public int compare(ScorePoint scorePoint, ScorePoint scorePoint2) {
                if (scorePoint.y > scorePoint2.y) {
                    return 1;
                }
                if (scorePoint.y < scorePoint2.y) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

