/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.Arrow;
import com.actelion.research.util.DblPoint;
import com.actelion.research.util.LittleEndianDataInputStream;
import com.actelion.research.util.LittleEndianDataOutputStream;
import com.actelion.research.util.Rect;
import com.actelion.research.util.Rect2D;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class Sketch {
    private static final boolean debug_ = false;
    public static final double PI = 3.1415926;
    public static final int MAXMOLS = 12;
    public static final byte $Version = 1;
    public static final byte $Totobjs = 2;
    public static final byte $Obj = 3;
    public static final byte $Locked = 4;
    public static final byte $Pen_width = 5;
    public static final byte $Pen_style = 6;
    public static final byte $Pen_color = 7;
    public static final byte $Transparent = 8;
    public static final byte $Fill_style = 9;
    public static final byte $Fill_color = 10;
    public static final byte $Font = 11;
    public static final byte $Parent = 12;
    public static final byte $Obj_coords = 13;
    public static final byte $Crop_coords = 14;
    public static final byte $Roundrect_curve = 15;
    public static final byte $Arc_endpts = 16;
    public static final byte $Poly_points = 17;
    public static final byte $Poly_smoothed = 18;
    public static final byte $Begsketch = 19;
    public static final byte $Endsketch = 20;
    public static final byte $MDLEditText = 21;
    public static final byte $Atom_coords = 22;
    public static final byte $Atom_type = 23;
    public static final byte $Atom_list = 24;
    public static final byte $Atom_alias = 25;
    public static final byte $Atom_number = 26;
    public static final byte $Atom_chg = 27;
    public static final byte $Atom_rad = 28;
    public static final byte $Atom_msdif = 29;
    public static final byte $Atom_valence = 30;
    public static final byte $Atom_rbcount = 31;
    public static final byte $Atom_substcount = 32;
    public static final byte $Atom_stereo_care = 33;
    public static final byte $Atom_h0bit = 34;
    public static final byte $Atom_unsat = 35;
    public static final byte $Atom_value = 36;
    public static final byte $Atom_dispflags = 37;
    public static final byte $Atom_hpos = 38;
    public static final byte $Bond_atoms = 39;
    public static final byte $Bond_type = 40;
    public static final byte $Bond_stereo_type = 41;
    public static final byte $Bond_topo = 42;
    public static final byte $Bond_qtopo = 43;
    public static final byte $Bond_rxn_center = 44;
    public static final byte $Bond_stereo_care = 45;
    public static final byte $Bond_dbl_side = 46;
    public static final byte $Bond_dbl_width = 47;
    public static final byte $RxnAtch = 48;
    public static final byte $RGroupNo = 49;
    public static final byte $RLogic = 50;
    public static final byte $SGroupAtch = 51;
    public static final byte $SGroupName = 52;
    public static final byte $Atom_rgroupAtch = 53;
    public static final byte $SGroupType = 54;
    public static final byte $SGroupLinkVal = 55;
    public static final byte $ArrowDir = 56;
    public static final byte $ArrowStyle = 57;
    public static final byte $MetaData = 58;
    public static final byte $Mol_type = 59;
    public static final byte $Abbrev_atch = 60;
    public static final byte $SGroupAtchPt = 61;
    public static final byte $Atom_npos = 62;
    public static final byte $Atom_aamapped = 63;
    public static final byte $Name = 64;
    public static final byte $Comment = 65;
    public static final byte $Atom_fixed = 66;
    public static final byte $3D_num_basis_objs = 67;
    public static final byte $3D_basis_objs = 68;
    public static final byte $3D_name = 69;
    public static final byte $3D_minval = 70;
    public static final byte $3D_maxval = 71;
    public static final byte $3D_tolerance = 72;
    public static final byte $3D_point_dist = 73;
    public static final byte $3D_dihed_chiral = 74;
    public static final byte $3D_exclus_radius = 75;
    public static final byte $3D_point_dir = 76;
    public static final byte $3D_atom_query = 77;
    public static final byte $Atom_zcoord = 78;
    public static final byte $Atom_exact_change = 79;
    public static final byte $Atom_rxn_stereo = 80;
    public static final byte $Bond_crossed = 81;
    public static final byte $Bond_alt_stereo = 82;
    public static final byte $3D_exclus_ignore = 83;
    public static final byte $Pen_style_token = 84;
    public static final byte $BigMetaData = 85;
    public static final byte $Pen_RGB2Color = 88;
    public static final byte $Fill_RGB2Color = 89;
    public static final byte $Atom_tplatchpt = 91;
    public static final byte $Is_A_Model = 92;
    public static final byte $Atom_aamap_num = 96;
    public static final byte $Atom_hshow = 98;
    public static final byte $SGroupNewAtch = -92;
    public static final byte $SGroupContext = -54;
    public static final byte $Nostruct_label = -53;
    public static final byte $Nostruct_regno = -52;
    public static final byte $Circ_Arc_Points = -51;
    public static final byte $Bond_hash_spacing = -50;
    public static final byte $Bond_bond_spacing = -49;
    public static final byte $Atom_margin_width = -48;
    public static final byte $ArrowType = -36;
    public static final byte $Atom_Orig_coords = -33;
    public static final byte $Atom_AttachLen = -32;
    public static final byte $Atom_DotWidth = -31;
    public static final byte $SGroupBracketLen = -30;
    public static final byte $3D_marker_rf = -29;
    public static final byte $Model_Rotated = -28;
    public static final byte $ArrowSize = -27;
    public static final byte $ArrowShaftSp = -26;
    public static final byte $Pen_widthUnit = -25;
    public static final byte $Atom_symbol = -24;
    public static final byte $Atom_NumSize = -23;
    public static final byte $3D_exclus_dradius = -22;
    public static final byte $Atom_can_reverse = -21;
    public static final byte $3D_point_ddist = -20;
    public static final byte $Obj_Mol = 12;
    public static final byte $Obj_Chiral = 19;
    public static final byte $Obj_Bond = 32;
    public static final byte $Obj_Atom = 33;
    public static final int MSDIFF_OFFSET = 19;
    private static String DefaultFontName = "Arial";
    private static final int BYTESIZE = 1;
    private static final int WORDSIZE = 2;
    private static final int MOLSIZE = 1440;
    private static final int REACTIONSIZE = 4000;
    private static final int PLUSSIZE = 20;

    public static boolean createMolFromSketchFile(StereoMolecule stereoMolecule, String string) throws IOException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return Sketch.createMolFromSketchBuffer(stereoMolecule, byArray);
    }

    public static boolean createMolFromSketchBuffer(StereoMolecule stereoMolecule, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(byteArrayInputStream);
        return Sketch.getMolObjects(stereoMolecule, littleEndianDataInputStream);
    }

    public static boolean writeMolSketchFile(Molecule molecule, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        boolean bl = Sketch.writeMolSketchFile(molecule, fileOutputStream);
        fileOutputStream.close();
        return bl;
    }

    public static boolean writeMolSketchFile(Molecule molecule, OutputStream outputStream) throws IOException {
        boolean bl = false;
        byte[] byArray = Sketch.createSketchFromMol(molecule);
        if (byArray != null) {
            outputStream.write(byArray);
            bl = true;
        }
        return bl;
    }

    public static boolean createReactionFromSketchFile(Reaction reaction, String string) throws IOException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(byteArrayInputStream);
        return Sketch.createReactionFromSketchBuffer(reaction, littleEndianDataInputStream);
    }

    public static boolean createReactionFromSketchBuffer(Reaction reaction, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(byteArrayInputStream);
        return Sketch.createReactionFromSketchBuffer(reaction, littleEndianDataInputStream);
    }

    public static boolean writeReactionSketchFile(Reaction reaction, String string) throws IOException {
        boolean bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        if (Sketch.writeReactionSketchFile(reaction, fileOutputStream)) {
            fileOutputStream.flush();
            fileOutputStream.close();
            bl = true;
        }
        return bl;
    }

    public static boolean writeReactionSketchFile(Reaction reaction, OutputStream outputStream) throws IOException {
        boolean bl = false;
        byte[] byArray = Sketch.createSketchFromReaction(reaction);
        if (byArray != null) {
            outputStream.write(byArray);
            bl = true;
        }
        return bl;
    }

    private static boolean getMolObjects(StereoMolecule stereoMolecule, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        int n = 0;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        boolean bl2 = false;
        block14: do {
            by = littleEndianDataInputStream.readByte();
            block1 : switch (by) {
                case 1: {
                    n = 0;
                    short s = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    break;
                }
                case 2: {
                    short s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readShort();
                    n = -1;
                    break;
                }
                case 11: {
                    short s = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    littleEndianDataInputStream.readFully(byArray, 0, by2);
                    littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readByte();
                    break;
                }
                case 20: {
                    short s;
                    try {
                        s = littleEndianDataInputStream.readShort();
                    }
                    catch (IOException iOException) {
                        System.err.println("Error found $Endsketch, but no data...");
                    }
                    continue block14;
                }
                case 3: {
                    short s = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    switch (by2) {
                        case 12: {
                            StereoMolecule stereoMolecule2 = new StereoMolecule();
                            if (!Sketch.getMolObject(stereoMolecule2, littleEndianDataInputStream)) {
                                return false;
                            }
                            stereoMolecule.addMolecule(stereoMolecule2);
                            if (stereoMolecule2.isFragment()) {
                                stereoMolecule.setFragment(true);
                            }
                            bl = true;
                            break block1;
                        }
                        case 19: {
                            bl2 = true;
                            ++n;
                            break block1;
                        }
                    }
                    System.out.println("Warning: Sketch.getMolObjects() Object not supported: " + by2);
                    ++n;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    short s = littleEndianDataInputStream.readShort();
                    if (s <= 2) continue block14;
                    littleEndianDataInputStream.readFully(byArray, 0, s - 2);
                }
            }
        } while (by != -1 && littleEndianDataInputStream.in.available() > 0);
        if (!bl2) {
            stereoMolecule.setToRacemate();
        }
        return bl;
    }

    private static boolean createReactionFromSketchBuffer(Reaction reaction, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        StereoMolecule stereoMolecule = null;
        Rect rect = new Rect();
        Arrow arrow = new Arrow();
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        int n = Sketch.readSketchHeader(littleEndianDataInputStream);
        if (n > 1) {
            block6: for (int i = 0; i < n; ++i) {
                switch (Sketch.getNextObject(littleEndianDataInputStream)) {
                    case 9: {
                        String string = Sketch.getTextObject(rect, littleEndianDataInputStream);
                        if (string != "+") continue block6;
                        continue block6;
                    }
                    case 12: {
                        stereoMolecule = new StereoMolecule();
                        Sketch.getMolObject(stereoMolecule, littleEndianDataInputStream);
                        stereoMolecule.ensureHelperArrays(1);
                        arrayList.add(stereoMolecule);
                        continue block6;
                    }
                    case 14: {
                        Sketch.getArrowObject(arrow, littleEndianDataInputStream);
                        continue block6;
                    }
                    case 4: {
                        Sketch.getLineArrowObject(arrow, littleEndianDataInputStream);
                        continue block6;
                    }
                    default: {
                        System.err.println("Warning: Sketch.createReactionFromSketchBuffer(): UnKnown Object");
                    }
                }
            }
            Sketch.buildReaction(reaction, arrayList, arrow);
            return true;
        }
        return false;
    }

    private static void buildReaction(Reaction reaction, ArrayList<StereoMolecule> arrayList, Arrow arrow) {
        int n = arrayList.size();
        StereoMolecule stereoMolecule = null;
        for (int i = 0; i < n; ++i) {
            stereoMolecule = arrayList.get(i);
            Point point = Sketch.getMoleculeCenter(stereoMolecule);
            if (arrow.left > point.x) {
                reaction.addReactant(stereoMolecule);
                continue;
            }
            reaction.addProduct(stereoMolecule);
        }
    }

    private static Rect getBoundingRect(Molecule molecule) {
        Rect rect = new Rect(Short.MAX_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, Short.MIN_VALUE);
        int n = molecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            float f = (short)molecule.getAtomX(i);
            float f2 = (short)molecule.getAtomY(i);
            rect.left = (short)Math.min(f, (float)rect.left);
            rect.top = (short)Math.min(f2, (float)rect.top);
            rect.right = (short)Math.max(f, (float)rect.right);
            rect.bottom = (short)Math.max(f2, (float)rect.bottom);
        }
        Sketch.debug("Bounding Rect for Molecule " + molecule + " is " + rect.left + "," + rect.top + "," + rect.right + "," + rect.bottom);
        return rect;
    }

    private static Rect2D getBoundingRectangle(Molecule molecule) {
        Rect2D rect2D = new Rect2D(Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        int n = molecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            double d = molecule.getAtomX(i);
            double d2 = molecule.getAtomY(i);
            rect2D.left = Math.min(d, rect2D.left);
            rect2D.top = Math.min(d2, rect2D.top);
            rect2D.right = Math.max(d, rect2D.right);
            rect2D.bottom = Math.max(d2, rect2D.bottom);
        }
        Sketch.debug("Bounding Rect2D for Molecule " + molecule + " is " + rect2D.left + "," + rect2D.top + "," + rect2D.right + "," + rect2D.bottom);
        return rect2D;
    }

    private static Rect2D getBoundingRectangle(Reaction reaction) {
        Rect2D rect2D = new Rect2D(Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        Rect2D rect2D2 = null;
        int n = reaction.getMolecules();
        for (int i = 0; i < n; ++i) {
            rect2D2 = Sketch.getBoundingRectangle(reaction.getMolecule(i));
            rect2D.left = Math.min(rect2D.left, rect2D2.left);
            rect2D.top = Math.min(rect2D.top, rect2D2.top);
            rect2D.right = Math.max(rect2D.right, rect2D2.right);
            rect2D.bottom = Math.max(rect2D.bottom, rect2D2.bottom);
        }
        Sketch.debug("Bounding Rect2D for Reaction " + reaction + " is " + rect2D.left + "," + rect2D.top + "," + rect2D.right + "," + rect2D.bottom);
        return rect2D;
    }

    private static Point getMoleculeCenter(Molecule molecule) {
        Rect rect = Sketch.getBoundingRect(molecule);
        return Sketch.getCenter(rect);
    }

    private static Point getCenter(Rect rect) {
        int n = rect.right - rect.left;
        int n2 = rect.bottom - rect.top;
        return new Point(rect.left + n / 2, rect.top + n2 / 2);
    }

    private static boolean getMolObject(StereoMolecule stereoMolecule, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        byte[] byArray = new byte[1024];
        int n = 0;
        short s = 0;
        int n2 = 0;
        DblPoint dblPoint = new DblPoint();
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int[] nArray = new int[stereoMolecule.getMaxAtoms()];
        boolean bl = false;
        block26: do {
            by = littleEndianDataInputStream.readByte();
            switch (by) {
                case 2: {
                    short s2 = littleEndianDataInputStream.readShort();
                    s = littleEndianDataInputStream.readShort();
                    n3 = -1;
                    n6 = -1;
                    n5 = -1;
                    break;
                }
                case 3: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    switch (by2) {
                        case 32: {
                            ++n5;
                            ++n3;
                            break;
                        }
                        case 33: {
                            ++n6;
                            stereoMolecule.addAtom("C");
                            ++n3;
                            n = 0;
                            break;
                        }
                        case 19: {
                            ++n3;
                            bl = true;
                            n = 0;
                            break;
                        }
                        default: {
                            ++n3;
                        }
                    }
                    if (n4 <= 1) continue block26;
                    System.err.println("Sorry Only One Molecule supported\n");
                    throw new RuntimeException("Only One Molecule supported");
                }
                case 19: {
                    short s2 = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s2 - 2);
                    break;
                }
                case 20: {
                    short s2 = littleEndianDataInputStream.readShort();
                    Sketch.correctBondAtomNumbering(stereoMolecule, n6 + 1, n5 + 1, nArray);
                    if (!bl) {
                        stereoMolecule.setToRacemate();
                    }
                    return true;
                }
                case 22: {
                    short s2 = littleEndianDataInputStream.readShort();
                    dblPoint.x = littleEndianDataInputStream.readFloat();
                    dblPoint.y = littleEndianDataInputStream.readFloat();
                    stereoMolecule.setAtomX(n6, dblPoint.x);
                    stereoMolecule.setAtomY(n6, dblPoint.y);
                    stereoMolecule.setAtomZ(n6, 0.0);
                    nArray[n6] = n3;
                    break;
                }
                case 23: {
                    short s2 = littleEndianDataInputStream.readShort();
                    n = littleEndianDataInputStream.readShort();
                    break;
                }
                case -24: {
                    short s2 = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s2 - 2);
                    String string = Sketch.convertPascalString(byArray);
                    stereoMolecule.setAtomicNo(n6, Molecule.getAtomicNoFromLabel(string));
                    break;
                }
                case 24: {
                    boolean bl2 = false;
                    if (n == 271) {
                        bl2 = true;
                    }
                    short s2 = littleEndianDataInputStream.readShort();
                    n2 = littleEndianDataInputStream.readByte();
                    int[] nArray2 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        s = littleEndianDataInputStream.readShort();
                        nArray2[i] = s;
                    }
                    stereoMolecule.setAtomList(n6, nArray2, bl2);
                    stereoMolecule.setFragment(true);
                    break;
                }
                case 25: {
                    short s2 = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s2 - 2);
                    break;
                }
                case 26: {
                    short s2 = littleEndianDataInputStream.readShort();
                    s = littleEndianDataInputStream.readShort();
                    break;
                }
                case 27: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    stereoMolecule.setAtomCharge(n6, by2 - 16);
                    break;
                }
                case 28: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    stereoMolecule.setAtomRadical(n6, Sketch.getRadicalType(by2));
                    break;
                }
                case 29: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    if (by2 == 0) continue block26;
                    int n7 = by2 - 19;
                    int n8 = stereoMolecule.getAtomicNo(n6);
                    stereoMolecule.setAtomMass(n6, Molecule.cRoundedMass[n8] + n7);
                    break;
                }
                case 30: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    break;
                }
                case 39: {
                    short s2 = littleEndianDataInputStream.readShort();
                    short s3 = littleEndianDataInputStream.readShort();
                    short s4 = littleEndianDataInputStream.readShort();
                    stereoMolecule.addBond(s3, s4, 1);
                    break;
                }
                case 40: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    Sketch.setBondFeatures(stereoMolecule, n5, by2, 0, 0);
                    break;
                }
                case 41: {
                    short s2 = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    Sketch.setBondFeatures(stereoMolecule, n5, 0, by2, 0);
                    break;
                }
                case 96: {
                    short s2 = littleEndianDataInputStream.readShort();
                    s = littleEndianDataInputStream.readShort();
                    stereoMolecule.setAtomMapNo(n6, s, false);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    short s2 = littleEndianDataInputStream.readShort();
                    if (s2 <= 2) continue block26;
                    littleEndianDataInputStream.readFully(byArray, 0, s2 - 2);
                }
            }
        } while (by != -1);
        return false;
    }

    private static int findAtomIndex(StereoMolecule stereoMolecule, int n, int[] nArray) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private static boolean correctBondAtomNumbering(StereoMolecule stereoMolecule, int n, int n2, int[] nArray) {
        int n3;
        int n4 = n2;
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = Sketch.findAtomIndex(stereoMolecule, stereoMolecule.getBondAtom(0, n3), nArray);
            int n6 = Sketch.findAtomIndex(stereoMolecule, stereoMolecule.getBondAtom(1, n3), nArray);
            if (n5 == -1 || n6 == -1) {
                return false;
            }
            stereoMolecule.setBondAtom(0, n3, n5);
            stereoMolecule.setBondAtom(1, n3, n6);
        }
        n4 = n;
        for (n3 = 0; n3 < n4; ++n3) {
        }
        return true;
    }

    private static String convertPascalString(byte[] byArray) {
        if (byArray == null || byArray[0] > 255) {
            return null;
        }
        return new String(byArray, 1, (int)byArray[0]);
    }

    private static void setBondFeatures(StereoMolecule stereoMolecule, int n, int n2, int n3, int n4) {
        int n5 = 0;
        boolean bl = false;
        block0 : switch (n3) {
            case 1: {
                n5 = 257;
                break;
            }
            case 3: {
                n5 = 386;
                break;
            }
            case 4: {
                n5 = 257;
                bl = true;
                break;
            }
            case 6: {
                n5 = 129;
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        n5 = 1;
                        break block0;
                    }
                    case 2: {
                        n5 = 2;
                        break block0;
                    }
                    case 3: {
                        n5 = 4;
                        break block0;
                    }
                    case 4: {
                        n5 = 64;
                    }
                }
            }
        }
        if (n5 > 0) {
            stereoMolecule.setBondType(n, n5);
        }
        if (bl) {
            stereoMolecule.setAtomESR(stereoMolecule.getBondAtom(0, n), 1, -1);
        }
        int n6 = 0;
        if (n2 > 4) {
            switch (n2) {
                case 5: {
                    n6 |= 3;
                    break;
                }
                case 6: {
                    n6 |= 9;
                    break;
                }
                case 7: {
                    n6 |= 0xA;
                    break;
                }
                case 8: {
                    n6 |= 0x1F;
                }
            }
        }
        if (n4 == 1) {
            n6 |= 0x100;
        }
        if (n4 == 2) {
            n6 |= 0x80;
        }
        if (n6 != 0) {
            stereoMolecule.setBondQueryFeature(n, n6, true);
        }
    }

    private static int getRadicalType(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 32;
                break;
            }
            case 3: {
                n2 = 48;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private static int readSketchHeader(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        byte[] byArray = new byte[1024];
        block5: while ((by = littleEndianDataInputStream.readByte()) != -1) {
            short s;
            switch (by) {
                case 1: {
                    s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readByte();
                    continue block5;
                }
                case 2: {
                    s = littleEndianDataInputStream.readShort();
                    short s2 = littleEndianDataInputStream.readShort();
                    return s2;
                }
                case 64: 
                case 65: {
                    s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s - 2);
                    continue block5;
                }
            }
            s = littleEndianDataInputStream.readShort();
            littleEndianDataInputStream.readFully(byArray, 0, s - 2);
            return 0;
        }
        return 0;
    }

    private static int getNextObject(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        byte[] byArray = new byte[1024];
        while ((by = littleEndianDataInputStream.readByte()) != -1) {
            short s;
            switch (by) {
                case 3: {
                    s = littleEndianDataInputStream.readShort();
                    byte by2 = littleEndianDataInputStream.readByte();
                    return by2;
                }
            }
            s = littleEndianDataInputStream.readShort();
            littleEndianDataInputStream.readFully(byArray, 0, s - 2);
        }
        return 0;
    }

    private static String getTextObject(Rect rect, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        String string = null;
        byte[] byArray = new byte[1024];
        littleEndianDataInputStream.in.mark(1);
        block5: while ((by = littleEndianDataInputStream.readByte()) != -1) {
            switch (by) {
                case 13: {
                    short s = littleEndianDataInputStream.readShort();
                    rect.left = littleEndianDataInputStream.readShort();
                    rect.top = littleEndianDataInputStream.readShort();
                    rect.right = littleEndianDataInputStream.readShort();
                    rect.bottom = littleEndianDataInputStream.readShort();
                    continue block5;
                }
                case 21: {
                    short s = littleEndianDataInputStream.readShort();
                    string = Sketch.getMDLText(littleEndianDataInputStream);
                    continue block5;
                }
                case 8: 
                case 14: 
                case 48: 
                case 88: {
                    short s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s - 2);
                    continue block5;
                }
            }
            littleEndianDataInputStream.in.reset();
            return string;
        }
        return string;
    }

    private static String getMDLText(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readFully(byArray, 0, 12);
        int n = littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readInt();
        littleEndianDataInputStream.readShort();
        littleEndianDataInputStream.readFully(byArray, 0, 32);
        littleEndianDataInputStream.readByte();
        littleEndianDataInputStream.readShort();
        byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = littleEndianDataInputStream.readByte();
            littleEndianDataInputStream.readByte();
        }
        return new String(byArray2);
    }

    private static boolean getArrowObject(Arrow arrow, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        int n = 12;
        int n2 = 0;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        littleEndianDataInputStream.in.mark(1);
        while ((by = littleEndianDataInputStream.readByte()) != -1) {
            switch (by) {
                case 13: {
                    short s = littleEndianDataInputStream.readShort();
                    arrow.left = littleEndianDataInputStream.readShort();
                    arrow.top = littleEndianDataInputStream.readShort();
                    arrow.right = littleEndianDataInputStream.readShort();
                    arrow.bottom = littleEndianDataInputStream.readShort();
                    bl = true;
                    break;
                }
                case -36: 
                case -27: 
                case -26: 
                case -25: 
                case 5: 
                case 14: 
                case 56: 
                case 57: 
                case 84: 
                case 88: {
                    short s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s - 2);
                    break;
                }
                case 48: {
                    short s = littleEndianDataInputStream.readShort();
                    arrow.attach[0] = littleEndianDataInputStream.readShort();
                    arrow.attach[1] = littleEndianDataInputStream.readShort();
                    break;
                }
                default: {
                    littleEndianDataInputStream.in.reset();
                    return bl;
                }
            }
            if (++n2 < n) continue;
            return bl;
        }
        return bl;
    }

    private static boolean getLineArrowObject(Arrow arrow, LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        byte by;
        int n = 13;
        int n2 = 0;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        littleEndianDataInputStream.in.mark(1);
        while ((by = littleEndianDataInputStream.readByte()) != -1) {
            switch (by) {
                case 13: {
                    short s = littleEndianDataInputStream.readShort();
                    arrow.left = littleEndianDataInputStream.readShort();
                    arrow.top = littleEndianDataInputStream.readShort();
                    arrow.right = littleEndianDataInputStream.readShort();
                    arrow.bottom = littleEndianDataInputStream.readShort();
                    bl = true;
                    break;
                }
                case -36: 
                case -27: 
                case -26: 
                case -25: 
                case 5: 
                case 9: 
                case 56: 
                case 57: 
                case 84: 
                case 88: 
                case 89: {
                    short s = littleEndianDataInputStream.readShort();
                    littleEndianDataInputStream.readFully(byArray, 0, s - 2);
                    break;
                }
                case 48: {
                    short s = littleEndianDataInputStream.readShort();
                    arrow.attach[0] = littleEndianDataInputStream.readShort();
                    arrow.attach[1] = littleEndianDataInputStream.readShort();
                    break;
                }
                default: {
                    littleEndianDataInputStream.in.reset();
                    return bl;
                }
            }
            if (++n2 < n) continue;
            return bl;
        }
        return bl;
    }

    private static int writeSketchHeader(LittleEndianDataOutputStream littleEndianDataOutputStream, int n) throws IOException {
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)1, (byte)4);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)2, (short)n);
        Sketch.Write97(littleEndianDataOutputStream);
        int n2 = 88;
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeShort(5);
        n2 = 0;
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeByte(n2);
        n2 = 89;
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeShort(5);
        n2 = 0;
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeByte(n2);
        littleEndianDataOutputStream.writeByte(n2);
        int n3 = DefaultFontName.length();
        littleEndianDataOutputStream.writeByte(11);
        littleEndianDataOutputStream.writeShort((short)(n3 + 4 + 2));
        littleEndianDataOutputStream.writeByte((byte)n3);
        littleEndianDataOutputStream.writeBytes(DefaultFontName);
        littleEndianDataOutputStream.writeShort(120);
        littleEndianDataOutputStream.writeByte(0);
        return 1;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by, byte by2) throws IOException {
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort(3);
        littleEndianDataOutputStream.writeByte(by2);
        return 4;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by, String string) throws IOException {
        int n = string.length();
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort((short)(n + 1 + 2));
        littleEndianDataOutputStream.writeByte((byte)n);
        littleEndianDataOutputStream.writeBytes(string);
        return n + 5;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by, short s) throws IOException {
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort(4);
        littleEndianDataOutputStream.writeShort(s);
        return 5;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by, DblPoint dblPoint) throws IOException {
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort(10);
        littleEndianDataOutputStream.writeFloat(dblPoint.x);
        littleEndianDataOutputStream.writeFloat(dblPoint.y);
        return 11;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by, Rect rect) throws IOException {
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort(10);
        littleEndianDataOutputStream.writeShort(rect.left);
        littleEndianDataOutputStream.writeShort(rect.top);
        littleEndianDataOutputStream.writeShort(rect.right);
        littleEndianDataOutputStream.writeShort(rect.bottom);
        return 11;
    }

    private static int writeProperty(LittleEndianDataOutputStream littleEndianDataOutputStream, byte by) throws IOException {
        littleEndianDataOutputStream.writeByte(by);
        littleEndianDataOutputStream.writeShort(2);
        return 3;
    }

    private static int Write97(LittleEndianDataOutputStream littleEndianDataOutputStream) throws IOException {
        int n = 97;
        littleEndianDataOutputStream.writeByte((byte)n);
        littleEndianDataOutputStream.writeShort(3);
        n = 0;
        littleEndianDataOutputStream.writeByte((byte)n);
        return 4;
    }

    private static void translateMolecule(Molecule molecule) {
        Rect2D rect2D = Sketch.getBoundingRectangle(molecule);
        double d = 0.0;
        double d2 = 0.0;
        if (rect2D.left < 0.0) {
            d = 0.0 - rect2D.left;
        }
        if (rect2D.top < 0.0) {
            d2 = 0.0 - rect2D.top;
        }
        Sketch.translateMolecule(molecule, d, d2);
    }

    private static void translateMolecule(Molecule molecule, double d, double d2) {
        int n = molecule.getAllAtoms();
        Sketch.debug("Translate molecule " + d + " " + d2);
        for (int i = 0; i < n; ++i) {
            molecule.setAtomX(i, molecule.getAtomX(i) + d);
            molecule.setAtomY(i, molecule.getAtomY(i) + d2);
        }
    }

    private static void translateReaction(Reaction reaction) {
        Rect2D rect2D = Sketch.getBoundingRectangle(reaction);
        double d = 0.0;
        double d2 = 0.0;
        if (rect2D.left < 0.0) {
            d = 0.0 - rect2D.left;
        }
        if (rect2D.top < 0.0) {
            d2 = 0.0 - rect2D.top;
        }
        int n = reaction.getMolecules();
        for (int i = 0; i < n; ++i) {
            Sketch.translateMolecule(reaction.getMolecule(i), d, d2);
        }
    }

    private static void scaleMolecule(Molecule molecule, int n) {
        Rect2D rect2D = Sketch.getBoundingRectangle(molecule);
        double d = Math.abs(rect2D.right - rect2D.left);
        double d2 = Math.abs(rect2D.bottom - rect2D.top);
        double d3 = (double)n / Math.max(d, d2);
        Sketch.scaleMolecule(molecule, d3);
    }

    private static void scaleMolecule(Molecule molecule, double d) {
        int n = molecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            molecule.setAtomX(i, molecule.getAtomX(i) * d);
            molecule.setAtomY(i, molecule.getAtomY(i) * d);
            molecule.setAtomZ(i, molecule.getAtomZ(i) * d);
        }
    }

    private static double getScaleFactor(Reaction reaction) {
        Rect2D rect2D = Sketch.getBoundingRectangle(reaction);
        double d = 4000.0 / (rect2D.right - rect2D.left);
        return d;
    }

    private static void scaleReaction(Reaction reaction, double d) {
        Sketch.debug("Scaling Reaciton at " + d);
        int n = reaction.getMolecules();
        for (int i = 0; i < n; ++i) {
            Sketch.scaleMolecule((Molecule)reaction.getMolecule(i), d);
        }
    }

    public static byte[] createSketchFromMol(Molecule molecule) {
        byte[] byArray = null;
        StereoMolecule stereoMolecule = new StereoMolecule(molecule);
        try {
            if (stereoMolecule.getAllAtoms() > 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
                Sketch.writeSketchHeader(littleEndianDataOutputStream, 1);
                Sketch.translateMolecule(stereoMolecule);
                Sketch.scaleMolecule((Molecule)stereoMolecule, 1440);
                Sketch.writeMoleculeToSketch(littleEndianDataOutputStream, stereoMolecule, 1.0);
                Sketch.writeProperty(littleEndianDataOutputStream, (byte)20);
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            System.err.println("Sketch.SketchFromMol() " + iOException);
        }
        return byArray;
    }

    public static byte[] createSketchFromReaction(Reaction reaction) throws IOException {
        Rect rect;
        Rect rect2;
        Object object;
        int n;
        Reaction reaction2 = new Reaction(reaction);
        int n2 = reaction2.getReactants();
        int n3 = reaction2.getProducts();
        int n4 = n3 + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
        Sketch.translateReaction(reaction2);
        double d = Sketch.getScaleFactor(reaction2);
        Sketch.scaleReaction(reaction2, d);
        Sketch.writeSketchHeader(littleEndianDataOutputStream, n4 + n2 - 1 + n3 - 1 + 1);
        for (n = 0; n < n2; ++n) {
            object = reaction2.getMolecule(n);
            rect2 = Sketch.getBoundingRect((Molecule)object);
            Sketch.debug("Drawing reactant " + n + " @ " + rect2.left + "," + rect2.top + "," + rect2.right + "," + rect2.bottom);
            Sketch.writeMoleculeToSketch(littleEndianDataOutputStream, (Molecule)object, (short)-1, (short)-1, 1.0);
            if (n >= n2 - 1) continue;
            Rect rect3 = Sketch.getBoundingRect(reaction2.getMolecule(n + 1));
            rect = Sketch.calcMiddleRect(rect2, rect3, 20);
            Sketch.debug("Writing plus at " + rect.left + "," + rect.top + "," + rect.right + "," + rect.bottom);
            Sketch.writePlus(littleEndianDataOutputStream, rect, -1, -1);
        }
        if (n2 > 0 && n3 > 0) {
            Rect rect4 = Sketch.getBoundingRect(reaction2.getMolecule(n2 - 1));
            object = Sketch.getBoundingRect(reaction2.getMolecule(n2));
            rect2 = Sketch.calcMiddleRect(rect4, (Rect)object, 1);
            int n5 = (((Rect)object).left - rect4.right) / 4;
            rect2.left = (short)(rect2.left - n5);
            rect2.right = (short)(rect2.right + n5);
            Sketch.writeArrowObject(littleEndianDataOutputStream, rect2, -1, -1);
        }
        for (n = n2; n < n4; ++n) {
            object = reaction2.getMolecule(n);
            rect2 = Sketch.getBoundingRect((Molecule)object);
            Sketch.debug("Drawing prod " + n + " @ " + rect2.left + "," + rect2.top + "," + rect2.right + "," + rect2.bottom);
            Sketch.writeMoleculeToSketch(littleEndianDataOutputStream, (Molecule)object, (short)-1, (short)-1, 1.0);
            if (n >= n4 - 1) continue;
            Rect rect5 = Sketch.getBoundingRect(reaction2.getMolecule(n + 1));
            rect = Sketch.calcMiddleRect(rect2, rect5, 20);
            Sketch.writePlus(littleEndianDataOutputStream, rect, -1, -1);
        }
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)20);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSketchFromReactionOLd(Reaction reaction) throws IOException {
        Rect rect;
        Rect rect2;
        Object object;
        int n;
        int n2 = reaction.getReactants();
        int n3 = reaction.getProducts();
        int n4 = n3 + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
        Rect2D rect2D = Sketch.getBoundingRectangle(reaction);
        float f = (float)(rect2D.right - rect2D.left);
        f = 5000.0f / f;
        Sketch.writeSketchHeader(littleEndianDataOutputStream, n4 + n2 - 1 + n3 - 1 + 1);
        for (n = 0; n < n2; ++n) {
            object = reaction.getMolecule(n);
            rect2 = Sketch.getBoundingRect((Molecule)object);
            Sketch.writeMoleculeToSketch(littleEndianDataOutputStream, (Molecule)object, (short)-1, (short)-1, f);
            if (n >= n2 - 1) continue;
            Rect rect3 = Sketch.getBoundingRect(reaction.getMolecule(n + 1));
            rect = Sketch.calcMiddleRect(rect2, rect3, 5);
            Sketch.scaleRect(rect, f);
            Sketch.writePlus(littleEndianDataOutputStream, rect, -1, -1);
        }
        if (n2 > 0 && n3 > 0) {
            Rect rect4 = Sketch.getBoundingRect(reaction.getMolecule(n2 - 1));
            object = Sketch.getBoundingRect(reaction.getMolecule(n2));
            rect2 = Sketch.calcMiddleRect(rect4, (Rect)object, 1);
            int n5 = (((Rect)object).left - rect4.right) / 4;
            rect2.left = (short)(rect2.left - n5);
            rect2.right = (short)(rect2.right + n5);
            Sketch.scaleRect(rect2, f);
            Sketch.writeArrowObject(littleEndianDataOutputStream, rect2, -1, -1);
        }
        for (n = n2; n < n4; ++n) {
            object = reaction.getMolecule(n);
            rect2 = Sketch.getBoundingRect((Molecule)object);
            Sketch.writeMoleculeToSketch(littleEndianDataOutputStream, (Molecule)object, (short)-1, (short)-1, f);
            if (n >= n4 - 1) continue;
            Rect rect5 = Sketch.getBoundingRect(reaction.getMolecule(n + 1));
            rect = Sketch.calcMiddleRect(rect2, rect5, 5);
            Sketch.scaleRect(rect, f);
            Sketch.writePlus(littleEndianDataOutputStream, rect, -1, -1);
        }
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)20);
        return byteArrayOutputStream.toByteArray();
    }

    private static void scaleRect(Rect rect, double d) {
        rect.left = (short)((double)rect.left * d);
        rect.top = (short)((double)rect.top * d);
        rect.right = (short)((double)rect.right * d);
        rect.bottom = (short)((double)rect.bottom * d);
    }

    private static int writeMoleculeToSketch(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, double d) throws IOException {
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)12);
        Sketch.writeSubSketch(littleEndianDataOutputStream, molecule, d);
        return 1;
    }

    private static int writeMoleculeToSketch(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, short s, short s2, double d) throws IOException {
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)12);
        int n = 48;
        littleEndianDataOutputStream.writeByte(n);
        littleEndianDataOutputStream.writeShort(6);
        littleEndianDataOutputStream.writeShort(s);
        littleEndianDataOutputStream.writeShort(s2);
        Sketch.writeSubSketch(littleEndianDataOutputStream, molecule, d);
        return 1;
    }

    private static void writeSubSketch(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, double d) throws IOException {
        int n;
        int n2 = molecule.getAllAtoms();
        int n3 = molecule.getAllBonds();
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)19);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)2, (short)(n2 + n3));
        Sketch.Write97(littleEndianDataOutputStream);
        for (n = 0; n < n2; ++n) {
            Sketch.writeAtom(littleEndianDataOutputStream, molecule, n, d);
            if (molecule.getAtomCharge(n) != 0) {
                Sketch.writeAtomCharge(littleEndianDataOutputStream, molecule, n);
            }
            if (!molecule.isNaturalAbundance(n)) {
                Sketch.writeAtomIsotope(littleEndianDataOutputStream, molecule, n);
            }
            if (molecule.getAtomRadical(n) != 0) {
                Sketch.writeAtomRadical(littleEndianDataOutputStream, molecule, n);
            }
            if (molecule.getAtomList(n) == null) continue;
            Sketch.writeAtomList(littleEndianDataOutputStream, molecule, n);
        }
        for (n = 0; n < n3; ++n) {
            Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)32);
            Sketch.writeProperty(littleEndianDataOutputStream, (byte)5, (byte)7);
            int n4 = 39;
            littleEndianDataOutputStream.writeByte(n4);
            littleEndianDataOutputStream.writeShort(6);
            littleEndianDataOutputStream.writeShort((short)molecule.getBondAtom(0, n));
            littleEndianDataOutputStream.writeShort((short)molecule.getBondAtom(1, n));
            Sketch.writeProperty(littleEndianDataOutputStream, (byte)40, (byte)Sketch.getMDLBondType(molecule.getBondType(n), false));
            Sketch.writeProperty(littleEndianDataOutputStream, (byte)41, (byte)Sketch.getMDLBondType(molecule.getBondType(n), true));
        }
        if (molecule.getChirality() != 65536 && molecule.getChirality() != 131072 && molecule.getChirality() != 196608 && molecule.getChirality() != 0) {
            Sketch.writeChiral(littleEndianDataOutputStream, molecule, d);
        }
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)20);
    }

    private static void writeAtom(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, int n, double d) throws IOException {
        DblPoint dblPoint = new DblPoint();
        dblPoint.x = (float)(molecule.getAtomX(n) * d);
        dblPoint.y = (float)(molecule.getAtomY(n) * d);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)33);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)22, dblPoint);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)-24, molecule.getAtomLabel(n));
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)26, (short)(n + 1));
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)37, (short)4);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)-48, (short)15);
        if (molecule.getAtomMapNo(n) != 0) {
            Sketch.writeProperty(littleEndianDataOutputStream, (byte)96, (short)molecule.getAtomMapNo(n));
        }
    }

    private static void writeChiral(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, double d) throws IOException {
        Rect rect = Sketch.getBoundingRect(molecule);
        Sketch.scaleRect(rect, d);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)19);
        rect.left = (short)(rect.right + 10);
        rect.right = (short)(rect.left + 300);
        rect.top = (short)(rect.top - 50);
        rect.bottom = (short)(rect.top + 40);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)13, rect);
    }

    private static void writeAtomCharge(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, int n) throws IOException {
        int n2 = molecule.getAtomCharge(n);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)27, (byte)(n2 + 16));
    }

    private static void writeAtomIsotope(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, int n) throws IOException {
        int n2 = molecule.getAtomMass(n);
        int n3 = molecule.getAtomicNo(n);
        int n4 = n2 - Molecule.cRoundedMass[n3];
        int n5 = n4 + 19;
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)29, (byte)n5);
    }

    private static void writeAtomRadical(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, int n) throws IOException {
        int n2 = 0;
        switch (molecule.getAtomRadical(n)) {
            case 16: {
                n2 = 1;
                break;
            }
            case 32: {
                n2 = 2;
                break;
            }
            case 48: {
                n2 = 3;
                break;
            }
        }
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)28, (byte)n2);
    }

    private static void writeAtomList(LittleEndianDataOutputStream littleEndianDataOutputStream, Molecule molecule, int n) throws IOException {
        int[] nArray = molecule.getAtomList(n);
        if (nArray != null) {
            boolean bl = (molecule.getAtomQueryFeatures(n) & 1L) == 1L;
            int n2 = nArray.length;
            if (n2 > 0) {
                Sketch.writeProperty(littleEndianDataOutputStream, (byte)23, (short)(bl ? 271 : 270));
                Sketch.writeProperty(littleEndianDataOutputStream, (byte)24, (byte)n2);
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray[i];
                    littleEndianDataOutputStream.writeShort(n3);
                }
            }
        }
    }

    private static int writeArrowObject(LittleEndianDataOutputStream littleEndianDataOutputStream, Rect rect, int n, int n2) throws IOException {
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)4);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)5, (byte)7);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)56, (byte)1);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)57, (byte)1);
        littleEndianDataOutputStream.writeByte(-27);
        littleEndianDataOutputStream.writeShort(8);
        littleEndianDataOutputStream.writeShort(10);
        littleEndianDataOutputStream.writeShort(10);
        littleEndianDataOutputStream.writeByte(2);
        littleEndianDataOutputStream.writeByte(2);
        littleEndianDataOutputStream.writeByte(48);
        littleEndianDataOutputStream.writeShort(6);
        littleEndianDataOutputStream.writeShort(n);
        littleEndianDataOutputStream.writeShort(n2);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)13, rect);
        return 1;
    }

    static int writeMDLText(LittleEndianDataOutputStream littleEndianDataOutputStream, String string) throws IOException {
        int n;
        int n2 = DefaultFontName.length();
        int n3 = string.length();
        int n4 = n3 * 2 + 63;
        littleEndianDataOutputStream.writeShort(n4 - 2);
        for (n = 0; n < 12; ++n) {
            littleEndianDataOutputStream.writeByte(0);
        }
        littleEndianDataOutputStream.writeShort(n3);
        littleEndianDataOutputStream.writeShort(0);
        littleEndianDataOutputStream.writeShort(1);
        littleEndianDataOutputStream.writeShort(0);
        littleEndianDataOutputStream.writeInt(49152);
        littleEndianDataOutputStream.writeShort(17);
        littleEndianDataOutputStream.writeBytes(DefaultFontName);
        for (n = 0; n < 32 - n2; ++n) {
            littleEndianDataOutputStream.writeByte(0);
        }
        littleEndianDataOutputStream.writeByte(0);
        littleEndianDataOutputStream.writeShort(120);
        for (n = 0; n < n3; ++n) {
            littleEndianDataOutputStream.writeByte((byte)string.charAt(n));
            littleEndianDataOutputStream.writeByte(0);
        }
        return n4;
    }

    static int writePlus(LittleEndianDataOutputStream littleEndianDataOutputStream, Rect rect, int n, int n2) throws IOException {
        String string = "+";
        int n3 = string.length();
        int n4 = n3 * 2 + 63;
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)3, (byte)9);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)8);
        littleEndianDataOutputStream.writeByte(48);
        littleEndianDataOutputStream.writeShort(6);
        littleEndianDataOutputStream.writeShort(n);
        littleEndianDataOutputStream.writeShort(n2);
        Sketch.writeProperty(littleEndianDataOutputStream, (byte)13, rect);
        littleEndianDataOutputStream.writeByte(21);
        littleEndianDataOutputStream.writeShort(n4 + 2);
        Sketch.writeMDLText(littleEndianDataOutputStream, string);
        return 0;
    }

    private static Rect calcMiddleRect(Rect rect, Rect rect2, int n) {
        Rect rect3 = new Rect(rect.right, rect.top, rect2.left, rect.bottom);
        Point point = Sketch.getCenter(rect3);
        return new Rect((short)(point.x - n / 2), (short)(point.y - n / 2), (short)(point.x + n / 2), (short)(point.y + n / 2));
    }

    static int getMDLBondType(int n, boolean bl) {
        int n2 = 1;
        int n3 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                n3 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                n3 = 0;
                break;
            }
            case 4: {
                n2 = 3;
                n3 = 0;
                break;
            }
            case 129: {
                n2 = 1;
                n3 = 6;
                break;
            }
            case 257: {
                n2 = 1;
                n3 = 1;
                break;
            }
            case 386: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 64: {
                n2 = 4;
                n3 = 0;
                break;
            }
            default: {
                n2 = 1;
                n3 = 0;
            }
        }
        if (bl) {
            return n3;
        }
        return n2;
    }

    private static void debug(String string) {
    }
}

