/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.IPipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class Pipeline<T>
implements IPipeline<T>,
Supplier<T> {
    private AtomicBoolean allDataIn = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private AtomicLong added = new AtomicLong();
    private AtomicLong polled = new AtomicLong();

    public Pipeline() {
    }

    public Pipeline(List<T> list) {
        this();
        this.queue.addAll(list);
        this.setAllDataIn(true);
    }

    public void reset() {
        this.allDataIn.set(false);
        this.added.set(0L);
        this.polled.set(0L);
        this.queue.clear();
    }

    @Override
    public boolean isAllDataIn() {
        return this.allDataIn.get();
    }

    @Override
    public void setAllDataIn(boolean bl) {
        this.allDataIn.set(bl);
    }

    public void setAllDataIn() {
        this.allDataIn.set(true);
    }

    public void addData(T t) {
        this.queue.add(t);
        this.added.incrementAndGet();
    }

    public void addData(List<T> list) {
        this.queue.addAll(list);
        this.added.addAndGet(list.size());
    }

    public T pollData() {
        T t = this.queue.poll();
        if (t != null) {
            this.polled.incrementAndGet();
        }
        return t;
    }

    @Override
    public T get() {
        if (this.wereAllDataFetched()) {
            return null;
        }
        T t = null;
        while (t == null) {
            t = this.pollData();
            if (t != null) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return t;
    }

    public int sizePipe() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public long getAdded() {
        return this.added.get();
    }

    public long getPolled() {
        return this.polled.get();
    }

    public List<T> pollAllWithWait() {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (!this.wereAllDataFetched()) {
            T t = this.pollData();
            if (t == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    public List<T> pollBatchWithWait(int n) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (!this.wereAllDataFetched()) {
            T t = this.pollData();
            if (t == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            arrayList.add(t);
            if (arrayList.size() != n) continue;
            break;
        }
        return arrayList;
    }

    public List<T> pollAll() {
        if (!this.isAllDataIn()) {
            throw new RuntimeException("all_data_in flag not set.");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        while (!this.isEmpty()) {
            arrayList.add(this.pollData());
        }
        return arrayList;
    }

    @Override
    public boolean wereAllDataFetched() {
        if (!this.isAllDataIn()) {
            return false;
        }
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }
}

