/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.io.StringReadChannel;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.StringFunctions;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.IntArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;

public class IO {
    private static final int LIMIT_FILES_DIR = 10000;
    public static final String SEP = System.getProperty("file.separator");

    public static boolean canWriteAndDeleteInPath(File file) throws IOException {
        boolean bl = false;
        File file2 = File.createTempFile("test", ".txt", file);
        if (file2.canWrite()) {
            bl = true;
        }
        bl = file2.delete();
        return bl;
    }

    public static BufferedReader getBufferedReader(String string) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (string.length() > 0) {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        return bufferedReader;
    }

    public static String getUniqueFileName(String string) {
        File file = new File(string);
        return IO.getUniqueFileName(file, file.getParentFile(), Formatter.dfI3).getAbsolutePath();
    }

    public static File getUniqueFileName(File file) {
        return IO.getUniqueFileName(file, file.getParentFile());
    }

    public static File getUniqueFileName(String string, String string2) {
        return IO.getUniqueFileName(new File(string), new File(string2), Formatter.dfI3);
    }

    public static File getUniqueFileName(File file, File file2) {
        return IO.getUniqueFileName(file, file2, Formatter.dfI3);
    }

    public static File getUniqueFileName(File file, File file2, DecimalFormat decimalFormat) {
        String string = file.getName();
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            return file3;
        }
        String string2 = IO.getBaseName(file);
        String string3 = IO.getExtension(file);
        String string4 = string2;
        int n = 1;
        while (file3.isFile()) {
            string4 = IO.next(string4, decimalFormat);
            string = string4 + string3;
            file3 = new File(file2, string);
            if (++n <= 10000) continue;
            string = null;
            IOException iOException = new IOException("To many files in this dir.");
            iOException.printStackTrace();
            break;
        }
        return file3;
    }

    public static File getUniqueUserDir() throws IOException {
        String string = System.getProperty("user.home");
        File file = new File(string);
        return IO.getUniqueDateDir(file);
    }

    public static File getUniqueDateDir(File file) throws IOException {
        return IO.getUniqueDateDir(file, "");
    }

    public static File getUniqueDateDir(String string) throws IOException {
        String string2 = System.getProperty("user.home");
        File file = new File(string2);
        return IO.getUniqueDateDir(file, string);
    }

    public static File getUniqueDateDir(File file, String string) throws IOException {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd");
        String string2 = simpleDateFormat.format(date);
        String string3 = string2 + string;
        File file2 = new File(file, string3);
        int n = 1;
        while (file2.exists()) {
            string3 = string2 + "_" + n + "_" + string;
            ++n;
            file2 = new File(file, string3);
        }
        if (!file2.mkdirs()) {
            String string4 = "Not possible to make dir " + file2.getAbsolutePath() + ".";
            throw new IOException(string4);
        }
        return file2;
    }

    public static File getUniqueDir(File file, String string) throws IOException {
        String string2 = string;
        File file2 = new File(file, string2);
        int n = 1;
        while (file2.exists()) {
            string2 = string + n;
            ++n;
            file2 = new File(file, string2);
        }
        if (!file2.mkdirs()) {
            String string3 = "Not possible to make dir " + file2.getAbsolutePath() + ".";
            throw new IOException(string3);
        }
        return file2;
    }

    public static String getNextFileName(String string) {
        File file = new File(string);
        return IO.getUniqueFileName(file, file.getParentFile(), Formatter.dfI3).getAbsolutePath();
    }

    public static String next(String string) {
        return IO.next(string, Formatter.dfI3);
    }

    public static String next(String string, DecimalFormat decimalFormat) {
        String string2 = "";
        int n = -1;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isDigit(string.charAt(i))) continue;
            n = i;
            break;
        }
        string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, string.length());
        DecimalFormat decimalFormat2 = decimalFormat;
        int n2 = 0;
        if (string3.length() > 0) {
            n2 = Integer.parseInt(string3);
            String string4 = "";
            for (int i = 0; i < string3.length(); ++i) {
                string4 = string4 + "0";
            }
            decimalFormat2 = new DecimalFormat(string4);
        }
        string2 = string2 + decimalFormat2.format(++n2);
        return string2;
    }

    public static BufferedWriter getBuffWrite(String string, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = null;
        if (string.length() > 0) {
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        return bufferedWriter;
    }

    public static String getBaseName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(92);
        if (n == -1) {
            n = string2.lastIndexOf(File.separator);
        }
        if (n == -1) {
            n = 0;
        }
        int n2 = string2.lastIndexOf(46);
        String string3 = "";
        if (n2 == -1) {
            n2 = string2.length();
        }
        string3 = string2.substring(n, n2);
        return string3;
    }

    public static String getBaseName(File file) {
        return IO.getBaseName(file.getAbsolutePath());
    }

    public static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(SEP) + 1;
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return "";
        }
        String string2 = string.substring(n2);
        return string2;
    }

    public static void mkdirs(String string) throws IOException {
        IO.mkdirs(new File(string));
    }

    public static void mkdirs(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Not possible to make dir " + file.getAbsolutePath() + ".");
        }
    }

    public static void readBetweenTags(String string, String string2, String string3, Vector<String> vector) {
        try {
            String string4;
            StringReadChannel stringReadChannel = new StringReadChannel(Channels.newChannel(new FileInputStream(new File(string))));
            boolean bl = false;
            boolean bl2 = false;
            while (stringReadChannel.hasMoreLines()) {
                string4 = stringReadChannel.readLine();
                if (string4 == null || !string4.matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                while (stringReadChannel.hasMoreLines()) {
                    string4 = stringReadChannel.readLine();
                    if (string4 == null) continue;
                    if (string4.matches(string3)) {
                        bl2 = true;
                        break;
                    }
                    vector.addElement(string4);
                }
            } else {
                System.err.println("Tag: " + string2 + " not found");
                new RuntimeException().printStackTrace();
            }
            stringReadChannel.close();
            if (!bl2) {
                System.err.println("Tag: " + string3 + " not found");
                new RuntimeException().printStackTrace();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static void readFromTag(String string, String string2, Vector<String> vector) {
        try {
            StringReadChannel stringReadChannel = new StringReadChannel(Channels.newChannel(new FileInputStream(new File(string))));
            boolean bl = false;
            String string3 = "";
            while (stringReadChannel.hasMoreLines()) {
                string3 = stringReadChannel.readLine();
                if (string3 == null || !string3.matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                while (stringReadChannel.hasMoreLines()) {
                    string3 = stringReadChannel.readLine();
                    if (string3 == null) continue;
                    if (string3.length() >= 1) {
                        vector.addElement(string3);
                        continue;
                    }
                    break;
                }
            } else {
                System.err.println("Tag: " + string2 + " not found");
                new RuntimeException().printStackTrace();
            }
            stringReadChannel.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static void skipUntilLineMatchesRegEx(InputStream inputStream, String string) throws Exception {
        int n = 10000;
        int n2 = 0;
        String string2 = IO.readLine(inputStream);
        while (!string2.matches(string)) {
            string2 = IO.readLine(inputStream);
            if (n2 == n) {
                throw new Exception("Limit of " + n + " lines exceeded.");
            }
            ++n2;
        }
    }

    public static String read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static List<Integer> readListIntger(File file) throws IOException {
        Scanner scanner = new Scanner(file);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (scanner.hasNextInt()) {
            arrayList.add(scanner.nextInt());
        }
        scanner.close();
        return arrayList;
    }

    public static int[] readLines2IntArray(File file) throws IOException {
        IntArray intArray = new IntArray();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            int n = Integer.parseInt(string);
            intArray.add(n);
        }
        bufferedReader.close();
        return intArray.get();
    }

    public static double[] readLines2DoubleArray(File file) throws IOException {
        DoubleArray doubleArray = new DoubleArray();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            double d = Double.parseDouble(string);
            doubleArray.add(d);
        }
        bufferedReader.close();
        return doubleArray.get();
    }

    public static String readLine(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        while ((n = inputStream.read()) != 10 && n != -1) {
            stringBuilder.append((char)n);
        }
        String string = StringFunctions.removeCharacter(stringBuilder, '\r');
        return string;
    }

    public static String read(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static String readLine(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = reader.read();
        while (n != -1 && n != 10) {
            stringBuffer.append((char)n);
            n = reader.read();
        }
        return stringBuffer.toString();
    }

    public static String readLine(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        long l = fileChannel.position();
        while (!bl) {
            byteBuffer.position(0);
            int n = fileChannel.read(byteBuffer);
            if (n == -1) break;
            for (int i = 0; i < n; ++i) {
                byte by = byteBuffer.get(i);
                ++l;
                if (by == -1) {
                    bl = true;
                    continue;
                }
                if (by == 10) {
                    fileChannel.position(l);
                    bl2 = true;
                    break;
                }
                stringBuilder.append((char)by);
            }
            if (!bl2) continue;
            break;
        }
        return stringBuilder.toString();
    }

    public static List<String> readLines2List(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static List<String> readLines2List(InputStream inputStream) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> readLines2List(List<File> list) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            arrayList.addAll(IO.readLines2List(file));
        }
        return arrayList;
    }

    public static void write(String string, String string2) {
        IO.write(string, string2, true);
    }

    public static void write(String string, String string2, boolean bl) {
        IO.write(new File(string), string2, bl);
    }

    public static void write(File file, String string) {
        IO.write(file, string, false);
    }

    public static void write(File file, String string, boolean bl) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write2Channel(FileChannel fileChannel, String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length());
        byte[] byArray = string.getBytes();
        byteBuffer.put(byArray);
        byteBuffer.flip();
        fileChannel.write(byteBuffer);
    }

    public static void write(File file, List<String> list) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (int i = 0; i < list.size(); ++i) {
            fileWriter.write(list.get(i));
            if (i >= list.size() - 1) continue;
            fileWriter.write("\n");
        }
        fileWriter.close();
    }

    public static void writeIntegerList(File file, List<Integer> list) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (int i = 0; i < list.size(); ++i) {
            fileWriter.write(list.get(i).toString());
            if (i >= list.size() - 1) continue;
            fileWriter.write("\n");
        }
        fileWriter.close();
    }

    public static void write(File file, int[] nArray) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < nArray.length; ++i) {
            bufferedWriter.write(Integer.toString(nArray[i]));
            if (i >= nArray.length - 1) continue;
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    public static void write(File file, double[] dArray) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < dArray.length; ++i) {
            bufferedWriter.write(Double.toString(dArray[i]));
            if (i >= dArray.length - 1) continue;
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    public static void saveObject(String string, Object object) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(object);
        fileOutputStream.close();
    }

    public static Object loadObject(String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        Object object = objectInputStream.readObject();
        fileInputStream.close();
        return object;
    }

    public static String readerToString(Reader reader) throws IOException {
        return IO.readerToString(reader, Integer.MAX_VALUE);
    }

    public static String readerToString(Reader reader, int n) throws IOException {
        int n2;
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        char[] cArray = new char[512];
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < n && (n2 = reader.read(cArray, 0, Math.min(cArray.length, n - stringBuilder.length()))) > 0) {
            stringBuilder.append(cArray, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static String streamToString(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read(byArray)) > 0) {
            stringBuilder.append(new String(byArray, 0, n));
        }
        return stringBuilder.toString();
    }

    public static byte[] getBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray, 0, byArray.length);
        fileInputStream.close();
        return byArray;
    }

    public static void bytesToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static void stringToFile(String string, File file) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(string);
        }
    }

    public static String fileToString(File file) throws IOException {
        return IO.fileToString(file, Integer.MAX_VALUE);
    }

    public static String fileToString(File file, int n) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            String string = IO.readerToString(fileReader, n);
            return string;
        }
    }

    public static void redirect(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
    }

    public static void redirect(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[512];
        while ((n = reader.read(cArray)) > 0) {
            writer.write(cArray, 0, n);
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            IO.redirect(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStack() {
        Exception exception = new Exception("StackTrace");
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(exception);
        PrintStream printStream = System.err;
        synchronized (printStream) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            System.err.println("Exception " + exception.getMessage());
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement.getClassName().contains("com.actelion.research.util.IOUtils") || !stackTraceElement.getClassName().contains("com.actelion")) continue;
                System.err.println("\tat " + stackTraceElement);
            }
            if (exception.getCause() != null) {
                System.err.println("Caused by " + exception.getCause());
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    if (stackTraceElement.getClassName().contains("com.actelion.research.util.IOUtils.dumpStack") || !stackTraceElement.getClassName().contains("com.actelion")) continue;
                    System.err.println("\tat " + stackTraceElement);
                }
            }
        }
    }
}

