/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.util.BitUtils;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.IntArray;

public class EncoderFloatingPointNumbers {
    private static final double TINY_FACTOR_EXPONENT = -6.0;
    private static final double TINY_FACTOR = Math.pow(10.0, -6.0);
    private static final int CAPACITY_DATA = 100;
    private double min;
    private double max;
    private int precisionBits;
    private double factorPrecision;
    private double range;
    private int[] dataEncoded;
    private int ccBitCounter;
    private int ccAddedValuesCounter;
    private boolean finalized;
    private double tiny;

    public EncoderFloatingPointNumbers(double[] dArray, int n) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (double d3 : dArray) {
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        this.initialize(d, d2, n);
        for (double d3 : dArray) {
            this.add(d3);
        }
    }

    public EncoderFloatingPointNumbers(float[] fArray, int n) {
        double d;
        int n2;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        float[] fArray2 = fArray;
        int n3 = fArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            d = fArray2[n2];
            if (d < d2) {
                d2 = d;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        this.initialize(d2, d3, n);
        fArray2 = fArray;
        n3 = fArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            d = fArray2[n2];
            this.add(d);
        }
    }

    private EncoderFloatingPointNumbers(double d, double d2, int n) {
        this.initialize(d, d2, n);
    }

    private void initialize(double d, double d2, int n) {
        if (n > 64) {
            throw new RuntimeException("Maximum possible precision exceeded!");
        }
        double d3 = Math.abs(d2 - d);
        if (d3 < 1.0E-6) {
            int n2 = -6;
        } else {
            int n3 = (int)(Math.log10(d3) + -6.0);
        }
        this.tiny = d3 * TINY_FACTOR;
        this.min = d - this.tiny;
        this.max = d2 + this.tiny;
        this.precisionBits = n;
        this.factorPrecision = Math.pow(2.0, n);
        this.range = this.max - this.min;
        this.dataEncoded = new int[100];
        this.ccBitCounter = 0;
        this.ccBitCounter += 8;
        this.ccBitCounter += 32;
        this.ccBitCounter += 64;
        this.ccBitCounter += 64;
        this.ccAddedValuesCounter = 0;
        this.finalized = false;
    }

    private void add(double d) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized!");
        }
        double d2 = d - this.min;
        if (d2 < -this.tiny) {
            throw new RuntimeException("Value lower than minimum!");
        }
        double d3 = this.min + this.range;
        if (d - d3 > this.tiny) {
            throw new RuntimeException("Value higher than maximum!");
        }
        long l = this.getEncoded(d);
        this.add(l, this.precisionBits);
        ++this.ccAddedValuesCounter;
    }

    private void add(long l, int n) {
        for (int i = 0; i < n; ++i) {
            if ((1L & l) == 1L) {
                BitUtils.setBit(this.dataEncoded, this.ccBitCounter);
            } else {
                BitUtils.unsetBit(this.dataEncoded, this.ccBitCounter);
            }
            l >>= 1;
            ++this.ccBitCounter;
            if (BitUtils.isValidBitIndex(this.dataEncoded, this.ccBitCounter)) continue;
            int n2 = this.dataEncoded.length * 2;
            this.dataEncoded = IntArray.resize(this.dataEncoded, n2);
        }
    }

    private void set(long l, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + i;
            if ((l & 1L) == 1L) {
                BitUtils.setBit(this.dataEncoded, n3);
            } else {
                BitUtils.unsetBit(this.dataEncoded, n3);
            }
            l >>= 1;
        }
    }

    private long getEncoded(double d) {
        double d2 = (d - this.min) / this.range;
        long l = (long)(d2 * this.factorPrecision);
        return l;
    }

    private int[] finalizeAndGet() {
        this.finalized = true;
        long l = this.precisionBits;
        int n = 0;
        this.set(l, 8, n);
        this.set(this.ccAddedValuesCounter, 32, n += 8);
        long l2 = Double.doubleToLongBits(this.min);
        this.set(l2, 64, n += 32);
        long l3 = Double.doubleToLongBits(this.range);
        this.set(l3, 64, n += 64);
        int n2 = this.ccBitCounter / 32 + 1;
        int[] nArray = new int[n2];
        System.arraycopy(this.dataEncoded, 0, nArray, 0, n2);
        return nArray;
    }

    private String encode() {
        int[] nArray = this.finalizeAndGet();
        String string = new String(new DescriptorEncoder().encode(nArray));
        return string;
    }

    public static double[] decode(String string) {
        int[] nArray = new DescriptorEncoder().decode(string);
        return EncoderFloatingPointNumbers.decode(nArray);
    }

    private static double[] decode(int[] nArray) {
        int n = 0;
        int n2 = (int)EncoderFloatingPointNumbers.decode(nArray, n, 8);
        int n3 = (int)EncoderFloatingPointNumbers.decode(nArray, n += 8, 32);
        long l = EncoderFloatingPointNumbers.decode(nArray, n += 32, 64);
        double d = Double.longBitsToDouble(l);
        long l2 = EncoderFloatingPointNumbers.decode(nArray, n += 64, 64);
        double d2 = Double.longBitsToDouble(l2);
        n += 64;
        Decoder decoder = new Decoder(n2, d, d2);
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            double d3;
            long l3 = EncoderFloatingPointNumbers.decode(nArray, n, n2);
            dArray[i] = d3 = decoder.getDecoded(l3);
            n += n2;
        }
        return dArray;
    }

    private static long decode(int[] nArray, int n, int n2) {
        int n3;
        long l = 0L;
        for (int i = n3 = n + n2 - 1; i >= n; --i) {
            if (BitUtils.isBitSet(nArray, i)) {
                l |= 1L;
            }
            if (i <= n) continue;
            l <<= 1;
        }
        return l;
    }

    public static String encode(double[] dArray, int n) {
        EncoderFloatingPointNumbers encoderFloatingPointNumbers = new EncoderFloatingPointNumbers(dArray, n);
        return encoderFloatingPointNumbers.encode();
    }

    public static String encode(float[] fArray, int n) {
        EncoderFloatingPointNumbers encoderFloatingPointNumbers = new EncoderFloatingPointNumbers(fArray, n);
        return encoderFloatingPointNumbers.encode();
    }

    public static void main(String[] stringArray) {
        int n = 61;
        double d = -7.742162891457342;
        double d2 = 8.161857389358609;
        double d3 = 8.161857389358609;
        DoubleArray doubleArray = new DoubleArray();
        doubleArray.add(8.161857389358609);
        doubleArray.add(1000.003);
        doubleArray.add(1000000.005);
        doubleArray.add(6.700000001005E9);
        double[] dArray = doubleArray.get();
        EncoderFloatingPointNumbers encoderFloatingPointNumbers = new EncoderFloatingPointNumbers(dArray, n);
        String string = encoderFloatingPointNumbers.encode();
        System.out.println(string);
        double[] dArray2 = EncoderFloatingPointNumbers.decode(string);
        for (int i = 0; i < dArray2.length; ++i) {
            double d4 = dArray2[i] - dArray[i];
            System.out.println(d4 + "\t" + dArray[i] + "\t" + dArray2[i]);
        }
    }

    private static class Decoder {
        private double min;
        private double factorPrecision;
        private double range;

        public Decoder(int n, double d, double d2) {
            this.min = d;
            this.range = d2;
            this.factorPrecision = Math.pow(2.0, n);
        }

        private double getDecoded(long l) {
            double d = (double)l / this.factorPrecision * this.range + this.min;
            return d;
        }
    }
}

