/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

public class BitUtils {
    public static final long MASK_FIRST_SHORT = 65535L;
    public static final long MASK_SEC_SHORT = 0xFFFF0000L;
    public static final long MASK_THIRD_SHORT = 0xFFFF00000000L;
    public static final long MASK_FOURTH_SHORT = -281474976710656L;
    private static int[] BIT_COUNTS = new int[65536];

    static int countBitsSlow(int n) {
        int n2 = 0x55555555;
        n = (n & n2) + (n >>> 1 & n2);
        n2 = 0x33333333;
        n = (n & n2) + (n >>> 2 & n2);
        n2 = 0x7070707;
        n = (n & n2) + (n >>> 4 & n2);
        n2 = 983055;
        n = (n & n2) + (n >>> 8 & n2);
        return (n & 0x1F) + (n >>> 16);
    }

    public static int bitCount(int n) {
        int n2 = (0xFFFF0000 & n) >>> 16;
        int n3 = 0xFFFF & n;
        return BIT_COUNTS[n2] + BIT_COUNTS[n3];
    }

    public static int bitCount(long l) {
        int n = (int)((0xFFFF000000000000L & l) >>> 48);
        int n2 = (int)((0xFFFF00000000L & l) >>> 32);
        int n3 = (int)((0xFFFF0000L & l) >>> 16);
        int n4 = (int)(0xFFFFL & l);
        return BIT_COUNTS[n] + BIT_COUNTS[n2] + BIT_COUNTS[n3] + BIT_COUNTS[n4];
    }

    public static void setBit(int[] nArray, int n) {
        int n2 = n / 32;
        int n3 = n % 32;
        int n4 = 1;
        nArray[n2] = nArray[n2] | (n4 <<= n3);
    }

    public static void unsetBit(int[] nArray, int n) {
        int n2 = n / 32;
        int n3 = n % 32;
        int n4 = 1;
        nArray[n2] = nArray[n2] & ~(n4 <<= n3);
    }

    public static boolean isBitSet(int[] nArray, int n) {
        int n2 = n / 32;
        int n3 = n % 32;
        int n4 = 1;
        return (nArray[n2] & (n4 <<= n3)) != 0;
    }

    public static boolean isValidBitIndex(int[] nArray, int n) {
        boolean bl = false;
        int n2 = n / 32;
        if (n2 < nArray.length) {
            bl = true;
        }
        return bl;
    }

    static {
        for (int i = 0; i < BIT_COUNTS.length; ++i) {
            BitUtils.BIT_COUNTS[i] = BitUtils.countBitsSlow(i);
        }
    }
}

