/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.Arrow;
import com.actelion.research.share.gui.DrawConfig;
import com.actelion.research.share.gui.editor.chem.IDrawingObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExtendedDepictor<T, C> {
    protected StereoMolecule[] mMolecule;
    protected AbstractDepictor[] mDepictor;
    protected List<IDrawingObject> mDrawingObjectList;
    protected int mDisplayMode;
    protected int mReactantOrCoreCount;
    protected boolean mUseGraphics2D;
    protected boolean mDoLayoutMolecules;
    protected boolean mIsMarkushStructure;
    protected DepictorTransformation mTransformation;
    private DrawConfig drawConfig;
    protected C mFragmentNoColor;

    public AbstractExtendedDepictor(StereoMolecule stereoMolecule, List<IDrawingObject> list, boolean bl, DrawConfig drawConfig) {
        this(new StereoMolecule[]{stereoMolecule}, list, bl, drawConfig);
    }

    public AbstractExtendedDepictor(StereoMolecule[] stereoMoleculeArray, List<IDrawingObject> list, boolean bl, DrawConfig drawConfig) {
        this.initialize(stereoMoleculeArray, list, bl, drawConfig);
        this.mReactantOrCoreCount = -1;
    }

    public AbstractExtendedDepictor(StereoMolecule[] stereoMoleculeArray, int n, List<IDrawingObject> list, boolean bl, DrawConfig drawConfig) {
        this(stereoMoleculeArray, list, bl, drawConfig);
        this.mReactantOrCoreCount = n;
    }

    public AbstractExtendedDepictor(Reaction reaction, List<IDrawingObject> list, boolean bl, boolean bl2, DrawConfig drawConfig) {
        StereoMolecule[] stereoMoleculeArray = null;
        if (reaction != null) {
            stereoMoleculeArray = new StereoMolecule[reaction.getMolecules()];
            for (int i = 0; i < reaction.getMolecules(); ++i) {
                stereoMoleculeArray[i] = reaction.getMolecule(i);
            }
            this.mReactantOrCoreCount = reaction.getReactants();
            this.mDoLayoutMolecules = bl;
        }
        this.initialize(stereoMoleculeArray, list, bl2, drawConfig);
    }

    public abstract AbstractDepictor createDepictor(StereoMolecule var1, boolean var2, DrawConfig var3);

    protected abstract void paintFragmentNumbers(T var1);

    protected abstract void paintStructures(T var1);

    protected abstract void paintDrawingObjects(T var1);

    private void initialize(StereoMolecule[] stereoMoleculeArray, List<IDrawingObject> list, boolean bl, DrawConfig drawConfig) {
        this.mMolecule = stereoMoleculeArray;
        this.mIsMarkushStructure = false;
        this.mDrawingObjectList = list;
        this.mUseGraphics2D = bl;
        this.drawConfig = drawConfig;
        this.mTransformation = new DepictorTransformation();
        if (this.mMolecule != null) {
            this.mDepictor = new AbstractDepictor[this.mMolecule.length];
            for (int i = 0; i < this.mMolecule.length; ++i) {
                this.mDepictor[i] = this.createDepictor(this.mMolecule[i], this.mUseGraphics2D, this.drawConfig);
            }
        }
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
    }

    public void setFragmentNoColor(C c) {
        this.mFragmentNoColor = c;
    }

    public int getMoleculeCount() {
        return this.mMolecule.length;
    }

    public ExtendedMolecule getMolecule(int n) {
        return this.mMolecule[n];
    }

    public AbstractDepictor getMoleculeDepictor(int n) {
        return this.mDepictor[n];
    }

    public void setOverruleColor(Color color, Color color2) {
        if (this.mDepictor != null) {
            for (AbstractDepictor abstractDepictor : this.mDepictor) {
                abstractDepictor.setOverruleColor(color, color2);
            }
        }
    }

    public void setForegroundColor(Color color, Color color2) {
        if (this.mDepictor != null) {
            for (AbstractDepictor abstractDepictor : this.mDepictor) {
                abstractDepictor.setForegroundColor(color, color2);
            }
        }
    }

    public void paint(T t) {
        this.paintFragmentNumbers(t);
        this.paintStructures(t);
        this.paintDrawingObjects(t);
    }

    public DepictorTransformation updateCoords(T t, GenericRectangle genericRectangle, int n) {
        int n2;
        this.validateView(t, genericRectangle, n);
        if (this.mTransformation.isVoidTransformation()) {
            return null;
        }
        if (this.mMolecule != null) {
            for (n2 = 0; n2 < this.mMolecule.length; ++n2) {
                this.mTransformation.applyTo(this.mMolecule[n2]);
            }
        }
        if (this.mDrawingObjectList != null) {
            for (n2 = 0; n2 < this.mDrawingObjectList.size(); ++n2) {
                IDrawingObject iDrawingObject = this.mDrawingObjectList.get(n2);
                GenericRectangle genericRectangle2 = iDrawingObject.getBoundingRect();
                GenericRectangle genericRectangle3 = new GenericRectangle(genericRectangle2.getX(), genericRectangle2.getY(), genericRectangle2.getWidth(), genericRectangle2.getHeight());
                this.mTransformation.applyTo(genericRectangle3);
            }
        }
        if (this.mDepictor != null) {
            for (n2 = 0; n2 < this.mDepictor.length; ++n2) {
                this.mDepictor[n2].getTransformation().clear();
            }
        }
        DepictorTransformation depictorTransformation = this.mTransformation;
        this.mTransformation = new DepictorTransformation();
        return depictorTransformation;
    }

    public DepictorTransformation validateView(T t, GenericRectangle genericRectangle, int n) {
        Object object;
        int n2;
        if (this.mDoLayoutMolecules) {
            this.doLayoutMolecules(t);
        }
        Object object2 = null;
        if (this.mDepictor != null) {
            for (n2 = 0; n2 < this.mDepictor.length; ++n2) {
                this.mDepictor[n2].validateView(t, null, 0);
                object2 = object2 == null ? this.mDepictor[n2].getBoundingRect() : ((GenericRectangle)object2).union(this.mDepictor[n2].getBoundingRect());
            }
        }
        if (this.mDrawingObjectList != null) {
            for (n2 = 0; n2 < this.mDrawingObjectList.size(); ++n2) {
                GenericRectangle genericRectangle2 = this.mDrawingObjectList.get(n2).getBoundingRect();
                object = new GenericRectangle(genericRectangle2.getX(), genericRectangle2.getY(), genericRectangle2.getWidth(), genericRectangle2.getHeight());
                this.mTransformation.applyTo((GenericRectangle)object);
                object2 = object2 == null ? object : ((GenericRectangle)object2).union((GenericRectangle)object);
            }
        }
        if (object2 == null) {
            return null;
        }
        double d = this.calculateAverageBondLength();
        object = new DepictorTransformation((GenericRectangle)object2, genericRectangle, d, n);
        if (!((DepictorTransformation)object).isVoidTransformation()) {
            ((DepictorTransformation)object).applyTo(this.mTransformation);
            if (this.mDepictor != null) {
                for (int i = 0; i < this.mDepictor.length; ++i) {
                    this.mDepictor[i].applyTransformation((DepictorTransformation)object);
                }
            }
            return object;
        }
        return null;
    }

    protected double calculateAverageBondLength() {
        float f = 0.0f;
        int n = 0;
        if (this.mMolecule != null) {
            for (int i = 0; i < this.mMolecule.length; ++i) {
                if (this.mMolecule[i].getAllAtoms() == 0) continue;
                f = (float)((double)f + this.mDepictor[i].getTransformation().getScaling() * (double)this.mMolecule[i].getAllBonds() * this.mMolecule[i].getAverageBondLength());
                n += this.mMolecule[i].getAllBonds();
            }
        }
        return n == 0 ? 24.0 : this.mTransformation.getScaling() * (double)f / (double)n;
    }

    private void doLayoutMolecules(T t) {
        GenericRectangle[] genericRectangleArray = new GenericRectangle[this.mMolecule.length];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            this.mDepictor[i].validateView(t, null, 65536);
            genericRectangleArray[i] = this.mDepictor[i].getBoundingRect();
            d += genericRectangleArray[i].width;
            d2 = Math.max(d2, genericRectangleArray[i].height);
        }
        float f = 36.0f;
        float f2 = 48.0f;
        int n = -1;
        if (this.mDrawingObjectList == null) {
            this.mDrawingObjectList = new ArrayList<IDrawingObject>();
            this.mDrawingObjectList.add(new Arrow(this.drawConfig, 0.0, 0.0, 0.0, 0.0));
            n = 0;
        } else if (this.mDrawingObjectList.size() == 0) {
            n = this.mDrawingObjectList.size();
            this.mDrawingObjectList.add(new Arrow(this.drawConfig, 0.0, 0.0, 0.0, 0.0));
        }
        float f3 = 0.5f * f;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            if (i == this.mReactantOrCoreCount) {
                f3 += f2;
            }
            double d3 = (double)f3 - genericRectangleArray[i].x;
            double d4 = 0.5 * (d2 - genericRectangleArray[i].height) - genericRectangleArray[i].y;
            this.mDepictor[i].applyTransformation(new DepictorTransformation(1.0, d3, d4));
            f3 = (float)((double)f3 + ((double)f + genericRectangleArray[i].width));
        }
        this.mDoLayoutMolecules = false;
    }

    public DepictorTransformation getmTransformation() {
        return this.mTransformation;
    }
}

