/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.BondHighlightAction;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class NewChainAction
extends BondHighlightAction {
    private int sourceAtom = -1;
    private int numChainAtoms = 0;
    private double[] mChainAtomX = null;
    private double[] mChainAtomY = null;
    private int[] mChainAtom = null;

    public NewChainAction(Model model) {
        super(model);
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMolecule();
        boolean bl = false;
        this.origin = genericPoint;
        this.sourceAtom = this.findAtom(stereoMolecule, genericPoint);
        if (this.sourceAtom != -1) {
            if (stereoMolecule.getAllConnAtoms(this.sourceAtom) == 8) {
                return false;
            }
            this.origin = new GenericPoint(stereoMolecule.getAtomX(this.sourceAtom), stereoMolecule.getAtomY(this.sourceAtom));
            bl = true;
            this.numChainAtoms = 0;
            this.mChainAtomX = null;
            this.mChainAtomY = null;
            this.mChainAtom = null;
        } else {
            this.origin = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
            bl = true;
            this.numChainAtoms = 0;
            this.mChainAtomX = null;
            this.mChainAtomY = null;
            this.mChainAtom = null;
        }
        return bl;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        int n;
        boolean bl = false;
        this.model.pushUndo();
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (this.numChainAtoms == 0) {
            stereoMolecule = this.model.getMoleculeAt(genericPoint, false);
            if (stereoMolecule != null && (n = this.model.getSelectedAtom()) != -1) {
                this.addSingleBondAtAtom(stereoMolecule, n);
            }
        } else if (this.numChainAtoms > 0) {
            if (this.sourceAtom == -1) {
                this.sourceAtom = stereoMolecule.addAtom((float)this.origin.getX(), (float)this.origin.getY());
            }
            if (this.mChainAtom[0] == -1) {
                this.mChainAtom[0] = stereoMolecule.addAtom((float)this.mChainAtomX[0], (float)this.mChainAtomY[0]);
            }
            if (this.mChainAtom[0] != -1) {
                stereoMolecule.addBond(this.sourceAtom, this.mChainAtom[0]);
            }
            if (this.model.isReaction()) {
                this.model.needsLayout(true);
            }
        }
        if (this.numChainAtoms > 1) {
            for (n = 1; n < this.numChainAtoms; ++n) {
                if (this.mChainAtom[n] == -1) {
                    this.mChainAtom[n] = stereoMolecule.addAtom((float)this.mChainAtomX[n], (float)this.mChainAtomY[n]);
                }
                if (this.mChainAtom[n] == -1) continue;
                stereoMolecule.addBond(this.mChainAtom[n - 1], this.mChainAtom[n]);
            }
            if (this.model.isReaction()) {
                this.model.needsLayout(true);
            }
        }
        this.highlightAtom(stereoMolecule, -1);
        bl = true;
        this.dragging = false;
        return bl;
    }

    private void addSingleBondAtAtom(StereoMolecule stereoMolecule, int n) {
        GenericPoint genericPoint = this.suggestNewX2AndY2(n);
        int n2 = stereoMolecule.findAtom((float)genericPoint.getX(), (float)genericPoint.getY());
        if (n2 != -1) {
            stereoMolecule.addOrChangeBond(n, n2, stereoMolecule.suggestBondType(n, n2));
        } else {
            n2 = stereoMolecule.addAtom((float)genericPoint.getX(), (float)genericPoint.getY(), 0.0);
            stereoMolecule.addBond(n, n2, stereoMolecule.suggestBondType(n, n2));
            stereoMolecule.ensureHelperArrays(1);
        }
    }

    @Override
    protected boolean onDrag(GenericPoint genericPoint) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        boolean bl = false;
        if (stereoMolecule != null) {
            int n;
            double d;
            double d2;
            double d3;
            if (this.numChainAtoms > 0) {
                d3 = this.mChainAtomX[this.numChainAtoms - 1];
                d2 = this.mChainAtomY[this.numChainAtoms - 1];
            } else {
                d3 = 0.0;
                d2 = 0.0;
            }
            double d4 = d = stereoMolecule.getAverageBondLength();
            double d5 = 0.866 * d;
            double d6 = 0.5 * d;
            double d7 = genericPoint.getX() - this.origin.getX();
            double d8 = genericPoint.getY() - this.origin.getY();
            double d9 = 1.0;
            double d10 = 1.0;
            if (Math.abs(d8) > Math.abs(d7)) {
                this.numChainAtoms = (int)(2.0 * Math.abs(d8) / (d4 + d6));
                if ((double)((int)Math.abs(d8) % (int)(d4 + d6)) > d4) {
                    ++this.numChainAtoms;
                }
                this.mChainAtomX = new double[this.numChainAtoms];
                this.mChainAtomY = new double[this.numChainAtoms];
                if (genericPoint.getX() < this.origin.getX()) {
                    d10 = -d10;
                }
                if (genericPoint.getY() < this.origin.getY()) {
                    d9 = -d9;
                }
                if (this.numChainAtoms > 0) {
                    this.mChainAtomX[0] = this.origin.getX() + d5 * d10;
                    this.mChainAtomY[0] = this.origin.getY() + d6 * d9;
                    for (n = 1; n < this.numChainAtoms; ++n) {
                        if ((n & 1) == 0) {
                            this.mChainAtomX[n] = this.mChainAtomX[n - 1] + d4 * d10;
                            this.mChainAtomY[n] = this.mChainAtomY[n - 1] + d6 * d9;
                            continue;
                        }
                        this.mChainAtomX[n] = this.mChainAtomX[n - 1];
                        this.mChainAtomY[n] = this.mChainAtomY[n - 1] + d4 * d9;
                    }
                }
            } else {
                this.numChainAtoms = (int)(Math.abs(d7) / d5);
                this.mChainAtomX = new double[this.numChainAtoms];
                this.mChainAtomY = new double[this.numChainAtoms];
                if (genericPoint.getX() < this.origin.getX()) {
                    d5 = -d5;
                }
                if (genericPoint.getY() < this.origin.getY()) {
                    d6 = -d6;
                }
                for (n = 0; n < this.numChainAtoms; ++n) {
                    this.mChainAtomX[n] = this.origin.getX() + (double)(n + 1) * d5;
                    this.mChainAtomY[n] = this.origin.getY();
                    if ((n & 1) != 0) continue;
                    int n2 = n;
                    this.mChainAtomY[n2] = this.mChainAtomY[n2] + d6;
                }
            }
            if (this.numChainAtoms > 0) {
                this.mChainAtom = new int[this.numChainAtoms];
                for (n = 0; n < this.numChainAtoms; ++n) {
                    this.mChainAtom[n] = stereoMolecule.findAtom((float)this.mChainAtomX[n], (float)this.mChainAtomY[n]);
                    if (this.mChainAtom[n] == -1) continue;
                    this.mChainAtomX[n] = stereoMolecule.getAtomX(this.mChainAtom[n]);
                    this.mChainAtomY[n] = stereoMolecule.getAtomY(this.mChainAtom[n]);
                }
                if (this.mChainAtomX[this.numChainAtoms - 1] != d3 || this.mChainAtomY[this.numChainAtoms - 1] != d2) {
                    bl = true;
                }
            } else if (d3 != 0.0 || d2 != 0.0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            if (!this.dragging) {
                super.paint(iDrawContext);
            } else {
                int n = this.model.getSelectedAtom();
                this.drawChain(iDrawContext, n != -1 ? new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n)) : this.origin);
            }
        }
        return false;
    }

    private void drawChain(IDrawContext iDrawContext, GenericPoint genericPoint) {
        if (this.numChainAtoms > 0) {
            this.drawLine(iDrawContext, genericPoint.getX(), genericPoint.getY(), this.mChainAtomX[0], this.mChainAtomY[0]);
        }
        if (this.numChainAtoms > 1) {
            for (int i = 1; i < this.numChainAtoms; ++i) {
                this.drawLine(iDrawContext, this.mChainAtomX[i - 1], this.mChainAtomY[i - 1], this.mChainAtomX[i], this.mChainAtomY[i]);
            }
        }
    }

    void drawLine(IDrawContext iDrawContext, double d, double d2, double d3, double d4) {
        iDrawContext.drawLine(d, d2, d3, d4);
    }

    @Override
    public int getCursor() {
        return 45;
    }
}

