/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.AtomHighlightAction;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class ChangeAtomAction
extends AtomHighlightAction {
    int theAtomNo = 6;

    public ChangeAtomAction(Model model, int n) {
        super(model);
        this.theAtomNo = n;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        this.model.pushUndo();
        int n = this.model.getSelectedAtom();
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (n != -1) {
            stereoMolecule.setAtomicNo(n, this.theAtomNo);
        } else {
            int n2 = stereoMolecule.addAtom((float)genericPoint.getX(), (float)genericPoint.getY());
            stereoMolecule.setAtomicNo(n2, this.theAtomNo);
        }
        this.setHighlightAtom(stereoMolecule, -1);
        return true;
    }

    @Override
    boolean trackHighLight(GenericPoint genericPoint) {
        int n = this.model.getSelectedAtom();
        boolean bl = super.trackHighLight(genericPoint);
        int n2 = this.model.getSelectedAtom();
        return bl || n != n2;
    }
}

