/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.swing.SwingComponent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class SwingPopupMenu
extends SwingComponent
implements ActionListener,
GenericPopupMenu {
    private JPopupMenu mPopupMenu = (JPopupMenu)this.getComponent();
    private JMenu mSubMenu;
    private JComponent mOwner;

    public SwingPopupMenu(JComponent jComponent, GenericEventListener<GenericActionEvent> genericEventListener) {
        super(new JPopupMenu());
        this.mOwner = jComponent;
        this.addEventConsumer(genericEventListener);
    }

    @Override
    public void addItem(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        if (string2 != null) {
            jMenuItem.setActionCommand(string2);
        }
        jMenuItem.addActionListener(this);
        if (this.mSubMenu != null) {
            this.mSubMenu.add(jMenuItem);
        } else {
            this.mPopupMenu.add(jMenuItem);
        }
    }

    @Override
    public void addRadioButtonItem(String string, String string2, int n, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        if (string2 != null) {
            jRadioButtonMenuItem.setActionCommand(string2);
        }
        if (n != 0) {
            jRadioButtonMenuItem.setBackground(new Color(n));
        }
        jRadioButtonMenuItem.addActionListener(this);
        if (this.mSubMenu != null) {
            this.mSubMenu.add(jRadioButtonMenuItem);
        } else {
            this.mPopupMenu.add(jRadioButtonMenuItem);
        }
    }

    @Override
    public void startSubMenu(String string) {
        this.mSubMenu = new JMenu(string);
    }

    @Override
    public void endSubMenu() {
        this.mPopupMenu.add(this.mSubMenu);
        this.mSubMenu = null;
    }

    @Override
    public void addSeparator() {
        if (this.mSubMenu != null) {
            this.mSubMenu.addSeparator();
        } else {
            this.mPopupMenu.addSeparator();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEvent(new GenericActionEvent((Object)this, 2, actionEvent.getActionCommand()));
    }

    @Override
    public void show(int n, int n2) {
        this.mPopupMenu.show(this.mOwner, n, n2);
    }
}

