/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.util.ColorHelper;
import com.actelion.research.util.Platform;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import javax.swing.UIManager;

public class HiDPIHelper {
    private static final int[] BRIGHT_TO_DARK_LAF = new int[]{5258420, 11837695, 0, 0xE0E0E0};
    private static float sRetinaFactor = -1.0f;
    private static float sUIScaleFactor = -1.0f;

    public static float getRetinaScaleFactor() {
        block6: {
            if (Platform.isMacintosh()) {
                if (sRetinaFactor != -1.0f) {
                    return sRetinaFactor;
                }
                sRetinaFactor = 1.0f;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                try {
                    Field field = graphicsDevice.getClass().getDeclaredField("scale");
                    if (field == null) break block6;
                    field.setAccessible(true);
                    Object object = field.get(graphicsDevice);
                    if (object instanceof Integer) {
                        sRetinaFactor = ((Integer)object).intValue();
                        break block6;
                    }
                    System.out.println("Unexpected content scale (not 1 nor 2): " + object.toString());
                }
                catch (Throwable throwable) {}
            } else {
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                sRetinaFactor = (float)graphicsDevice.getDefaultConfiguration().getDefaultTransform().getScaleX();
            }
        }
        return sRetinaFactor;
    }

    public static float getUIScaleFactor() {
        if (sUIScaleFactor == -1.0f) {
            if (HiDPIHelper.getRetinaScaleFactor() != 1.0f) {
                sUIScaleFactor = 1.0f;
            } else {
                float f = 0.0f;
                String string = System.getProperty("dpifactor");
                if (string != null) {
                    try {
                        f = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sUIScaleFactor = f != 0.0f ? f : (Platform.isMacintosh() ? 1.0f : (float)UIManager.getFont("Label.font").getSize() / 12.0f);
            }
        }
        return sUIScaleFactor;
    }

    public static int scale(float f) {
        return Math.round(HiDPIHelper.getUIScaleFactor() * f);
    }

    public static int scaleRetinaAndUI(float f) {
        return Math.round(HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() * f);
    }

    public static Color getThemeColor(int n) {
        return new Color(BRIGHT_TO_DARK_LAF[2 * n + (LookAndFeelHelper.isDarkLookAndFeel() ? 1 : 0)]);
    }

    public static void adaptForLookAndFeel(GenericImage genericImage) {
        if (LookAndFeelHelper.isDarkLookAndFeel()) {
            HiDPIHelper.useSpotColorsForDarkLookAndFeel(genericImage);
        }
    }

    public static void disableImage(GenericImage genericImage) {
        Color color = LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.brighter(UIManager.getColor("Panel.background"), 0.8f) : ColorHelper.darker(UIManager.getColor("Panel.background"), 0.8f);
        int n = 0xFFFFFF & color.getRGB();
        for (int i = 0; i < genericImage.getWidth(); ++i) {
            for (int j = 0; j < genericImage.getHeight(); ++j) {
                int n2 = genericImage.getRGB(i, j);
                genericImage.setRGB(i, j, (0xFF000000 & n2) + n);
            }
        }
    }

    private static void useSpotColorsForDarkLookAndFeel(GenericImage genericImage) {
        for (int i = 0; i < genericImage.getWidth(); ++i) {
            for (int j = 0; j < genericImage.getHeight(); ++j) {
                int n = genericImage.getRGB(i, j);
                int n2 = n & 0xFFFFFF;
                for (int k = 0; k < BRIGHT_TO_DARK_LAF.length; k += 2) {
                    if (n2 != BRIGHT_TO_DARK_LAF[k]) continue;
                    n2 = BRIGHT_TO_DARK_LAF[k + 1];
                    break;
                }
                genericImage.setRGB(i, j, (0xFF000000 & n) + n2);
            }
        }
    }
}

