/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.DividerChangeListener;
import com.actelion.research.gui.dock.MySplitPane;
import com.actelion.research.gui.dock.TreeContainer;
import com.actelion.research.gui.dock.TreeElement;
import com.actelion.research.gui.dock.TreeLeaf;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JSplitPane;

public class TreeFork
extends TreeContainer {
    private TreeElement mLeftChildElement;
    private TreeElement mRightChildElement;
    private Vector<DividerChangeListener> mDividerChangeListeners;

    public TreeFork(TreeLeaf treeLeaf, TreeLeaf treeLeaf2, int n, double d, Vector<DividerChangeListener> vector) {
        Container container = null;
        switch (n) {
            case 1: {
                container = new MySplitPane(0, treeLeaf2.getComponent(), (Component)treeLeaf.getComponent(), d);
                this.mLeftChildElement = treeLeaf2;
                this.mRightChildElement = treeLeaf;
                break;
            }
            case 2: {
                container = new MySplitPane(1, treeLeaf2.getComponent(), (Component)treeLeaf.getComponent(), d);
                this.mLeftChildElement = treeLeaf2;
                this.mRightChildElement = treeLeaf;
                break;
            }
            case 3: {
                container = new MySplitPane(0, treeLeaf.getComponent(), (Component)treeLeaf2.getComponent(), d);
                this.mLeftChildElement = treeLeaf;
                this.mRightChildElement = treeLeaf2;
                break;
            }
            case 4: {
                container = new MySplitPane(1, treeLeaf.getComponent(), (Component)treeLeaf2.getComponent(), d);
                this.mLeftChildElement = treeLeaf;
                this.mRightChildElement = treeLeaf2;
            }
        }
        container.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> {
            if (this.mDividerChangeListeners != null && ((MySplitPane)this.mComponent).isDragged()) {
                for (DividerChangeListener dividerChangeListener : this.mDividerChangeListeners) {
                    dividerChangeListener.dividerLocationChanged(this);
                }
            }
        });
        this.mDividerChangeListeners = vector;
        this.mComponent = container;
        treeLeaf.setParent(this);
        treeLeaf2.setParent(this);
    }

    public void updateDividerChangeListeners(Vector<DividerChangeListener> vector) {
        this.mDividerChangeListeners = vector;
        if (this.mLeftChildElement instanceof TreeFork) {
            ((TreeFork)this.mLeftChildElement).updateDividerChangeListeners(vector);
        }
        if (this.mLeftChildElement instanceof TreeFork) {
            ((TreeFork)this.mRightChildElement).updateDividerChangeListeners(vector);
        }
    }

    @Override
    public void removeWithLeaf(TreeLeaf treeLeaf) {
        assert (treeLeaf == this.mLeftChildElement || treeLeaf == this.mRightChildElement);
        if (treeLeaf == this.mLeftChildElement) {
            this.mParent.replaceChildElement(this, this.mRightChildElement);
        } else {
            this.mParent.replaceChildElement(this, this.mLeftChildElement);
        }
    }

    @Override
    public void replaceChildElement(TreeElement treeElement, TreeElement treeElement2) {
        JSplitPane jSplitPane = (JSplitPane)this.mComponent;
        int n = jSplitPane.getDividerLocation();
        if (treeElement == this.mLeftChildElement) {
            jSplitPane.setLeftComponent(treeElement2.getComponent());
            this.mLeftChildElement = treeElement2;
        } else {
            jSplitPane.setRightComponent(treeElement2.getComponent());
            this.mRightChildElement = treeElement2;
        }
        jSplitPane.setDividerLocation(n);
        treeElement2.setParent(this);
    }

    public TreeElement getLeftChild() {
        return this.mLeftChildElement;
    }

    public TreeElement getRightChild() {
        return this.mRightChildElement;
    }

    public boolean isVertical() {
        return ((JSplitPane)this.mComponent).getOrientation() == 0;
    }

    public double getDividerLocation() {
        JSplitPane jSplitPane = (JSplitPane)this.mComponent;
        int n = (this.isVertical() ? jSplitPane.getHeight() : jSplitPane.getWidth()) - jSplitPane.getDividerSize();
        return (double)jSplitPane.getDividerLocation() / (double)n;
    }

    @Override
    public void updateChildElement(Component component, TreeElement treeElement) {
        JSplitPane jSplitPane = (JSplitPane)this.mComponent;
        int n = jSplitPane.getDividerLocation();
        if (treeElement == this.mLeftChildElement) {
            jSplitPane.setLeftComponent(treeElement.getComponent());
        } else {
            jSplitPane.setRightComponent(treeElement.getComponent());
        }
        jSplitPane.setDividerLocation(n);
    }

    protected void addStateInfo(ArrayList<String> arrayList, String string) {
        String string2 = this.addOneLeafToStateInfo(this.mLeftChildElement, arrayList, string);
        this.addOneLeafToStateInfo(this.mRightChildElement, arrayList, this.getRightDockInfo(string2));
        if (this.mLeftChildElement instanceof TreeFork) {
            ((TreeFork)this.mLeftChildElement).addStateInfo(arrayList, string);
        }
        if (this.mRightChildElement instanceof TreeFork) {
            ((TreeFork)this.mRightChildElement).addStateInfo(arrayList, string);
        }
    }

    private String addOneLeafToStateInfo(ArrayList<String> arrayList, String string) {
        return this.addOneLeafToStateInfo(this.mLeftChildElement, arrayList, string);
    }

    private String addOneLeafToStateInfo(TreeElement treeElement, ArrayList<String> arrayList, String string) {
        if (treeElement instanceof TreeLeaf) {
            return ((TreeLeaf)treeElement).addStateInfo(arrayList, string);
        }
        return ((TreeFork)treeElement).addOneLeafToStateInfo(arrayList, string);
    }

    @Override
    protected void clearStateInfo() {
        this.mLeftChildElement.clearStateInfo();
        this.mRightChildElement.clearStateInfo();
    }

    private String getRightDockInfo(String string) {
        return string + "\t" + (this.isVertical() ? "bottom" : "right") + "\t" + (double)((int)(1000.0 * this.getDividerLocation())) / 1000.0;
    }

    @Override
    public void printStatus() {
        JSplitPane jSplitPane = (JSplitPane)this.mComponent;
        String string = jSplitPane.getLeftComponent() == this.mLeftChildElement.getComponent() ? "OK" : "failed";
        String string2 = jSplitPane.getRightComponent() == this.mRightChildElement.getComponent() ? "OK" : "failed";
        System.out.println("Fork leftChildStatus:" + string + " rightChildStatus:" + string2);
        this.mLeftChildElement.printStatus();
        this.mRightChildElement.printStatus();
    }
}

