/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ReactionTransferable
implements Transferable,
ClipboardOwner {
    protected Reaction mReaction;

    public ReactionTransferable(Reaction reaction) {
        this.mReaction = reaction;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return ChemistryFlavors.REACTION_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.equals(ChemistryFlavors.DF_REACTION_SMILES)) {
            return false;
        }
        for (DataFlavor dataFlavor2 : ChemistryFlavors.REACTION_FLAVORS) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(ChemistryFlavors.DF_SERIALIZED_REACTION)) {
            Reaction reaction = new Reaction(this.mReaction);
            reaction.removeDrawingObjects();
            return reaction;
        }
        if (dataFlavor.equals(ChemistryFlavors.DF_REACTION_SMILES)) {
            return IsomericSmilesCreator.createReactionSmiles(this.mReaction);
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return ReactionEncoder.encode(this.mReaction, true);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public String toString() {
        return "ReactionTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

