/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.gui.FileHelper;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class MoleculeDropAdapter
implements DropTargetListener {
    public static final boolean debug = false;
    private boolean active_ = true;
    private final int mAllowedDropAction = 3;

    public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
        this.DEBUG("MoleculeDropAdapter.onDropMolecule(). Override this! " + stereoMolecule);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("DragEnter");
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("DragOver");
    }

    public void setActive(boolean bl) {
        this.active_ = bl;
    }

    public boolean isActive() {
        return this.active_;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("dropActionChanged");
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.DEBUG("dragExit");
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.active_) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.DEBUG("MoleculeDropAdapter   ClassLoader " + classLoader);
            this.DEBUG("MoleculeDropAdapter   Ignoring setContextclassloader!!!");
            this.DEBUG("MoleculeDropAdapter " + dropTargetDropEvent);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                this.DEBUG("Transferable is " + transferable);
                DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
                if (dataFlavor != null) {
                    dropTargetDropEvent.acceptDrop(3);
                    this.DEBUG("Chose is " + dataFlavor);
                    Object object = transferable.getTransferData(dataFlavor);
                    this.DEBUG("Object is " + object);
                    dropTargetDropEvent.dropComplete(true);
                    SwingUtilities.invokeLater(() -> {
                        try {
                            StereoMolecule stereoMolecule = this.createFromDataFlavor(dataFlavor, object);
                            if (stereoMolecule != null) {
                                boolean bl = dataFlavor.equals(DataFlavor.javaFileListFlavor);
                                this.onDropMolecule(stereoMolecule, bl ? null : dropTargetDropEvent.getLocation());
                            } else {
                                System.err.println("Drop failed: " + dropTargetDropEvent);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    });
                    return;
                }
                System.err.println("Drop failed: " + dropTargetDropEvent);
                dropTargetDropEvent.rejectDrop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DataFlavor[] getFlavors() {
        return ChemistryFlavors.MOLECULE_FLAVORS;
    }

    protected StereoMolecule createFromDataFlavor(DataFlavor dataFlavor, Object object) throws Exception {
        StereoMolecule stereoMolecule = null;
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            List list = (List)object;
            File file = (File)list.get(0);
            String string = file.getAbsolutePath().trim();
            if (string.endsWith(".URL")) {
                return null;
            }
            ArrayList<StereoMolecule> arrayList = new FileHelper(null).readStructuresFromFile(file, false);
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            return (StereoMolecule)arrayList.get(0);
        }
        if (dataFlavor.equals(ChemistryFlavors.DF_SERIALIZED_MOLECULE) && object instanceof Molecule) {
            stereoMolecule = new StereoMolecule((Molecule)object);
        } else if (dataFlavor.equals(ChemistryFlavors.DF_MDLMOLFILE) && object instanceof String) {
            stereoMolecule = new StereoMolecule();
            new MolfileParser().parse(stereoMolecule, (String)object);
        } else if (dataFlavor.equals(ChemistryFlavors.DF_SMILES) && object instanceof String) {
            stereoMolecule = new StereoMolecule();
            new SmilesParser().parse(stereoMolecule, ((String)object).getBytes());
        } else if (dataFlavor.equals(ChemistryFlavors.DF_IDCODE) && object instanceof String) {
            stereoMolecule = new StereoMolecule();
            new IDCodeParser(true).parse(stereoMolecule, ((String)object).getBytes());
        } else if (dataFlavor.equals(DataFlavor.stringFlavor) && object instanceof String) {
            try {
                stereoMolecule = new StereoMolecule();
                new IDCodeParser(true).parse(stereoMolecule, ((String)object).getBytes());
            }
            catch (Throwable throwable) {
                stereoMolecule = StructureNameResolver.resolve((String)object);
            }
            if (stereoMolecule == null) {
                System.err.println("Unable to instantiate from text flavor: " + object);
            }
        } else {
            System.err.println("Unable to instantiate flavor: " + dataFlavor);
        }
        return stereoMolecule;
    }

    protected boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        for (int i = 0; i < ChemistryFlavors.MOLECULE_FLAVORS.length; ++i) {
            if (!dropTargetDragEvent.isDataFlavorSupported(ChemistryFlavors.MOLECULE_FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < ChemistryFlavors.MOLECULE_FLAVORS.length; ++i) {
            DataFlavor dataFlavor = ChemistryFlavors.MOLECULE_FLAVORS[i];
            for (int j = 0; j < dataFlavorArray.length; ++j) {
                DataFlavor dataFlavor2 = dataFlavorArray[j];
                if (dataFlavor2.equals(DataFlavor.javaFileListFlavor)) {
                    return dataFlavor2;
                }
                if (!dataFlavor.equals(dataFlavor2)) continue;
                return dataFlavor;
            }
        }
        return null;
    }

    public boolean isDropOK(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        return (dropTargetDragEvent.getDropAction() & 3) != 0;
    }

    private void DEBUG(String string) {
    }
}

