/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard.external;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.clipboard.NativeClipboardAccessor;
import com.actelion.research.util.LittleEndianDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChemDrawCDX {
    private static byte[] COLORTABLE = new byte[]{0, 3, 50, 0, 8, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1};
    private static final byte[] HEADER = new byte[]{86, 106, 67, 68, 48, 49, 48, 48, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final boolean debug = false;
    public static final int kCDXObj_Page = 32769;
    public static final int kCDXObj_Group = 32770;
    public static final int kCDXObj_Fragment = 32771;
    public static final int kCDXObj_Node = 32772;
    public static final int kCDXObj_Bond = 32773;
    private static int NUM = 0;

    private static void debug(String string) {
    }

    public boolean parse(BufferedInputStream bufferedInputStream) {
        return false;
    }

    public String build() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public byte[] getChemDrawBuffer(StereoMolecule stereoMolecule) {
        CDXDocument cDXDocument = new CDXDocument();
        cDXDocument.add(new CDPShowEnhAtomStereo(true));
        cDXDocument.add(new CDPShowAtomStereo(true));
        cDXDocument.add(new CDPShowBondStereo(true));
        CDXPage cDXPage = new CDXPage();
        CDXFragment cDXFragment = new CDXFragment();
        cDXDocument.add(cDXPage);
        ((CDXNode)cDXPage).add(cDXFragment);
        MolGeom molGeom = this.getTransform(stereoMolecule);
        this.writeMolecule(stereoMolecule, cDXFragment, molGeom);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
        this.write(littleEndianDataOutputStream, cDXDocument);
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("ChemDrawCDX::getChemDrawBuffer(): Error closing stream : " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getChemDrawBuffer(Reaction reaction) {
        Object object;
        Object object2;
        CDXDocument cDXDocument = new CDXDocument();
        int n = reaction.getReactants();
        int n2 = reaction.getProducts();
        int n3 = reaction.getMolecules();
        cDXDocument.add(new CDPShowEnhAtomStereo(true));
        cDXDocument.add(new CDPShowAtomStereo(true));
        cDXDocument.add(new CDPShowBondStereo(true));
        CDXPage cDXPage = new CDXPage();
        cDXDocument.add(cDXPage);
        MolGeom molGeom = this.getTransform(reaction);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            StereoMolecule stereoMolecule = reaction.getReactant(i);
            object2 = new CDXFragment();
            this.writeMolecule(stereoMolecule, (CDXNode)object2, molGeom);
            nArray[i] = ((CDXNode)object2).getID();
            ((CDXNode)cDXPage).add((CDXNode)object2);
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            object2 = reaction.getProduct(i);
            object = new CDXFragment();
            this.writeMolecule((StereoMolecule)object2, (CDXNode)object, molGeom);
            nArray2[i] = ((CDXNode)object).getID();
            ((CDXNode)cDXPage).add((CDXNode)object);
        }
        CDXReactionStep cDXReactionStep = new CDXReactionStep(nArray, nArray2);
        ((CDXNode)cDXPage).add(cDXReactionStep);
        object2 = new ByteArrayOutputStream();
        object = new LittleEndianDataOutputStream((OutputStream)object2);
        this.write((DataOutput)object, cDXDocument);
        try {
            ((ByteArrayOutputStream)object2).close();
        }
        catch (IOException iOException) {
            System.err.println("ChemDrawCDX::getChemDrawBuffer(): Error closing stream : " + iOException);
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    private MolGeom getTransform(Reaction reaction) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MAX_VALUE;
        int n = reaction.getMolecules();
        if (n < 1) {
            return new MolGeom(0.0, 0.0, 1.0);
        }
        for (int i = 0; i < n; ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            stereoMolecule.ensureHelperArrays(31);
            int n2 = stereoMolecule.getAllAtoms();
            for (int j = 0; j < n2; ++j) {
                double d6 = stereoMolecule.getAtomX(j);
                double d7 = stereoMolecule.getAtomY(j);
                d = Math.min(d, d6);
                d2 = Math.max(d2, d6);
                d3 = Math.min(d3, d7);
                d4 = Math.max(d4, d7);
            }
            double d8 = d2 - d;
            double d9 = d2 - d3;
            ChemDrawCDX.debug(String.format("Mofile dx = %f dy = %f", d8, d9));
            double d10 = 1.6777216E7 / d8;
            double d11 = 1.6777216E7 / d9;
            ChemDrawCDX.debug(String.format("Mofile scale x = %.16f y = %.16f", d10, d11));
            d5 = Math.min(d10, d11);
        }
        return new MolGeom(d, d3, d5);
    }

    private MolGeom getTransform(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(31);
        int n = stereoMolecule2.getAllAtoms();
        double d = stereoMolecule2.getAtomX(0);
        double d2 = stereoMolecule2.getAtomX(0);
        double d3 = stereoMolecule2.getAtomY(0);
        double d4 = stereoMolecule2.getAtomY(0);
        for (int i = 1; i < n; ++i) {
            double d5 = stereoMolecule2.getAtomX(i);
            double d6 = stereoMolecule2.getAtomY(i);
            d = Math.min(d, d5);
            d2 = Math.max(d2, d5);
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d6);
        }
        double d7 = d2 - d;
        double d8 = d2 - d3;
        ChemDrawCDX.debug(String.format("Mofile dx = %f dy = %f", d7, d8));
        double d9 = 1.048576E7 / d7;
        double d10 = 1.048576E7 / d8;
        ChemDrawCDX.debug(String.format("Mofile scale x = %.16f y = %.16f", d9, d10));
        return new MolGeom(d, d3, Math.min(d9, d10));
    }

    private void writeMolecule(StereoMolecule stereoMolecule, CDXNode cDXNode, MolGeom molGeom) {
        int n;
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(31);
        int n2 = stereoMolecule2.getAllAtoms();
        int n3 = stereoMolecule2.getAllBonds();
        CDXAtom[] cDXAtomArray = new CDXAtom[n2];
        stereoMolecule2.translateCoords((float)(-molGeom.xmin), (float)(-molGeom.ymin));
        stereoMolecule2.scaleCoords((float)molGeom.scale);
        boolean bl = n2 == 1 && stereoMolecule2.getAtomicNo(0) == 6;
        for (n = 0; n < n2; ++n) {
            double d = stereoMolecule2.getAtomX(n);
            double d2 = stereoMolecule2.getAtomY(n);
            ChemDrawCDX.debug(String.format("C Atom x = %.0f y = %.0f", d, d2));
            CDXAtom cDXAtom = null;
            cDXAtom = bl ? new CDXMethane(0x100000 + (int)d, 0x100000 + (int)d2) : new CDXAtom((short)stereoMolecule2.getAtomicNo(n), 0x100000 + (int)d, 0x100000 + (int)d2);
            if (stereoMolecule2.isAtomStereoCenter(n)) {
                int n4 = stereoMolecule2.getAtomESRGroup(n);
                int n5 = stereoMolecule2.getAtomESRType(n);
                if (!stereoMolecule2.isAtomConfigurationUnknown(n) && !stereoMolecule2.getStereoProblem(n)) {
                    cDXAtom.setAtomESRStereo(n5);
                }
                ChemDrawCDX.debug("Group is " + n4);
                if (n4 != -1) {
                    cDXAtom.setAtomESRGroup(n4 + 1);
                }
                if (stereoMolecule2.getAtomCIPParity(n) != 0) {
                    cDXAtom.setAtomCIP(stereoMolecule2.getAtomCIPParity(n), stereoMolecule2.getAtomPi(n) == 2, stereoMolecule2.isAtomParityPseudo(n));
                }
                if (stereoMolecule2.getAtomMass(n) != 0) {
                    cDXAtom.setAtomMass((short)stereoMolecule2.getAtomMass(n));
                }
                if (stereoMolecule2.getAtomCharge(n) != 0) {
                    cDXAtom.setAtomCharge((byte)stereoMolecule2.getAtomCharge(n));
                }
                if (stereoMolecule2.getAtomRadical(n) != 0) {
                    cDXAtom.setAtomRadical((byte)stereoMolecule2.getAtomRadical(n));
                }
            }
            cDXAtomArray[n] = cDXAtom;
            cDXNode.add(cDXAtom);
        }
        for (n = 0; n < n3; ++n) {
            int n6 = stereoMolecule2.getBondAtom(0, n);
            int n7 = stereoMolecule2.getBondAtom(1, n);
            int n8 = stereoMolecule2.getBondType(n);
            CDXBond cDXBond = new CDXBond(cDXAtomArray[n6].getID(), cDXAtomArray[n7].getID());
            cDXBond.setBondType(n8);
            cDXNode.add(cDXBond);
        }
    }

    public void dump(CDXNode cDXNode) {
        cDXNode.walk(new Functor(){

            @Override
            public void start(CDXNode cDXNode) {
                System.out.println(cDXNode.start());
            }

            @Override
            public void end(CDXNode cDXNode) {
                System.out.println(cDXNode.end());
            }
        });
    }

    public void write(final DataOutput dataOutput, CDXNode cDXNode) {
        cDXNode.walk(new Functor(){

            @Override
            public void start(CDXNode cDXNode) {
                try {
                    cDXNode.startWrite(dataOutput);
                }
                catch (IOException iOException) {
                    System.err.println("Error " + iOException);
                }
            }

            @Override
            public void end(CDXNode cDXNode) {
                try {
                    cDXNode.endWrite(dataOutput);
                }
                catch (IOException iOException) {
                    System.err.println("Error " + iOException);
                }
            }
        });
    }

    public void test() {
        CDXDocument cDXDocument = new CDXDocument();
        CDXPage cDXPage = new CDXPage();
        CDXFragment cDXFragment = new CDXFragment();
        CDXAtom cDXAtom = new CDXAtom(7, 0, 0);
        CDXAtom cDXAtom2 = new CDXAtom(8, 0x2000000, 11273146);
        CDXBond cDXBond = new CDXBond(cDXAtom.getID(), cDXAtom2.getID());
        cDXDocument.add(cDXPage);
        ((CDXNode)cDXPage).add(cDXFragment);
        cDXFragment.add(cDXAtom);
        cDXFragment.add(cDXAtom2);
        cDXFragment.add(cDXBond);
        this.dump(cDXDocument);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
        this.write(littleEndianDataOutputStream, cDXDocument);
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (i != 0) {
                stringBuilder.append(" ");
            }
            if (i > 0 && i % 16 == 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(String.format("%02X", by & 0xFF));
        }
        System.out.println("\nByte Dump:\n" + stringBuilder);
        NativeClipboardAccessor.setClipBoardData("ChemDraw Interchange Format", byArray);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("d:\\dev\\console\\test.cdx"));
            littleEndianDataOutputStream = new LittleEndianDataOutputStream(bufferedOutputStream);
            this.write(littleEndianDataOutputStream, cDXDocument);
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ int access$008() {
        return NUM++;
    }

    private static interface Functor {
        public void start(CDXNode var1);

        public void end(CDXNode var1);
    }

    public class CDPText
    extends CDPProperty {
        String s;

        CDPText(String string) {
            super(1792);
            this.s = string;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort((short)(2 + this.s.length()));
            dataOutput.writeShort(0);
            dataOutput.write(this.s.getBytes());
        }
    }

    public class CDPProducts
    extends CDPProperty {
        int[] elems;

        CDPProducts(int[] nArray) {
            super(3074);
            this.elems = nArray;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(this.elems.length * 4);
            for (int n : this.elems) {
                dataOutput.writeInt(n);
            }
        }
    }

    public class CDPReactants
    extends CDPProperty {
        int[] elems;

        CDPReactants(int[] nArray) {
            super(3073);
            this.elems = nArray;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(this.elems.length * 4);
            for (int n : this.elems) {
                dataOutput.writeInt(n);
            }
        }
    }

    public class CDPBondDisplay
    extends CDPProperty {
        short val;

        CDPBondDisplay(short s) {
            super(1537);
            this.val = s;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(2);
            dataOutput.writeShort(this.val);
        }
    }

    public class CDPBondEnd
    extends CDPBondAttach {
        public CDPBondEnd(int n) {
            super(1541, n);
        }
    }

    public class CDPBondBegin
    extends CDPBondAttach {
        public CDPBondBegin(int n) {
            super(1540, n);
        }
    }

    public abstract class CDPBondAttach
    extends CDPProperty {
        int ref;

        public CDPBondAttach(int n, int n2) {
            super(n);
            this.ref = n2;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(4);
            dataOutput.writeInt(this.ref);
        }
    }

    public class CDPElement
    extends CDPProperty {
        short ord;

        public CDPElement(short s) {
            super(1026);
            this.ord = s;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(2);
            dataOutput.writeShort(this.ord);
        }
    }

    public class CDPBondType
    extends CDPProperty {
        short btype;

        CDPBondType(int n) {
            super(1536);
            this.btype = (short)-1;
            switch (n) {
                case 1: {
                    this.btype = 1;
                    break;
                }
                case 2: {
                    this.btype = (short)2;
                    break;
                }
                case 4: {
                    this.btype = (short)4;
                    break;
                }
                case 129: {
                    this.btype = 1;
                    break;
                }
                case 257: {
                    this.btype = 1;
                    break;
                }
                case 386: {
                    this.btype = (short)2;
                    break;
                }
                case 32: {
                    this.btype = 1;
                    break;
                }
                case 64: {
                    this.btype = (short)128;
                    break;
                }
            }
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(2);
            dataOutput.writeShort(this.btype);
        }

        public boolean equals(Object object) {
            return object instanceof CDPBondType;
        }

        public int hascode() {
            return this.type;
        }
    }

    public class CDPPoint2D
    extends CDPProperty {
        int x;
        int y;

        public CDPPoint2D(int n, int n2) {
            super(512);
            this.x = n;
            this.y = n2;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(8);
            dataOutput.writeInt(this.y);
            dataOutput.writeInt(this.x);
        }
    }

    public class CDPAtomEnhGroup
    extends CDPProperty {
        short val;

        CDPAtomEnhGroup(short s) {
            super(1095);
            this.val = s;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(2);
            dataOutput.writeShort(this.val);
        }
    }

    public class CDPShowBondStereo
    extends CDPProperty {
        byte val;

        CDPShowBondStereo(boolean bl) {
            super(1549);
            this.val = bl ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.val);
        }
    }

    public class CDPShowAtomStereo
    extends CDPProperty {
        byte val;

        CDPShowAtomStereo(boolean bl) {
            super(1083);
            this.val = bl ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.val);
        }
    }

    public class CDPShowEnhAtomStereo
    extends CDPProperty {
        byte val;

        CDPShowEnhAtomStereo(boolean bl) {
            super(1093);
            this.val = bl ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.val);
        }
    }

    public class CDPAtomEnhStereoType
    extends CDPProperty {
        byte val;

        CDPAtomEnhStereoType(byte by) {
            super(1094);
            this.val = by;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.val);
        }
    }

    public class CDPAtomCIP
    extends CDPProperty {
        byte val;

        CDPAtomCIP(byte by) {
            super(1079);
            this.val = by;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.val);
        }
    }

    public class CDPAtomIsotope
    extends CDPProperty {
        short iso;

        CDPAtomIsotope(short s) {
            super(1056);
            this.iso = s;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(2);
            dataOutput.writeShort(this.iso);
        }
    }

    public class CDPAtomRadical
    extends CDPProperty {
        byte rad;

        CDPAtomRadical(byte by) {
            super(1058);
            this.rad = by;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.rad);
        }
    }

    public class CDPAtomCharge
    extends CDPProperty {
        byte charge;

        CDPAtomCharge(byte by) {
            super(1057);
            this.charge = by;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeShort(1);
            dataOutput.writeByte(this.charge);
        }
    }

    private abstract class CDPProperty {
        protected int type;

        public CDPProperty(int n) {
            this.type = n;
        }

        public abstract void write(DataOutput var1) throws IOException;
    }

    public class CDXReactionStep
    extends CDXNode {
        public CDXReactionStep(int[] nArray, int[] nArray2) {
            super(32782);
            CDPReactants cDPReactants = new CDPReactants(nArray);
            CDPProducts cDPProducts = new CDPProducts(nArray2);
            this.add(cDPReactants);
            this.add(cDPProducts);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXBond
    extends CDXNode {
        public CDXBond(int n, int n2) {
            super(32773);
            this.add(new CDPBondBegin(n));
            this.add(new CDPBondEnd(n2));
        }

        @Override
        public String start() {
            return this.startString();
        }

        public void setBondType(int n) {
            CDPBondType cDPBondType = new CDPBondType(n);
            this.add(cDPBondType);
            switch (n) {
                case 129: {
                    this.add(new CDPBondDisplay(3));
                    break;
                }
                case 257: {
                    this.add(new CDPBondDisplay(6));
                }
            }
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXAtom
    extends CDXNode {
        public CDXAtom(short s, int n, int n2) {
            super(32772);
            this.add(new CDPPoint2D(n, n2));
            this.add(new CDPElement(s));
        }

        public void setAtomESRStereo(int n) {
            ChemDrawCDX.debug("setAtomESRStereo " + n);
            switch (n) {
                case 0: {
                    this.add(new CDPAtomEnhStereoType(2));
                    break;
                }
                case 1: {
                    this.add(new CDPAtomEnhStereoType(4));
                    break;
                }
                case 2: {
                    this.add(new CDPAtomEnhStereoType(5));
                    break;
                }
            }
        }

        public void setAtomESRGroup(int n) {
            this.add(new CDPAtomEnhGroup((short)n));
        }

        public void setAtomCIP(int n, boolean bl, boolean bl2) {
            if (!bl) {
                switch (n) {
                    case 1: {
                        this.add(new CDPAtomCIP(bl2 ? (byte)4 : 2));
                        break;
                    }
                    case 2: {
                        this.add(new CDPAtomCIP(bl2 ? (byte)5 : 3));
                        break;
                    }
                    default: {
                        this.add(new CDPAtomCIP(6));
                    }
                }
            }
        }

        public void setAtomMass(short s) {
            this.add(new CDPAtomIsotope(s));
        }

        public void setAtomCharge(byte by) {
            this.add(new CDPAtomCharge(by));
        }

        public void setAtomRadical(byte by) {
            this.add(new CDPAtomRadical(by));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXMethane
    extends CDXAtom {
        public CDXMethane(int n, int n2) {
            super((short)6, n, n2);
            this.add(new CDXText("CH4", n, n2));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXText
    extends CDXNode {
        String s;

        CDXText(String string, int n, int n2) {
            super(32774);
            this.s = string;
            this.add(new CDPPoint2D(n, n2));
            this.add(new CDPText(string));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXFragment
    extends CDXNode {
        public CDXFragment() {
            super(32771);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    public class CDXPage
    extends CDXNode {
        public CDXPage() {
            super(32769);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    public class CDXDocument
    extends CDXNode {
        public CDXDocument() {
            super(1145268822);
        }

        @Override
        public void startWrite(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.type);
            dataOutput.writeInt(0x30303130);
            dataOutput.writeInt(16909060);
            dataOutput.writeLong(0L);
            dataOutput.writeLong(0L);
            dataOutput.write(COLORTABLE);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private abstract class CDXNode {
        protected int id = ChemDrawCDX.access$008();
        protected int type;
        private List<CDXNode> children;
        protected Set<CDPProperty> properties;

        public CDXNode(int n) {
            this.type = n;
        }

        public int getID() {
            return this.id;
        }

        public abstract String start();

        public abstract String end();

        public void startWrite(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.type);
            dataOutput.writeInt(this.id);
            this.writeProperties(dataOutput);
        }

        public final void endWrite(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(0);
        }

        protected void writeProperties(DataOutput dataOutput) {
            if (this.properties != null) {
                for (CDPProperty cDPProperty : this.properties) {
                    try {
                        cDPProperty.write(dataOutput);
                    }
                    catch (IOException iOException) {
                        System.err.println("Error writin property: " + iOException);
                    }
                }
            }
        }

        public void walk(Functor functor) {
            functor.start(this);
            if (this.children != null) {
                for (CDXNode cDXNode : this.children) {
                    cDXNode.walk(functor);
                }
            }
            functor.end(this);
        }

        public void add(CDXNode cDXNode) {
            if (this.children == null) {
                this.children = new ArrayList<CDXNode>();
            }
            this.children.add(cDXNode);
        }

        public void add(CDPProperty cDPProperty) {
            if (this.properties == null) {
                this.properties = new HashSet<CDPProperty>();
            }
            if (this.properties.contains(cDPProperty)) {
                this.properties.remove(cDPProperty);
            }
            this.properties.add(cDPProperty);
        }

        protected String startString() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LittleEndianDataOutputStream littleEndianDataOutputStream = new LittleEndianDataOutputStream(byteArrayOutputStream);
                this.startWrite(littleEndianDataOutputStream);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    if (i != 0) {
                        stringBuilder.append(" ");
                    }
                    if (i > 0 && i % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(String.format("%02X", by & 0xFF));
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException);
                return "#";
            }
        }
    }

    class MolGeom {
        double xmin;
        double ymin;
        double scale;

        MolGeom(double d, double d2, double d3) {
            this.xmin = d;
            this.ymin = d2;
            this.scale = d3;
        }
    }
}

