/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.SwingCanvas;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDragAdapter;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingCursorHelper;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class JStructureView
extends SwingCanvas
implements ActionListener,
MouseListener,
MouseMotionListener,
StructureListener {
    static final long serialVersionUID = 537268499L;
    private static final String ITEM_COPY = "Copy Structure";
    private static final String ITEM_COPY_SMILES = "Copy Structure As SMILES-String";
    private static final String ITEM_PASTE = "Paste Structure";
    private static final String ITEM_PASTE_WITH_NAME = "Paste Structure or Name";
    private static final String ITEM_CLEAR = "Clear Structure";
    private static final int DRAG_MARGIN = 12;
    private ArrayList<StructureListener> mListener;
    private String mIDCode;
    private StereoMolecule mMol;
    private StereoMolecule mDisplayMol;
    private GenericDepictor mDepictor;
    private boolean mShowBorder;
    private boolean mAllowFragmentStatusChangeOnPasteOrDrop;
    private boolean mIsDraggingThis;
    private boolean mIsEditable;
    private boolean mDisableBorder;
    private int mChiralTextPosition;
    private int mDisplayMode;
    private String[] mAtomText;
    private IClipboardHandler mClipboardHandler;
    protected MoleculeDropAdapter mDropAdapter = null;
    protected int mAllowedDragAction;
    protected int mAllowedDropAction;
    private int[] mAtomHiliteColor;
    private float[] mAtomHiliteRadius;
    private double mTextSizeFactor;
    private BufferedImage tempImage;
    private boolean setSizeToStructure = false;
    private double scaling = 1.0;

    public JStructureView() {
        this((StereoMolecule)null);
    }

    public JStructureView(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 3, 3);
    }

    public JStructureView(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this(stereoMolecule, stereoMolecule2, 3, 3);
    }

    public JStructureView(int n, int n2) {
        this(null, n, n2);
    }

    public JStructureView(StereoMolecule stereoMolecule, int n, int n2) {
        this(stereoMolecule, null, n, n2);
    }

    public JStructureView(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n, int n2) {
        this.mMol = stereoMolecule == null ? new StereoMolecule() : new StereoMolecule(stereoMolecule);
        this.mDisplayMol = stereoMolecule2 == null ? this.mMol : stereoMolecule2;
        this.mDisplayMode = 8;
        this.mTextSizeFactor = 1.0;
        this.mIsEditable = false;
        this.updateBackground();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initializeDragAndDrop(n, n2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBackground();
    }

    public void setClipboardHandler(IClipboardHandler iClipboardHandler) {
        this.mClipboardHandler = iClipboardHandler;
    }

    public IClipboardHandler getClipboardHandler() {
        return this.mClipboardHandler;
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(int n) {
        if (this.mDisplayMode != n) {
            this.mDisplayMode = n;
            this.repaint();
        }
    }

    public void setFactorTextSize(double d) {
        this.mTextSizeFactor = d;
    }

    public void setDisableBorder(boolean bl) {
        this.mDisableBorder = bl;
    }

    public void setAtomText(String[] stringArray) {
        this.mAtomText = stringArray;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.updateBackground();
            this.repaint();
            if (this.mDropAdapter != null) {
                this.mDropAdapter.setActive(bl);
            }
        }
        super.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.mIsEditable;
    }

    public void setEditable(boolean bl) {
        if (this.mIsEditable != bl) {
            this.mIsEditable = bl;
        }
    }

    public void setAllowFragmentStatusChangeOnPasteOrDrop(boolean bl) {
        this.mAllowFragmentStatusChangeOnPasteOrDrop = bl;
    }

    public void setAtomHighlightColors(int[] nArray, float[] fArray) {
        this.mAtomHiliteColor = nArray;
        this.mAtomHiliteRadius = fArray;
        this.repaint();
    }

    public boolean canDrop() {
        return this.mIsEditable && this.isEnabled() && !this.mIsDraggingThis;
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        GenericRectangle genericRectangle;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.setGraphicsRenderingHints(graphics2D);
        Color color = graphics2D.getColor();
        Color color2 = this.getBackground();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fill(new Rectangle(insets.left, insets.top, dimension.width, dimension.height));
        }
        if (this.mShowBorder && !this.mDisableBorder && (genericRectangle = this.mDepictor.getBoundingRect()) != null) {
            graphics.setColor(ColorHelper.perceivedBrightness(color2) < 0.5f ? ColorHelper.brighter(color2, 0.85f) : ColorHelper.darker(color2, 0.85f));
            int n = (int)Math.min(genericRectangle.height / 4.0, Math.min(genericRectangle.width / 4.0, (double)HiDPIHelper.scale(10.0f)));
            graphics.fillRoundRect((int)genericRectangle.x, (int)genericRectangle.y, (int)genericRectangle.width, (int)genericRectangle.height, n, n);
        }
        graphics2D.setColor(color);
        this.mDepictor = this.depict(graphics2D, this.getSize(), this.getInsets());
        if (this.mWarningMessage != null) {
            int n = HiDPIHelper.scale(12.0f);
            graphics.setFont(this.getFont().deriveFont(1, n));
            Color color3 = graphics.getColor();
            graphics.setColor(Color.RED);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.mWarningMessage, graphics);
            graphics.drawString(this.mWarningMessage, insets.left + (int)((double)dimension.width - rectangle2D.getWidth()) / 2, insets.top + fontMetrics.getHeight());
            graphics.setColor(color3);
        }
    }

    private void setGraphicsRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void setIDCode(String string) {
        this.setIDCode(string, null);
    }

    public synchronized void setIDCode(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (this.mIDCode == null && string == null) {
            return;
        }
        if (this.mIDCode != null && this.mIDCode.equals(string)) {
            return;
        }
        new IDCodeParser(true).parse(this.mMol, string, string2);
        this.mDisplayMol = this.mMol;
        this.mIDCode = string;
        this.repaint();
        this.informListeners();
    }

    @Override
    public synchronized void structureChanged(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            this.mMol.clear();
        } else {
            stereoMolecule.copyMolecule(this.mMol);
        }
        this.mDisplayMol = this.mMol;
        this.structureChanged();
    }

    public synchronized void structureChanged(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        if (stereoMolecule == null) {
            this.mMol.clear();
        } else {
            stereoMolecule.copyMolecule(this.mMol);
        }
        this.mDisplayMol = stereoMolecule2;
        this.structureChanged();
    }

    public synchronized void structureChanged() {
        this.mIDCode = null;
        this.repaint();
        this.informListeners();
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public StereoMolecule getDisplayMolecule() {
        return this.mDisplayMol;
    }

    public GenericDepictor getDepictor() {
        return this.mDepictor;
    }

    public void addStructureListener(StructureListener structureListener) {
        if (this.mListener == null) {
            this.mListener = new ArrayList();
        }
        this.mListener.add(structureListener);
    }

    public void removeStructureListener(StructureListener structureListener) {
        if (this.mListener != null) {
            this.mListener.remove(structureListener);
        }
    }

    public void setChiralDrawPosition(int n) {
        this.mChiralTextPosition = n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.handlePopupTrigger(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupTrigger(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        GenericRectangle genericRectangle;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (this.mDepictor != null && (this.mAllowedDragAction & 1) != 0 && (genericRectangle = this.shrink(this.mDepictor.getBoundingRect())) != null && genericRectangle.contains(n, n2)) {
            bl = true;
        }
        this.updateBorder(bl);
        this.setCursor(SwingCursorHelper.getCursor(bl ? 2 : 11));
    }

    private GenericRectangle shrink(GenericRectangle genericRectangle) {
        int n = HiDPIHelper.scale(12.0f);
        int n2 = Math.min(n, (int)genericRectangle.width / 6);
        int n3 = Math.min(n, (int)genericRectangle.height / 6);
        return new GenericRectangle((int)genericRectangle.x + n2, (int)genericRectangle.y + n3, (int)genericRectangle.width - 2 * n2, (int)genericRectangle.height - 2 * n3);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getActionCommand().equals(ITEM_COPY)) {
            this.mClipboardHandler.copyMolecule(this.mMol);
        }
        if (actionEvent.getActionCommand().equals(ITEM_COPY_SMILES)) {
            String string = new IsomericSmilesCreator(this.mMol).getSmiles();
            object = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
        }
        if (actionEvent.getActionCommand().startsWith(ITEM_PASTE) && this.mIsEditable) {
            int n = this.mAllowFragmentStatusChangeOnPasteOrDrop ? 1 : (this.mMol.isFragment() ? 2 : 0);
            object = this.mClipboardHandler.pasteMolecule(true, n);
            if (object != null) {
                if (!this.mAllowFragmentStatusChangeOnPasteOrDrop) {
                    ((Molecule)object).setFragment(this.mMol.isFragment());
                }
                this.mMol = object;
                this.mDisplayMol = object;
                this.structureChanged();
            } else {
                this.showWarningMessage("No molecule on clipboard!");
            }
        }
        if (actionEvent.getActionCommand().equals(ITEM_CLEAR) && this.mIsEditable) {
            this.mMol.clear();
            this.mDisplayMol = this.mMol;
            this.structureChanged();
        }
    }

    private void updateBackground() {
        Color color = UIManager.getColor(this.isEditable() && this.isEnabled() ? "TextField.background" : "TextField.inactiveBackground");
        if (color != null) {
            this.setBackground(color);
        }
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        if (this.mMol != null && mouseEvent.isPopupTrigger() && this.mClipboardHandler != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(ITEM_COPY);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.mMol.getAllAtoms() != 0);
            jPopupMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(ITEM_COPY_SMILES);
            jMenuItem2.addActionListener(this);
            jMenuItem2.setEnabled(this.mMol.getAllAtoms() != 0);
            jPopupMenu.add(jMenuItem2);
            if (this.mIsEditable) {
                String string = StructureNameResolver.getInstance() == null ? ITEM_PASTE : ITEM_PASTE_WITH_NAME;
                JMenuItem jMenuItem3 = new JMenuItem(string);
                jMenuItem3.addActionListener(this);
                jPopupMenu.add(jMenuItem3);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem4 = new JMenuItem(ITEM_CLEAR);
                jMenuItem4.addActionListener(this);
                jMenuItem4.setEnabled(this.mMol.getAllAtoms() != 0);
                jPopupMenu.add(jMenuItem4);
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void informListeners() {
        if (this.mListener != null) {
            for (int i = 0; i < this.mListener.size(); ++i) {
                this.mListener.get(i).structureChanged(this.mMol);
            }
        }
    }

    private void initializeDragAndDrop(int n, int n2) {
        final JStructureView jStructureView = this;
        this.mAllowedDragAction = n;
        this.mAllowedDropAction = n2;
        this.mAllowFragmentStatusChangeOnPasteOrDrop = false;
        if (n != 0) {
            new MoleculeDragAdapter(this){

                @Override
                public Transferable getTransferable(Point point) {
                    return JStructureView.this.getMoleculeTransferable(point);
                }

                @Override
                public void onDragEnter() {
                    jStructureView.onDragEnter();
                }

                @Override
                public void dragIsValidAndStarts() {
                    JStructureView.this.mIsDraggingThis = true;
                }

                @Override
                public void onDragExit() {
                    jStructureView.onDragExit();
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                    JStructureView.this.mIsDraggingThis = false;
                }
            };
        }
        if (n2 != 0) {
            this.mDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                    if (stereoMolecule != null && JStructureView.this.canDrop()) {
                        boolean bl = JStructureView.this.mMol.isFragment();
                        JStructureView.this.mMol = new StereoMolecule(stereoMolecule);
                        JStructureView.this.mMol.removeAtomColors();
                        JStructureView.this.mMol.removeBondHiliting();
                        if (!JStructureView.this.mAllowFragmentStatusChangeOnPasteOrDrop) {
                            JStructureView.this.mMol.setFragment(bl);
                        }
                        JStructureView.this.mDisplayMol = JStructureView.this.mMol;
                        JStructureView.this.repaint();
                        JStructureView.this.informListeners();
                        JStructureView.this.onDrop();
                    }
                    JStructureView.this.updateBorder(false);
                }

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    boolean bl;
                    boolean bl2 = bl = JStructureView.this.canDrop() && this.isDropOK(dropTargetDragEvent);
                    if (!bl) {
                        dropTargetDragEvent.rejectDrag();
                    }
                }

                @Override
                public void dragExit(DropTargetEvent dropTargetEvent) {
                }
            };
            new DropTarget(this, this.mAllowedDropAction, this.mDropAdapter, true);
        }
    }

    protected Transferable getMoleculeTransferable(Point point) {
        return new MoleculeTransferable(this.mMol);
    }

    protected void onDragEnter() {
    }

    protected void onDragExit() {
    }

    protected void onDragOver() {
    }

    protected void onDrop() {
    }

    private void updateBorder(boolean bl) {
        if (this.mShowBorder != bl) {
            this.mShowBorder = bl;
            this.repaint();
        }
    }

    public GenericDepictor depict(Graphics2D graphics2D, Dimension dimension, Insets insets) {
        Graphics2D graphics2D2;
        int n;
        if (this.mDisplayMol == null && this.mDisplayMol.getAllAtoms() == 0) {
            return null;
        }
        GenericDepictor genericDepictor = new GenericDepictor(this.mDisplayMol);
        genericDepictor.setDisplayMode(this.mDisplayMode);
        genericDepictor.setFactorTextSize(this.mTextSizeFactor);
        genericDepictor.setAtomText(this.mAtomText);
        genericDepictor.setAtomHighlightColors(this.mAtomHiliteColor, this.mAtomHiliteRadius);
        Color color = this.getBackground();
        int n2 = n = color == null ? 0 : color.getRGB();
        if (!this.isEnabled()) {
            genericDepictor.setOverruleColor(ColorHelper.getContrastColor(0x808080, n), n);
        } else {
            genericDepictor.setForegroundColor(this.getForeground().getRGB(), n);
        }
        int n3 = HiDPIHelper.scale(24.0f * (float)this.scaling);
        Graphics2D graphics2D3 = graphics2D2 = graphics2D == null ? this.getTempGraphics() : graphics2D;
        if (dimension == null) {
            dimension = new Dimension(1000, 1000);
        }
        if (insets == null) {
            insets = new Insets(5, 5, 5, 5);
        }
        int n4 = dimension.width - (insets.left + insets.right);
        int n5 = dimension.height - (insets.top + insets.bottom);
        SwingDrawContext swingDrawContext = new SwingDrawContext(graphics2D2);
        genericDepictor.validateView(swingDrawContext, new GenericRectangle(insets.left, insets.top, n4, n5), 0x10000 | this.mChiralTextPosition | n3);
        if (graphics2D != null) {
            this.setGraphicsRenderingHints(graphics2D);
            genericDepictor.paint(swingDrawContext);
        }
        return genericDepictor;
    }

    private Graphics2D getTempGraphics() {
        if (this.tempImage == null) {
            this.tempImage = new BufferedImage(1000, 1000, 2);
        }
        return this.tempImage.createGraphics();
    }

    public Dimension setSizeToStructure(boolean bl) {
        this.setSizeToStructure = bl;
        return this.getPreferredSize();
    }

    public void setScaling(double d) {
        this.scaling = d;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            GenericDepictor genericDepictor;
            GenericDepictor genericDepictor2 = genericDepictor = this.setSizeToStructure ? this.depict(null, null, null) : null;
            if (genericDepictor != null) {
                GenericRectangle genericRectangle = genericDepictor.getBoundingRect();
                if (genericRectangle.width > 0.0 && genericRectangle.height > 0.0) {
                    return new Dimension((int)genericRectangle.width + 10, (int)genericRectangle.height + 10);
                }
            }
        }
        return super.getPreferredSize();
    }

    public static JStructureView getStandardView(StereoMolecule stereoMolecule) {
        return JStructureView.createView(stereoMolecule, 0, 1.0, Color.white);
    }

    public static JStructureView createView(StereoMolecule stereoMolecule, int n, double d, Color color) {
        JStructureView jStructureView = new JStructureView(stereoMolecule);
        if (n == 0) {
            n = 0x1000E0;
        }
        jStructureView.setDisplayMode(n);
        jStructureView.setBackground(color);
        jStructureView.setScaling(d);
        jStructureView.setSizeToStructure(true);
        return jStructureView;
    }

    public void showInFrame(String string, Point point) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(3);
        JFrame jFrame2 = jFrame;
        jFrame2.add(this);
        jFrame2.pack();
        jFrame2.setLocation(point.x, point.y);
        jFrame2.setVisible(true);
    }

    public BufferedImage getSizedImage() {
        Dimension dimension = this.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = this.getBackground();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
        this.depict(graphics2D, dimension, null);
        return bufferedImage;
    }
}

