/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JMessageBar
extends JPanel {
    private static JMessageBar sMessageBar = null;
    private static Color sBackground = new Color(99, 99, 99);
    private static Color sTextColor = Color.GREEN;
    private static Color sBusyColor = Color.ORANGE;
    private static Color sErrorColor = Color.RED;
    private JLabel mLabel;
    private String mText;

    public static JMessageBar getBar() {
        if (sMessageBar == null) {
            sMessageBar = new JMessageBar();
        }
        return sMessageBar;
    }

    private JMessageBar() {
        this.setLayout(new BorderLayout());
        this.mLabel = new JLabel("", 0);
        this.mLabel.setFont(this.mLabel.getFont().deriveFont(0, HiDPIHelper.scale(12.0f)));
        this.mLabel.setForeground(sTextColor);
        this.mLabel.setBackground(sBackground);
        this.mLabel.setOpaque(true);
        this.add((Component)this.mLabel, "Center");
    }

    public static void setTextColor(Color color) {
        sTextColor = color;
    }

    public static void setBusyColor(Color color) {
        sTextColor = color;
    }

    public static void setErrorColor(Color color) {
        sTextColor = color;
    }

    public static void setBackgroundColor(Color color) {
        sBackground = color;
    }

    public void setText(String string) {
        this.mLabel.setForeground(sTextColor);
        this.mLabel.setText(string);
        this.mText = string;
    }

    public void showText() {
        this.mLabel.setForeground(sTextColor);
        this.mLabel.setText(this.mText);
    }

    public void showBusyMessage(String string) {
        this.mLabel.setForeground(sBusyColor);
        this.mLabel.setText(string);
    }

    public void showErrorMessage(String string) {
        this.mLabel.setForeground(sErrorColor);
        this.mLabel.setText(string);
    }
}

