/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.JStructureView;
import com.actelion.research.gui.editor.SwingEditorDialog;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingUIHelper;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class JEditableStructureView
extends JStructureView {
    static final long serialVersionUID = 537462567L;
    private static final String EDIT_MESSAGE = "<double click or drag & drop>";
    private boolean mAllowQueryFeatures;
    private int mAllowedPseudoAtoms;

    public JEditableStructureView() {
        this((StereoMolecule)null);
    }

    public JEditableStructureView(StereoMolecule stereoMolecule) {
        super(stereoMolecule);
        this.setEditable(true);
        this.mAllowedPseudoAtoms = 331;
        this.mAllowQueryFeatures = true;
    }

    public JEditableStructureView(int n, int n2) {
        this(null, n, n2);
    }

    public JEditableStructureView(StereoMolecule stereoMolecule, int n, int n2) {
        super(stereoMolecule, n, n2);
        this.setEditable(true);
        this.mAllowedPseudoAtoms = 331;
        this.mAllowQueryFeatures = true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        super.paintComponent(graphics);
        if (this.isEnabled() && this.isEditable() && this.getMolecule().getAllAtoms() == 0) {
            graphics.setFont(graphics.getFont().deriveFont(0, HiDPIHelper.scale(10.0f)));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(EDIT_MESSAGE, graphics);
            graphics.drawString(EDIT_MESSAGE, (int)((double)(insets.left + dimension.width) - rectangle2D.getWidth()) / 2, (insets.top + dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.isEnabled() && this.isEditable()) {
            SwingEditorDialog swingEditorDialog = this.createDrawDialog();
            swingEditorDialog.getDrawArea().setAllowedPseudoAtoms(this.mAllowedPseudoAtoms);
            swingEditorDialog.getDrawArea().setAllowQueryFeatures(this.mAllowQueryFeatures);
            swingEditorDialog.getDrawArea().setDisplayMode(this.getDisplayMode());
            swingEditorDialog.addStructureListener(this);
            swingEditorDialog.setVisible(true);
        }
    }

    protected SwingEditorDialog createDrawDialog() {
        return new SwingEditorDialog(SwingUIHelper.getWindow(this), this.getMolecule(), Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public void setAllowedPseudoAtoms(int n) {
        this.mAllowedPseudoAtoms = n;
    }

    public void setAllowQueryFeatures(boolean bl) {
        if (this.mAllowQueryFeatures != bl) {
            this.mAllowQueryFeatures = bl;
            if (!bl && this.getMolecule().removeQueryFeatures()) {
                this.structureChanged();
            }
        }
    }
}

