/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.MoleculeFilter;
import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.MolfileV3Creator;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.SubstructureFilter;
import com.actelion.research.gui.CompoundCollectionListener;
import com.actelion.research.gui.CompoundCollectionModel;
import com.actelion.research.gui.DefaultCompoundCollectionModel;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.ScrollPaneAutoScrollerWhenDragging;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDragAdapter;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.editor.SwingEditorDialog;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingCursorHelper;
import com.actelion.research.gui.swing.SwingUIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CompoundCollectionPane<T>
extends JScrollPane
implements ActionListener,
CompoundCollectionListener,
MouseListener,
MouseMotionListener,
StructureListener {
    private static final long serialVersionUID = 537266436L;
    private static final String[] MESSAGE = new String[]{"<to add compounds use popup menu,", "drag&drop, or paste structure(s) or name(s)>"};
    private static final String ADD = "Add...";
    private static final String EDIT = "Edit...";
    private static final String REMOVE = "Remove";
    private static final String REMOVE_ALL = "Remove All";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    private static final String OPEN = "Add From File...";
    private static final String SAVE_DWAR = "Save DataWarrior-File...";
    private static final String SAVE_SDF2 = "Save SD-File V2...";
    private static final String SAVE_SDF3 = "Save SD-File V3...";
    public static final int FILE_SUPPORT_NONE = 0;
    public static final int FILE_SUPPORT_OPEN_FILES = 1;
    public static final int FILE_SUPPORT_SAVE_FILES = 2;
    public static final int FILE_SUPPORT_OPEN_AND_SAVE_FILES = 3;
    private static final int ALLOWED_DRAG_ACTIONS = 3;
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private static final int cWhiteSpace = 4;
    private CompoundCollectionModel<T> mModel;
    private IClipboardHandler mClipboardHandler;
    private MoleculeFilter mCompoundFilter;
    private int mDisplayMode;
    private int mSelectedIndex;
    private int mHighlightedIndex;
    private int mEditedIndex;
    private int mFileSupport;
    private int mStructureSize;
    private int mDragIndex;
    private int mDropIndex;
    private Dimension mContentSize;
    private Dimension mCellSize;
    private JPanel mContentPanel;
    private boolean mIsVertical;
    private boolean mIsEditable;
    private boolean mIsSelectable;
    private boolean mCreateFragments;
    private boolean mIsEnabled;
    private boolean mShowValidationError;
    private boolean mInternalDragAndDropIsMove;
    private String[] mMessage;
    private ArrayList<JMenuItem> mCustomPopupItemList;
    private ScrollPaneAutoScrollerWhenDragging mScroller;

    public CompoundCollectionPane(CompoundCollectionModel<T> compoundCollectionModel, boolean bl) {
        this(compoundCollectionModel, bl, 0, 3, 3);
    }

    public CompoundCollectionPane(CompoundCollectionModel<T> compoundCollectionModel, boolean bl, int n, int n2, int n3) {
        this.mModel = compoundCollectionModel;
        this.mModel.addCompoundCollectionListener(this);
        this.mIsEnabled = true;
        this.mIsVertical = bl;
        this.mDisplayMode = n;
        this.mFileSupport = 3;
        this.mStructureSize = 0;
        this.mSelectedIndex = -1;
        this.mHighlightedIndex = -1;
        this.mDragIndex = -1;
        this.mDropIndex = -1;
        this.init();
        this.initializeDragAndDrop(n2, n3);
        this.mScroller = new ScrollPaneAutoScrollerWhenDragging(this, bl);
    }

    public CompoundCollectionModel<T> getModel() {
        return this.mModel;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.mIsVertical) {
            this.getVerticalScrollBar().setEnabled(bl);
        } else {
            this.getHorizontalScrollBar().setEnabled(bl);
        }
        this.mIsEnabled = bl;
        this.repaint();
    }

    public void setInternalDragAndDropIsMove(boolean bl) {
        this.mInternalDragAndDropIsMove = bl;
    }

    public void setStructureSize(int n) {
        this.mStructureSize = n;
        this.validateSize();
        this.repaint();
    }

    public void setEditable(boolean bl) {
        this.mIsEditable = bl;
        this.updateMouseListening();
    }

    public void setFileSupport(int n) {
        this.mFileSupport = n;
    }

    public void setCompoundFilter(MoleculeFilter moleculeFilter) {
        if (this.mCompoundFilter != moleculeFilter) {
            this.mCompoundFilter = moleculeFilter;
            if (this.mCompoundFilter != null) {
                for (int i = this.mModel.getSize() - 1; i >= 0; --i) {
                    if (this.mCompoundFilter.moleculeQualifies(this.mModel.getMolecule(i))) continue;
                    this.mModel.remove(i);
                }
            }
        }
    }

    public void setSelectable(boolean bl) {
        this.mIsSelectable = bl;
        this.updateMouseListening();
    }

    public void setCreateFragments(boolean bl) {
        this.mCreateFragments = bl;
    }

    public void setShowValidationError(boolean bl) {
        this.mShowValidationError = bl;
    }

    public void setClipboardHandler(IClipboardHandler iClipboardHandler) {
        this.mClipboardHandler = iClipboardHandler;
    }

    public IClipboardHandler getClipboardHandler() {
        return this.mClipboardHandler;
    }

    public void addCustomPopupItem(JMenuItem jMenuItem) {
        if (this.mCustomPopupItemList == null) {
            this.mCustomPopupItemList = new ArrayList();
        }
        this.mCustomPopupItemList.add(jMenuItem);
    }

    public void setMessage(String string) {
        if (string == null) {
            this.mMessage = null;
        } else {
            this.mMessage = new String[1];
            this.mMessage[0] = string;
        }
        if (this.mModel.getSize() == 0) {
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(COPY) && this.mHighlightedIndex != -1) {
            this.mClipboardHandler.copyMolecule(this.mModel.getMolecule(this.mHighlightedIndex));
        } else if (actionEvent.getActionCommand().equals(PASTE)) {
            int n = this.mHighlightedIndex == -1 ? this.mModel.getSize() : this.mHighlightedIndex;
            ArrayList<StereoMolecule> arrayList2 = this.mClipboardHandler.pasteMolecules();
            if (arrayList2 != null) {
                int n2 = 0;
                for (StereoMolecule stereoMolecule : arrayList2) {
                    stereoMolecule.setFragment(this.mCreateFragments);
                    if (this.mCompoundFilter == null || this.mCompoundFilter.moleculeQualifies(stereoMolecule)) {
                        this.mModel.addMolecule(n, stereoMolecule);
                        continue;
                    }
                    ++n2;
                }
                if (n2 != 0) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), n2 + " compound(s) could not be added, because they doesn't qualify.");
                }
            }
        } else if (actionEvent.getActionCommand().equals(ADD)) {
            this.editStructure(-1);
        } else if (actionEvent.getActionCommand().equals(EDIT) && this.mHighlightedIndex != -1) {
            this.editStructure(this.mHighlightedIndex);
        } else if (actionEvent.getActionCommand().equals(REMOVE) && this.mHighlightedIndex != -1) {
            this.mModel.remove(this.mHighlightedIndex);
            this.mHighlightedIndex = -1;
        } else if (actionEvent.getActionCommand().equals(REMOVE_ALL)) {
            this.mModel.clear();
            this.mHighlightedIndex = -1;
        } else if (actionEvent.getActionCommand().equals(OPEN)) {
            new FileHelper(this.getParentFrame()).readStructuresFromFileAsync(true, arrayList -> {
                if (arrayList != null) {
                    for (Object e : arrayList) {
                        ((StereoMolecule)e).setFragment(this.mCreateFragments);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    int n = 0;
                    int n2 = arrayList.size();
                    for (int i = 0; i < n2; ++i) {
                        StereoMolecule stereoMolecule = (StereoMolecule)arrayList.get(i);
                        if (this.mCompoundFilter != null && !this.mCompoundFilter.moleculeQualifies(stereoMolecule)) {
                            ++n;
                            continue;
                        }
                        arrayList2.add(stereoMolecule);
                    }
                    if (n != 0) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), Integer.toString(n).concat(" compounds were removed, because they don't qualify."));
                    }
                    this.mModel.addMoleculeList(arrayList2);
                }
            });
        } else if (actionEvent.getActionCommand().equals(SAVE_DWAR)) {
            String string = new FileHelper(this.getParentFrame()).selectFileToSave("Save DataWarrior File", 1, "Untitled");
            if (string != null) {
                try {
                    String string2 = this.mCreateFragments ? "Fragment" : "Structure";
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
                    bufferedWriter.write("<datawarrior-fileinfo>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<version=\"3.1\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<rowcount=\"" + this.mModel.getSize() + "\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("</datawarrior-fileinfo>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<column properties>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<columnName=\"" + string2 + "\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<columnProperty=\"specialType\tidcode\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<columnName=\"coords\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<columnProperty=\"specialType\tidcoordinates2D\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<columnProperty=\"parent\t" + string2 + "\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("</column properties>");
                    bufferedWriter.newLine();
                    bufferedWriter.write(string2 + "\tcoords");
                    bufferedWriter.newLine();
                    for (int i = 0; i < this.mModel.getSize(); ++i) {
                        Object object;
                        if (this.mModel instanceof DefaultCompoundCollectionModel.IDCode) {
                            object = (String)this.mModel.getCompound(i);
                            int n = ((String)object).indexOf(32);
                            if (n == -1) {
                                bufferedWriter.write(((String)object).substring(0, n));
                                bufferedWriter.write(9);
                                bufferedWriter.write(((String)object).substring(n + 1));
                            } else {
                                bufferedWriter.write((String)object);
                                bufferedWriter.write(9);
                            }
                        } else {
                            object = new Canonizer(this.mModel.getMolecule(i));
                            bufferedWriter.write(((Canonizer)object).getIDCode());
                            bufferedWriter.write(9);
                            bufferedWriter.write(((Canonizer)object).getEncodedCoordinates());
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), iOException.toString());
                }
            }
        } else if (actionEvent.getActionCommand().equals(SAVE_SDF2) || actionEvent.getActionCommand().equals(SAVE_SDF3)) {
            String string = "Version " + (actionEvent.getActionCommand().equals(SAVE_SDF2) ? "2" : "3");
            String string3 = new FileHelper(this.getParentFrame()).selectFileToSave("Save SD-File " + string, 768, "Untitled");
            if (string3 != null) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), "UTF-8"));
                    for (int i = 0; i < this.mModel.getSize(); ++i) {
                        StereoMolecule stereoMolecule = this.mModel.getMolecule(i);
                        if (actionEvent.getActionCommand().equals(SAVE_SDF3)) {
                            new MolfileV3Creator(stereoMolecule).writeMolfile(bufferedWriter);
                        } else {
                            new MolfileCreator(stereoMolecule).writeMolfile(bufferedWriter);
                        }
                        bufferedWriter.write("$$$$");
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), iOException.toString());
                }
            }
        }
    }

    private void editStructure(int n) {
        this.mEditedIndex = n;
        StereoMolecule stereoMolecule = null;
        if (n == -1) {
            stereoMolecule = new StereoMolecule();
            stereoMolecule.setFragment(this.mCreateFragments);
        } else {
            stereoMolecule = this.mModel.getMolecule(this.mEditedIndex);
        }
        SwingEditorDialog swingEditorDialog = new SwingEditorDialog(SwingUIHelper.getWindow(this), stereoMolecule, Dialog.ModalityType.APPLICATION_MODAL);
        swingEditorDialog.addStructureListener(this);
        swingEditorDialog.setVisible(true);
    }

    private void updateMouseListening() {
        if (this.mIsSelectable || this.mIsEditable) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
    }

    private void init() {
        this.mContentSize = new Dimension();
        this.mContentPanel = new JPanel(){
            private static final long serialVersionUID = 537266436L;

            @Override
            public void paintComponent(Graphics graphics) {
                Serializable serializable;
                super.paintComponent(graphics);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                CompoundCollectionPane.this.validateSize();
                Rectangle rectangle = graphics.getClipBounds();
                Color color = UIManager.getColor(CompoundCollectionPane.this.mIsEnabled ? "TextArea.background" : "TextArea.inactiveBackground");
                Color color2 = UIManager.getColor(CompoundCollectionPane.this.mIsEnabled ? "TextArea.foreground" : "TextArea.inactiveForeground");
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                int n = 0;
                int n2 = 0;
                if (CompoundCollectionPane.this.mModel.getSize() != 0) {
                    n = Math.max(0, CompoundCollectionPane.this.mIsVertical ? rectangle.y / ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.height : rectangle.x / ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.width);
                    n2 = Math.min(CompoundCollectionPane.this.mModel.getSize(), CompoundCollectionPane.this.mIsVertical ? 1 + (rectangle.y + rectangle.height) / ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.height : 1 + (rectangle.x + rectangle.width) / ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.width);
                    serializable = ColorHelper.perceivedBrightness(color) < 0.5f ? ColorHelper.brighter(color, 0.8f) : ColorHelper.darker(color, 0.8f);
                    for (int i = n; i < n2; ++i) {
                        Rectangle rectangle2 = CompoundCollectionPane.this.getMoleculeBounds(i);
                        StereoMolecule stereoMolecule = CompoundCollectionPane.this.mModel.getMoleculeForDisplay(i);
                        if (CompoundCollectionPane.this.mShowValidationError) {
                            try {
                                stereoMolecule.validate();
                            }
                            catch (Exception exception) {
                                int n3 = Math.min(rectangle2.width, rectangle2.height);
                                graphics.setColor((Color)serializable);
                                graphics.setFont(graphics.getFont().deriveFont(1, n3));
                                FontMetrics fontMetrics = graphics.getFontMetrics();
                                Rectangle2D rectangle2D = fontMetrics.getStringBounds("?", graphics);
                                graphics.drawString("?", rectangle2.x + (rectangle2.width - (int)rectangle2D.getWidth()) / 2, rectangle2.y + (rectangle2.height - (int)rectangle2D.getHeight()) / 2 + fontMetrics.getAscent());
                            }
                        }
                        Depictor2D depictor2D = new Depictor2D(stereoMolecule, CompoundCollectionPane.this.mDisplayMode);
                        depictor2D.validateView((Graphics2D)graphics, new GenericRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height), 65536);
                        depictor2D.setForegroundColor(color2, color);
                        depictor2D.paint((Graphics2D)graphics);
                        if (CompoundCollectionPane.this.mSelectedIndex != i && CompoundCollectionPane.this.mHighlightedIndex != i) continue;
                        graphics.setColor(!CompoundCollectionPane.this.mIsEnabled ? ColorHelper.getContrastColor(Color.GRAY, color) : (CompoundCollectionPane.this.mSelectedIndex != i ? Color.BLUE : (CompoundCollectionPane.this.mHighlightedIndex != i ? Color.RED : Color.MAGENTA)));
                        graphics.drawRect(rectangle2.x - 2, rectangle2.y - 2, rectangle2.width + 3, rectangle2.height + 3);
                        graphics.drawRect(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 1, rectangle2.height + 1);
                    }
                } else {
                    serializable = CompoundCollectionPane.this.getViewportBorderBounds();
                    graphics.setColor(color2);
                    graphics.setFont(graphics.getFont().deriveFont(0, HiDPIHelper.scale(12.0f)));
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    String[] stringArray = CompoundCollectionPane.this.mMessage == null ? MESSAGE : CompoundCollectionPane.this.mMessage;
                    for (int i = 0; i < stringArray.length; ++i) {
                        Rectangle2D rectangle2D = fontMetrics.getStringBounds(stringArray[i], graphics);
                        graphics.drawString(stringArray[i], serializable.x + (serializable.width - (int)rectangle2D.getWidth()) / 2, serializable.y + i * fontMetrics.getHeight() + (serializable.height - stringArray.length * fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                    }
                }
                if (CompoundCollectionPane.this.mIsEnabled && CompoundCollectionPane.this.mIsEditable && CompoundCollectionPane.this.mDropIndex >= n && CompoundCollectionPane.this.mDropIndex <= n2) {
                    serializable = CompoundCollectionPane.this.getMoleculeBounds(CompoundCollectionPane.this.mDropIndex);
                    graphics.setColor(ColorHelper.getContrastColor(Color.GRAY, color));
                    if (CompoundCollectionPane.this.mIsVertical) {
                        graphics.fillRect(serializable.x - 2, serializable.y - 4, serializable.width + 4, 5);
                    } else {
                        graphics.fillRect(serializable.x - 4, serializable.y - 2, 5, serializable.height + 4);
                    }
                }
            }
        };
        this.setHorizontalScrollBarPolicy(this.mIsVertical ? 31 : 32);
        this.setVerticalScrollBarPolicy(this.mIsVertical ? 22 : 21);
        this.setViewportView(this.mContentPanel);
    }

    @Override
    public void collectionUpdated(int n, int n2) {
        if (this.mSelectedIndex >= n && this.mSelectedIndex <= n2) {
            this.mSelectedIndex = -1;
        }
        if (this.mHighlightedIndex >= n && this.mHighlightedIndex <= n2) {
            this.mHighlightedIndex = -1;
        }
        this.repaint();
    }

    private Rectangle getMoleculeBounds(int n) {
        int n2 = 2;
        int n3 = 2;
        if (this.mIsVertical) {
            n3 += n * this.mCellSize.height;
        } else {
            n2 += n * this.mCellSize.width;
        }
        return new Rectangle(n2, n3, this.mCellSize.width - 4, this.mCellSize.height - 4);
    }

    private int getMoleculeIndex(int n, int n2) {
        if (this.mModel.getSize() == 0 || this.mCellSize.width == 0 || this.mCellSize.height == 0) {
            return -1;
        }
        Point point = this.getViewport().getViewPosition();
        int n3 = this.mIsVertical ? (n2 + point.y) / this.mCellSize.height : (n + point.x) / this.mCellSize.width;
        return n3 < this.mModel.getSize() ? n3 : -1;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mIsEnabled && this.mIsEditable && mouseEvent.getClickCount() == 2 && this.mHighlightedIndex != -1) {
            this.editStructure(this.mHighlightedIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mIsEnabled) {
            int n;
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopupTrigger(mouseEvent);
            } else if (this.mIsSelectable && this.mSelectedIndex != (n = this.getMoleculeIndex(mouseEvent.getX(), mouseEvent.getY()))) {
                this.mSelectedIndex = n;
                this.setSelection(n);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mIsEnabled && mouseEvent.isPopupTrigger()) {
            this.handlePopupTrigger(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.mIsEnabled && this.mHighlightedIndex != (n = this.getMoleculeIndex(mouseEvent.getX(), mouseEvent.getY()))) {
            this.mHighlightedIndex = n;
            this.setCursor(SwingCursorHelper.getCursor(n == -1 ? 11 : 2));
            this.repaint();
        }
        this.mDragIndex = -1;
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(ADD);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        if (this.mHighlightedIndex != -1) {
            jMenuItem = new JMenuItem(EDIT);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(REMOVE);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
        }
        if (this.mModel.getSize() != 0) {
            jMenuItem = new JMenuItem(REMOVE_ALL);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
        }
        if (this.mClipboardHandler != null) {
            jPopupMenu.addSeparator();
            if (this.mHighlightedIndex != -1) {
                jMenuItem = new JMenuItem(COPY);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            jMenuItem = new JMenuItem(PASTE);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
        }
        if (this.mFileSupport != 0) {
            jPopupMenu.addSeparator();
            if ((this.mFileSupport & 1) != 0) {
                jMenuItem = new JMenuItem(OPEN);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            if ((this.mFileSupport & 2) != 0 && this.mModel.getSize() != 0) {
                jMenuItem = new JMenuItem(SAVE_DWAR);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(SAVE_SDF2);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(SAVE_SDF3);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
        }
        if (this.mCustomPopupItemList != null) {
            jPopupMenu.addSeparator();
            for (JMenuItem jMenuItem2 : this.mCustomPopupItemList) {
                jPopupMenu.add(jMenuItem2);
            }
        }
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void structureChanged(StereoMolecule stereoMolecule) {
        String string;
        String string2 = this.mCompoundFilter == null ? null : (string = this.mCompoundFilter instanceof SubstructureFilter ? "match the substructure" : "qualify");
        if (this.mEditedIndex == -1) {
            if (stereoMolecule.getAllAtoms() != 0) {
                if (this.mCompoundFilter == null || this.mCompoundFilter.moleculeQualifies(stereoMolecule)) {
                    this.mModel.addMolecule(this.mModel.getSize(), stereoMolecule);
                } else {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "The compound could not be added, because it doesn't " + string + ".");
                }
            }
        } else if (stereoMolecule.getAllAtoms() == 0) {
            this.mModel.remove(this.mEditedIndex);
        } else if (this.mCompoundFilter == null || this.mCompoundFilter.moleculeQualifies(stereoMolecule)) {
            this.mModel.setMolecule(this.mEditedIndex, stereoMolecule);
        } else {
            JOptionPane.showMessageDialog(this.getParentFrame(), "The compound could not be changed, because the changed structure doesn't " + string + ".");
        }
    }

    public void setSelection(int n) {
    }

    private void validateSize() {
        int n;
        Rectangle rectangle = this.getViewportBorderBounds();
        int n2 = this.mIsVertical ? rectangle.width : (n = this.mStructureSize == 0 ? rectangle.height : this.mStructureSize);
        int n3 = !this.mIsVertical ? rectangle.height : (this.mStructureSize == 0 ? rectangle.width : this.mStructureSize);
        this.mCellSize = new Dimension(n, n3);
        if (this.mIsVertical) {
            if ((n3 *= this.mModel.getSize()) < rectangle.height) {
                n3 = rectangle.height;
            }
        } else if ((n *= this.mModel.getSize()) < rectangle.width) {
            n = rectangle.width;
        }
        if (this.mContentSize.width != n || this.mContentSize.height != n3) {
            this.mContentSize.width = n;
            this.mContentSize.height = n3;
            this.mContentPanel.setPreferredSize(this.mContentSize);
            this.mContentPanel.revalidate();
        }
    }

    private void initializeDragAndDrop(int n, int n2) {
        if (n != 0) {
            new MoleculeDragAdapter(this){

                @Override
                public Transferable getTransferable(Point point) {
                    if (CompoundCollectionPane.this.mHighlightedIndex == -1) {
                        return null;
                    }
                    CompoundCollectionPane.this.setCursor(SwingCursorHelper.getCursor(4));
                    CompoundCollectionPane.this.mDragIndex = CompoundCollectionPane.this.mHighlightedIndex;
                    return new MoleculeTransferable(CompoundCollectionPane.this.mModel.getMolecule(CompoundCollectionPane.this.mHighlightedIndex));
                }
            };
        }
        if (n2 != 0) {
            MoleculeDropAdapter moleculeDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                    if (CompoundCollectionPane.this.mIsEnabled && CompoundCollectionPane.this.mIsEditable && stereoMolecule != null && stereoMolecule.getAllAtoms() != 0 && CompoundCollectionPane.this.mDropIndex != -1) {
                        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                            stereoMolecule.setAtomColor(i, 0);
                        }
                        stereoMolecule.setFragment(CompoundCollectionPane.this.mCreateFragments);
                        if (CompoundCollectionPane.this.mCompoundFilter == null || CompoundCollectionPane.this.mCompoundFilter.moleculeQualifies(stereoMolecule)) {
                            if (CompoundCollectionPane.this.mDragIndex != -1 && CompoundCollectionPane.this.mInternalDragAndDropIsMove) {
                                CompoundCollectionPane.this.mModel.remove(CompoundCollectionPane.this.mDragIndex);
                                if (CompoundCollectionPane.this.mDropIndex > CompoundCollectionPane.this.mDragIndex) {
                                    CompoundCollectionPane.this.mDropIndex--;
                                }
                            }
                            CompoundCollectionPane.this.mModel.addMolecule(CompoundCollectionPane.this.mDropIndex, stereoMolecule);
                        } else {
                            String string = CompoundCollectionPane.this.mCompoundFilter instanceof SubstructureFilter ? "match the substructure" : "qualify";
                            JOptionPane.showMessageDialog(CompoundCollectionPane.this.getParentFrame(), "The compound could not be added, because it doesn't " + string + ".");
                        }
                    }
                    CompoundCollectionPane.this.updateDropPosition(-1);
                }

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    boolean bl;
                    boolean bl2 = bl = CompoundCollectionPane.this.mIsEnabled && CompoundCollectionPane.this.mIsEditable && this.isDropOK(dropTargetDragEvent);
                    if (!bl) {
                        dropTargetDragEvent.rejectDrag();
                    } else {
                        CompoundCollectionPane.this.updateDropPosition(this.getDropIndex(dropTargetDragEvent));
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                    CompoundCollectionPane.this.mScroller.autoScroll();
                    CompoundCollectionPane.this.updateDropPosition(this.getDropIndex(dropTargetDragEvent));
                }

                @Override
                public void dragExit(DropTargetEvent dropTargetEvent) {
                    CompoundCollectionPane.this.updateDropPosition(-1);
                }

                private int getDropIndex(DropTargetDragEvent dropTargetDragEvent) {
                    int n;
                    int n2 = dropTargetDragEvent.getLocation().x + (CompoundCollectionPane.this.mIsVertical ? 0 : ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.width / 2);
                    int n3 = CompoundCollectionPane.this.getMoleculeIndex(n2, n = dropTargetDragEvent.getLocation().y + (CompoundCollectionPane.this.mIsVertical ? ((CompoundCollectionPane)CompoundCollectionPane.this).mCellSize.height / 2 : 0));
                    if (n3 == -1) {
                        n3 = CompoundCollectionPane.this.mModel.getSize();
                    }
                    if (CompoundCollectionPane.this.mInternalDragAndDropIsMove && (n3 == CompoundCollectionPane.this.mDragIndex || n3 == CompoundCollectionPane.this.mDragIndex + 1)) {
                        n3 = -1;
                    }
                    return n3;
                }
            };
            new DropTarget(this, n2, moleculeDropAdapter, true, new OurFlavorMap());
        }
    }

    private void updateDropPosition(int n) {
        if (this.mIsEnabled && this.mIsEditable && this.mDropIndex != n) {
            this.mDropIndex = n;
            this.repaint();
        }
    }

    private Component getParentFrame() {
        return this.getTopLevelAncestor();
    }

    static class OurFlavorMap
    implements FlavorMap {
        OurFlavorMap() {
        }

        @Override
        public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getNativesForFlavors(dataFlavorArray);
        }

        @Override
        public Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getFlavorsForNatives(stringArray);
        }
    }
}

