/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.mapping.MappingScorer;
import com.actelion.research.chem.reaction.mapping.ReactionCenterMapper;
import com.actelion.research.chem.reaction.mapping.RootAtomPair;
import com.actelion.research.chem.reaction.mapping.RootAtomPairSource;
import com.actelion.research.util.ByteArrayComparator;
import java.util.Arrays;

public class SimilarityGraphBasedReactionMapper {
    public static final boolean DEBUG = false;
    private static final int SIMILARITY_SHIFT = 8;
    private static final int NO_PI_PENALTY = 1;
    private static final int SKELETON_PENALTY = 2;
    private static final int MAX_ENVIRONMENT_RADIUS = 8;
    private static final int MAX_ENVIRONMENT_SIMILARITY = 2048;
    private static final int MAX_SKELETON_SIMILARITY = 1536;
    private static final int PI_AND_HETERO_PLUS = 1;
    private static final int STEREO_MATCH_PLUS = 64;
    private static final int ENDO_RING_PLUS = 128;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private int mMapNo;
    private int mGraphMapNoCount;
    private int mMappableAtomCount;
    private int mAtomPairSequenceCount;
    private int[] mReactantMapNo;
    private int[] mProductMapNo;
    private int[] mReactantRingMembership;
    private int[] mProductRingMembership;
    private float mScore;
    private ByteArrayComparator mSimilarityComparator;
    private byte[][][][] mReactantConnAtomEnv;
    private byte[][][][] mProductConnAtomEnv;
    private byte[][][][] mReactantNoPiAtomEnv;
    private byte[][][][] mProductNoPiAtomEnv;
    private byte[][][][] mReactantSkelAtomEnv;
    private byte[][][][] mProductSkelAtomEnv;

    public void map(Reaction reaction) {
        this.mergeReactantsAndProducts(reaction);
        this.map(this.mReactant, this.mProduct, new int[this.mReactant.getAtoms()], new int[this.mProduct.getAtoms()]);
        this.copyMapNosToReaction(reaction, this.mReactantMapNo, this.mProductMapNo, this.mGraphMapNoCount);
    }

    public void map(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray, int[] nArray2) {
        this.mReactant = stereoMolecule;
        this.mProduct = stereoMolecule2;
        this.mReactantMapNo = new int[nArray.length];
        this.mProductMapNo = new int[nArray2.length];
        this.mReactantConnAtomEnv = this.classifyNeighbourAtomEnvironment(this.mReactant, false, false);
        this.mReactantNoPiAtomEnv = this.classifyNeighbourAtomEnvironment(this.mReactant, false, true);
        this.mReactantSkelAtomEnv = this.classifyNeighbourAtomEnvironment(this.mReactant, true, false);
        this.mProductConnAtomEnv = this.classifyNeighbourAtomEnvironment(this.mProduct, false, false);
        this.mProductNoPiAtomEnv = this.classifyNeighbourAtomEnvironment(this.mProduct, false, true);
        this.mProductSkelAtomEnv = this.classifyNeighbourAtomEnvironment(this.mProduct, true, false);
        this.initializeRingMembership();
        this.mSimilarityComparator = new ByteArrayComparator();
        this.mScore = -1.0E10f;
        RootAtomPairSource rootAtomPairSource = new RootAtomPairSource(stereoMolecule, stereoMolecule2, this.mReactantMapNo, this.mProductMapNo);
        this.mAtomPairSequenceCount = 0;
        while (rootAtomPairSource.hasNextPairSequence()) {
            int n;
            float f;
            Object object;
            ++this.mAtomPairSequenceCount;
            this.mMapNo = rootAtomPairSource.getManualMapCount();
            this.mMappableAtomCount = rootAtomPairSource.getMappableAtomCount();
            RootAtomPair rootAtomPair = rootAtomPairSource.nextPair();
            while (rootAtomPair != null) {
                this.mapFromRootAtoms(rootAtomPair);
                rootAtomPair = rootAtomPairSource.nextPair();
            }
            this.mGraphMapNoCount = this.mMapNo;
            if (this.mMapNo < this.mMappableAtomCount) {
                object = new ReactionCenterMapper(this.mReactant, this.mProduct, this.mReactantMapNo, this.mProductMapNo, this.mMapNo);
                f = ((ReactionCenterMapper)object).completeAndScoreMapping();
                this.mMapNo += ((ReactionCenterMapper)object).getMappedAtomCount();
            } else {
                object = new MappingScorer(this.mReactant, this.mProduct);
                f = ((MappingScorer)object).scoreMapping(((MappingScorer)object).createReactantToProductAtomMap(this.mReactantMapNo, this.mProductMapNo));
            }
            if (!(this.mScore < f)) continue;
            this.mScore = f;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.mReactantMapNo[n];
            }
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = this.mProductMapNo[n];
            }
        }
    }

    public int getGraphMapNoCount() {
        return this.mGraphMapNoCount;
    }

    public int getAtomPairSequenceCount() {
        return this.mAtomPairSequenceCount;
    }

    public float getScore() {
        return this.mScore;
    }

    private void initializeRingMembership() {
        this.mReactantRingMembership = this.initializeRingMembership(this.mReactant);
        this.mProductRingMembership = this.initializeRingMembership(this.mProduct);
    }

    private int[] initializeRingMembership(StereoMolecule stereoMolecule) {
        int[] nArray = new int[stereoMolecule.getAtoms()];
        RingCollection ringCollection = stereoMolecule.getRingSet();
        for (int i = 0; i < Math.min(32, ringCollection.getSize()); ++i) {
            int[] nArray2;
            int[] nArray3 = nArray2 = ringCollection.getRingAtoms(i);
            int n = nArray3.length;
            for (int j = 0; j < n; ++j) {
                int n2;
                int n3 = n2 = nArray3[j];
                nArray[n3] = nArray[n3] | 1 << i;
            }
        }
        return nArray;
    }

    private boolean leavesRing(int n, int n2, int n3, int[] nArray) {
        return (nArray[n] & nArray[n2] & ~nArray[n3]) != 0;
    }

    private int getAtomSimilarity(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = -1;
        for (n6 = 0; n6 < this.mReactant.getConnAtoms(n2); ++n6) {
            if (this.mReactant.getConnAtom(n2, n6) != n) continue;
            n7 = n6;
            break;
        }
        n6 = -1;
        for (n5 = 0; n5 < this.mProduct.getConnAtoms(n4); ++n5) {
            if (this.mProduct.getConnAtom(n4, n5) != n3) continue;
            n6 = n5;
            break;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            if (this.mSimilarityComparator.compare(this.mReactantConnAtomEnv[n2][n7][n5], this.mProductConnAtomEnv[n4][n6][n5]) == 0) continue;
            return n5 << 8;
        }
        return 2048;
    }

    private int getUnmappedRadius(StereoMolecule stereoMolecule, int n, int n2, int[] nArray) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        blArray[n] = true;
        blArray[n2] = true;
        nArray2[0] = n2;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        for (int i = 2; i < 8; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = 0; k < stereoMolecule.getConnAtoms(nArray2[j]); ++k) {
                    int n6 = stereoMolecule.getConnAtom(nArray2[j], k);
                    if (blArray[n6]) continue;
                    if (nArray[n6] != 0) {
                        return i - 1;
                    }
                    nArray2[n5++] = n6;
                    blArray[n6] = true;
                }
            }
            if (n4 == n5) {
                return 8;
            }
            n3 = n4;
            n4 = n5;
        }
        return 8;
    }

    private int getSkeletonSimilarity(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = -1;
        for (n6 = 0; n6 < this.mReactant.getConnAtoms(n2); ++n6) {
            if (this.mReactant.getConnAtom(n2, n6) != n) continue;
            n7 = n6;
            break;
        }
        n6 = -1;
        for (n5 = 0; n5 < this.mProduct.getConnAtoms(n4); ++n5) {
            if (this.mProduct.getConnAtom(n4, n5) != n3) continue;
            n6 = n5;
            break;
        }
        for (n5 = 2; n5 < 8; ++n5) {
            if (this.mReactantSkelAtomEnv[n2][n7][n5] != null && this.mSimilarityComparator.compare(this.mReactantSkelAtomEnv[n2][n7][n5], this.mProductSkelAtomEnv[n4][n6][n5]) == 0) continue;
            return n5 - 2 << 8;
        }
        return 1536;
    }

    private int getCombinedAtomSimilarity(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = -1;
        for (n6 = 0; n6 < this.mReactant.getConnAtoms(n2); ++n6) {
            if (this.mReactant.getConnAtom(n2, n6) != n) continue;
            n7 = n6;
            break;
        }
        n6 = -1;
        for (n5 = 0; n5 < this.mProduct.getConnAtoms(n4); ++n5) {
            if (this.mProduct.getConnAtom(n4, n5) != n3) continue;
            n6 = n5;
            break;
        }
        for (n5 = 0; n5 < 8 && this.mSimilarityComparator.compare(this.mReactantConnAtomEnv[n2][n7][n5], this.mProductConnAtomEnv[n4][n6][n5]) == 0; ++n5) {
        }
        return n5 << 8;
    }

    private int getPiAndHeteroBondCount(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getAtomPi(n);
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (!stereoMolecule.isElectronegative(stereoMolecule.getConnAtom(n, i))) continue;
            ++n2;
        }
        return n2;
    }

    private byte[][][][] classifyNeighbourAtomEnvironment(StereoMolecule stereoMolecule, boolean bl, boolean bl2) {
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        byte[][][][] byArray = new byte[stereoMolecule.getAtoms()][8][][];
        int[] nArray = new int[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            byArray[i] = new byte[stereoMolecule.getConnAtoms(i)][8][];
            if (bl && stereoMolecule.getAtomicNo(i) != 6) continue;
            for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                int n = stereoMolecule.getConnAtom(i, j);
                if (blArray == null) {
                    blArray = new boolean[stereoMolecule.getAtoms()];
                } else {
                    Arrays.fill(blArray, false);
                }
                int n2 = 1;
                int n3 = 2;
                stereoMolecule.setAtomSelection(n, true);
                for (int k = 0; k < 8 && n3 < stereoMolecule.getAtoms(); ++k) {
                    int n4;
                    if (k == 0) {
                        nArray[0] = n;
                        blArray[n] = true;
                        nArray[1] = i;
                        blArray[i] = true;
                    } else {
                        int n5;
                        n4 = n3;
                        for (n5 = n2; n5 < n3; ++n5) {
                            int n6 = nArray[n5];
                            for (int i2 = 0; i2 < stereoMolecule.getConnAtoms(n6); ++i2) {
                                int n7 = stereoMolecule.getConnAtom(n6, i2);
                                if (blArray[n7] || bl && stereoMolecule.getAtomicNo(n7) != 6) continue;
                                blArray[n7] = true;
                                nArray[n4++] = n7;
                            }
                        }
                        if (n4 == n3) {
                            if (bl) break;
                            for (n5 = k; n5 < 8; ++n5) {
                                byArray[i][j][n5] = byArray[i][j][n5 - 1];
                            }
                            break;
                        }
                        n2 = n3;
                        n3 = n4;
                    }
                    if (k == 0) {
                        byArray[i][j][k] = new byte[2];
                        byArray[i][j][k][0] = (byte)stereoMolecule.getAtomicNo(i);
                        byArray[i][j][k][1] = (byte)stereoMolecule.getAtomMass(i);
                        continue;
                    }
                    stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, nArray2);
                    stereoMolecule2.setAtomCharge(nArray2[n], 0);
                    stereoMolecule2.setAtomRadical(nArray2[n], 0);
                    for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
                        if (nArray2[n4] == -1 || stereoMolecule.getConnAtoms(n4) <= stereoMolecule2.getConnAtoms(nArray2[n4])) continue;
                        stereoMolecule2.setAtomQueryFeature(nArray2[n4], 4096L, true);
                    }
                    if (bl || bl2) {
                        for (n4 = 0; n4 < stereoMolecule2.getBonds(); ++n4) {
                            stereoMolecule2.setBondType(n4, 1);
                        }
                    }
                    byArray[i][j][k] = new Canonizer(stereoMolecule2, 16).getIDCode().getBytes();
                }
                stereoMolecule.setAtomSelection(n, false);
            }
        }
        return byArray;
    }

    public void mergeReactantsAndProducts(Reaction reaction) {
        StereoMolecule stereoMolecule;
        int n;
        this.mReactant = new StereoMolecule();
        for (n = 0; n < reaction.getReactants(); ++n) {
            stereoMolecule = reaction.getReactant(n);
            stereoMolecule.ensureHelperArrays(1);
            this.mReactant.addMolecule(stereoMolecule, stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        }
        this.mProduct = new StereoMolecule();
        for (n = 0; n < reaction.getProducts(); ++n) {
            stereoMolecule = reaction.getProduct(n);
            stereoMolecule.ensureHelperArrays(1);
            this.mProduct.addMolecule(stereoMolecule, stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        }
        this.mReactant.normalizeAmbiguousBonds();
        this.mProduct.normalizeAmbiguousBonds();
    }

    public StereoMolecule getReactant() {
        return this.mReactant;
    }

    public StereoMolecule getProduct() {
        return this.mProduct;
    }

    public void copyMapNosToReaction(Reaction reaction, int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.mReactant.getAtoms(); ++n2) {
            StereoMolecule stereoMolecule = reaction.getReactant(n3);
            stereoMolecule.ensureHelperArrays(1);
            if (n4 == stereoMolecule.getAtoms()) {
                n4 = 0;
                stereoMolecule = reaction.getReactant(++n3);
            }
            stereoMolecule.setAtomMapNo(n4, nArray[n2], nArray[n2] <= n);
            ++n4;
        }
        n2 = 0;
        int n5 = 0;
        for (int i = 0; i < this.mProduct.getAtoms(); ++i) {
            StereoMolecule stereoMolecule = reaction.getProduct(n2);
            stereoMolecule.ensureHelperArrays(1);
            if (n5 == stereoMolecule.getAtoms()) {
                n5 = 0;
                stereoMolecule = reaction.getProduct(++n2);
            }
            stereoMolecule.setAtomMapNo(n5, nArray2[i], nArray2[i] <= n);
            ++n5;
        }
    }

    private int mapFromRootAtoms(RootAtomPair rootAtomPair) {
        int[] nArray = new int[this.mReactant.getAtoms()];
        int[] nArray2 = new int[this.mProduct.getAtoms()];
        int[] nArray3 = new int[this.mReactant.getAtoms()];
        int[] nArray4 = new int[this.mProduct.getAtoms()];
        nArray[0] = rootAtomPair.reactantAtom;
        nArray3[rootAtomPair.reactantAtom] = rootAtomPair.reactantAtom;
        nArray2[0] = rootAtomPair.productAtom;
        nArray4[rootAtomPair.productAtom] = rootAtomPair.productAtom;
        if (this.mReactantMapNo[rootAtomPair.reactantAtom] == 0) {
            this.mReactantMapNo[rootAtomPair.reactantAtom] = ++this.mMapNo;
            this.mProductMapNo[rootAtomPair.productAtom] = this.mMapNo;
        }
        int n = 0;
        block0: for (int i = 0; i <= n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = nArray[i];
            int n10 = nArray2[i];
            int[][] nArray5 = new int[this.mReactant.getConnAtoms(n9)][this.mProduct.getConnAtoms(n10)];
            for (n8 = 0; n8 < this.mReactant.getConnAtoms(n9); ++n8) {
                n7 = this.mReactant.getConnAtom(n9, n8);
                if (this.mReactantMapNo[n7] != 0) continue;
                n6 = this.getBondType(this.mReactant, this.mReactant.getConnBond(n9, n8));
                for (n5 = 0; n5 < this.mProduct.getConnAtoms(n10); ++n5) {
                    n4 = this.mProduct.getConnAtom(n10, n5);
                    if (this.mProductMapNo[n4] != 0 || this.mReactant.getAtomicNo(n7) != this.mProduct.getAtomicNo(n4)) continue;
                    n3 = this.mProduct.getConnBond(n10, n5);
                    n2 = this.getSkeletonSimilarity(n9, n7, n10, n4);
                    if (n6 == this.getBondType(this.mProduct, n3) || n2 != 0) {
                        boolean bl;
                        int n11;
                        int n12;
                        if (!this.passesBasicRules(n9, n7, n10, n4) || (n12 = Math.max(n2, n11 = this.getAtomSimilarity(n9, n7, n10, n4))) == 0 || !this.passesSimilarityDependentRules(n9, n7, n10, n4, n12, bl = this.matchesStereo(nArray3[n9], n9, n7, nArray4[n10], n10, n4))) continue;
                        nArray5[n8][n5] = n12;
                        if (bl) {
                            int[] nArray6 = nArray5[n8];
                            int n13 = n5;
                            nArray6[n13] = nArray6[n13] + 64;
                        }
                        if (this.leavesRing(nArray3[n9], n9, n7, this.mReactantRingMembership) == this.leavesRing(nArray4[n10], n10, n4, this.mProductRingMembership)) {
                            int[] nArray7 = nArray5[n8];
                            int n14 = n5;
                            nArray7[n14] = nArray7[n14] + 128;
                        }
                        if (this.getPiAndHeteroBondCount(this.mReactant, n7) != this.getPiAndHeteroBondCount(this.mProduct, n4)) continue;
                        int[] nArray8 = nArray5[n8];
                        int n15 = n5;
                        nArray8[n15] = nArray8[n15] + 1;
                        continue;
                    }
                    if (this.getAtomSimilarity(n9, n7, n10, n4) != 2048) continue;
                    nArray5[n8][n5] = 768;
                }
            }
            while (true) {
                n8 = 0;
                n7 = -1;
                n6 = -1;
                for (n5 = 0; n5 < nArray5.length; ++n5) {
                    n4 = this.mReactant.getConnAtom(n9, n5);
                    if (this.mReactantMapNo[n4] != 0) continue;
                    for (n3 = 0; n3 < nArray5[n5].length; ++n3) {
                        n2 = this.mProduct.getConnAtom(n10, n3);
                        if (this.mProductMapNo[n2] != 0 || n8 >= nArray5[n5][n3]) continue;
                        n8 = nArray5[n5][n3];
                        n7 = n4;
                        n6 = n2;
                    }
                }
                if (n8 == 0) continue block0;
                nArray[++n] = n7;
                nArray3[n7] = nArray[i];
                nArray2[n] = n6;
                nArray4[n6] = nArray2[i];
                this.mReactantMapNo[n7] = ++this.mMapNo;
                this.mProductMapNo[n6] = this.mMapNo;
            }
        }
        return n + 1;
    }

    private int getBondType(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.isDelocalizedBond(n)) {
            return 0;
        }
        return stereoMolecule.getBondTypeSimple(n);
    }

    private boolean passesBasicRules(int n, int n2, int n3, int n4) {
        if (this.mReactant.getAtomicNo(n2) == 6 && Math.abs(this.mReactant.getConnAtoms(n2) - this.mProduct.getConnAtoms(n4)) > 1) {
            return false;
        }
        if (this.mReactant.getAtomicNo(n2) == 8 && this.mReactant.getConnAtoms(n2) == 2 && this.connAtomsOfAtomicNo(this.mReactant, n, 8) > this.connAtomsOfAtomicNo(this.mProduct, n3, 8)) {
            return false;
        }
        if (this.mProduct.getAtomicNo(n4) == 8 && this.mProduct.getConnAtoms(n4) == 2 && this.connAtomsOfAtomicNo(this.mReactant, n, 8) < this.connAtomsOfAtomicNo(this.mProduct, n3, 8)) {
            return false;
        }
        if (this.mReactant.getAtomicNo(n2) == 8 && this.mReactant.getConnAtoms(n2) == 2 && this.mProduct.getConnAtoms(n4) == 2) {
            int n5;
            int n6 = this.mReactant.getConnAtom(n2, 0) == n ? 0 : 1;
            int n7 = n5 = this.mProduct.getConnAtom(n4, 0) == n3 ? 0 : 1;
            if (this.mSimilarityComparator.compare(this.mReactantSkelAtomEnv[n2][n6][3], this.mProductSkelAtomEnv[n4][n5][3]) != 0) {
                return false;
            }
        }
        if (this.mReactant.getAtomicNo(n2) == 7 && this.connAtomsOfAtomicNo(this.mReactant, n, 7) < this.connAtomsOfAtomicNo(this.mProduct, n3, 7)) {
            return false;
        }
        if (this.mProduct.getAtomicNo(n4) == 7 && this.connAtomsOfAtomicNo(this.mReactant, n, 7) > this.connAtomsOfAtomicNo(this.mProduct, n3, 7)) {
            return false;
        }
        return !(this.mReactant.getBondRingSize(this.mReactant.getBond(n, n2)) == 3 ^ this.mProduct.getBondRingSize(this.mProduct.getBond(n3, n4)) == 3);
    }

    private boolean passesSimilarityDependentRules(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (this.mReactant.getAtomicNo(n2) == 8 && this.mReactant.getAtomPi(n2) == 0 && SimilarityGraphBasedReactionMapper.hasOxo(this.mReactant, n) && SimilarityGraphBasedReactionMapper.hasOxo(this.mProduct, n3) && n5 != 2048) {
            return false;
        }
        if (this.mReactant.getAtomicNo(n2) == 8 && this.mReactant.getConnAtoms(n2) == 2 && SimilarityGraphBasedReactionMapper.hasOxo(this.mReactant, this.getNextNeighbour(this.mReactant, n, n2)) && n5 < 768) {
            return false;
        }
        if (this.mReactant.getAtomicNo(n) == 8 && (SimilarityGraphBasedReactionMapper.hasOxo(this.mReactant, n2) || SimilarityGraphBasedReactionMapper.hasOxo(this.mProduct, n4)) && n5 < 512) {
            return false;
        }
        if (!(bl || this.mReactant.getAtomicNo(n2) == 6 && SimilarityGraphBasedReactionMapper.hasNonCarbonNeighbour(this.mReactant, n))) {
            return false;
        }
        if (this.mReactant.getAtomicNo(n2) == 8 && this.mReactant.getAtomicNo(n) != 6 && n5 != 2048) {
            return false;
        }
        return this.mReactant.getAtomicNo(n) != 5 || this.mReactant.getAtomicNo(n2) != 6 || n5 >= 768;
    }

    private boolean matchesStereo(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!(this.mReactant.getConnAtoms(n2) != 3 || this.mReactant.getAtomParity(n2) != 1 && this.mReactant.getAtomParity(n2) != 2 || this.mProduct.getConnAtoms(n5) != 3 || this.mProduct.getAtomParity(n5) != 1 && this.mProduct.getAtomParity(n5) != 2)) {
            int n7;
            int n8 = n > n3 ? 1 : 0;
            int n9 = -1;
            for (n7 = 0; n7 < this.mReactant.getConnAtoms(n2); ++n7) {
                n9 = this.mReactant.getConnAtom(n2, n7);
                if (n9 == n || n9 == n3) continue;
                if ((n9 <= n3 || n9 >= n) && (n9 >= n3 || n9 <= n)) break;
                n8 = n8 == 0 ? 1 : 0;
                break;
            }
            n7 = n4 > n6 ? 1 : 0;
            for (int i = 0; i < this.mProduct.getConnAtoms(n5); ++i) {
                n9 = this.mProduct.getConnAtom(n5, i);
                if (n9 == n4 || n9 == n6) continue;
                if ((n9 <= n6 || n9 >= n4) && (n9 >= n6 || n9 <= n4)) break;
                n7 = n7 == 0 ? 1 : 0;
                break;
            }
            return n8 == n7 == (this.mReactant.getAtomParity(n2) == this.mProduct.getAtomParity(n5));
        }
        return true;
    }

    public static boolean hasOxo(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getConnBondOrder(n, i) != 2 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) <= 6) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOxo(StereoMolecule stereoMolecule, int n, int n2) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getConnBondOrder(n, i) != 2 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) <= 6 || stereoMolecule.getConnAtom(n, i) == n2) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNonCarbonNeighbour(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) == 6) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNonCarbonNeighbour(StereoMolecule stereoMolecule, int n, int n2) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) == 6 || stereoMolecule.getConnAtom(n, i) == n2) continue;
            return true;
        }
        return false;
    }

    private boolean isOrganicAcid(StereoMolecule stereoMolecule, int n) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n2) == 8 && stereoMolecule.getConnAtoms(n2) == 1 && stereoMolecule.getConnBondOrder(n, i) == 1) {
                bl2 = true;
            }
            if (!stereoMolecule.isElectronegative(n2) || stereoMolecule.getConnBondOrder(n, i) != 2) continue;
            bl = true;
        }
        return bl && bl2;
    }

    private int getNextNeighbour(StereoMolecule stereoMolecule, int n, int n2) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
            int n3 = stereoMolecule.getConnAtom(n2, i);
            if (n3 == n) continue;
            return n3;
        }
        return -1;
    }

    private int connAtomsOfAtomicNo(StereoMolecule stereoMolecule, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if (stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(n, i)) != n2) continue;
            ++n3;
        }
        return n3;
    }
}

