/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;

public class TransformerRule
implements Comparable<TransformerRule> {
    private int mAtom1;
    private int mAtom2;
    private int mMapNo1;
    private int mMapNo2;
    private int mBondQFTypes;
    private int mTargetBondType;
    private int mTargetBondDif;
    private TYPE mType;

    public TransformerRule(StereoMolecule stereoMolecule, int n) {
        this.mAtom1 = stereoMolecule.getBondAtom(0, n);
        this.mAtom2 = stereoMolecule.getBondAtom(1, n);
        int n2 = stereoMolecule.getAtomMapNo(this.mAtom1);
        int n3 = stereoMolecule.getAtomMapNo(this.mAtom2);
        if (n2 < n3) {
            this.mMapNo1 = n2;
            this.mMapNo2 = n3;
        } else {
            this.mMapNo1 = n3;
            this.mMapNo2 = n2;
        }
        this.mBondQFTypes = stereoMolecule.getBondQueryFeatures(n) & 0x1F;
        int n4 = stereoMolecule.getBondTypeSimple(n);
        this.mBondQFTypes = n4 == 32 ? (this.mBondQFTypes |= 0x10) : (n4 == 2 ? (this.mBondQFTypes |= 2) : (n4 == 4 ? (this.mBondQFTypes |= 4) : (this.mBondQFTypes |= 1)));
        this.mType = TYPE.UNKNOWN;
    }

    public int getAtom1() {
        return this.mAtom1;
    }

    public int getAtom2() {
        return this.mAtom2;
    }

    public TYPE getType() {
        return this.mType;
    }

    public boolean equals(Object object) {
        return this.mMapNo1 == ((TransformerRule)object).mMapNo1 && this.mMapNo2 == ((TransformerRule)object).mMapNo2;
    }

    @Override
    public int compareTo(TransformerRule transformerRule) {
        if (this.mMapNo1 != transformerRule.mMapNo1) {
            return this.mMapNo1 < transformerRule.mMapNo1 ? -1 : 1;
        }
        if (this.mMapNo2 != transformerRule.mMapNo2) {
            return this.mMapNo2 < transformerRule.mMapNo2 ? -1 : 1;
        }
        return 0;
    }

    public boolean isNoChange() {
        return this.mType == TYPE.NO_CHANGE;
    }

    public boolean isFinished() {
        return this.mType != TYPE.UNKNOWN;
    }

    public void finishWithProduct(TransformerRule transformerRule) {
        if (this.mBondQFTypes == transformerRule.mBondQFTypes) {
            this.mType = TYPE.NO_CHANGE;
        } else if (Integer.bitCount(transformerRule.mBondQFTypes) == 1) {
            this.mTargetBondType = transformerRule.mBondQFTypes == 1 ? 1 : (transformerRule.mBondQFTypes == 2 ? 386 : (transformerRule.mBondQFTypes == 4 ? 4 : (transformerRule.mBondQFTypes == 16 ? 32 : 64)));
            this.mType = TYPE.CHANGE_ABS;
        } else {
            int n;
            int n2;
            int n3 = (this.mBondQFTypes & 0x10) != 0 ? 0 : ((this.mBondQFTypes & 1) != 0 ? 1 : (n2 = (this.mBondQFTypes & 2) != 0 ? 2 : 3));
            int n4 = (transformerRule.mBondQFTypes & 0x10) != 0 ? 0 : ((transformerRule.mBondQFTypes & 1) != 0 ? 1 : (n = (transformerRule.mBondQFTypes & 2) != 0 ? 2 : 3));
            if (n == n2) {
                this.mType = TYPE.NO_CHANGE;
            } else {
                this.mTargetBondDif = n - n2;
                this.mType = TYPE.CHANGE_DIF;
            }
        }
    }

    public void finishProductOnly() {
        this.mType = TYPE.CREATE;
    }

    public void finishNoProduct() {
        this.mType = TYPE.REMOVE;
    }

    public boolean adaptBondOrder(StereoMolecule stereoMolecule, int[] nArray) {
        int n = nArray[this.mAtom1];
        int n2 = nArray[this.mAtom2];
        if (this.mType == TYPE.CREATE) {
            stereoMolecule.addBond(n, n2, this.mTargetBondType);
            return true;
        }
        int n3 = stereoMolecule.getBond(n, n2);
        if (this.mType == TYPE.CHANGE_ABS) {
            stereoMolecule.setBondType(n3, this.mTargetBondType);
            return true;
        }
        if (this.mType == TYPE.CHANGE_DIF) {
            int n4 = stereoMolecule.getBondOrder(n3) + this.mTargetBondDif;
            if (n4 >= 0 && n4 <= 3) {
                stereoMolecule.setBondType(n3, Molecule.bondOrderToType(n4, true));
                return true;
            }
        } else if (this.mType == TYPE.REMOVE) {
            stereoMolecule.markBondForDeletion(n3);
            return true;
        }
        return false;
    }

    public int addBondCode(StereoMolecule stereoMolecule, int[] nArray, boolean[] blArray) {
        int n = nArray[this.mAtom1];
        int n2 = nArray[this.mAtom2];
        if (this.mType == TYPE.CREATE) {
            return TransformerRule.getBondCode(n, n2, Molecule.bondTypeToOrder(this.mTargetBondType));
        }
        int n3 = stereoMolecule.getBond(n, n2);
        if (this.mType == TYPE.CHANGE_ABS) {
            blArray[n3] = true;
            return TransformerRule.getBondCode(n, n2, Molecule.bondTypeToOrder(this.mTargetBondType));
        }
        if (this.mType == TYPE.CHANGE_DIF) {
            int n4 = stereoMolecule.getBondOrder(n3) + this.mTargetBondDif;
            if (n4 >= 0 && n4 <= 3) {
                blArray[n3] = true;
                return TransformerRule.getBondCode(n, n2, n4);
            }
            return -1;
        }
        if (this.mType == TYPE.REMOVE) {
            blArray[n3] = true;
            return -1;
        }
        return -1;
    }

    public static int getBondCode(int n, int n2, int n3) {
        return n < n2 ? (n << 17) + (n2 << 2) + n3 : (n2 << 17) + (n << 2) + n3;
    }

    public static enum TYPE {
        CREATE,
        CHANGE_DIF,
        CHANGE_ABS,
        REMOVE,
        NO_CHANGE,
        UNKNOWN;

    }
}

