/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.calc.ProgressController;
import com.actelion.research.chem.CanonizerUtil;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.StructureSearchController;
import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.chem.descriptor.DescriptorHandlerReactionFP;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.chem.reaction.ReactionSearchDataSource;
import com.actelion.research.chem.reaction.ReactionSearchSpecification;
import com.actelion.research.chem.reaction.SRSearcher;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ReactionSearch {
    private static final boolean MULTITHREADED_SEARCH = true;
    private volatile ReactionSearchSpecification mSpecification;
    private volatile ReactionSearchDataSource mDataSource;
    private volatile StructureSearchController mSearchController;
    private volatile ProgressController mProgressController;
    private volatile Reaction[] mQueryReaction;
    private volatile StereoMolecule[] mQueryReactant;
    private volatile StereoMolecule[] mQueryProduct;
    private volatile StereoMolecule[] mQueryRetron;
    private volatile long[] mQueryHash;
    private volatile DescriptorHandlerLongFFP512 mDescriptorHandlerFFP512;
    private volatile DescriptorHandlerReactionFP mDescriptorHandlerRxnFP;
    private volatile long[][] mQueryReactionDescriptor;
    private volatile long[][] mQueryReactantDescriptor;
    private volatile long[][] mQueryProductDescriptor;
    private volatile long[][] mQueryRetronDescriptor;
    private volatile int mMaxSSSMatches;
    private volatile int mMaxNonSSSMatches;
    private ConcurrentLinkedQueue<Integer> mResultQueue;
    private AtomicInteger mSMPIndex;
    private AtomicInteger mMatchCount;

    public ReactionSearch(ReactionSearchSpecification reactionSearchSpecification, ReactionSearchDataSource reactionSearchDataSource, StructureSearchController structureSearchController, ProgressController progressController) {
        this.mSpecification = reactionSearchSpecification;
        this.mDataSource = reactionSearchDataSource;
        this.mSearchController = structureSearchController;
        this.mProgressController = progressController;
        if (this.mSpecification != null) {
            if (this.mSpecification.isSimilaritySearch()) {
                this.mDescriptorHandlerRxnFP = DescriptorHandlerReactionFP.getDefaultInstance();
            } else if (this.mSpecification.isSubreactionSearch() || this.mSpecification.isRetronSearch()) {
                this.mDescriptorHandlerFFP512 = DescriptorHandlerLongFFP512.getDefaultInstance();
            }
        }
    }

    public void setMatchLimit(int n, int n2) {
        this.mMaxSSSMatches = n;
        this.mMaxNonSSSMatches = n2;
    }

    public int[] start() {
        int n;
        int n2;
        if (!this.mDataSource.isSupportedSearchType(this.mSpecification)) {
            return null;
        }
        this.mMatchCount = new AtomicInteger(0);
        if (!this.mSpecification.isNoReactionSearch()) {
            int n3;
            n2 = this.mSpecification.getReactionCount();
            if (n2 == 0) {
                return null;
            }
            if (this.mSpecification.isSubreactionSearch() || this.mSpecification.isSimilaritySearch()) {
                this.mQueryReaction = new Reaction[n2];
                this.mQueryReactant = new StereoMolecule[n2];
                this.mQueryProduct = new StereoMolecule[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.mQueryReactant[n3] = this.mergeMolecules(ReactionEncoder.decodeMolecules(this.mSpecification.getEncodedQuery(n3), true, true, true, false));
                    this.mQueryReactant[n3].ensureHelperArrays(15);
                    this.mQueryProduct[n3] = this.mergeMolecules(ReactionEncoder.decodeMolecules(this.mSpecification.getEncodedQuery(n3), true, true, false, true));
                    this.mQueryProduct[n3].ensureHelperArrays(15);
                    this.mQueryReaction[n3] = new Reaction();
                    this.mQueryReaction[n3].addReactant(this.mQueryReactant[n3]);
                    this.mQueryReaction[n3].addProduct(this.mQueryProduct[n3]);
                }
                if (this.mSpecification.isSubreactionSearch()) {
                    this.ensureMoleculeDescriptors();
                } else {
                    this.ensureReactionDescriptors();
                }
            } else if (this.mSpecification.isRetronSearch()) {
                this.mQueryRetron = new StereoMolecule[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.mQueryRetron[n3] = new IDCodeParser(false).getCompactMolecule(this.mSpecification.getEncodedQuery(n3));
                    this.mQueryRetron[n3].ensureHelperArrays(15);
                }
                this.ensureRetronDescriptors();
            } else if (this.mSpecification.isExactSearch()) {
                this.mQueryHash = new long[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    String[] object;
                    n = this.mSpecification.getEncodedQuery(n3).indexOf(35);
                    if (n <= 0) continue;
                    for (String string : object = this.mSpecification.getEncodedQuery(n3).substring(0, n).split(" ")) {
                        int n4 = n3;
                        this.mQueryHash[n4] = this.mQueryHash[n4] + CanonizerUtil.StrongHasher.hash(string);
                    }
                }
            } else if (this.mSpecification.isNoStereoSearch()) {
                this.mQueryHash = new long[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    String[] interruptedException;
                    n = this.mSpecification.getEncodedQuery(n3).indexOf(35);
                    if (n <= 0) continue;
                    for (String string : interruptedException = this.mSpecification.getEncodedQuery(n3).substring(0, n).split(" ")) {
                        int n5 = n3;
                        this.mQueryHash[n5] = this.mQueryHash[n5] + CanonizerUtil.getNoStereoHash(new IDCodeParser(false).getCompactMolecule(string), false);
                    }
                }
            }
        }
        this.mSMPIndex = new AtomicInteger(this.mDataSource.getRowCount());
        this.mResultQueue = new ConcurrentLinkedQueue();
        if (this.mProgressController != null && this.mSpecification.getReactionCount() > 1023) {
            this.mProgressController.startProgress("Searching structures", 0, this.mSpecification.getReactionCount());
        }
        n2 = Runtime.getRuntime().availableProcessors();
        SearchThread[] searchThreadArray = new SearchThread[n2];
        for (n = 0; n < n2; ++n) {
            searchThreadArray[n] = new SearchThread("Structure Search " + (n + 1));
            searchThreadArray[n].setPriority(1);
            searchThreadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            try {
                searchThreadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int[] nArray = new int[this.mResultQueue.size()];
        int n6 = 0;
        for (Integer n7 : this.mResultQueue) {
            nArray[n6++] = n7;
        }
        return nArray;
    }

    private void ensureMoleculeDescriptors() {
        int n;
        int n2;
        int n3 = this.mSpecification.getReactionCount();
        this.mQueryReactantDescriptor = new long[n3][];
        this.mQueryProductDescriptor = new long[n3][];
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            this.mQueryReactantDescriptor[n2] = this.mSpecification.getReactantDescriptor(n2);
            if (this.mQueryReactantDescriptor[n2] == null) {
                bl = true;
            }
            this.mQueryProductDescriptor[n2] = this.mSpecification.getProductDescriptor(n2);
            if (this.mQueryProductDescriptor[n2] != null) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.mSMPIndex = new AtomicInteger(this.mQueryReactantDescriptor.length);
        n2 = Math.min(n3, Runtime.getRuntime().availableProcessors());
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            threadArray[n] = new Thread("Query Molecule Descriptor Calculation " + (n + 1)){

                @Override
                public void run() {
                    int n;
                    while ((n = ReactionSearch.this.mSMPIndex.decrementAndGet()) >= 0) {
                        if (ReactionSearch.this.mQueryReactantDescriptor[n] == null) {
                            ((ReactionSearch)ReactionSearch.this).mQueryReactantDescriptor[n] = ReactionSearch.this.mDescriptorHandlerFFP512.createDescriptor(ReactionSearch.this.mQueryReactant[n]);
                        }
                        if (ReactionSearch.this.mQueryProductDescriptor[n] != null) continue;
                        ((ReactionSearch)ReactionSearch.this).mQueryProductDescriptor[n] = ReactionSearch.this.mDescriptorHandlerFFP512.createDescriptor(ReactionSearch.this.mQueryProduct[n]);
                    }
                }
            };
            threadArray[n].setPriority(1);
            threadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void ensureRetronDescriptors() {
        int n;
        int n2;
        int n3 = this.mSpecification.getReactionCount();
        this.mQueryRetronDescriptor = new long[n3][];
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            this.mQueryRetronDescriptor[n2] = this.mSpecification.getRetronDescriptor(n2);
            if (this.mQueryRetronDescriptor[n2] != null) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.mSMPIndex = new AtomicInteger(n3);
        n2 = Math.min(n3, Runtime.getRuntime().availableProcessors());
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            threadArray[n] = new Thread("Query Retron Descriptor Calculation " + (n + 1)){

                @Override
                public void run() {
                    int n;
                    while ((n = ReactionSearch.this.mSMPIndex.decrementAndGet()) >= 0) {
                        if (ReactionSearch.this.mQueryRetronDescriptor[n] != null) continue;
                        ((ReactionSearch)ReactionSearch.this).mQueryRetronDescriptor[n] = ReactionSearch.this.mDescriptorHandlerFFP512.createDescriptor(ReactionSearch.this.mQueryRetron[n]);
                    }
                }
            };
            threadArray[n].setPriority(1);
            threadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void ensureReactionDescriptors() {
        int n;
        int n2 = this.mSpecification.getReactionCount();
        this.mQueryReactionDescriptor = new long[n2][];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            this.mQueryReactionDescriptor[n] = this.mSpecification.getReactionDescriptor(n);
            if (this.mQueryReactionDescriptor[n] != null) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (n2 > 1) {
            int n3;
            this.mSMPIndex = new AtomicInteger(this.mQueryReactionDescriptor.length);
            n = Math.min(n2, Runtime.getRuntime().availableProcessors());
            Thread[] threadArray = new Thread[n];
            for (n3 = 0; n3 < n; ++n3) {
                threadArray[n3] = new Thread("Query Reaction Descriptor Calculation " + (n3 + 1)){

                    @Override
                    public void run() {
                        int n;
                        while ((n = ReactionSearch.this.mSMPIndex.decrementAndGet()) >= 0) {
                            if (ReactionSearch.this.mQueryReactionDescriptor[n] != null) continue;
                            ((ReactionSearch)ReactionSearch.this).mQueryReactionDescriptor[n] = ReactionSearch.this.mDescriptorHandlerRxnFP.createDescriptor(ReactionSearch.this.mQueryReaction[n]);
                        }
                    }
                };
                threadArray[n3].setPriority(1);
                threadArray[n3].start();
            }
            for (n3 = 0; n3 < n; ++n3) {
                try {
                    threadArray[n3].join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else {
            for (n = 0; n < this.mQueryReactionDescriptor.length; ++n) {
                this.mQueryReactionDescriptor[n] = this.mDescriptorHandlerRxnFP.createDescriptor(this.mQueryReaction[n]);
            }
        }
    }

    private StereoMolecule mergeMolecules(StereoMolecule[] stereoMoleculeArray) {
        if (stereoMoleculeArray == null) {
            return null;
        }
        if (stereoMoleculeArray.length > 1) {
            stereoMoleculeArray[0] = new StereoMolecule(stereoMoleculeArray[0]);
            for (int i = 1; i < stereoMoleculeArray.length; ++i) {
                stereoMoleculeArray[0].addMolecule(stereoMoleculeArray[i]);
            }
        }
        return stereoMoleculeArray[0];
    }

    private int countEquivalentMatches(StereoMolecule stereoMolecule, ArrayList<int[]> arrayList) {
        int n = 0;
        TreeSet<int[]> treeSet = new TreeSet<int[]>(new IntArrayComparator());
        for (int[] nArray : arrayList) {
            int[] nArray2 = new int[nArray.length];
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray2[i] = nArray[i] == -1 ? -1 : stereoMolecule.getAtomMapNo(nArray[i]);
                if (nArray2[i] != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Arrays.sort(nArray2);
            if (treeSet.contains(nArray2)) {
                ++n;
                continue;
            }
            treeSet.add(nArray2);
        }
        return n;
    }

    private class SearchThread
    extends Thread {
        private SRSearcher mSRSearcher;
        private SSSearcherWithIndex mReactantSearcher;
        private SSSearcherWithIndex mProductSearcher;

        public SearchThread(String string) {
            super(string);
            if (ReactionSearch.this.mSpecification.isSubreactionSearch()) {
                this.mSRSearcher = new SRSearcher();
            } else if (ReactionSearch.this.mSpecification.isRetronSearch()) {
                this.mReactantSearcher = new SSSearcherWithIndex();
                this.mProductSearcher = new SSSearcherWithIndex();
            }
        }

        @Override
        public void run() {
            int n = ReactionSearch.this.mSMPIndex.decrementAndGet();
            while (!(n < 0 || ReactionSearch.this.mProgressController != null && ReactionSearch.this.mProgressController.threadMustDie())) {
                if (ReactionSearch.this.mProgressController != null && n % 1024 == 1023) {
                    ReactionSearch.this.mProgressController.updateProgress(ReactionSearch.this.mSpecification.getReactionCount() - n);
                }
                if (ReactionSearch.this.mSearchController == null || ReactionSearch.this.mSearchController.rowQualifies(n)) {
                    boolean bl = false;
                    if (ReactionSearch.this.mSpecification.isSubreactionSearch() || ReactionSearch.this.mSpecification.isRetronSearch()) {
                        long[] lArray;
                        if (ReactionSearch.this.mMaxSSSMatches != 0 && ReactionSearch.this.mMatchCount.get() > ReactionSearch.this.mMaxSSSMatches) break;
                        if (ReactionSearch.this.mSpecification.isSubreactionSearch()) {
                            long[] lArray2 = ReactionSearch.this.mDataSource.getMergedReactantDescriptor(n);
                            lArray = ReactionSearch.this.mDataSource.getMergedProductDescriptor(n);
                            this.mSRSearcher.setReaction(ReactionSearch.this.mDataSource.getReactionCode(n), ReactionSearch.this.mDataSource.getMapping(n), ReactionSearch.this.mDataSource.getCoordinates(n), lArray2, lArray);
                            for (int i = 0; i < ReactionSearch.this.mQueryReaction.length; ++i) {
                                this.mSRSearcher.setQuery(ReactionSearch.this.mQueryReaction[i], ReactionSearch.this.mQueryReactantDescriptor[i], ReactionSearch.this.mQueryProductDescriptor[i]);
                                if (!this.mSRSearcher.isQueryInReaction()) continue;
                                bl = true;
                                break;
                            }
                        } else {
                            for (int i = 0; i < ReactionSearch.this.mQueryRetron.length; ++i) {
                                if (ReactionSearch.this.mDescriptorHandlerFFP512.calculationFailed(ReactionSearch.this.mQueryRetronDescriptor[i])) continue;
                                lArray = ReactionSearch.this.mDataSource.getMergedProductDescriptor(n);
                                this.mProductSearcher.setFragment(ReactionSearch.this.mQueryRetron[i], ReactionSearch.this.mQueryRetronDescriptor[i]);
                                this.mProductSearcher.setMolecule((StereoMolecule)null, lArray);
                                if (!this.mProductSearcher.isFragmentIndexInMoleculeIndex()) continue;
                                StereoMolecule stereoMolecule = ReactionSearch.this.mergeMolecules(ReactionEncoder.decodeMolecules(ReactionSearch.this.mDataSource.getReactionCode(n), ReactionSearch.this.mDataSource.getCoordinates(n), ReactionSearch.this.mDataSource.getMapping(n), false, true));
                                this.mProductSearcher.setMolecule(stereoMolecule, lArray);
                                int n2 = this.mProductSearcher.findFragmentInMoleculeWithoutIndex(3);
                                if (n2 == 0) continue;
                                long[] lArray3 = ReactionSearch.this.mDataSource.getMergedReactantDescriptor(n);
                                this.mReactantSearcher.setFragment(ReactionSearch.this.mQueryRetron[i], ReactionSearch.this.mQueryRetronDescriptor[i]);
                                this.mReactantSearcher.setMolecule((StereoMolecule)null, lArray3);
                                int n3 = 0;
                                if (this.mReactantSearcher.isFragmentIndexInMoleculeIndex()) {
                                    StereoMolecule stereoMolecule2 = ReactionSearch.this.mergeMolecules(ReactionEncoder.decodeMolecules(ReactionSearch.this.mDataSource.getReactionCode(n), ReactionSearch.this.mDataSource.getCoordinates(n), ReactionSearch.this.mDataSource.getMapping(n), true, false));
                                    this.mReactantSearcher.setMolecule(stereoMolecule2, lArray3);
                                    n3 = this.mReactantSearcher.findFragmentInMoleculeWithoutIndex(3);
                                    if (n3 != 0 && ReactionSearch.this.mDataSource.getMapping(n) != null && (n2 -= ReactionSearch.this.countEquivalentMatches(stereoMolecule, this.mProductSearcher.getGraphMatcher().getMatchList())) <= n3) {
                                        n3 -= ReactionSearch.this.countEquivalentMatches(stereoMolecule2, this.mReactantSearcher.getGraphMatcher().getMatchList());
                                    }
                                }
                                if (n2 <= n3) continue;
                                bl = true;
                                break;
                            }
                        }
                    } else {
                        if (ReactionSearch.this.mMaxNonSSSMatches != 0 && ReactionSearch.this.mMatchCount.get() > ReactionSearch.this.mMaxNonSSSMatches) break;
                        if (ReactionSearch.this.mSpecification.isNoReactionSearch()) {
                            bl = true;
                        } else if (ReactionSearch.this.mSpecification.isSimilaritySearch()) {
                            for (int i = 0; i < ReactionSearch.this.mQueryReactionDescriptor.length; ++i) {
                                if (!(ReactionSearch.this.mDescriptorHandlerRxnFP.getReactionCenterSimilarity(ReactionSearch.this.mQueryReactionDescriptor[i], ReactionSearch.this.mDataSource.getReactionDescriptor(n)) >= ReactionSearch.this.mSpecification.getReactionCenterSimilarity()) || !(ReactionSearch.this.mDescriptorHandlerRxnFP.getPeripherySimilarity(ReactionSearch.this.mQueryReactionDescriptor[i], ReactionSearch.this.mDataSource.getReactionDescriptor(n)) >= ReactionSearch.this.mSpecification.getPeripherySimilarity())) continue;
                                bl = true;
                                break;
                            }
                        } else if (ReactionSearch.this.mSpecification.isExactSearch()) {
                            for (int i = 0; i < ReactionSearch.this.mQueryHash.length; ++i) {
                                if (ReactionSearch.this.mQueryHash[i] != ReactionSearch.this.mDataSource.getExactHash(n)) continue;
                                bl = true;
                                break;
                            }
                        } else if (ReactionSearch.this.mSpecification.isNoStereoSearch()) {
                            for (int i = 0; i < ReactionSearch.this.mQueryHash.length; ++i) {
                                if (ReactionSearch.this.mQueryHash[i] != ReactionSearch.this.mDataSource.getNoStereoHash(n)) continue;
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (bl) {
                        ReactionSearch.this.mResultQueue.add(new Integer(n));
                        ReactionSearch.this.mMatchCount.incrementAndGet();
                    }
                }
                n = ReactionSearch.this.mSMPIndex.decrementAndGet();
            }
        }
    }
}

