/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.ArrayUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class ReactionEncoder {
    public static final char MOLECULE_DELIMITER = ' ';
    public static final char PRODUCT_IDENTIFIER = '!';
    public static final char CATALYST_DELIMITER = '+';
    public static final char OBJECT_DELIMITER = '#';
    public static final String MOLECULE_DELIMITER_STRING = " ";
    public static final String OBJECT_DELIMITER_STRING = "#";
    public static final int INCLUDE_MAPPING = 1;
    public static final int INCLUDE_COORDS = 2;
    public static final int INCLUDE_DRAWING_OBJECTS = 4;
    public static final int INCLUDE_CATALYSTS = 8;
    public static final int INCLUDE_ALL = 15;
    public static final int INCLUDE_RXN_CODE_ONLY = 0;
    public static final int INCLUDE_DEFAULT = 3;
    public static final int RETAIN_REACTANT_AND_PRODUCT_ORDER = 16;

    private ReactionEncoder() {
    }

    public static String[] encode(Reaction reaction, boolean bl) {
        return ReactionEncoder.encode(reaction, bl, true);
    }

    private static String[] encode(Reaction reaction, boolean bl, boolean bl2) {
        int n;
        String string;
        int n2;
        int n3;
        Object object;
        Serializable serializable;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            return null;
        }
        String[] stringArray = new String[reaction.getMolecules()];
        String[] stringArray2 = new String[reaction.getMolecules()];
        String[] stringArray3 = new String[reaction.getMolecules()];
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            serializable = reaction.getMolecule(i);
            if (((Molecule)serializable).isFragment() && i < reaction.getReactants()) {
                for (int j = 0; j < ((Molecule)serializable).getAllAtoms(); ++j) {
                    ((Molecule)serializable).setAtomQueryFeature(j, 0xC0000000L, false);
                }
            }
            object = new Canonizer((StereoMolecule)serializable);
            stringArray[i] = ((Canonizer)object).getIDCode();
            if (stringArray[i] == null) {
                return null;
            }
            stringArray2[i] = ((Canonizer)object).getEncodedMapping();
            stringArray3[i] = ((Canonizer)object).getEncodedCoordinates(bl);
        }
        StringBuilder stringBuilder = new StringBuilder();
        serializable = new StringBuilder();
        object = new StringBuilder();
        for (n3 = 0; n3 < reaction.getReactants(); ++n3) {
            n2 = n3;
            if (bl2) {
                string = "";
                n2 = -1;
                for (n = 0; n < reaction.getReactants(); ++n) {
                    if (string.compareTo(stringArray[n]) >= 0) continue;
                    string = stringArray[n];
                    n2 = n;
                }
            }
            if (n3 > 0) {
                stringBuilder.append(' ');
                ((StringBuilder)object).append(' ');
                ((StringBuilder)serializable).append(' ');
            }
            stringBuilder.append(stringArray[n2]);
            ((StringBuilder)object).append(stringArray2[n2]);
            ((StringBuilder)serializable).append(stringArray3[n2]);
            stringArray[n2] = "";
        }
        stringBuilder.append('!');
        ((StringBuilder)object).append(' ');
        ((StringBuilder)serializable).append(' ');
        for (n3 = reaction.getReactants(); n3 < reaction.getMolecules(); ++n3) {
            n2 = n3;
            if (bl2) {
                string = "";
                n2 = -1;
                for (n = reaction.getReactants(); n < reaction.getMolecules(); ++n) {
                    if (string.compareTo(stringArray[n]) >= 0) continue;
                    string = stringArray[n];
                    n2 = n;
                }
            }
            if (n3 > reaction.getReactants()) {
                stringBuilder.append(' ');
                ((StringBuilder)object).append(' ');
                ((StringBuilder)serializable).append(' ');
            }
            stringBuilder.append(stringArray[n2]);
            ((StringBuilder)object).append(stringArray2[n2]);
            ((StringBuilder)serializable).append(stringArray3[n2]);
            stringArray[n2] = "";
        }
        String[] stringArray4 = new String[5];
        stringArray4[0] = stringBuilder.toString();
        if (((StringBuilder)object).length() > reaction.getMolecules() - 1) {
            stringArray4[1] = ((StringBuilder)object).toString();
        }
        if (((StringBuilder)serializable).length() > reaction.getMolecules() - 1) {
            stringArray4[2] = ((StringBuilder)serializable).toString();
        }
        if (reaction.getDrawingObjects() != null) {
            stringArray4[3] = reaction.getDrawingObjects().toString();
        }
        if (reaction.getCatalysts() != 0) {
            stringArray4[4] = ReactionEncoder.encodeCatalysts(reaction, bl);
        }
        return stringArray4;
    }

    private static String encodeCatalysts(Reaction reaction, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < reaction.getCatalysts(); ++i) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('+');
            }
            Canonizer canonizer = new Canonizer(reaction.getCatalyst(i));
            stringBuilder.append(canonizer.getIDCode());
            if (!bl) continue;
            stringBuilder.append(MOLECULE_DELIMITER_STRING);
            stringBuilder.append(canonizer.getEncodedCoordinates(true));
        }
        return stringBuilder.toString();
    }

    public static String encode(Reaction reaction, boolean bl, int n) {
        String[] stringArray = ReactionEncoder.encode(reaction, bl, (n & 0x10) == 0);
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        if (n != 0) {
            stringBuffer.append('#');
            if ((n & 1) != 0 && stringArray.length > 1 && stringArray[1] != null) {
                stringBuffer.append(stringArray[1]);
            }
        }
        if ((n &= 0xFFFFFFFE) != 0) {
            stringBuffer.append('#');
            if ((n & 2) != 0 && stringArray.length > 2 && stringArray[2] != null) {
                stringBuffer.append(stringArray[2]);
            }
        }
        if ((n &= 0xFFFFFFFD) != 0) {
            stringBuffer.append('#');
            if ((n & 4) != 0 && stringArray.length > 3 && stringArray[3] != null) {
                stringBuffer.append(stringArray[3]);
            }
        }
        if ((n &= 0xFFFFFFFB) != 0) {
            stringBuffer.append('#');
            if ((n & 8) != 0 && stringArray.length > 4 && stringArray[4] != null) {
                stringBuffer.append(stringArray[4]);
            }
        }
        return stringBuffer.toString();
    }

    public static Reaction decode(String string, String string2, String string3, String string4, String string5, boolean bl, Reaction reaction) {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(33);
        if (n4 == -1) {
            return null;
        }
        if (reaction == null) {
            reaction = new Reaction();
        } else {
            reaction.clear();
        }
        while (n != -1) {
            if (n > n4) {
                bl2 = true;
            }
            int n5 = string.indexOf(32, n);
            if (!(bl2 || n5 <= n4 && n5 != -1)) {
                n5 = n4;
            }
            String string6 = null;
            if (n5 == -1) {
                string6 = string.substring(n);
                n = -1;
            } else {
                string6 = string.substring(n, n5);
                n = n5 + 1;
            }
            String string7 = null;
            if (string2 != null && string2.length() != 0) {
                n5 = string2.indexOf(32, n2);
                if (n5 == -1) {
                    string7 = string2.substring(n2);
                } else {
                    string7 = string2.substring(n2, n5);
                    n2 = n5 + 1;
                }
            }
            String string8 = null;
            if (string3 != null && string3.length() != 0) {
                n5 = string3.indexOf(32, n3);
                if (n5 == -1) {
                    string8 = string3.substring(n3);
                } else {
                    string8 = string3.substring(n3, n5);
                    n3 = n5 + 1;
                }
            }
            IDCodeParser iDCodeParser = new IDCodeParser(bl);
            StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string6, string8);
            if (string7 != null) {
                iDCodeParser.parseMapping(string7.getBytes());
            }
            if (bl2) {
                reaction.addProduct(stereoMolecule);
                continue;
            }
            reaction.addReactant(stereoMolecule);
        }
        if (string4 != null && string4.length() != 0) {
            reaction.setDrawingObjects(new DrawingObjectList(string4));
        }
        if (string5 != null && string5.length() != 0) {
            IDCodeParser iDCodeParser = new IDCodeParser(bl);
            int n6 = 0;
            int n7 = string5.indexOf(43);
            while (n7 != -1) {
                reaction.addCatalyst(iDCodeParser.getCompactMolecule(string5.substring(n6, n7)));
                n6 = n7 + 1;
                n7 = string5.indexOf(43, n6);
            }
            reaction.addCatalyst(iDCodeParser.getCompactMolecule(string5.substring(n6)));
        }
        return reaction;
    }

    public static Reaction decode(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, byte[] byArray4, boolean bl) {
        int n;
        int n2;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = ReactionEncoder.indexOf(byArray, '!');
        if (n6 == -1) {
            return null;
        }
        Reaction reaction = new Reaction();
        while (n3 != -1) {
            if (n3 > n6) {
                bl2 = true;
            }
            int n7 = ReactionEncoder.indexOf(byArray, ' ', n3);
            if (!(bl2 || n7 <= n6 && n7 != -1)) {
                n7 = n6;
            }
            n2 = n3;
            n3 = n7 == -1 ? -1 : n7 + 1;
            n = -1;
            if (byArray2 != null && n4 < byArray2.length) {
                n = byArray2[n4] == 32 ? -1 : n4;
                n7 = ReactionEncoder.indexOf(byArray2, ' ', n4);
                if (n7 != -1) {
                    n4 = n7 + 1;
                }
            }
            int n8 = -1;
            if (byArray3 != null && byArray3.length != 0) {
                n8 = n5;
                n7 = ReactionEncoder.indexOf(byArray3, ' ', n5);
                if (n7 != -1) {
                    n5 = n7 + 1;
                }
            }
            IDCodeParser iDCodeParser = new IDCodeParser(bl);
            iDCodeParser.neglectSpaceDelimitedCoordinates();
            StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(byArray, byArray3, n2, n8);
            if (n != -1) {
                iDCodeParser.parseMapping(byArray2, n);
            }
            if (bl2) {
                reaction.addProduct(stereoMolecule);
                continue;
            }
            reaction.addReactant(stereoMolecule);
        }
        if (string != null && string.length() != 0) {
            reaction.setDrawingObjects(new DrawingObjectList(string));
        }
        if (byArray4 != null && byArray4.length != 0) {
            IDCodeParser iDCodeParser = new IDCodeParser(bl);
            n2 = 0;
            n = ReactionEncoder.indexOf(byArray4, '+');
            while (n != -1) {
                reaction.addCatalyst(iDCodeParser.getCompactMolecule(byArray4, n2));
                n2 = n + 1;
                n = ReactionEncoder.indexOf(byArray4, '+', n2);
            }
            reaction.addCatalyst(iDCodeParser.getCompactMolecule(byArray4, n2));
        }
        return reaction;
    }

    private static int indexOf(byte[] byArray, char c) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(byte[] byArray, char c, int n) {
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static Reaction decode(String string, boolean bl) {
        return ReactionEncoder.decode(string, bl, null);
    }

    public static Reaction decode(String string, boolean bl, Reaction reaction) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = string.indexOf(35);
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            int n2 = string.indexOf(35, n + 1);
            if (n2 == -1) {
                string3 = string.substring(n + 1);
            } else {
                string3 = string.substring(n + 1, n2);
                int n3 = string.indexOf(35, n2 + 1);
                if (n3 == -1) {
                    string4 = string.substring(n2 + 1);
                } else {
                    string4 = string.substring(n2 + 1, n3);
                    int n4 = string.indexOf(35, n3 + 1);
                    if (n4 == -1) {
                        string5 = string.substring(n3 + 1);
                    } else {
                        string5 = string.substring(n3 + 1, n4);
                        string6 = string.substring(n4 + 1);
                    }
                }
            }
        }
        return ReactionEncoder.decode(string2, string3, string4, string5, string6, bl, reaction);
    }

    public static Reaction decode(String string, int n, Reaction reaction) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n2);
            int n3 = string.indexOf(35, n2 + 1);
            if (n3 == -1) {
                string3 = string.substring(n2 + 1);
            } else {
                string3 = string.substring(n2 + 1, n3);
                int n4 = string.indexOf(35, n3 + 1);
                if (n4 == -1) {
                    string4 = string.substring(n3 + 1);
                } else {
                    string4 = string.substring(n3 + 1, n4);
                    int n5 = string.indexOf(35, n4 + 1);
                    if (n5 == -1) {
                        string5 = string.substring(n4 + 1);
                    } else {
                        string5 = string.substring(n4 + 1, n5);
                        string6 = string.substring(n5 + 1);
                    }
                }
            }
        }
        return ReactionEncoder.decode(string2, (n & 1) != 0 ? string3 : null, (n & 2) != 0 ? string4 : null, (n & 4) != 0 ? string5 : null, (n & 8) != 0 ? string6 : null, false, reaction);
    }

    public static StereoMolecule[] decodeMolecules(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n = string.indexOf(35);
        if (n == -1) {
            byArray = string.getBytes();
        } else {
            byArray = string.substring(0, n).getBytes();
            if (bl2 || bl) {
                int n2 = string.indexOf(35, n + 1);
                if (n2 == -1) {
                    if (bl2) {
                        byArray2 = string.substring(n + 1).getBytes();
                    }
                } else {
                    if (bl2) {
                        byArray2 = string.substring(n + 1, n2).getBytes();
                    }
                    if (bl) {
                        int n3 = string.indexOf(35, n2 + 1);
                        byArray3 = n3 == -1 ? string.substring(n2 + 1).getBytes() : string.substring(n2 + 1, n3).getBytes();
                    }
                }
            }
        }
        return ReactionEncoder.decodeMolecules(byArray, byArray3, byArray2, bl3, bl4);
    }

    public static StereoMolecule[] decodeMolecules(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl, boolean bl2) {
        Object object;
        int n;
        int n2;
        int n3;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n4 = ArrayUtils.indexOf(byArray, (byte)33);
        if (n4 <= 0) {
            return null;
        }
        int n5 = n4 + 1;
        int n6 = ArrayUtils.indexOf(byArray, (byte)35, n5);
        if (n6 == -1) {
            n6 = byArray.length;
        }
        if (n5 == n6) {
            return null;
        }
        int n7 = 0;
        if (byArray2 == null && (n7 = 1 + ArrayUtils.indexOf(byArray, (byte)35, n6 + 1)) != 0) {
            byArray2 = byArray;
        }
        if (byArray2 != null && !bl) {
            n3 = 1;
            for (n2 = 0; n2 < n4; ++n2) {
                if (byArray[n2] != 32) continue;
                ++n3;
            }
            for (n2 = 0; n3 != 0 && n2 < byArray2.length; ++n2) {
                if (byArray2[n2] != 32) continue;
                n7 = n2 + 1;
                --n3;
            }
        }
        n3 = 0;
        if (byArray3 != null && !bl) {
            n2 = 1;
            for (n = 0; n < n4; ++n) {
                if (byArray[n] != 32) continue;
                ++n2;
            }
            for (n = 0; n2 != 0 && n < byArray3.length; ++n) {
                if (byArray3[n] != 32) continue;
                n3 = n + 1;
                --n2;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            n = 0;
            do {
                object = new IDCodeParser();
                ((IDCodeParserWithoutCoordinateInvention)object).neglectSpaceDelimitedCoordinates();
                StereoMolecule stereoMolecule = ((IDCodeParserWithoutCoordinateInvention)object).getCompactMolecule(byArray, byArray2, n, n7);
                if (stereoMolecule.getAllAtoms() != 0) {
                    arrayList.add(stereoMolecule);
                }
                n = 1 + ArrayUtils.indexOf(byArray, (byte)32, n);
                if (byArray2 != null) {
                    n7 = 1 + ArrayUtils.indexOf(byArray2, (byte)32, n7);
                }
                if (byArray3 == null) continue;
                ((IDCodeParserWithoutCoordinateInvention)object).parseMapping(byArray3, n3);
                n3 = 1 + ArrayUtils.indexOf(byArray3, (byte)32, n3);
            } while (n != 0 && n < n4);
        }
        if (bl2) {
            do {
                IDCodeParser iDCodeParser = new IDCodeParser();
                iDCodeParser.neglectSpaceDelimitedCoordinates();
                object = iDCodeParser.getCompactMolecule(byArray, byArray2, n5, n7);
                if (((Molecule)object).getAllAtoms() != 0) {
                    arrayList.add(object);
                }
                n5 = 1 + ArrayUtils.indexOf(byArray, (byte)32, n5);
                if (byArray2 != null) {
                    n7 = 1 + ArrayUtils.indexOf(byArray2, (byte)32, n7);
                }
                if (byArray3 == null) continue;
                iDCodeParser.parseMapping(byArray3, n3);
                n3 = 1 + ArrayUtils.indexOf(byArray3, (byte)32, n3);
            } while (n5 != 0 && n5 < n6);
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new StereoMolecule[0]);
    }

    public static StereoMolecule[] decodeCatalysts(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if ((n = 1 + ArrayUtils.indexOf(byArray, (byte)35, n)) != 0) continue;
            return null;
        }
        if (n == byArray.length) {
            return null;
        }
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        while (n != 0 && n < byArray.length) {
            StereoMolecule stereoMolecule;
            int n2 = 1 + ArrayUtils.indexOf(byArray, (byte)43, n);
            int n3 = 1 + ArrayUtils.indexOf(byArray, (byte)32, n);
            StereoMolecule stereoMolecule2 = stereoMolecule = n3 != 0 && (n2 == 0 || n2 > n3) ? new IDCodeParser().getCompactMolecule(byArray, byArray, n, n3) : new IDCodeParser().getCompactMolecule(byArray, null, n, -1);
            if (stereoMolecule.getAllAtoms() != 0) {
                arrayList.add(stereoMolecule);
            }
            n = n2;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new StereoMolecule[0]);
    }

    public static byte[][] getMoleculeIDCodes(byte[] byArray, boolean bl, boolean bl2) {
        int n;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n2 = ArrayUtils.indexOf(byArray, (byte)33);
        if (n2 <= 0) {
            return null;
        }
        int n3 = n2 + 1;
        int n4 = ArrayUtils.indexOf(byArray, (byte)35, n3);
        if (n4 == -1) {
            n4 = byArray.length;
        }
        if (n3 == n4) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (bl) {
            n = 0;
            while (n < n2) {
                int n5 = ArrayUtils.indexOf(byArray, (byte)32, n);
                if (n5 == -1) {
                    n5 = n2;
                }
                arrayList.add(Arrays.copyOfRange(byArray, n, n5));
                n = 1 + n5;
            }
        }
        if (bl2) {
            while (n3 < n4) {
                n = ArrayUtils.indexOf(byArray, (byte)32, n3);
                if (n == -1) {
                    n = n4;
                }
                arrayList.add(Arrays.copyOfRange(byArray, n3, n));
                n3 = 1 + n;
            }
        }
        return arrayList.size() == 0 ? (byte[][])null : (byte[][])arrayList.toArray((T[])new byte[0][]);
    }
}

