/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.properties.complexity.BitArray128;
import com.actelion.research.chem.properties.complexity.IBitArray;
import java.io.IOException;
import java.io.InputStream;

public class FragmentDefinedByBondsIdCode {
    String idcode;
    private int frequency;
    private IBitArray bitArray;

    public FragmentDefinedByBondsIdCode() {
        this.idcode = "";
    }

    public FragmentDefinedByBondsIdCode(IBitArray iBitArray) {
        this.bitArray = iBitArray;
    }

    public FragmentDefinedByBondsIdCode(FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode) {
        this.bitArray = fragmentDefinedByBondsIdCode.bitArray;
        this.idcode = fragmentDefinedByBondsIdCode.idcode;
        this.frequency = fragmentDefinedByBondsIdCode.frequency;
    }

    public void addBits(IBitArray iBitArray) {
        this.bitArray.add(iBitArray);
    }

    public String getIdCode() {
        return this.idcode;
    }

    public IBitArray getBitArray() {
        return this.bitArray;
    }

    public void setIdCode(String string) {
        this.idcode = string;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void incrementFrequency() {
        ++this.frequency;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public int getBitsSet() {
        if (this.bitArray == null) {
            return 0;
        }
        return this.bitArray.getBitsSet();
    }

    public boolean isOverlappingBits(IBitArray iBitArray) {
        return this.bitArray.isOverlap(iBitArray);
    }

    public String write2String() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.idcode);
        stringBuilder.append("\t");
        stringBuilder.append(this.frequency);
        stringBuilder.append(" ");
        stringBuilder.append(this.bitArray.write2String());
        return stringBuilder.toString();
    }

    public static FragmentDefinedByBondsIdCode read(InputStream inputStream) throws IOException {
        String string = FragmentDefinedByBondsIdCode.parseString(inputStream);
        int n = (int)BitArray128.parseLong(inputStream);
        BitArray128 bitArray128 = BitArray128.read(inputStream);
        FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode = new FragmentDefinedByBondsIdCode(bitArray128);
        fragmentDefinedByBondsIdCode.idcode = string;
        fragmentDefinedByBondsIdCode.frequency = n;
        return fragmentDefinedByBondsIdCode;
    }

    public static String parseString(InputStream inputStream) throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (9 != (n = inputStream.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }
}

