/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SortedStringList;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.ParameterizedStringList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ToxicityPredictor {
    public static final String[] RISK_NAME = new String[]{"unknown", "none", "low", "high"};
    public static final int cUnknownRisk = 0;
    public static final int cNoRisk = 1;
    public static final int cLowRisk = 2;
    public static final int cHighRisk = 3;
    public static final int cRiskTypes = 4;
    public static final int cRiskTypeMutagenic = 0;
    public static final int cRiskTypeTumorigenic = 1;
    public static final int cRiskTypeIrritant = 2;
    public static final int cRiskTypeReproductiveEffective = 3;
    public static final String[] cRiskNameA = new String[]{"mutagenic", "tumorigenic", "irritant", "reproductive effective"};
    public static final String[] cRiskNameN = new String[]{"Mutagenicity", "Tumorigenicity", "Irritating effects", "Reproductive effects"};
    private static ArrayList<String>[] sHighRiskFragments;
    private static ArrayList<String>[] sLowRiskFragments;
    private static SortedStringList[] sRiskMolecules;
    private static boolean sInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToxicityPredictor() {
        Class<ToxicityPredictor> clazz = ToxicityPredictor.class;
        synchronized (ToxicityPredictor.class) {
            if (!sInitialized) {
                try {
                    sRiskMolecules = new SortedStringList[4];
                    sHighRiskFragments = new ArrayList[4];
                    sLowRiskFragments = new ArrayList[4];
                    ToxicityPredictor.sHighRiskFragments[0] = this.readIDCodeFile("/resources/toxpredictor/m1.txt");
                    ToxicityPredictor.sHighRiskFragments[1] = this.readIDCodeFile("/resources/toxpredictor/t1.txt");
                    ToxicityPredictor.sHighRiskFragments[2] = this.readIDCodeFile("/resources/toxpredictor/i1.txt");
                    ToxicityPredictor.sHighRiskFragments[3] = this.readIDCodeFile("/resources/toxpredictor/r1.txt");
                    ToxicityPredictor.sLowRiskFragments[0] = this.readIDCodeFile("/resources/toxpredictor/m2.txt");
                    ToxicityPredictor.sLowRiskFragments[1] = this.readIDCodeFile("/resources/toxpredictor/t2.txt");
                    ToxicityPredictor.sLowRiskFragments[2] = this.readIDCodeFile("/resources/toxpredictor/i2.txt");
                    ToxicityPredictor.sLowRiskFragments[3] = this.readIDCodeFile("/resources/toxpredictor/r2.txt");
                    ToxicityPredictor.sRiskMolecules[0] = this.readAndSortIDCodeFile("/resources/toxpredictor/m3.txt");
                    ToxicityPredictor.sRiskMolecules[1] = this.readAndSortIDCodeFile("/resources/toxpredictor/t3.txt");
                    ToxicityPredictor.sRiskMolecules[2] = this.readAndSortIDCodeFile("/resources/toxpredictor/i3.txt");
                    ToxicityPredictor.sRiskMolecules[3] = this.readAndSortIDCodeFile("/resources/toxpredictor/r3.txt");
                    sInitialized = true;
                }
                catch (Exception exception) {
                    System.out.println("Error ToxicityPredictor::initialize() " + exception);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int assessRisk(StereoMolecule stereoMolecule, int n, ThreadMaster threadMaster) {
        int n2;
        if (!sInitialized) {
            return 0;
        }
        if (sRiskMolecules[n].contains(new Canonizer(stereoMolecule).getIDCode())) {
            return 3;
        }
        SSSearcher sSSearcher = new SSSearcher(1);
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        for (n2 = 0; n2 < sHighRiskFragments[n].size(); ++n2) {
            if (threadMaster != null && threadMaster.threadMustDie()) {
                return 0;
            }
            Thread.yield();
            new IDCodeParser(false).parse(stereoMolecule2, sHighRiskFragments[n].get(n2));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            return 3;
        }
        for (n2 = 0; n2 < sLowRiskFragments[n].size(); ++n2) {
            if (threadMaster != null && threadMaster.threadMustDie()) {
                return 0;
            }
            Thread.yield();
            new IDCodeParser(false).parse(stereoMolecule2, sLowRiskFragments[n].get(n2));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            return 2;
        }
        return 1;
    }

    public ParameterizedStringList getDetail(StereoMolecule stereoMolecule, int n) {
        int n2;
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        if (!sInitialized) {
            parameterizedStringList.add("Toxicity predictor not properly initialized.", 2);
            return parameterizedStringList;
        }
        String string = new Canonizer(stereoMolecule).getIDCode();
        if (sRiskMolecules[n].contains(string)) {
            parameterizedStringList.add("This molecule is known to be " + cRiskNameA[n] + ":", 2);
            parameterizedStringList.add(string, 1);
            return parameterizedStringList;
        }
        SSSearcher sSSearcher = new SSSearcher(1);
        boolean bl = false;
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        for (n2 = 0; n2 < sHighRiskFragments[n].size(); ++n2) {
            new IDCodeParser(false).parse(stereoMolecule2, sHighRiskFragments[n].get(n2));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            if (!bl) {
                parameterizedStringList.add("High-risk fragments indicating " + cRiskNameN[n] + ":", 2);
            }
            bl = true;
            parameterizedStringList.add(sHighRiskFragments[n].get(n2), 1);
        }
        bl = false;
        for (n2 = 0; n2 < sLowRiskFragments[n].size(); ++n2) {
            new IDCodeParser(false).parse(stereoMolecule2, sLowRiskFragments[n].get(n2));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            if (!bl) {
                parameterizedStringList.add("Medium-risk fragments indicating " + cRiskNameN[n] + ":", 2);
            }
            bl = true;
            parameterizedStringList.add(sLowRiskFragments[n].get(n2), 1);
        }
        if (parameterizedStringList.getSize() == 0) {
            parameterizedStringList.add("No indication for " + cRiskNameN[n] + " found.", 2);
        }
        return parameterizedStringList;
    }

    private ArrayList<String> readIDCodeFile(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bufferedReader.close();
        return arrayList;
    }

    private SortedStringList readAndSortIDCodeFile(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
        SortedStringList sortedStringList = new SortedStringList();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                sortedStringList.addString(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bufferedReader.close();
        return sortedStringList;
    }
}

