/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.EncodeFunctions;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import java.util.Base64;

public class SimplePharmacophorePoint
implements IPharmacophorePoint {
    private Coordinates center;
    private int atomID;
    private IPharmacophorePoint.Functionality functionality;
    private static final Coordinates directionality = new Coordinates(1.0, 0.0, 0.0);

    public SimplePharmacophorePoint(int n, Coordinates coordinates, IPharmacophorePoint.Functionality functionality) {
        this.atomID = n;
        this.center = coordinates;
        this.functionality = functionality;
    }

    public SimplePharmacophorePoint(SimplePharmacophorePoint simplePharmacophorePoint) {
        this.atomID = simplePharmacophorePoint.atomID;
        this.center = new Coordinates(simplePharmacophorePoint.center);
        this.functionality = simplePharmacophorePoint.functionality;
    }

    private SimplePharmacophorePoint(String string, StereoMolecule stereoMolecule) {
        SimplePharmacophorePoint.decode(string);
    }

    public static SimplePharmacophorePoint fromString(String string, StereoMolecule stereoMolecule) {
        return new SimplePharmacophorePoint(string, stereoMolecule);
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.center = new Coordinates(coordinatesArray[this.atomID]);
    }

    @Override
    public Coordinates getDirectionality() {
        return directionality;
    }

    @Override
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("s");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.atomID));
        stringBuilder.append(" ");
        double[] dArray = new double[]{this.center.x, this.center.y, this.center.z};
        stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleArrayToByteArray(dArray)));
        stringBuilder.append(" ");
        stringBuilder.append(this.functionality.getIndex());
        return stringBuilder.toString();
    }

    public static SimplePharmacophorePoint decode(String string) {
        Base64.Decoder decoder = Base64.getDecoder();
        String[] stringArray = string.split(" ");
        int n = Integer.decode(stringArray[1]);
        double[] dArray = EncodeFunctions.byteArrayToDoubleArray(decoder.decode(stringArray[2].getBytes()));
        Coordinates coordinates = new Coordinates(dArray[0], dArray[1], dArray[2]);
        IPharmacophorePoint.Functionality functionality = null;
        int n2 = Integer.valueOf(stringArray[3]);
        for (IPharmacophorePoint.Functionality functionality2 : IPharmacophorePoint.Functionality.values()) {
            if (functionality2.getIndex() != n2) continue;
            functionality = functionality2;
            break;
        }
        SimplePharmacophorePoint simplePharmacophorePoint = new SimplePharmacophorePoint(n, coordinates, functionality);
        return simplePharmacophorePoint;
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        double d = 0.0;
        if (iPharmacophorePoint.getFunctionalityIndex() == this.functionality.getIndex()) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public int getCenterID() {
        return this.atomID;
    }

    @Override
    public void setCenterID(int n) {
        this.atomID = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.atomID = nArray[this.atomID];
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new SimplePharmacophorePoint(this);
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = new Coordinates(directionality);
        return coordinates;
    }

    @Override
    public int getFunctionalityIndex() {
        return this.functionality.getIndex();
    }

    @Override
    public double getVectorSimilarity(IPharmacophorePoint iPharmacophorePoint, Coordinates coordinates) {
        return 1.0;
    }
}

