/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.phesaflex.MathHelper;
import java.util.ArrayList;
import java.util.List;

public class AcceptorPoint
implements IPharmacophorePoint {
    private int acceptorAtom;
    private List<Integer> neighbours;
    private Coordinates directionality;
    private int interactionClass;
    private Coordinates center;
    private int acceptorID;

    public AcceptorPoint(StereoMolecule stereoMolecule, int n, List<Integer> list, int n2) {
        this(stereoMolecule, n, list, n2, 0);
    }

    public AcceptorPoint(AcceptorPoint acceptorPoint) {
        this.acceptorAtom = acceptorPoint.acceptorAtom;
        this.neighbours = new ArrayList<Integer>();
        for (int n : acceptorPoint.neighbours) {
            this.neighbours.add(n);
        }
        this.directionality = new Coordinates(acceptorPoint.directionality);
        this.interactionClass = acceptorPoint.interactionClass;
        this.center = new Coordinates(acceptorPoint.center);
        this.acceptorID = acceptorPoint.acceptorID;
    }

    public AcceptorPoint(StereoMolecule stereoMolecule, int n, List<Integer> list, int n2, int n3) {
        this.acceptorAtom = n;
        this.neighbours = list;
        this.interactionClass = n2;
        this.acceptorID = n3;
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    private AcceptorPoint(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public static AcceptorPoint fromString(String string, StereoMolecule stereoMolecule) {
        return new AcceptorPoint(string, stereoMolecule);
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.center = new Coordinates(coordinatesArray[this.acceptorAtom].x, coordinatesArray[this.acceptorAtom].y, coordinatesArray[this.acceptorAtom].z);
        if (this.neighbours.size() == 1) {
            int n = this.neighbours.get(0);
            this.directionality = this.center.subC(coordinatesArray[n]);
        } else if (this.neighbours.size() == 2 && this.acceptorID != 0) {
            int n = this.neighbours.get(0);
            Coordinates coordinates = this.center.subC(coordinatesArray[n]);
            int n2 = this.neighbours.get(1);
            Coordinates coordinates2 = coordinatesArray[n2].subC(this.center);
            Coordinates coordinates3 = coordinates.cross(coordinates2).unit();
            double d = this.acceptorID == 1 ? 0.7853981633974483 : -0.7853981633974483;
            this.directionality = coordinates.rotate(coordinates3, d);
        } else if (this.neighbours.size() == 3) {
            int n = this.neighbours.get(0);
            int n3 = this.neighbours.get(1);
            int n4 = this.neighbours.get(2);
            Coordinates coordinates = this.center.subC(coordinatesArray[n]).unit();
            Coordinates coordinates4 = this.center.subC(coordinatesArray[n3]).unit();
            Coordinates coordinates5 = this.center.subC(coordinatesArray[n4]).unit();
            this.directionality = coordinates5.add(coordinates4).add(coordinates);
        } else {
            int n = this.neighbours.get(0);
            int n5 = this.neighbours.get(1);
            Coordinates coordinates = this.center.subC(coordinatesArray[n]).unit();
            Coordinates coordinates6 = this.center.subC(coordinatesArray[n5]).unit();
            this.directionality = coordinates.addC(coordinates6);
        }
        this.directionality.unit();
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public Coordinates getDirectionality() {
        return this.directionality;
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.acceptorAtom));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.interactionClass));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.acceptorID));
        stringBuilder.append(" ");
        for (Integer n : this.neighbours) {
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.acceptorAtom = Integer.decode(stringArray[1]);
        this.interactionClass = Integer.decode(stringArray[2]);
        this.acceptorID = Integer.decode(stringArray[3]);
        this.neighbours = new ArrayList<Integer>();
        for (int i = 4; i < stringArray.length; ++i) {
            this.neighbours.add(Integer.decode(stringArray[i]));
        }
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        if (iPharmacophorePoint instanceof AcceptorPoint) {
            return 1.0;
        }
        return 0.0;
    }

    public int getInteractionClass() {
        return this.interactionClass;
    }

    @Override
    public int getCenterID() {
        return this.acceptorAtom;
    }

    @Override
    public void setCenterID(int n) {
        this.acceptorAtom = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
        this.directionality = coordinates;
    }

    public int getAcceptorID() {
        return this.acceptorID;
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
        if (this.neighbours.size() == 1) {
            int n = this.neighbours.get(0);
            dArray[3 * this.acceptorAtom] = d * coordinates.x / 3.0;
            dArray[3 * this.acceptorAtom + 1] = d * coordinates.y / 3.0;
            dArray[3 * this.acceptorAtom + 2] = d * coordinates.z / 3.0;
            dArray[3 * n] = d * -coordinates.x / 3.0;
            dArray[3 * n + 1] = d * -coordinates.y / 3.0;
            dArray[3 * n + 2] = d * -coordinates.z / 3.0;
        } else if (this.neighbours.size() == 2 && this.acceptorID != 0) {
            Coordinates coordinates2;
            Coordinates coordinates3 = new Coordinates(dArray2[3 * this.acceptorAtom], dArray2[3 * this.acceptorAtom + 1], dArray2[3 * this.acceptorAtom + 2]);
            int n = this.neighbours.get(0);
            Coordinates coordinates4 = new Coordinates(dArray2[3 * n], dArray2[3 * n + 1], dArray2[3 * n + 2]);
            Coordinates coordinates5 = coordinates3.subC(coordinates4);
            int n2 = this.neighbours.get(1);
            Coordinates coordinates6 = new Coordinates(dArray2[3 * n2], dArray2[3 * n2 + 1], dArray2[3 * n2 + 2]);
            Coordinates coordinates7 = coordinates6.subC(coordinates3);
            Coordinates coordinates8 = coordinates5.cross(coordinates7).unit();
            double d2 = this.acceptorID == 1 ? 0.7853981633974483 : -0.7853981633974483;
            double[][] dArray3 = new double[3][3];
            Coordinates[][] coordinatesArray = new Coordinates[3][3];
            double[][] dArray4 = new double[3][3];
            MathHelper.getRotMatrix(coordinates8, d2, dArray3);
            MathHelper.getRotMatrixDerivative(coordinates8, d2, coordinatesArray);
            Coordinates coordinates9 = new Coordinates(1.0, 1.0, 1.0);
            Coordinates coordinates10 = coordinates9.cross(coordinates5);
            dArray4[0][0] = coordinatesArray[0][0].dot(coordinates10);
            dArray4[0][1] = coordinatesArray[0][1].dot(coordinates10);
            dArray4[0][2] = coordinatesArray[0][2].dot(coordinates10);
            dArray4[1][0] = coordinatesArray[1][0].dot(coordinates10);
            dArray4[1][1] = coordinatesArray[1][1].dot(coordinates10);
            dArray4[1][2] = coordinatesArray[1][2].dot(coordinates10);
            dArray4[2][0] = coordinatesArray[2][0].dot(coordinates10);
            dArray4[2][1] = coordinatesArray[2][2].dot(coordinates10);
            dArray4[2][2] = coordinatesArray[2][2].dot(coordinates10);
            Coordinates coordinates11 = new Coordinates(dArray4[0][0] * coordinates5.x + dArray4[0][1] * coordinates5.y + dArray4[0][2] * coordinates5.z, dArray4[1][0] * coordinates5.x + dArray4[1][1] * coordinates5.y + dArray4[2][1] * coordinates5.z, dArray4[2][0] * coordinates5.x + dArray4[2][1] * coordinates5.y + dArray4[2][2] * coordinates5.z);
            int n3 = 3 * n2;
            dArray[n3] = dArray[n3] + d * coordinates11.x / 3.0;
            int n4 = 3 * n2 + 1;
            dArray[n4] = dArray[n4] + d * coordinates11.y / 3.0;
            int n5 = 3 * n2 + 2;
            dArray[n5] = dArray[n5] + d * coordinates11.z / 3.0;
            Coordinates coordinates12 = coordinates2 = new Coordinates(-1.0, -1.0, -1.0);
            Coordinates coordinates13 = coordinates2.cross(coordinates7).add(coordinates12.cross(coordinates5));
            double[][] dArray5 = dArray4;
            dArray5[0][0] = coordinatesArray[0][0].dot(coordinates13);
            dArray5[0][1] = coordinatesArray[0][1].dot(coordinates13);
            dArray5[0][2] = coordinatesArray[0][2].dot(coordinates13);
            dArray5[1][0] = coordinatesArray[1][0].dot(coordinates13);
            dArray5[1][1] = coordinatesArray[1][1].dot(coordinates13);
            dArray5[1][2] = coordinatesArray[1][2].dot(coordinates13);
            dArray5[2][0] = coordinatesArray[2][0].dot(coordinates13);
            dArray5[2][1] = coordinatesArray[2][2].dot(coordinates13);
            dArray5[2][2] = coordinatesArray[2][2].dot(coordinates13);
            Coordinates coordinates14 = new Coordinates(dArray4[0][0] * coordinates5.x + dArray4[0][1] * coordinates5.y + dArray4[0][2] * coordinates5.z + dArray3[0][0] * coordinates2.x + dArray3[0][1] * coordinates2.y + dArray3[0][2] * coordinates2.z, dArray4[1][0] * coordinates5.x + dArray4[1][1] * coordinates5.y + dArray4[1][2] * coordinates5.z + dArray3[1][0] * coordinates2.x + dArray3[1][1] * coordinates2.y + dArray3[1][2] * coordinates2.z, dArray4[2][0] * coordinates5.x + dArray4[2][1] * coordinates5.y + dArray4[2][2] * coordinates5.z + dArray3[2][0] * coordinates2.x + dArray3[2][1] * coordinates2.y + dArray3[2][2] * coordinates2.z);
            int n6 = 3 * n;
            dArray[n6] = dArray[n6] + d * coordinates14.x / 3.0;
            int n7 = 3 * n + 1;
            dArray[n7] = dArray[n7] + d * coordinates14.y / 3.0;
            int n8 = 3 * n + 2;
            dArray[n8] = dArray[n8] + d * coordinates14.z / 3.0;
            Coordinates coordinates15 = coordinates9;
            Coordinates coordinates16 = coordinates15.cross(coordinates7);
            double[][] dArray6 = dArray4;
            dArray6[0][0] = coordinatesArray[0][0].dot(coordinates16);
            dArray6[0][1] = coordinatesArray[0][1].dot(coordinates16);
            dArray6[0][2] = coordinatesArray[0][2].dot(coordinates16);
            dArray6[1][0] = coordinatesArray[1][0].dot(coordinates16);
            dArray6[1][1] = coordinatesArray[1][1].dot(coordinates16);
            dArray6[1][2] = coordinatesArray[1][2].dot(coordinates16);
            dArray6[2][0] = coordinatesArray[2][0].dot(coordinates16);
            dArray6[2][1] = coordinatesArray[2][2].dot(coordinates16);
            dArray6[2][2] = coordinatesArray[2][2].dot(coordinates16);
            Coordinates coordinates17 = new Coordinates(dArray6[0][0] * coordinates5.x + dArray6[0][1] * coordinates5.y + dArray6[0][2] * coordinates5.z + dArray3[0][0] * coordinates15.x + dArray3[0][1] * coordinates15.y + dArray3[0][2] * coordinates15.z, dArray6[1][0] * coordinates5.x + dArray6[1][1] * coordinates5.y + dArray6[1][2] * coordinates5.z + dArray3[1][0] * coordinates15.x + dArray3[1][1] * coordinates15.y + dArray3[1][2] * coordinates15.z, dArray6[2][0] * coordinates5.x + dArray6[2][1] * coordinates5.y + dArray6[2][2] * coordinates5.z + dArray3[2][0] * coordinates15.x + dArray3[2][1] * coordinates15.y + dArray3[2][2] * coordinates15.z);
            int n9 = 3 * this.acceptorAtom;
            dArray[n9] = dArray[n9] + d * coordinates17.x / 3.0;
            int n10 = 3 * this.acceptorAtom + 1;
            dArray[n10] = dArray[n10] + d * coordinates17.y / 3.0;
            int n11 = 3 * this.acceptorAtom + 2;
            dArray[n11] = dArray[n11] + d * coordinates17.z / 3.0;
        } else if (this.neighbours.size() == 3) {
            int n = this.neighbours.get(0);
            int n12 = this.neighbours.get(1);
            int n13 = this.neighbours.get(2);
            int n14 = 3 * this.acceptorAtom;
            dArray[n14] = dArray[n14] + d * 3.0 * coordinates.x / 3.0;
            int n15 = 3 * this.acceptorAtom + 1;
            dArray[n15] = dArray[n15] + d * 3.0 * coordinates.y / 3.0;
            int n16 = 3 * this.acceptorAtom + 2;
            dArray[n16] = dArray[n16] + d * 3.0 * coordinates.z / 3.0;
            int n17 = 3 * n;
            dArray[n17] = dArray[n17] + d * -coordinates.x / 3.0;
            int n18 = 3 * n + 1;
            dArray[n18] = dArray[n18] + d * -coordinates.y / 3.0;
            int n19 = 3 * n + 2;
            dArray[n19] = dArray[n19] + d * -coordinates.z / 3.0;
            int n20 = 3 * n12;
            dArray[n20] = dArray[n20] + d * -coordinates.x / 3.0;
            int n21 = 3 * n12 + 1;
            dArray[n21] = dArray[n21] + d * -coordinates.y / 3.0;
            int n22 = 3 * n12 + 2;
            dArray[n22] = dArray[n22] + d * -coordinates.z / 3.0;
            int n23 = 3 * n13;
            dArray[n23] = dArray[n23] + d * -coordinates.x / 3.0;
            int n24 = 3 * n13 + 1;
            dArray[n24] = dArray[n24] + d * -coordinates.y / 3.0;
            int n25 = 3 * n13 + 2;
            dArray[n25] = dArray[n25] + d * -coordinates.z / 3.0;
        } else {
            int n = this.neighbours.get(0);
            int n26 = this.neighbours.get(1);
            int n27 = 3 * this.acceptorAtom;
            dArray[n27] = dArray[n27] + d * 2.0 * coordinates.x / 3.0;
            int n28 = 3 * this.acceptorAtom + 1;
            dArray[n28] = dArray[n28] + d * 2.0 * coordinates.y / 3.0;
            int n29 = 3 * this.acceptorAtom + 2;
            dArray[n29] = dArray[n29] + d * 2.0 * coordinates.z / 3.0;
            int n30 = 3 * n;
            dArray[n30] = dArray[n30] + d * -coordinates.x / 3.0;
            int n31 = 3 * n + 1;
            dArray[n31] = dArray[n31] + d * -coordinates.y / 3.0;
            int n32 = 3 * n + 2;
            dArray[n32] = dArray[n32] + d * -coordinates.z / 3.0;
            int n33 = 3 * n26;
            dArray[n33] = dArray[n33] + d * -coordinates.x / 3.0;
            int n34 = 3 * n26 + 1;
            dArray[n34] = dArray[n34] + d * -coordinates.y / 3.0;
            int n35 = 3 * n26 + 2;
            dArray[n35] = dArray[n35] + d * -coordinates.z / 3.0;
        }
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.acceptorAtom = nArray[this.acceptorAtom];
        for (int i = 0; i < this.neighbours.size(); ++i) {
            int n = nArray[this.neighbours.get(i)];
            this.neighbours.set(i, n);
        }
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new AcceptorPoint(this);
    }

    @Override
    public int getFunctionalityIndex() {
        return IPharmacophorePoint.Functionality.ACCEPTOR.getIndex();
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = new Coordinates();
        coordinates = this.directionality.rotateC(dArray);
        coordinates.scale(d);
        return coordinates;
    }
}

