/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;

public class PPTriangle {
    private double[] d = new double[3];
    private Coordinates[] c = new Coordinates[3];
    private int[] f = new int[3];
    private double[][] initialRot;
    private double[] initialTranslate;
    private double[][] u;
    private Coordinates molCom;
    private Coordinates com;
    private Coordinates[] dirs = new Coordinates[3];

    public PPTriangle(IPharmacophorePoint iPharmacophorePoint, IPharmacophorePoint iPharmacophorePoint2, IPharmacophorePoint iPharmacophorePoint3, double d, double d2, double d3, Coordinates coordinates) {
        this.molCom = coordinates;
        this.f[0] = iPharmacophorePoint.getFunctionalityIndex();
        this.f[1] = iPharmacophorePoint2.getFunctionalityIndex();
        this.f[2] = iPharmacophorePoint3.getFunctionalityIndex();
        this.d[0] = d;
        this.d[1] = d2;
        this.d[2] = d3;
        this.c[0] = new Coordinates(iPharmacophorePoint.getCenter());
        this.c[1] = new Coordinates(iPharmacophorePoint2.getCenter());
        this.c[2] = new Coordinates(iPharmacophorePoint3.getCenter());
        this.dirs[0] = iPharmacophorePoint.getDirectionality();
        this.dirs[1] = iPharmacophorePoint2.getDirectionality();
        this.dirs[2] = iPharmacophorePoint3.getDirectionality();
        this.canonizeOrder();
    }

    private void canonizeOrder() {
        if (this.f[0] != this.f[1] && this.f[0] != this.f[2] && this.f[1] != this.f[2]) {
            return;
        }
        if (this.f[0] == this.f[1] && this.f[1] == this.f[2]) {
            if (this.d[0] <= this.d[1]) {
                if (this.d[1] <= this.d[2]) {
                    return;
                }
                if (this.d[0] <= this.d[2]) {
                    this.swap(0, 1);
                } else {
                    this.swap(0, 1);
                    this.swap(1, 2);
                }
            } else if (this.d[2] <= this.d[1]) {
                this.swap(0, 2);
            } else if (this.d[0] <= this.d[2]) {
                this.swap(1, 2);
            } else {
                this.swap(0, 1);
                this.swap(0, 2);
            }
        } else if (this.f[0] == this.f[1]) {
            if (this.d[1] > this.d[2]) {
                this.swap(0, 1);
            }
        } else if (this.f[1] == this.f[2] && this.d[0] > this.d[1]) {
            this.swap(1, 2);
        }
    }

    private void swap(int n, int n2) {
        int n3 = this.f[n];
        Coordinates coordinates = new Coordinates(this.dirs[n]);
        this.dirs[n] = new Coordinates(this.dirs[n2]);
        this.f[n] = this.f[n2];
        this.f[n2] = n3;
        this.dirs[n2] = coordinates;
        Coordinates coordinates2 = new Coordinates(this.c[n]);
        this.c[n] = new Coordinates(this.c[n2]);
        this.c[n2] = new Coordinates(coordinates2);
        if (n == 0 && n2 == 1) {
            double d = this.d[2];
            this.d[2] = this.d[1];
            this.d[1] = d;
        } else if (n == 0 && n2 == 2) {
            double d = this.d[2];
            this.d[2] = this.d[0];
            this.d[0] = d;
        } else if (n == 1 && n2 == 2) {
            double d = this.d[1];
            this.d[1] = this.d[0];
            this.d[0] = d;
        }
    }

    public int getHash() {
        return this.f[0] + 10 * this.f[1] + 100 * this.f[2];
    }

    public double[] getEdgeLengths() {
        return this.d;
    }

    private void preAlign() {
        this.com = this.c[0].addC(this.c[1]).addC(this.c[2]).scaleC(0.33333);
        this.c[0].sub(this.com);
        this.c[1].sub(this.com);
        this.c[2].sub(this.com);
        Coordinates coordinates = this.c[0].unitC();
        Coordinates coordinates2 = this.c[1].unitC();
        Coordinates coordinates3 = coordinates.cross(coordinates2).unitC();
        Coordinates coordinates4 = coordinates3.cross(coordinates).unitC();
        double[][] dArray = new double[3][3];
        dArray[0][0] = coordinates.x;
        dArray[1][0] = coordinates.y;
        dArray[2][0] = coordinates.z;
        dArray[0][1] = coordinates4.x;
        dArray[1][1] = coordinates4.y;
        dArray[2][1] = coordinates4.z;
        dArray[0][2] = coordinates3.x;
        dArray[1][2] = coordinates3.y;
        dArray[2][2] = coordinates3.z;
        this.c[0].rotate(dArray);
        this.c[1].rotate(dArray);
        this.c[2].rotate(dArray);
        this.initialRot = dArray;
        this.initialTranslate = new double[]{-this.com.x, -this.com.y, -this.com.z};
    }

    public double[][] getInitialRot() {
        return this.initialRot;
    }

    public double[] getInitialTranslate() {
        return this.initialTranslate;
    }

    public double getMatchingTransform(PPTriangle pPTriangle, TransformationSequence transformationSequence, boolean bl) {
        double[][] dArray = new double[3][3];
        if (this.initialRot == null && this.initialTranslate == null) {
            this.preAlign();
        }
        if (pPTriangle.initialRot == null && pPTriangle.initialTranslate == null) {
            pPTriangle.preAlign();
        }
        Coordinates coordinates = this.c[0];
        Coordinates coordinates2 = this.c[1];
        Coordinates coordinates3 = this.c[2];
        Coordinates coordinates4 = pPTriangle.c[0];
        Coordinates coordinates5 = pPTriangle.c[1];
        Coordinates coordinates6 = pPTriangle.c[2];
        double d = (4.0 - 2.0 * Math.min(coordinates.subC(coordinates4).dist(), 2.0) + (4.0 - 2.0 * Math.min(coordinates2.subC(coordinates5).dist(), 2.0)) + (4.0 - 2.0 * Math.min(coordinates3.subC(coordinates6).dist(), 2.0))) / 12.0;
        Matrix matrix = new Matrix(this.initialRot);
        this.u = matrix.getTranspose().getArray();
        PheSAAlignment.multiplyMatrix(this.u, pPTriangle.initialRot, dArray);
        transformationSequence.addTransformation(new Translation(pPTriangle.initialTranslate));
        transformationSequence.addTransformation(new Rotation(dArray));
        transformationSequence.addTransformation(new Translation(new double[]{-this.initialTranslate[0], -this.initialTranslate[1], -this.initialTranslate[2]}));
        Coordinates coordinates7 = new Coordinates();
        coordinates7.x = pPTriangle.molCom.x - pPTriangle.com.x;
        coordinates7.y = pPTriangle.molCom.y - pPTriangle.com.y;
        coordinates7.z = pPTriangle.molCom.z - pPTriangle.com.z;
        Coordinates coordinates8 = new Coordinates();
        coordinates8.x = dArray[0][0] * coordinates7.x + dArray[1][0] * coordinates7.y + dArray[2][0] * coordinates7.z;
        coordinates8.y = dArray[0][1] * coordinates7.x + dArray[1][1] * coordinates7.y + dArray[2][1] * coordinates7.z;
        coordinates8.z = dArray[0][2] * coordinates7.x + dArray[1][2] * coordinates7.y + dArray[2][2] * coordinates7.z;
        Coordinates coordinates9 = this.com.subC(this.molCom);
        Coordinates coordinates10 = coordinates8.scale(-1.0);
        double d2 = coordinates9.dist();
        double d3 = coordinates10.dist();
        double d4 = coordinates9.unitC().dot(coordinates10.unitC());
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        double d5 = coordinates9.subC(coordinates10).dist();
        double d6 = 1.0;
        double d7 = 1.0;
        if (bl) {
            Coordinates coordinates11 = new Coordinates(pPTriangle.dirs[0]);
            Coordinates coordinates12 = new Coordinates(pPTriangle.dirs[1]);
            Coordinates coordinates13 = new Coordinates(pPTriangle.dirs[2]);
            if (pPTriangle.f[0] == IPharmacophorePoint.Functionality.ACCEPTOR.getIndex() || pPTriangle.f[0] == IPharmacophorePoint.Functionality.DONOR.getIndex()) {
                coordinates11.rotate(dArray);
            }
            if (pPTriangle.f[1] == IPharmacophorePoint.Functionality.ACCEPTOR.getIndex() || pPTriangle.f[1] == IPharmacophorePoint.Functionality.DONOR.getIndex()) {
                coordinates12.rotate(dArray);
            }
            if (pPTriangle.f[2] == IPharmacophorePoint.Functionality.ACCEPTOR.getIndex() || pPTriangle.f[2] == IPharmacophorePoint.Functionality.DONOR.getIndex()) {
                coordinates13.rotate(dArray);
            }
            d7 = 0.33333 * (Math.max(0.0, coordinates11.dot(this.dirs[0])) + Math.max(0.0, coordinates12.dot(this.dirs[1])) + Math.max(0.0, coordinates13.dot(this.dirs[2])));
            d6 = (1.0 - (1.0 - Math.exp(-0.25 * Math.sqrt(d2 * d3))) * (1.0 - d4)) * Math.exp(-0.125 * (d5 * d5));
        }
        return d * d7 * d6;
    }
}

