/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.ChargePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class IonizableGroupDetector {
    private StereoMolecule mol;
    private List<ArrayList<Integer>> ionizableGroups;
    private RingCollection ringCollection;

    public IonizableGroupDetector(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
        this.ionizableGroups = new ArrayList<ArrayList<Integer>>();
        this.ringCollection = stereoMolecule.getRingSet();
    }

    public ArrayList<ChargePoint> detect() {
        Object object;
        int n;
        int n2;
        int n3;
        ArrayList<ChargePoint> arrayList = new ArrayList<ChargePoint>();
        for (n3 = 0; n3 < this.ringCollection.getSize(); ++n3) {
            int[] nArray;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            Object object2 = nArray = this.ringCollection.getRingAtoms(n3);
            n2 = ((int[])object2).length;
            for (n = 0; n < n2; ++n) {
                object = object2[n];
                if (this.alreadyDetected((Integer)object) || this.mol.getAtomicNo((Integer)object) != 7 || !this.mol.isAromaticAtom((Integer)object) || this.mol.getConnAtoms((Integer)object) > 2) continue;
                arrayList2.add((Integer)object);
            }
            if (arrayList2.size() != 4) continue;
            this.ionizableGroups.add(arrayList2);
            object2 = new ChargePoint(this.mol, (Integer)arrayList2.get(0), Arrays.asList((Integer)arrayList2.get(1), (Integer)arrayList2.get(2), (Integer)arrayList2.get(3)), -1);
            arrayList.add((ChargePoint)object2);
        }
        for (n3 = 0; n3 < this.mol.getAtoms(); ++n3) {
            int n4;
            ArrayList<Integer> arrayList3;
            if (this.alreadyDetected(n3)) continue;
            if (this.mol.getAtomicNo(n3) == 8) {
                int n5;
                if (this.mol.getConnAtoms(n3) == 0 || this.alreadyDetected(n5 = this.mol.getConnAtom(n3, 0))) continue;
                if (IonizableGroupDetector.isPartOfAcid(this.mol, n3)) {
                    if (this.mol.getAtomicNo(n5) == 6) {
                        arrayList3 = new ArrayList();
                        arrayList3.add(n3);
                        arrayList3.add(n5);
                        int n6 = this.mol.getConnAtom(n5, 0);
                        int n7 = this.mol.getConnAtom(n5, 1);
                        n2 = this.mol.getConnAtom(n5, 2);
                        int n8 = n6 != n3 && this.mol.getAtomicNo(n6) == 8 ? n6 : (n = n7 != n3 && this.mol.getAtomicNo(n7) == 8 ? n7 : n2);
                        if (this.alreadyDetected(n)) continue;
                        arrayList3.add(n);
                        this.ionizableGroups.add(arrayList3);
                        object = new ChargePoint(this.mol, n5, new ArrayList<Integer>(), -1);
                        arrayList.add((ChargePoint)object);
                        continue;
                    }
                    if (this.mol.getAtomicNo(n5) == 15) {
                        arrayList3 = new ArrayList();
                        arrayList3.add(n3);
                        arrayList3.add(n5);
                        for (int i = 0; i < this.mol.getConnAtoms(n5); ++i) {
                            int n9 = this.mol.getConnAtom(n5, i);
                            if (this.mol.getAtomicNo(n9) != 8 || n9 == n3 || this.alreadyDetected(n9)) continue;
                            arrayList3.add(n9);
                        }
                        this.ionizableGroups.add(arrayList3);
                        ChargePoint chargePoint = new ChargePoint(this.mol, n5, new ArrayList<Integer>(), -1);
                        arrayList.add(chargePoint);
                        continue;
                    }
                    if (this.mol.getAtomicNo(n5) == 16) {
                        arrayList3 = new ArrayList();
                        arrayList3.add(n3);
                        arrayList3.add(n5);
                        for (int i = 0; i < this.mol.getConnAtoms(n5); ++i) {
                            int n10 = this.mol.getConnAtom(n5, i);
                            if (this.mol.getAtomicNo(n10) != 8 || n10 == n3 || this.alreadyDetected(n10)) continue;
                            arrayList3.add(n10);
                        }
                        this.ionizableGroups.add(arrayList3);
                        ChargePoint chargePoint = new ChargePoint(this.mol, n5, new ArrayList<Integer>(), -1);
                        arrayList.add(chargePoint);
                        continue;
                    }
                }
            } else if (this.mol.getAtomicNo(n3) == 7) {
                if (!this.mol.isAromaticAtom(n3) && this.mol.getConnAtoms(n3) <= 2) {
                    boolean bl = false;
                    for (int i = 0; i < this.mol.getConnAtoms(n3) && !bl; ++i) {
                        int n11 = 0;
                        n2 = this.mol.getConnAtom(n3, i);
                        if (this.alreadyDetected(n2) || this.mol.getAtomicNo(n2) != 6) continue;
                        if (this.mol.getBondOrder(this.mol.getBond(n3, n2)) == 2) {
                            ++n11;
                        }
                        for (n = 0; n < this.mol.getConnAtoms(n2) && !bl; ++n) {
                            int n12 = this.mol.getConnAtom(n2, n);
                            if (this.mol.isAromaticAtom(n12) || n12 == n3 || this.alreadyDetected(n12) || this.mol.getAtomicNo(n12) != 7 || this.mol.getConnAtoms(n12) > 2) continue;
                            if (this.mol.getBondOrder(this.mol.getBond(n2, n12)) == 2) {
                                ++n11;
                            }
                            if (n11 != 1) continue;
                            arrayList3 = new ArrayList();
                            arrayList3.add(n3);
                            arrayList3.add(n2);
                            arrayList3.add(n12);
                            this.ionizableGroups.add(arrayList3);
                            ChargePoint chargePoint = new ChargePoint(this.mol, n2, new ArrayList<Integer>(), 1);
                            arrayList.add(chargePoint);
                            bl = true;
                        }
                    }
                }
                if (this.alreadyDetected(n3)) continue;
                if (AtomFunctionAnalyzer.isBasicNitrogen(this.mol, n3)) {
                    arrayList3 = new ArrayList<Integer>();
                    arrayList3.add(n3);
                    this.ionizableGroups.add(arrayList3);
                    ChargePoint chargePoint = new ChargePoint(this.mol, n3, new ArrayList<Integer>(), 1);
                    arrayList.add(chargePoint);
                    continue;
                }
            }
            if (this.alreadyDetected(n3) || (n4 = this.mol.getAtomCharge(n3)) == 0 || this.hasCounterChargedNeighbour(n3)) continue;
            n4 = n4 > 0 ? 1 : -1;
            ChargePoint chargePoint = new ChargePoint(this.mol, n3, new ArrayList<Integer>(), n4);
            arrayList.add(chargePoint);
        }
        return arrayList;
    }

    public List<ArrayList<Integer>> getIonizableGroups() {
        return this.ionizableGroups;
    }

    private boolean hasCounterChargedNeighbour(int n) {
        for (int i = 0; i < this.mol.getConnAtoms(n); ++i) {
            if (this.mol.getAtomCharge(n) * this.mol.getAtomCharge(this.mol.getConnAtom(n, i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean alreadyDetected(int n) {
        boolean bl = this.ionizableGroups.stream().flatMap(Collection::stream).collect(Collectors.toList()).contains(n);
        return bl;
    }

    private static boolean isPartOfAcid(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.getConnAtoms(n) != 1 || stereoMolecule.getConnBondOrder(n, 0) != 1) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtom(n, 0);
        if (stereoMolecule.getAtomicNo(n2) == 6) {
            int n3 = stereoMolecule.getConnAtoms(n2);
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = stereoMolecule.getConnAtom(n2, i);
                if (n5 == n || stereoMolecule.getAtomicNo(n5) != 8 || stereoMolecule.getBondType(n4 = stereoMolecule.getBond(n2, n5)) != 2) continue;
                return true;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 7) {
            if (stereoMolecule.getAtomCharge(n2) == 1) {
                return true;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 16) {
            int n6 = stereoMolecule.getConnAtoms(n2);
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                int n8;
                int n9 = stereoMolecule.getConnAtom(n2, i);
                if (n9 == n || stereoMolecule.getAtomicNo(n9) != 8 || stereoMolecule.getBondType(n8 = stereoMolecule.getBond(n2, n9)) != 2) continue;
                ++n7;
            }
            if (n7 == 2) {
                return true;
            }
        } else if (AtomFunctionAnalyzer.isAcidicOxygenAtPhosphoricAcid(stereoMolecule, n)) {
            return true;
        }
        return false;
    }
}

