/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.optimization.OptimizerLBFGS;
import com.actelion.research.chem.phesa.EncodeFunctions;
import com.actelion.research.chem.phesa.EvaluableOverlap;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.ShapeVolume;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.IntStream;

public class PheSAAlignment {
    private ShapeVolume refMolGauss;
    private ShapeVolume molGauss;
    private double ppWeight;
    public static final double TVERSKY_COEFFICIENT = 0.95;

    public PheSAAlignment(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, double d) {
        this.ppWeight = d;
        this.refMolGauss = new MolecularVolume(stereoMolecule);
        this.molGauss = new MolecularVolume(stereoMolecule2);
    }

    public PheSAAlignment(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this(stereoMolecule, stereoMolecule2, 0.5);
    }

    public PheSAAlignment(MolecularVolume molecularVolume, MolecularVolume molecularVolume2) {
        this(molecularVolume, molecularVolume2, 0.5);
    }

    public PheSAAlignment(ShapeVolume shapeVolume, ShapeVolume shapeVolume2, double d) {
        this.ppWeight = d;
        this.refMolGauss = shapeVolume;
        this.molGauss = shapeVolume2;
    }

    public ShapeVolume getRefMolGauss() {
        return this.refMolGauss;
    }

    public ShapeVolume getMolGauss() {
        return this.molGauss;
    }

    public static void rotateMolAroundAxis180(Conformer conformer, axis axis2) {
        IntStream.range(0, conformer.getSize()).forEach(n -> {
            Coordinates coordinates = conformer.getCoordinates(n);
            PheSAAlignment.rotateCoordsAroundAxis180(coordinates, axis2);
        });
    }

    public static void rotateCoordsAroundAxis180(Coordinates coordinates, axis axis2) {
        if (axis2 == axis.X) {
            coordinates.y = -coordinates.y;
            coordinates.z = -coordinates.z;
        } else if (axis2 == axis.Y) {
            coordinates.x = -coordinates.x;
            coordinates.z = -coordinates.z;
        } else {
            coordinates.x = -coordinates.x;
            coordinates.y = -coordinates.y;
        }
    }

    public static double[][] initialTransform(int n) {
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.14, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 3.14, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 3.14, 0.0, 0.0, 0.0}};
        double[][] dArrayArray2 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.14, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 3.14, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 3.14, 0.0, 0.0, 0.0}, {1.57, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.57, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.57, 0.0, 0.0, 0.0}, {-1.21, -1.21, 1.21, 0.0, 0.0, 0.0}, {-1.21, 1.21, -1.21, 0.0, 0.0, 0.0}, {1.21, 1.21, -1.21, 0.0, 0.0, 0.0}, {-1.21, -1.21, -1.21, 0.0, 0.0, 0.0}, {1.21, -1.21, -1.21, 0.0, 0.0, 0.0}};
        switch (n) {
            case 1: {
                return dArrayArray;
            }
            case 2: {
                return dArrayArray2;
            }
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        return dArrayArray3;
    }

    public double getSelfAtomOverlapRef() {
        return this.refMolGauss.getSelfAtomOverlap();
    }

    public double getSelfAtomOverlapFit() {
        return this.molGauss.getSelfAtomOverlap();
    }

    public double getSelfPPOverlapRef() {
        return this.refMolGauss.getSelfPPOverlap();
    }

    public double getSelfPPOverlapFit() {
        return this.molGauss.getSelfPPOverlap();
    }

    public static void rotateMol(Conformer conformer, Quaternion quaternion, double[] dArray) {
        double d = 1.0 / quaternion.normSquared();
        int n = conformer.getSize();
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates = conformer.getCoordinates(i);
            double[][] dArray2 = quaternion.getRotMatrix().getArray();
            coordinates.rotate(dArray2);
            coordinates.scale(d);
            coordinates.add(dArray[0], dArray[1], dArray[2]);
        }
    }

    public static void rotateMol(StereoMolecule stereoMolecule, Quaternion quaternion, double[] dArray) {
        double d = 1.0 / quaternion.normSquared();
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates = stereoMolecule.getCoordinates(i);
            double[][] dArray2 = quaternion.getRotMatrix().getArray();
            coordinates.rotate(dArray2);
            coordinates.scale(d);
            coordinates.add(dArray[0], dArray[1], dArray[2]);
        }
    }

    public static void rotateMol(StereoMolecule stereoMolecule, double[][] dArray) {
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates = stereoMolecule.getCoordinates(i);
            coordinates.rotate(dArray);
        }
    }

    public static void rotateMol(Conformer conformer, double[][] dArray) {
        int n = conformer.getMolecule().getAllAtoms();
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates = conformer.getCoordinates(i);
            coordinates.rotate(dArray);
        }
    }

    public static void translateMol(StereoMolecule stereoMolecule, double[] dArray) {
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            Coordinates coordinates = stereoMolecule.getCoordinates(i);
            coordinates.x += dArray[0];
            coordinates.y += dArray[1];
            coordinates.z += dArray[2];
        }
    }

    public static void multiplyMatrix(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        dArray3[0][0] = dArray[0][0] * dArray2[0][0] + dArray[0][1] * dArray2[1][0] + dArray[0][2] * dArray2[2][0];
        dArray3[0][1] = dArray[0][0] * dArray2[0][1] + dArray[0][1] * dArray2[1][1] + dArray[0][2] * dArray2[2][1];
        dArray3[0][2] = dArray[0][0] * dArray2[0][2] + dArray[0][1] * dArray2[1][2] + dArray[0][2] * dArray2[2][2];
        dArray3[1][0] = dArray[1][0] * dArray2[0][0] + dArray[1][1] * dArray2[1][0] + dArray[1][2] * dArray2[2][0];
        dArray3[1][1] = dArray[1][0] * dArray2[0][1] + dArray[1][1] * dArray2[1][1] + dArray[1][2] * dArray2[2][1];
        dArray3[1][2] = dArray[1][0] * dArray2[0][2] + dArray[1][1] * dArray2[1][2] + dArray[1][2] * dArray2[2][2];
        dArray3[2][0] = dArray[2][0] * dArray2[0][0] + dArray[2][1] * dArray2[1][0] + dArray[2][2] * dArray2[2][0];
        dArray3[2][1] = dArray[2][0] * dArray2[0][1] + dArray[2][1] * dArray2[1][1] + dArray[2][2] * dArray2[2][1];
        dArray3[2][2] = dArray[2][0] * dArray2[0][2] + dArray[2][1] * dArray2[1][2] + dArray[2][2] * dArray2[2][2];
    }

    public static void multiplyInverseMatrix(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        dArray3[0][0] = dArray[0][0] * dArray2[0][0] + dArray[0][1] * dArray2[0][1] + dArray[0][2] * dArray2[0][2];
        dArray3[0][1] = dArray[0][0] * dArray2[1][0] + dArray[0][1] * dArray2[1][1] + dArray[0][2] * dArray2[1][2];
        dArray3[0][2] = dArray[0][0] * dArray2[2][0] + dArray[0][1] * dArray2[2][1] + dArray[0][2] * dArray2[2][2];
        dArray3[1][0] = dArray[1][0] * dArray2[0][0] + dArray[1][1] * dArray2[0][1] + dArray[1][2] * dArray2[0][2];
        dArray3[1][1] = dArray[1][0] * dArray2[1][0] + dArray[1][1] * dArray2[1][1] + dArray[1][2] * dArray2[1][2];
        dArray3[1][2] = dArray[1][0] * dArray2[2][0] + dArray[1][1] * dArray2[2][1] + dArray[1][2] * dArray2[2][2];
        dArray3[2][0] = dArray[2][0] * dArray2[0][0] + dArray[2][1] * dArray2[0][1] + dArray[2][2] * dArray2[0][2];
        dArray3[2][1] = dArray[2][0] * dArray2[1][0] + dArray[2][1] * dArray2[1][1] + dArray[2][2] * dArray2[1][2];
        dArray3[2][2] = dArray[2][0] * dArray2[2][0] + dArray[2][1] * dArray2[2][1] + dArray[2][2] * dArray2[2][2];
    }

    public static void getRotationMatrix(double d, Coordinates coordinates, double[][] dArray) {
        double d2 = coordinates.x;
        double d3 = coordinates.y;
        double d4 = coordinates.z;
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = 1.0 - d5;
        dArray[0][0] = d5 + d2 * d2 * d7;
        dArray[1][0] = d2 * d3 * d7 - d4 * d6;
        dArray[2][0] = d2 * d4 * d7 + d3 * d6;
        dArray[0][1] = d2 * d3 * d7 + d4 * d6;
        dArray[1][1] = d5 + d3 * d3 * d7;
        dArray[2][1] = d3 * d4 * d7 - d2 * d6;
        dArray[0][2] = d4 * d2 * d7 - d3 * d6;
        dArray[1][2] = d4 * d3 * d7 + d2 * d6;
        dArray[2][2] = d5 + d4 * d4 * d7;
    }

    public double[] findAlignment(double[][] dArray, TransformationSequence transformationSequence) {
        return this.findAlignment(dArray, transformationSequence, true);
    }

    public double[] findAlignment(double[][] dArray, TransformationSequence transformationSequence, boolean bl) {
        return this.findAlignment(dArray, transformationSequence, bl, PheSAAlignmentOptimizer.SimilarityMode.TANIMOTO);
    }

    public double[] findAlignment(double[][] dArray, TransformationSequence transformationSequence, boolean bl, PheSAAlignmentOptimizer.SimilarityMode similarityMode) {
        boolean bl2 = true;
        if (similarityMode == PheSAAlignmentOptimizer.SimilarityMode.TANIMOTO) {
            bl2 = false;
        }
        double d = similarityMode == PheSAAlignmentOptimizer.SimilarityMode.TVERSKY ? 0.95 : 0.050000000000000044;
        double d2 = this.getSelfAtomOverlapRef();
        double d3 = this.getSelfAtomOverlapFit();
        double d4 = this.getSelfPPOverlapRef();
        double d5 = this.getSelfPPOverlapFit();
        EvaluableOverlap evaluableOverlap = new EvaluableOverlap(this, new double[6], this.ppWeight);
        OptimizerLBFGS optimizerLBFGS = new OptimizerLBFGS(200, 0.001);
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double[] dArray2 = new double[6];
        for (double[] object2 : dArray) {
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            evaluableOverlap.setState(object2);
            double[] dArray3 = bl ? optimizerLBFGS.optimize(evaluableOverlap) : object2;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            d14 = this.refMolGauss.getTotalPPOverlap(dArray3, this.molGauss);
            d10 = this.getRefMolGauss().getPPGaussians().size() == 0 && this.getMolGauss().getPPGaussians().size() == 0 ? 1.0 : (bl2 ? d14 / (d * d5 + (1.0 - d) * d4) : d14 / (d4 + d5 - d14));
            double d16 = (double)this.refMolGauss.getPPGaussians().size() / this.refMolGauss.getPPGaussians().stream().mapToDouble(pPGaussian -> pPGaussian.getWeight()).sum();
            d10 *= d16;
            if (d10 > 1.0) {
                d10 = 1.0;
            }
            double[] dArray4 = this.refMolGauss.getTotalAtomOverlap(dArray3, this.molGauss);
            d13 = dArray4[0];
            double d17 = dArray4[1];
            d11 = bl2 ? d13 / (d * d3 + (1.0 - d) * d2) : d13 / (d2 + d3 - d13);
            if (!bl2 && d11 > 1.0) {
                d11 = 1.0;
            }
            d12 = d17 / d13;
            d15 = (1.0 - this.ppWeight) * d11 + this.ppWeight * d10;
            if (!(d15 > d6)) continue;
            d6 = d15;
            d8 = d12;
            d9 = d11;
            d7 = d10;
            dArray2 = dArray3;
        }
        Object object4 = new ExponentialMap(dArray2[0], dArray2[1], dArray2[2]);
        Quaternion quaternion = ((ExponentialMap)object4).toQuaternion();
        Translation translation = new Translation(new double[]{dArray2[3], dArray2[4], dArray2[5]});
        TransformationSequence transformationSequence2 = new TransformationSequence(quaternion);
        transformationSequence2.addTransformation(translation);
        for (Transformation transformation : transformationSequence2.getTransformations()) {
            transformationSequence.addTransformation(transformation);
        }
        if (!bl2 && d6 > 1.0) {
            d6 = 1.0;
        }
        return Arrays.stream(new double[]{d6, d7, d9, d8}).toArray();
    }

    public static class PheSAResult
    implements Comparable<PheSAResult> {
        private StereoMolecule refMol;
        private StereoMolecule fitMol;
        private StereoMolecule fitInput;
        private double sim;
        private double[] contributions;
        private static final String DELIMITER = ";";

        public PheSAResult(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, StereoMolecule stereoMolecule3, double d) {
            this.refMol = stereoMolecule;
            this.fitMol = stereoMolecule3;
            this.sim = d;
            this.contributions = new double[4];
            this.fitInput = stereoMolecule2;
        }

        public void setFitInput(StereoMolecule stereoMolecule) {
            this.fitInput = stereoMolecule;
        }

        public StereoMolecule getRefMol() {
            return this.refMol;
        }

        public StereoMolecule getFitMol() {
            return this.fitMol;
        }

        public double getSim() {
            return this.sim;
        }

        public void setContributions(double[] dArray) {
            this.contributions = dArray;
        }

        public double[] getContributions() {
            return this.contributions;
        }

        public String encode() {
            Base64.Encoder encoder = Base64.getEncoder();
            StringBuilder stringBuilder = new StringBuilder();
            Canonizer canonizer = new Canonizer(this.refMol, 64);
            String string = canonizer.getEncodedCoordinates(true);
            String string2 = canonizer.getIDCode();
            stringBuilder.append(string2);
            stringBuilder.append(DELIMITER);
            stringBuilder.append(string);
            stringBuilder.append(DELIMITER);
            Canonizer canonizer2 = new Canonizer(this.fitMol, 64);
            String string3 = canonizer2.getEncodedCoordinates(true);
            String string4 = canonizer2.getIDCode();
            stringBuilder.append(string4);
            stringBuilder.append(DELIMITER);
            stringBuilder.append(string3);
            stringBuilder.append(DELIMITER);
            stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleToByteArray(this.sim)));
            stringBuilder.append(DELIMITER);
            stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleArrayToByteArray(this.contributions)));
            stringBuilder.append(DELIMITER);
            stringBuilder.append(this.fitInput.getIDCode());
            return stringBuilder.toString();
        }

        public static PheSAResult decode(String string) {
            Base64.Decoder decoder = Base64.getDecoder();
            String[] stringArray = string.split(DELIMITER);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            StereoMolecule stereoMolecule = new StereoMolecule();
            IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            iDCodeParserWithoutCoordinateInvention.parse(stereoMolecule, string2, string3);
            stereoMolecule.ensureHelperArrays(31);
            string2 = stringArray[2];
            string3 = stringArray[3];
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            iDCodeParserWithoutCoordinateInvention.parse(stereoMolecule2, string2, string3);
            stereoMolecule2.ensureHelperArrays(31);
            double d = EncodeFunctions.byteArrayToDouble(decoder.decode(stringArray[4].getBytes()));
            double[] dArray = EncodeFunctions.byteArrayToDoubleArray(decoder.decode(stringArray[5].getBytes()));
            StereoMolecule stereoMolecule3 = new StereoMolecule();
            new IDCodeParser().parse(stereoMolecule3, stringArray[6]);
            PheSAResult pheSAResult = new PheSAResult(stereoMolecule, stereoMolecule3, stereoMolecule2, d);
            pheSAResult.setContributions(dArray);
            return pheSAResult;
        }

        @Override
        public int compareTo(PheSAResult pheSAResult) {
            return Double.compare(this.sim, pheSAResult.sim);
        }
    }

    public static enum axis {
        X,
        Y,
        Z;

    }
}

