/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.optimization;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.DockingUtils;
import java.util.Random;

public class MCHelper {
    private BondRotationHelper torsionHelper;
    private int[] mcsRotBondIndeces;
    private Random random;
    private static double TEMPERATURE = 0.0043;
    private static double MOVE_AMPLITUDE = 2.0;

    public MCHelper(BondRotationHelper bondRotationHelper, int[] nArray, Random random) {
        this.torsionHelper = bondRotationHelper;
        this.mcsRotBondIndeces = nArray;
        this.random = random;
    }

    public void randomPerturbation(Conformer conformer, double[] dArray) {
        if (this.mcsRotBondIndeces == null) {
            int n = (int)(3.0 * this.random.nextDouble());
            if (n == 0) {
                Coordinates coordinates = DockingUtils.randomVectorInSphere(this.random).scale(MOVE_AMPLITUDE);
                dArray[0] = dArray[0] + coordinates.x;
                dArray[1] = dArray[1] + coordinates.y;
                dArray[2] = dArray[2] + coordinates.z;
            } else if (n == 1) {
                Object object;
                double d = this.getGyrationRadius(conformer);
                Coordinates coordinates = DockingUtils.randomVectorInSphere(this.random).scale(MOVE_AMPLITUDE / d);
                double d2 = coordinates.dist();
                Quaternion quaternion = new Quaternion(1.0, 0.0, 0.0, 0.0);
                if (d2 > 1.0E-4) {
                    object = coordinates.scale(1.0 / d2);
                    quaternion = new Quaternion((Coordinates)object, d2);
                }
                object = new ExponentialMap(dArray[3], dArray[4], dArray[5]);
                Quaternion quaternion2 = ((ExponentialMap)object).toQuaternion();
                quaternion.multiply(quaternion2);
                ExponentialMap exponentialMap = new ExponentialMap(quaternion);
                dArray[3] = exponentialMap.getP().x;
                dArray[4] = exponentialMap.getP().y;
                dArray[5] = exponentialMap.getP().z;
            } else {
                this.torsionPerturbation(conformer, dArray);
            }
        } else {
            if (this.torsionHelper.getRotatableBonds().length == 0) {
                return;
            }
            if (this.mcsRotBondIndeces.length == 0) {
                return;
            }
            double d = this.random.nextDouble();
            double d3 = this.random.nextBoolean() ? d : -(d *= 180.0);
            d3 = d3 * Math.PI / 180.0;
            int n = this.mcsRotBondIndeces[this.random.nextInt(this.mcsRotBondIndeces.length)];
            double d4 = dArray[6 + n];
            double d5 = d4 + d3;
            if (d5 > Math.PI) {
                d5 -= Math.PI * 2;
            }
            dArray[6 + n] = d5;
        }
    }

    public void torsionPerturbation(Conformer conformer, double[] dArray) {
        if (this.torsionHelper.getRotatableBonds().length == 0) {
            return;
        }
        double d = this.random.nextDouble();
        double d2 = this.random.nextBoolean() ? d : -(d *= 180.0);
        d2 = d2 * Math.PI / 180.0;
        int n = this.random.nextInt(this.torsionHelper.getRotatableBonds().length);
        double d3 = dArray[6 + n];
        double d4 = d3 + d2;
        if (d4 > Math.PI) {
            d4 -= Math.PI * 2;
        }
        dArray[6 + n] = d4;
    }

    public double getGyrationRadius(Conformer conformer) {
        Coordinates coordinates = DockingUtils.getCOM(conformer);
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < conformer.getMolecule().getAtoms(); ++i) {
            Coordinates coordinates2 = conformer.getCoordinates(i);
            d += coordinates2.distanceSquared(coordinates);
            ++n;
        }
        return Math.sqrt(d /= (double)n);
    }

    public void setTorsionHelper(BondRotationHelper bondRotationHelper) {
        this.torsionHelper = bondRotationHelper;
    }

    public void setMcsRotBondIndeces(int[] nArray) {
        this.mcsRotBondIndeces = nArray;
    }

    public boolean accept(double d, double d2) {
        boolean bl = false;
        if (d2 > d) {
            bl = true;
        } else {
            double d3 = -(d2 - d);
            double d4 = Math.exp(-d3 / TEMPERATURE);
            double d5 = this.random.nextDouble();
            if (d5 < d4) {
                bl = true;
            }
        }
        return bl;
    }
}

