/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.mmp.MMPEnumerator;
import com.actelion.research.chem.mmp.MMPFragmenter;
import com.actelion.research.chem.mmp.MMPFragments;
import com.actelion.research.chem.mmp.MMPUniqueFragments;
import com.actelion.research.chem.mmp.MMPairs;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class MMP {
    private static String VERSION = "1.1";
    private static final String r1H = MMPFragmenter.createR1HMoleculeID();
    private static final boolean TRANSFORM_UM_TO_PIC50 = true;
    private int maxValueAtoms = 0;
    private MMPairs matchedMolecularPairs;
    private HashMap<Integer, HashMap<String, ArrayList<int[]>>> mMPIndex = new HashMap();
    private HashMap<String, ArrayList<MoleculeIndex>> wholeMoleculesIndex = new LinkedHashMap<String, ArrayList<MoleculeIndex>>();
    private List<List<String[]>> moleculesFragmentsID = new ArrayList<List<String[]>>();
    private MMPUniqueFragments mmpUniqueFragments;
    private MMPFragments mmpFragments;
    private int r1HIndex;
    private String[] fieldNames;
    private boolean[] fieldNumerics;
    private float[] fieldPercentiles5;
    private float[] fieldPercentiles95;
    private int moleculesRowCount = 0;
    private String datasetName;

    private static String getDateAndTime() {
        return new SimpleDateFormat("d-MMM-yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    private static boolean isNumeric(String string) {
        if (string == null) {
            return true;
        }
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private HashMap<String, ArrayList<int[]>> getIndex(int n) {
        if (this.mMPIndex.containsKey(n)) {
            return this.mMPIndex.get(n);
        }
        return null;
    }

    private boolean addValues(int n, String string, int[] nArray, boolean bl) {
        boolean bl2 = true;
        HashMap<Object, Object> hashMap = null;
        ArrayList<int[]> arrayList = null;
        hashMap = this.mMPIndex.containsKey(n) ? this.mMPIndex.get(n) : new HashMap();
        if (hashMap.containsKey(string)) {
            arrayList = (ArrayList<int[]>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<int[]>();
            }
            if (bl && !arrayList.isEmpty()) {
                int[] nArray2 = (int[])arrayList.get(arrayList.size() - 1);
                if (nArray2[0] != this.r1HIndex) {
                    arrayList.add(nArray);
                } else {
                    bl2 = false;
                }
            } else {
                arrayList.add(nArray);
            }
        } else {
            arrayList = new ArrayList<int[]>();
            arrayList.add(nArray);
        }
        hashMap.put(string, arrayList);
        this.mMPIndex.put(n, hashMap);
        return bl2;
    }

    public MMP(String string, CompoundFileParser compoundFileParser, boolean bl) throws IOException {
        int n;
        int[][] nArray;
        int n2;
        this.matchedMolecularPairs = new MMPairs();
        this.mmpUniqueFragments = new MMPUniqueFragments();
        this.r1HIndex = this.mmpUniqueFragments.addFragment(r1H, 0, null);
        this.mmpFragments = new MMPFragments();
        this.fieldNames = compoundFileParser.getFieldNames();
        this.fieldNumerics = new boolean[this.fieldNames.length];
        this.fieldPercentiles5 = new float[this.fieldNames.length];
        this.fieldPercentiles95 = new float[this.fieldNames.length];
        IDCodeParser iDCodeParser = new IDCodeParser();
        boolean bl2 = compoundFileParser.getClass().getName().contains("SDFileParser");
        ArrayList[] arrayListArray = new ArrayList[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        Arrays.fill(this.fieldNumerics, true);
        this.datasetName = string;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        int n3 = 0;
        if (bl) {
            if (compoundFileParser.getRowCount() != -1) {
                System.out.println(MMP.getDateAndTime() + ": fragmenting " + compoundFileParser.getRowCount() + " molecules...");
            } else {
                System.out.println(MMP.getDateAndTime() + ": fragmenting molecules...");
            }
        }
        while (compoundFileParser.next()) {
            StereoMolecule stereoMolecule = compoundFileParser.getMolecule();
            stereoMolecule.stripSmallFragments();
            String string2 = compoundFileParser.getMoleculeName() == null ? stereoMolecule.getName() : compoundFileParser.getMoleculeName();
            String string3 = compoundFileParser.getIDCode();
            String[] stringArray = compoundFileParser.getCoordinates();
            if (bl2) {
                iDCodeParser.parse(stereoMolecule, string3);
            }
            String[] stringArray2 = new String[this.fieldNames.length];
            for (int i = 0; i < this.fieldNames.length; ++i) {
                float f;
                if (!this.fieldNumerics[i]) continue;
                String string4 = compoundFileParser.getFieldData(i);
                if (string4 == null || string4.equals("N/A") || string4.equals("?")) {
                    string4 = null;
                } else if (string4.charAt(0) == '\ufffd') {
                    string4 = null;
                }
                stringArray2[i] = string4;
                if (!(MMP.isNumeric(string4) || MMP.isNumeric(string4.substring(1)) || MMP.isNumeric(string4.substring(2)))) {
                    this.fieldNumerics[i] = false;
                    continue;
                }
                if (string4 != null && MMP.isNumeric(string4)) {
                    if (this.fieldNames[i].endsWith("_uM")) {
                        f = MMP.round((float)(-Math.log10((double)Float.parseFloat(string4) * 1.0E-6)), 3);
                        stringArray2[i] = string4 = Float.toString(f);
                        arrayListArray[i].add(Float.valueOf(f));
                        continue;
                    }
                    arrayListArray[i].add(Float.valueOf(Float.parseFloat(string4)));
                    stringArray2[i] = decimalFormat.format(Float.parseFloat(string4));
                    continue;
                }
                if (string4 != null && !string4.startsWith("<") && !string4.startsWith(">")) {
                    this.fieldNumerics[i] = false;
                    continue;
                }
                if (string4 != null && (string4.startsWith("<=") || string4.startsWith(">="))) {
                    if (this.fieldNames[i].endsWith("_uM")) {
                        f = MMP.round((float)(-Math.log10((double)Float.parseFloat(string4.substring(2)) * 1.0E-6)), 3);
                        if (string4.startsWith(">=")) {
                            stringArray2[i] = "<=" + Float.toString(f);
                            continue;
                        }
                        stringArray2[i] = ">=" + Float.toString(f);
                        continue;
                    }
                    stringArray2[i] = string4.substring(0, 2) + decimalFormat.format(Float.parseFloat(string4.substring(2)));
                    continue;
                }
                if (string4 == null || !string4.startsWith("<") && !string4.startsWith(">")) continue;
                if (this.fieldNames[i].endsWith("_uM")) {
                    f = MMP.round((float)(-Math.log10((double)Float.parseFloat(string4.substring(1)) * 1.0E-6)), 3);
                    if (string4.startsWith(">")) {
                        stringArray2[i] = "<" + Float.toString(f);
                        continue;
                    }
                    stringArray2[i] = ">" + Float.toString(f);
                    continue;
                }
                stringArray2[i] = string4.substring(0, 1) + decimalFormat.format(Float.parseFloat(string4.substring(1)));
            }
            ArrayList<Object> arrayList = new ArrayList();
            n2 = n3;
            if (!this.wholeMoleculesIndex.containsKey(string3)) {
                MMPFragmenter mMPFragmenter = new MMPFragmenter(stereoMolecule);
                this.moleculesFragmentsID.add(mMPFragmenter.getMoleculeFragmentsID());
                List<MMPFragmenter.MoleculeIndexID> list = mMPFragmenter.getMoleculeIndexesID(false);
                for (MMPFragmenter.MoleculeIndexID moleculeIndexID : list) {
                    String[] stringArray3 = moleculeIndexID.getKeysID();
                    String string5 = moleculeIndexID.getValueID();
                    int n4 = moleculeIndexID.getValueIDAtoms();
                    int n5 = this.mmpUniqueFragments.addFragment(stringArray3[0]);
                    int n6 = this.mmpUniqueFragments.addFragment(string5);
                    moleculeIndexID.setValueIndex(n6);
                    if (stringArray3.length == 1) {
                        this.addValues(n4, Integer.toString(n5) + "\t", new int[]{n6, n3}, false);
                        moleculeIndexID.setKeysIndex(new int[]{n5});
                    } else {
                        int n7 = this.mmpUniqueFragments.addFragment(stringArray3[1]);
                        this.addValues(n4, Integer.toString(n5) + "\t" + Integer.toString(n7), new int[]{n6, n3}, false);
                        moleculeIndexID.setKeysIndex(new int[]{n5, n7});
                    }
                    this.mmpFragments.addFragments(n3, moleculeIndexID);
                    if (moleculeIndexID.getValueIDAtoms() <= this.maxValueAtoms) continue;
                    this.maxValueAtoms = moleculeIndexID.getValueIDAtoms();
                }
                ++n3;
            } else {
                arrayList = this.wholeMoleculesIndex.get(string3);
                n2 = ((MoleculeIndex)arrayList.get((int)0)).moleculeIndex;
            }
            if (arrayList.size() > 0) {
                arrayList.add(new MoleculeIndex(n2, string2, stringArray2));
            } else {
                arrayList.add(new MoleculeIndex(n2, (String)stringArray, string3, string2, stringArray2));
            }
            this.wholeMoleculesIndex.put(string3, arrayList);
            ++this.moleculesRowCount;
            if (!bl) continue;
            if (this.moleculesRowCount % 1000 == 0) {
                System.out.println("# " + this.moleculesRowCount);
                continue;
            }
            if (this.moleculesRowCount % 100 == 0) {
                System.out.print("#");
                continue;
            }
            if (this.moleculesRowCount % 10 != 0) continue;
            System.out.print(".");
        }
        if (bl) {
            System.out.println(" " + this.moleculesRowCount);
            System.out.println(MMP.getDateAndTime() + ": getting percentiles...");
        }
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNumerics[i] || arrayListArray[i].size() <= 0) continue;
            Collections.sort(arrayListArray[i]);
            int n8 = (int)Math.floor(0.05 * (double)arrayListArray[i].size());
            this.fieldPercentiles5[i] = (float)Math.round(0.05f * (float)arrayListArray[i].size()) != 0.05f * (float)arrayListArray[i].size() ? ((Float)arrayListArray[i].get(n8)).floatValue() : (((Float)arrayListArray[i].get(n8)).floatValue() + ((Float)arrayListArray[i].get(n8 + 1)).floatValue()) / 2.0f;
            n8 = (int)Math.floor(0.95 * (double)arrayListArray[i].size());
            this.fieldPercentiles95[i] = (float)Math.round(0.95f * (float)arrayListArray[i].size()) != 0.95f * (float)arrayListArray[i].size() ? ((Float)arrayListArray[i].get(n8)).floatValue() : (((Float)arrayListArray[i].get(n8)).floatValue() + ((Float)arrayListArray[i].get(n8 + 1)).floatValue()) / 2.0f;
        }
        if (bl) {
            System.out.println(MMP.getDateAndTime() + ": processing hydrogen replacements...");
        }
        for (List<String[]> list : this.moleculesFragmentsID) {
            for (String[] stringArray : list) {
                if (!this.wholeMoleculesIndex.containsKey(stringArray[1])) continue;
                int n9 = this.wholeMoleculesIndex.get((Object)stringArray[1]).get((int)0).moleculeIndex;
                int n10 = this.mmpUniqueFragments.addFragment(stringArray[0]);
                n2 = this.addValues(0, Integer.toString(n10) + "\t", new int[]{this.r1HIndex, n9}, true) ? 1 : 0;
                if (n2 == 0) continue;
                MMPFragmenter.MoleculeIndexID moleculeIndexID = new MMPFragmenter.MoleculeIndexID(new String[]{stringArray[0]}, new int[]{n10}, r1H, this.r1HIndex, null, 0, new int[]{-1}, new int[]{-1});
                this.mmpFragments.addFragments(n9, moleculeIndexID);
            }
        }
        if (bl) {
            System.out.print(MMP.getDateAndTime() + ": generating MMPs");
        }
        ++this.maxValueAtoms;
        int n11 = 0;
        if (VERSION == "1.0") {
            nArray = new int[this.maxValueAtoms * (this.maxValueAtoms + 1) / 2 - 1][2];
            for (n = 1; n < this.maxValueAtoms; ++n) {
                int n12 = 0;
                while (n12 <= n) {
                    nArray[n11][0] = n;
                    nArray[n11][1] = n12++;
                    ++n11;
                }
            }
        } else {
            nArray = new int[this.maxValueAtoms * this.maxValueAtoms][2];
            for (n = 0; n < this.maxValueAtoms; ++n) {
                int n13 = 0;
                while (n13 < this.maxValueAtoms) {
                    nArray[n11][0] = n;
                    nArray[n11][1] = n13++;
                    ++n11;
                }
            }
        }
        if (bl) {
            System.out.println(" (" + nArray.length + " combinations)...");
        }
        MMPEnumerator mMPEnumerator = new MMPEnumerator();
        n11 = 0;
        for (int[] nArray2 : nArray) {
            if (nArray2[0] == nArray2[1] && nArray2[0] != 0) {
                mMPEnumerator = new MMPEnumerator(nArray2, this.getIndex(nArray2[0]), null, VERSION);
            } else if (nArray2[0] != nArray2[1]) {
                mMPEnumerator = new MMPEnumerator(nArray2, this.getIndex(nArray2[0]), this.getIndex(nArray2[1]), VERSION);
            }
            HashMap<String, List<String[]>> hashMap = mMPEnumerator.getMMPEnumeration();
            if (hashMap != null && hashMap.size() > 0) {
                this.matchedMolecularPairs.writeMMPEnumeration(hashMap);
            }
            ++n11;
            if (!bl) continue;
            if (n11 % 1000 == 0) {
                System.out.println("# " + n11);
                continue;
            }
            if (n11 % 100 == 0) {
                System.out.print("#");
                continue;
            }
            if (n11 % 10 != 0) continue;
            System.out.print(".");
        }
        compoundFileParser.close();
        if (bl) {
            System.out.println(" " + n11 + "\n" + MMP.getDateAndTime() + ": done.");
        }
    }

    private void writeMolecules(PrintWriter printWriter) {
        String[] stringArray;
        Object object;
        String string;
        String string2 = "moleculeIndex\tidcoordinates2D\tmolecule\tmoleculeName";
        printWriter.println("<molecules>");
        printWriter.println("<column properties>");
        printWriter.println("<columnName=\"moleculeIndex\">");
        printWriter.println("<columnName=\"idcoordinates2D\">");
        printWriter.println("<columnProperty=\"specialType\tidcoordinates2D\">");
        printWriter.println("<columnProperty=\"parent\tmolecule\">");
        printWriter.println("<columnName=\"molecule\">");
        printWriter.println("<columnProperty=\"specialType\tidcode\">");
        printWriter.println("<columnName=\"moleculeName\">");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNumerics[i]) continue;
            if (this.fieldNames[i].endsWith("_uM")) {
                this.fieldNames[i] = "p" + this.fieldNames[i].substring(0, this.fieldNames[i].length() - 3);
            }
            String string3 = this.fieldNames[i];
            string = this.fieldNames[i];
            object = "other";
            stringArray = this.fieldNames[i].split("\t", -1);
            if (stringArray.length > 1) {
                object = stringArray[0];
                string3 = stringArray[1];
                string = stringArray[1];
                if (stringArray.length == 3) {
                    string = stringArray[2];
                }
            }
            printWriter.println("<columnName=\"" + string3 + "\" percentile5=\"" + Math.floor((double)this.fieldPercentiles5[i] * 10.0) / 10.0 + "\" percentile95=\"" + Math.ceil((double)this.fieldPercentiles95[i] * 10.0) / 10.0 + "\" longName=\"" + string + "\" category=\"" + (String)object + "\">");
            string2 = string2 + "\t" + string3;
        }
        printWriter.println("</column properties>");
        printWriter.println(string2);
        for (String string3 : this.wholeMoleculesIndex.keySet()) {
            string = "";
            object = this.wholeMoleculesIndex.get(string3);
            stringArray = object.iterator();
            while (stringArray.hasNext()) {
                MoleculeIndex moleculeIndex = (MoleculeIndex)stringArray.next();
                if (string == "" && moleculeIndex.moleculeIDCoord != null) {
                    string = moleculeIndex.moleculeIDCoord;
                }
                string2 = Integer.toString(moleculeIndex.moleculeIndex) + "\t" + string + "\t" + string3 + "\t" + moleculeIndex.moleculeName;
                for (int i = 0; i < moleculeIndex.moleculeData.length; ++i) {
                    if (!this.fieldNumerics[i]) continue;
                    string2 = moleculeIndex.moleculeData[i] != null ? string2 + "\t" + moleculeIndex.moleculeData[i] : string2 + "\t";
                }
                printWriter.println(string2);
            }
        }
        printWriter.println("</molecules>");
    }

    public void writeMMPFile(PrintWriter printWriter) throws IOException {
        printWriter.println("<matchedmolecularpairs-fileinfo>");
        printWriter.println("<version=\"" + VERSION + "\">");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = new Date();
        printWriter.println("<date=\"" + simpleDateFormat.format(date) + "\">");
        printWriter.println("<dataset=\"" + this.datasetName + "\">");
        printWriter.println("<moleculesrowcount=" + Integer.toString(this.moleculesRowCount) + ">");
        printWriter.println("<mmpuniquefragmentsrowcount=" + Integer.toString(this.mmpUniqueFragments.getUniqueFragmentsCount()) + ">");
        printWriter.println("<mmpfragmentsrowcount=" + Integer.toString(this.mmpFragments.getFragmentsCount()) + ">");
        printWriter.println("<mmprowcount=" + Integer.toString(this.matchedMolecularPairs.getMMPsCount()) + ">");
        printWriter.println("<keysminatoms=\"" + Integer.toString(MMPFragmenter.KEYS_MIN_ATOMS) + "\">");
        printWriter.println("</matchedmolecularpairs-fileinfo>");
        this.writeMolecules(printWriter);
        this.mmpUniqueFragments.writeUniqueFragments(printWriter);
        this.mmpFragments.writeFragments(printWriter);
        this.matchedMolecularPairs.writeMMPs(printWriter);
        printWriter.close();
    }

    private static float round(float f, int n) {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f));
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.floatValue();
    }

    public static class MoleculeIndex {
        int moleculeIndex;
        String moleculeName;
        String[] moleculeData;
        String moleculeIDCode;
        String moleculeIDCoord;

        public MoleculeIndex(int n, String string, String string2, String string3, String[] stringArray) {
            this.moleculeIndex = n;
            this.moleculeIDCoord = string;
            this.moleculeIDCode = string2;
            this.moleculeName = string3;
            this.moleculeData = stringArray;
        }

        public MoleculeIndex(int n, String string, String[] stringArray) {
            this.moleculeIndex = n;
            this.moleculeName = string;
            this.moleculeData = stringArray;
            this.moleculeIDCode = null;
            this.moleculeIDCoord = null;
        }

        public void setIDCode(String string) {
            this.moleculeIDCode = string;
        }

        public void setIDCoord(String string) {
            this.moleculeIDCoord = string;
        }
    }
}

