/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import java.util.ArrayList;
import java.util.List;

class PossibleMappingsFrag2Mol {
    private PossibleMappingsFrag2Mol parent;
    private int indexProcessingArray;
    private int indexAtomFrag;
    private final int[] arrIndexCounterAtomFragRingClosure;
    private int ringClosures;
    private final int[] arrIndexAtomMolMapping;
    private int sizeArrayMappingMolecules;
    private final List<PossibleMappingsFrag2Mol> liChild;

    public PossibleMappingsFrag2Mol(int n, int n2) {
        this.indexProcessingArray = n;
        this.indexAtomFrag = -1;
        this.arrIndexCounterAtomFragRingClosure = new int[8];
        this.arrIndexAtomMolMapping = new int[n2];
        this.sizeArrayMappingMolecules = 0;
        this.ringClosures = 0;
        this.liChild = new ArrayList<PossibleMappingsFrag2Mol>();
    }

    public void reset() {
        this.parent = null;
        this.indexAtomFrag = -1;
        this.ringClosures = 0;
        this.sizeArrayMappingMolecules = 0;
        this.liChild.clear();
    }

    public void resetMappingMolecules() {
        this.sizeArrayMappingMolecules = 0;
    }

    public PossibleMappingsFrag2Mol(int n) {
        this(n, 8);
    }

    public void addChild(PossibleMappingsFrag2Mol possibleMappingsFrag2Mol) {
        possibleMappingsFrag2Mol.setParent(this);
        this.liChild.add(possibleMappingsFrag2Mol);
    }

    public void addIndexMappingAtomMolecule(int n) {
        this.arrIndexAtomMolMapping[this.sizeArrayMappingMolecules] = n;
        ++this.sizeArrayMappingMolecules;
    }

    public void addIndexCounterAtomFragmentRingClosure(int n) {
        this.arrIndexCounterAtomFragRingClosure[this.ringClosures] = n;
        ++this.ringClosures;
    }

    public int getIndexCounterAtomFragmentRingClosure(int n) {
        return this.arrIndexCounterAtomFragRingClosure[n];
    }

    public int getRingClosures() {
        return this.ringClosures;
    }

    public int getIndexAtomFrag() {
        return this.indexAtomFrag;
    }

    public int getChilds() {
        return this.liChild.size();
    }

    public PossibleMappingsFrag2Mol getChild(int n) {
        return this.liChild.get(n);
    }

    public boolean empty() {
        return this.sizeArrayMappingMolecules == 0;
    }

    public int getIndexProcessingArray() {
        return this.indexProcessingArray;
    }

    public int pollIndexMappingAtomMolecule() {
        int n = this.arrIndexAtomMolMapping[this.sizeArrayMappingMolecules - 1];
        --this.sizeArrayMappingMolecules;
        return n;
    }

    public PossibleMappingsFrag2Mol getParent() {
        return this.parent;
    }

    private void setParent(PossibleMappingsFrag2Mol possibleMappingsFrag2Mol) {
        this.parent = possibleMappingsFrag2Mol;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.parent != null) {
            stringBuilder.append("Parent " + this.parent.indexAtomFrag);
            stringBuilder.append(", fragment atom " + this.indexAtomFrag);
        } else {
            stringBuilder.append("No parent, fragment atom " + this.indexAtomFrag);
        }
        stringBuilder.append(", mapping mol atms ");
        for (int i = 0; i < this.sizeArrayMappingMolecules; ++i) {
            stringBuilder.append(this.arrIndexAtomMolMapping[i]);
            if (i >= this.sizeArrayMappingMolecules - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    public void setIndexAtomFrag(int n) {
        this.indexAtomFrag = n;
    }
}

