/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import com.actelion.research.chem.io.pdb.parser.FormulaParser;
import com.actelion.research.chem.io.pdb.parser.HetNameParser;
import com.actelion.research.chem.io.pdb.parser.HetSynonymParser;
import com.actelion.research.chem.io.pdb.parser.ListInteger;
import com.actelion.research.chem.io.pdb.parser.ModelParser;
import com.actelion.research.chem.io.pdb.parser.PDBCoordEntryFile;
import com.actelion.research.chem.io.pdb.parser.RemarkParser;
import com.actelion.research.chem.io.pdb.parser.SiteParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;

public class PDBFileParser {
    public static final String DATE_FORMAT = "dd-MMM-yy";
    public static final String TAG_HEADER = "HEADER";
    public static final String TAG_OBSOLTE = "OBSLTE";
    public static final String TAG_TITLE = "TITLE";
    public static final String TAG_SPLIT = "SPLIT";
    public static final String TAG_CAVEAT = "CAVEAT";
    public static final String TAG_COMPND = "COMPND";
    public static final String TAG_SOURCE = "SOURCE";
    public static final String TAG_KEYWDS = "KEYWDS";
    public static final String TAG_EXPDTA = "EXPDTA";
    public static final String TAG_NUMMDL = "NUMMDL";
    public static final String TAG_MDLTYP = "MDLTYP";
    public static final String TAG_AUTHOR = "AUTHOR";
    public static final String TAG_REVDAT = "REVDAT";
    public static final String TAG_SPRSDE = "SPRSDE";
    public static final String TAG_JRNL = "JRNL";
    public static final String TAG_REMARK = "REMARK";
    public static final String TAG_REMARK0 = "REMARK 0";
    public static final String TAG_REMARK1 = "REMARK 1";
    public static final String TAG_REMARK2 = "REMARK 2";
    public static final String TAG_REMARK3 = "REMARK 3";
    public static final String TAG_REMARK_N = "REMARK N";
    public static final String TAG_DBREF = "DBREF";
    public static final String TAG_DBREF1_DBREF2 = "DBREF1/DBREF2";
    public static final String TAG_SEQADV = "SEQADV";
    public static final String TAG_SEQRES = "SEQRES";
    public static final String TAG_MODRES = "MODRES";
    public static final String TAG_HET = "HET";
    public static final String TAG_HETNAM = "HETNAM";
    public static final String TAG_HETSYN = "HETSYN";
    public static final String TAG_FORMUL = "FORMUL";
    public static final String TAG_HELIX = "HELIX";
    public static final String TAG_SHEET = "SHEET";
    public static final String TAG_SSBOND = "SSBOND";
    public static final String TAG_LINK = "LINK";
    public static final String TAG_CISPEP = "CISPEP";
    public static final String TAG_SITE = "SITE";
    public static final String TAG_CRYST1 = "CRYST1";
    public static final String TAG_ORIGX1 = "ORIGX1";
    public static final String TAG_ORIGX2 = "ORIGX2";
    public static final String TAG_ORIGX3 = "ORIGX3";
    public static final String TAG_SCALE1 = "SCALE1";
    public static final String TAG_SCALE2 = "SCALE2";
    public static final String TAG_SCALE3 = "SCALE3";
    public static final String TAG_MTRIX1 = "MTRIX1";
    public static final String TAG_MTRIX2 = "MTRIX2";
    public static final String TAG_MTRIX3 = "MTRIX3";
    public static final String TAG_MODEL = "MODEL";
    public static final String TAG_ATOM = "ATOM";
    public static final String TAG_ANISOU = "ANISOU";
    public static final String TAG_TER = "TER";
    public static final String TAG_HETATM = "HETATM";
    public static final String TAG_ENDMDL = "ENDMDL";
    public static final String TAG_CONECT = "CONECT";
    public static final String TAG_MASTER = "MASTER";
    public static final String TAG_END = "END";
    private DateFormat dfDateDeposition = new SimpleDateFormat("dd-MMM-yy");
    private RemarkParser remarkParser = new RemarkParser();
    private HetNameParser hetNameParser = new HetNameParser();
    private HetSynonymParser hetSynonymParser = new HetSynonymParser();
    private FormulaParser formulaParser = new FormulaParser();
    private SiteParser siteParser = new SiteParser();
    private ModelParser modelParser = new ModelParser();

    public PDBCoordEntryFile parse(File file) throws IOException, ParseException {
        return this.parse(new BufferedReader(new FileReader(file)));
    }

    public PDBCoordEntryFile parse(BufferedReader bufferedReader) throws IOException, ParseException {
        ListInteger<String> listInteger;
        ListInteger<String> listInteger2;
        String string;
        PDBCoordEntryFile pDBCoordEntryFile = new PDBCoordEntryFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        int n = 0;
        String string2 = (String)arrayList.get(n);
        if (string2.startsWith(TAG_HEADER)) {
            try {
                n = this.parseHeader(string2, pDBCoordEntryFile);
            }
            catch (Exception exception) {
                ++n;
            }
        }
        String string3 = (String)arrayList.get(n);
        while (!string3.startsWith(TAG_ATOM) && !string3.startsWith(TAG_HETATM) && n < arrayList.size() - 1) {
            if (((String)arrayList.get(n)).startsWith(TAG_OBSOLTE)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_OBSOLTE);
                pDBCoordEntryFile.setObsolete((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_TITLE)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_TITLE);
                pDBCoordEntryFile.setTitle((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_SPLIT)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_SPLIT);
                pDBCoordEntryFile.setSplit((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_CAVEAT)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_CAVEAT);
                pDBCoordEntryFile.setSplit((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_COMPND)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_COMPND);
                pDBCoordEntryFile.setCompound((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_SOURCE)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_SOURCE);
                pDBCoordEntryFile.setSource((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_KEYWDS)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_KEYWDS);
                pDBCoordEntryFile.setKeywords((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_EXPDTA)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_EXPDTA);
                pDBCoordEntryFile.setExpdata((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_NUMMDL)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_NUMMDL);
                pDBCoordEntryFile.setNummdl((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_MDLTYP)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_MDLTYP);
                pDBCoordEntryFile.setMdltyp((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_AUTHOR)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_AUTHOR);
                pDBCoordEntryFile.setAuthor((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = (Integer)((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_REVDAT)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_REVDAT);
                pDBCoordEntryFile.setRevdat(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SPRSDE)) {
                listInteger2 = this.parseOneTimeMultipleLines(arrayList, n, TAG_SPRSDE);
                pDBCoordEntryFile.setSprsde((String)((AbstractMap.SimpleEntry)((Object)listInteger2)).getKey());
                n = ((AbstractMap.SimpleEntry)((Object)listInteger2)).getValue();
            }
            if (arrayList.get(n).startsWith(TAG_JRNL)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_JRNL);
                pDBCoordEntryFile.setJrnl(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_DBREF)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_DBREF);
                pDBCoordEntryFile.setDBRef(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_DBREF1_DBREF2)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_DBREF1_DBREF2);
                pDBCoordEntryFile.setDBRef1DBRef2(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SEQADV)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_SEQADV);
                pDBCoordEntryFile.setSEQADV(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SEQRES)) {
                listInteger2 = PDBFileParser.parseMultipleTimesMultipleLinesSEQRES(arrayList, n, TAG_SEQRES);
                pDBCoordEntryFile.setSEQRES(listInteger2.getLi());
                n = listInteger2.getId();
            }
            if (arrayList.get(n).startsWith(TAG_MODRES)) {
                listInteger2 = this.parseMultipleTimesOneLine(arrayList, n, TAG_MODRES);
                pDBCoordEntryFile.setModRes(listInteger2.getLi());
                n = listInteger2.getId();
            }
            listInteger2 = "HET ";
            if (arrayList.get(n).startsWith((String)((Object)listInteger2))) {
                listInteger = this.parseMultipleTimesOneLine((List<String>)arrayList, n, (String)((Object)listInteger2));
                pDBCoordEntryFile.setHet(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_HETNAM)) {
                this.hetNameParser.parse(arrayList, n);
                listInteger = this.hetNameParser.getHMId_Name();
                pDBCoordEntryFile.setHmId_Name((HashMap<String, String>)((Object)listInteger));
                n = this.hetNameParser.getIndexLine();
            }
            if (arrayList.get(n).startsWith(TAG_HETSYN)) {
                this.hetSynonymParser.parse(arrayList, n);
                listInteger = this.hetSynonymParser.getHMId_Synonyms();
                pDBCoordEntryFile.setHmId_Synonyms((HashMap<String, String>)((Object)listInteger));
                n = this.hetSynonymParser.getIndexLine();
            }
            if (arrayList.get(n).startsWith(TAG_FORMUL)) {
                this.formulaParser.parse(arrayList, n);
                listInteger = this.formulaParser.getHMId_Formula();
                pDBCoordEntryFile.setHmId_Formula((HashMap<String, String>)((Object)listInteger));
                n = this.formulaParser.getIndexLine();
            }
            if (arrayList.get(n).startsWith(TAG_HELIX)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_HELIX);
                pDBCoordEntryFile.setHelix(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SHEET)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_SHEET);
                pDBCoordEntryFile.setSheet(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SSBOND)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_SSBOND);
                pDBCoordEntryFile.setSSBond(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_LINK)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_LINK);
                pDBCoordEntryFile.setLink(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_CISPEP)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_CISPEP);
                pDBCoordEntryFile.setCisPep(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_SITE)) {
                this.siteParser.parse(arrayList, n);
                listInteger = this.siteParser.getHMId_Site();
                pDBCoordEntryFile.setHmId_Site((HashMap<String, String>)((Object)listInteger));
                n = this.siteParser.getIndexLine();
            }
            if (arrayList.get(n).startsWith(TAG_CRYST1)) {
                pDBCoordEntryFile.setCryst1(arrayList.get(n).substring(6));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_ORIGX1)) {
                pDBCoordEntryFile.setOrigX1(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_ORIGX2)) {
                pDBCoordEntryFile.setOrigX2(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_ORIGX3)) {
                pDBCoordEntryFile.setOrigX3(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_SCALE1)) {
                pDBCoordEntryFile.setScale1(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_SCALE2)) {
                pDBCoordEntryFile.setScale2(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_SCALE3)) {
                pDBCoordEntryFile.setScale3(arrayList.get(n).substring(10));
                ++n;
            }
            if (arrayList.get(n).startsWith(TAG_MTRIX1)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_MTRIX1);
                pDBCoordEntryFile.setMtrix1(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_MTRIX2)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_MTRIX2);
                pDBCoordEntryFile.setMtrix2(listInteger.getLi());
                n = listInteger.getId();
            }
            if (arrayList.get(n).startsWith(TAG_MTRIX3)) {
                listInteger = this.parseMultipleTimesOneLine(arrayList, n, TAG_MTRIX3);
                pDBCoordEntryFile.setMtrix3(listInteger.getLi());
                n = listInteger.getId();
            } else {
                ++n;
            }
            string3 = arrayList.get(n);
        }
        listInteger2 = new ArrayList<AtomRecord>();
        listInteger = new ArrayList<AtomRecord>();
        this.modelParser.parse((List<String>)arrayList, n, (List<AtomRecord>)((Object)listInteger), (List<AtomRecord>)((Object)listInteger2));
        pDBCoordEntryFile.setProtAtomRecords((List<AtomRecord>)((Object)listInteger));
        pDBCoordEntryFile.setHetAtomRecords((List<AtomRecord>)((Object)listInteger2));
        n = this.modelParser.getIndexLine();
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        if (arrayList.get(n).startsWith(TAG_CONECT)) {
            ListInteger<String> listInteger3 = this.parseMultipleTimesOneLine(arrayList, n, TAG_CONECT);
            for (String string4 : listInteger3.getLi()) {
                string4 = string4.trim();
                String[] stringArray = string4.split("\\s+");
                try {
                    int n3 = Integer.parseInt(stringArray[0]);
                    IntStream.range(1, stringArray.length).forEach(n2 -> {
                        int[] nArray = new int[]{n3, Integer.parseInt(stringArray[n2])};
                        arrayList2.add(nArray);
                    });
                }
                catch (Exception exception) {}
            }
            n = listInteger3.getId();
        }
        pDBCoordEntryFile.setLiConnect(arrayList2);
        if (arrayList.get(n).startsWith(TAG_MASTER)) {
            pDBCoordEntryFile.setMaster(arrayList.get(n).substring(10).trim());
            ++n;
        }
        if (arrayList.get(n).startsWith(TAG_END)) {
            pDBCoordEntryFile.setEnd(true);
        } else {
            pDBCoordEntryFile.setEnd(false);
        }
        return pDBCoordEntryFile;
    }

    private int parseHeader(String string, PDBCoordEntryFile pDBCoordEntryFile) throws ParseException {
        int n = string.length();
        pDBCoordEntryFile.setClassification(string.substring(10, Math.min(n, 50)).trim());
        Date date = this.dfDateDeposition.parse(string.substring(50, Math.min(n, 59)).trim());
        pDBCoordEntryFile.setDateDeposition(date);
        pDBCoordEntryFile.setID(string.substring(62, Math.min(n, 66)).trim());
        return 1;
    }

    private AbstractMap.SimpleEntry<String, Integer> parseOneTimeMultipleLines(List<String> list, int n, String string) throws ParseException {
        int n2;
        String string2;
        String string3 = list.get(n);
        if (!string3.startsWith(string)) {
            throw new RuntimeException("Error in parsing " + string);
        }
        String string4 = string3.substring(string.length()).trim();
        StringBuilder stringBuilder = new StringBuilder(string4);
        for (int i = n2 = ++n; i < list.size() && (string2 = list.get(i)).startsWith(string); ++i) {
            String[] stringArray = string2.split("[ ]+");
            stringBuilder.append(" ");
            for (int j = 1; j < stringArray.length; ++j) {
                stringBuilder.append(stringArray[j]);
                if (j >= stringArray.length - 1) continue;
                stringBuilder.append(" ");
            }
            ++n;
        }
        AbstractMap.SimpleEntry<String, Integer> simpleEntry = new AbstractMap.SimpleEntry<String, Integer>(stringBuilder.toString(), n);
        return simpleEntry;
    }

    private ListInteger<String> parseMultipleTimesOneLine(List<String> list, int n, String string) throws ParseException {
        int n2;
        String string2;
        int n3 = 1;
        String string3 = list.get(n);
        if (!string3.startsWith(string)) {
            throw new RuntimeException("Error in parsing " + string);
        }
        String string4 = string3.substring(string.length()).trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string4);
        for (int i = n2 = ++n; i < list.size() && (string2 = list.get(i)).startsWith(string); ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = string2.split("[ ]+");
            stringBuilder.append(" ");
            for (int j = n3; j < stringArray.length; ++j) {
                stringBuilder.append(stringArray[j]);
                if (j >= stringArray.length - 1) continue;
                stringBuilder.append(" ");
            }
            arrayList.add(stringBuilder.toString());
            ++n;
        }
        ListInteger<String> listInteger = new ListInteger<String>(arrayList, n);
        return listInteger;
    }

    private static ListInteger<String> parseMultipleTimesMultipleLinesSEQRES(List<String> list, int n, String string) throws ParseException {
        String string2;
        String string3 = list.get(n);
        if (!string3.startsWith(string)) {
            throw new RuntimeException("Error in parsing " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        String string4 = string3.substring(11, 12);
        int n3 = Integer.parseInt(string3.substring(13, 17).trim());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n2; i < list.size() && (string2 = list.get(i)).startsWith(string); ++i) {
            String string5;
            String string6 = string2.substring(11, 12);
            int n4 = Integer.parseInt(string2.substring(13, 17).trim());
            if (!string4.equals(string6)) {
                string5 = stringBuilder.toString();
                arrayList.add(string5);
                string4 = string6;
                n3 = n4;
                stringBuilder = new StringBuilder();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            string5 = string2.substring(19).trim();
            stringBuilder.append(string5);
            ++n;
        }
        if (stringBuilder.length() > 0) {
            String string7 = stringBuilder.toString();
            arrayList.add(string7);
        }
        ListInteger<String> listInteger = new ListInteger<String>(arrayList, n);
        return listInteger;
    }
}

