/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import com.actelion.research.chem.io.pdb.parser.StructureAssembler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDBCoordEntryFile {
    private String classification;
    private String pdbID;
    private Date dateDeposition;
    private String obsolete;
    private String title;
    private String split;
    private String caveat;
    private String compound;
    private String source;
    private String keywords;
    private String expdata;
    private String nummdl;
    private String mdltyp;
    private String author;
    private List<String> liRevdat;
    private String sprsde;
    private List<String> liJRNL;
    private HashMap<Integer, String> hmNo_Remark;
    private List<String> liDBRef;
    private List<String> liDBRef1DBRef2;
    private List<String> liSEQADV;
    private List<String> liSEQRES;
    private List<String> liModRes;
    private List<String> liHet;
    private HashMap<String, String> hmId_Name;
    private HashMap<String, String> hmId_Synonyms;
    private HashMap<String, String> hmId_Formula;
    private List<String> liHelix;
    private List<String> liSheet;
    private List<String> liSSBond;
    private List<String> liLink;
    private List<String> liCisPep;
    private HashMap<String, String> hmId_Site;
    private String cryst1;
    private String origX1;
    private String origX2;
    private String origX3;
    private String scale1;
    private String scale2;
    private String scale3;
    private List<String> liMtrix1;
    private List<String> liMtrix2;
    private List<String> liMtrix3;
    private List<AtomRecord> protAtomRecords;
    private List<AtomRecord> hetAtomRecords;
    private List<int[]> liConnect;
    private String master;
    private boolean end;

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String string) {
        this.classification = string;
    }

    public String getID() {
        return this.pdbID;
    }

    public void setID(String string) {
        this.pdbID = string;
    }

    public Date getDateDeposition() {
        return this.dateDeposition;
    }

    public void setDateDeposition(Date date) {
        this.dateDeposition = date;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public List<AtomRecord> getProtAtomRecords() {
        return this.protAtomRecords;
    }

    public void setProtAtomRecords(List<AtomRecord> list) {
        this.protAtomRecords = list;
    }

    public List<AtomRecord> getHetAtomRecords() {
        return this.hetAtomRecords;
    }

    public void setHetAtomRecords(List<AtomRecord> list) {
        this.hetAtomRecords = list;
    }

    public String getObsolete() {
        return this.obsolete;
    }

    public void setObsolete(String string) {
        this.obsolete = string;
    }

    public String getSplit() {
        return this.split;
    }

    public void setSplit(String string) {
        this.split = string;
    }

    public String getCaveat() {
        return this.caveat;
    }

    public void setCaveat(String string) {
        this.caveat = string;
    }

    public String getCompound() {
        return this.compound;
    }

    public void setCompound(String string) {
        this.compound = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public String getExpdata() {
        return this.expdata;
    }

    public void setExpdata(String string) {
        this.expdata = string;
    }

    public String getNummdl() {
        return this.nummdl;
    }

    public void setNummdl(String string) {
        this.nummdl = string;
    }

    public String getMdltyp() {
        return this.mdltyp;
    }

    public void setMdltyp(String string) {
        this.mdltyp = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public List<String> getRevdat() {
        return this.liRevdat;
    }

    public void setRevdat(List<String> list) {
        this.liRevdat = list;
    }

    public String getSprsde() {
        return this.sprsde;
    }

    public void setSprsde(String string) {
        this.sprsde = string;
    }

    public List<String> getJrnl() {
        return this.liJRNL;
    }

    public void setJrnl(List<String> list) {
        this.liJRNL = list;
    }

    public String getRemark0() {
        return this.hmNo_Remark.get(0);
    }

    public String getRemark1() {
        return this.hmNo_Remark.get(1);
    }

    public String getRemark2() {
        return this.hmNo_Remark.get(2);
    }

    public String getRemark3() {
        return this.hmNo_Remark.get(3);
    }

    public void setRemarks(HashMap<Integer, String> hashMap) {
        this.hmNo_Remark = hashMap;
    }

    public String getRemark(int n) {
        return this.hmNo_Remark.get(n);
    }

    public List<Integer> getRemarks() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hmNo_Remark.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getDBRef() {
        return this.liDBRef;
    }

    public void setDBRef(List<String> list) {
        this.liDBRef = list;
    }

    public List<String> getDBRef1DBRef2() {
        return this.liDBRef1DBRef2;
    }

    public void setDBRef1DBRef2(List<String> list) {
        this.liDBRef1DBRef2 = list;
    }

    public List<String> getSEQADV() {
        return this.liSEQADV;
    }

    public void setSEQADV(List<String> list) {
        this.liSEQADV = list;
    }

    public List<String> getSEQRES() {
        return this.liSEQRES;
    }

    public void setSEQRES(List<String> list) {
        this.liSEQRES = list;
    }

    public List<String> getModRes() {
        return this.liModRes;
    }

    public void setModRes(List<String> list) {
        this.liModRes = list;
    }

    public List<String> getHet() {
        return this.liHet;
    }

    public void setHet(List<String> list) {
        this.liHet = list;
    }

    public HashMap<String, String> getHmId_Name() {
        return this.hmId_Name;
    }

    public void setHmId_Name(HashMap<String, String> hashMap) {
        this.hmId_Name = hashMap;
    }

    public List<String> getNameIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.hmId_Name.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getName(String string) {
        return this.hmId_Name.get(string);
    }

    public void setHmId_Synonyms(HashMap<String, String> hashMap) {
        this.hmId_Synonyms = hashMap;
    }

    public List<String> getSynonymIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.hmId_Synonyms.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getSynonyms(String string) {
        return this.hmId_Synonyms.get(string);
    }

    public void setHmId_Formula(HashMap<String, String> hashMap) {
        this.hmId_Formula = hashMap;
    }

    public List<String> getFormulaIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.hmId_Formula.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getFormula(String string) {
        return this.hmId_Formula.get(string);
    }

    public List<String> getHelix() {
        return this.liHelix;
    }

    public void setHelix(List<String> list) {
        this.liHelix = list;
    }

    public List<String> getSheet() {
        return this.liSheet;
    }

    public void setSheet(List<String> list) {
        this.liSheet = list;
    }

    public List<String> getSSBond() {
        return this.liSSBond;
    }

    public void setSSBond(List<String> list) {
        this.liSSBond = list;
    }

    public List<String> getLink() {
        return this.liLink;
    }

    public void setLink(List<String> list) {
        this.liLink = list;
    }

    public List<String> getCisPep() {
        return this.liCisPep;
    }

    public void setCisPep(List<String> list) {
        this.liCisPep = list;
    }

    public void setHmId_Site(HashMap<String, String> hashMap) {
        this.hmId_Site = hashMap;
    }

    public List<String> getSiteIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.hmId_Site.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getSite(String string) {
        return this.hmId_Site.get(string);
    }

    public String getCryst1() {
        return this.cryst1;
    }

    public void setCryst1(String string) {
        this.cryst1 = string;
    }

    public String getOrigX1() {
        return this.origX1;
    }

    public void setOrigX1(String string) {
        this.origX1 = string;
    }

    public String getOrigX2() {
        return this.origX2;
    }

    public void setOrigX2(String string) {
        this.origX2 = string;
    }

    public String getOrigX3() {
        return this.origX3;
    }

    public void setOrigX3(String string) {
        this.origX3 = string;
    }

    public String getScale1() {
        return this.scale1;
    }

    public void setScale1(String string) {
        this.scale1 = string;
    }

    public String getScale2() {
        return this.scale2;
    }

    public void setScale2(String string) {
        this.scale2 = string;
    }

    public String getScale3() {
        return this.scale3;
    }

    public void setScale3(String string) {
        this.scale3 = string;
    }

    public List<String> getMtrix1() {
        return this.liMtrix1;
    }

    public void setMtrix1(List<String> list) {
        this.liMtrix1 = list;
    }

    public List<String> getMtrix2() {
        return this.liMtrix2;
    }

    public void setMtrix2(List<String> list) {
        this.liMtrix2 = list;
    }

    public List<String> getMtrix3() {
        return this.liMtrix3;
    }

    public void setMtrix3(List<String> list) {
        this.liMtrix3 = list;
    }

    public List<int[]> getLiConnect() {
        return this.liConnect;
    }

    public void setLiConnect(List<int[]> list) {
        this.liConnect = list;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String string) {
        this.master = string;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean bl) {
        this.end = bl;
    }

    public Map<String, List<Molecule3D>> extractMols() {
        StructureAssembler structureAssembler = new StructureAssembler(this.liConnect, this.protAtomRecords, this.hetAtomRecords);
        return structureAssembler.assemble();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PDBCoordEntryFile{");
        stringBuilder.append("classification='").append(this.classification).append('\'');
        stringBuilder.append(", pdbID'").append(this.pdbID).append('\'');
        stringBuilder.append(", dateDeposition=").append(this.dateDeposition);
        stringBuilder.append(", obsolete='").append(this.obsolete).append('\'');
        stringBuilder.append(", title='").append(this.title).append('\'');
        stringBuilder.append(", split='").append(this.split).append('\'');
        stringBuilder.append(", caveat='").append(this.caveat).append('\'');
        stringBuilder.append(", compound='").append(this.compound).append('\'');
        stringBuilder.append(", source='").append(this.source).append('\'');
        stringBuilder.append(", keywords='").append(this.keywords).append('\'');
        stringBuilder.append(", expdata='").append(this.expdata).append('\'');
        stringBuilder.append(", nummdl='").append(this.nummdl).append('\'');
        stringBuilder.append(", mdltyp='").append(this.mdltyp).append('\'');
        stringBuilder.append(", author='").append(this.author).append('\'');
        stringBuilder.append(", revdat='").append(this.liRevdat).append('\'');
        stringBuilder.append(", sprsde='").append(this.sprsde).append('\'');
        stringBuilder.append(", jrnl='").append(this.liJRNL).append('\'');
        List<Integer> list = this.getRemarks();
        for (int n : list) {
            String string = this.getRemark(n);
            stringBuilder.append(", remark");
            stringBuilder.append(n);
            stringBuilder.append("='").append(string).append('\'');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

