/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.converter;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.pdb.converter.GeometryCalculator;
import java.util.Set;
import java.util.TreeSet;

public class MoleculeGrid {
    protected final StereoMolecule mol;
    protected final double gridWidth;
    protected final Coordinates min;
    protected final Coordinates max;
    protected final int[] gridSize = new int[3];
    protected final Set<Integer>[][][] grid;

    public MoleculeGrid(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 1.1, new Coordinates(0.0, 0.0, 0.0));
    }

    public MoleculeGrid(StereoMolecule stereoMolecule, double d, Coordinates coordinates) {
        this.mol = stereoMolecule;
        this.gridWidth = d;
        Coordinates[] coordinatesArray = GeometryCalculator.getBounds(stereoMolecule);
        this.min = coordinatesArray[0];
        this.max = coordinatesArray[1];
        this.min.x -= coordinates.x;
        this.min.y -= coordinates.y;
        this.min.z -= coordinates.z;
        this.max.x += coordinates.x;
        this.max.y += coordinates.y;
        this.max.z += coordinates.z;
        this.gridSize[0] = (int)((this.max.x - this.min.x) / d) + 1;
        this.gridSize[1] = (int)((this.max.y - this.min.y) / d) + 1;
        this.gridSize[2] = (int)((this.max.z - this.min.z) / d) + 1;
        this.grid = new Set[Math.max(0, this.gridSize[0])][Math.max(0, this.gridSize[1])][Math.max(0, this.gridSize[2])];
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = (int)((stereoMolecule.getAtomX(i) - this.min.x) / d);
            if (this.grid[n4][n3 = (int)((stereoMolecule.getAtomY(i) - this.min.y) / d)][n2 = (int)((stereoMolecule.getAtomZ(i) - this.min.z) / d)] == null) {
                this.grid[n4][n3][n2] = new TreeSet<Integer>();
            }
            this.grid[n4][n3][n2].add(i);
        }
    }

    public Set<Integer> getNeighbours(Coordinates coordinates, double d) {
        int n = (int)(d / this.gridWidth) + 1;
        int n2 = (int)((coordinates.x - this.min.x) / this.gridWidth);
        int n3 = (int)((coordinates.y - this.min.y) / this.gridWidth);
        int n4 = (int)((coordinates.z - this.min.z) / this.gridWidth);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = Math.max(0, n2 - n); i <= Math.min(this.gridSize[0] - 1, n2 + n); ++i) {
            for (int j = Math.max(0, n3 - n); j <= Math.min(this.gridSize[1] - 1, n3 + n); ++j) {
                for (int k = Math.max(0, n4 - n); k <= Math.min(this.gridSize[2] - 1, n4 + n); ++k) {
                    if (this.grid[i][j][k] == null) continue;
                    treeSet.addAll(this.grid[i][j][k]);
                }
            }
        }
        return treeSet;
    }

    public Set<Integer> getNeighbours(Coordinates coordinates, double d, boolean bl) {
        return this.getNeighbours(coordinates, d, bl, -1);
    }

    public Set<Integer> getNeighbours(Coordinates coordinates, double d, boolean bl, int n) {
        int n2 = (int)(d / this.gridWidth) + 1;
        int n3 = (int)((coordinates.x - this.min.x) / this.gridWidth);
        int n4 = (int)((coordinates.y - this.min.y) / this.gridWidth);
        int n5 = (int)((coordinates.z - this.min.z) / this.gridWidth);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = Math.max(0, n3 - n2); i <= Math.min(this.gridSize[0] - 1, n3 + n2); ++i) {
            for (int j = Math.max(0, n4 - n2); j <= Math.min(this.gridSize[1] - 1, n4 + n2); ++j) {
                for (int k = Math.max(0, n5 - n2); k <= Math.min(this.gridSize[2] - 1, n5 + n2); ++k) {
                    if (this.grid[i][j][k] == null) continue;
                    if (bl) {
                        for (int n6 : this.grid[i][j][k]) {
                            if (this.mol.getCoordinates(n6).distSquareTo(coordinates) > d * d) continue;
                            treeSet.add(n6);
                        }
                        continue;
                    }
                    treeSet.addAll(this.grid[i][j][k]);
                }
            }
        }
        return treeSet;
    }

    public boolean hasNeighbours(Coordinates coordinates, double d) {
        int n = (int)(d / this.gridWidth) + 1;
        int n2 = (int)((coordinates.x - this.min.x) / this.gridWidth);
        int n3 = (int)((coordinates.y - this.min.y) / this.gridWidth);
        int n4 = (int)((coordinates.z - this.min.z) / this.gridWidth);
        for (int i = Math.max(0, n2 - n); i <= Math.min(this.gridSize[0] - 1, n2 + n); ++i) {
            for (int j = Math.max(0, n3 - n); j <= Math.min(this.gridSize[1] - 1, n3 + n); ++j) {
                for (int k = Math.max(0, n4 - n); k <= Math.min(this.gridSize[2] - 1, n4 + n); ++k) {
                    if (this.grid[i][j][k] == null) continue;
                    for (int n5 : this.grid[i][j][k]) {
                        if (!(this.mol.getCoordinates(n5).distSquareTo(coordinates) <= d * d)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Set<Integer> getNeighbours(Coordinates[] coordinatesArray, double d) {
        int n = (int)(d / this.gridWidth) + 1;
        int n2 = (int)((coordinatesArray[0].x - this.min.x) / this.gridWidth);
        int n3 = (int)((coordinatesArray[0].y - this.min.y) / this.gridWidth);
        int n4 = (int)((coordinatesArray[0].z - this.min.z) / this.gridWidth);
        int n5 = (int)((coordinatesArray[1].x - this.min.x) / this.gridWidth);
        int n6 = (int)((coordinatesArray[1].y - this.min.y) / this.gridWidth);
        int n7 = (int)((coordinatesArray[1].z - this.min.z) / this.gridWidth);
        int n8 = Math.min(n2, n5);
        int n9 = Math.max(n2, n5);
        int n10 = Math.min(n3, n6);
        int n11 = Math.max(n3, n6);
        int n12 = Math.min(n4, n7);
        int n13 = Math.max(n4, n7);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = Math.max(0, n8 - n); i <= Math.min(this.gridSize[0] - 1, n9 + n); ++i) {
            for (int j = Math.max(0, n10 - n); j <= Math.min(this.gridSize[1] - 1, n11 + n); ++j) {
                for (int k = Math.max(0, n12 - n); k <= Math.min(this.gridSize[2] - 1, n13 + n); ++k) {
                    if (this.grid[i][j][k] == null) continue;
                    treeSet.addAll(this.grid[i][j][k]);
                }
            }
        }
        return treeSet;
    }

    public int getClosestNeighbour(Coordinates coordinates, double d) {
        Set<Integer> set = this.getNeighbours(coordinates, d);
        int n = -1;
        double d2 = d;
        for (int n2 : set) {
            double d3 = this.mol.getCoordinates(n2).distanceSquared(coordinates);
            if (!(d3 < d2)) continue;
            n = n2;
            d2 = d3;
        }
        return n;
    }

    public void updateGrid(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            int n;
            int n2;
            int n3 = (int)((stereoMolecule.getAtomX(i) - this.min.x) / this.gridWidth);
            if (this.grid[n3][n2 = (int)((stereoMolecule.getAtomY(i) - this.min.y) / this.gridWidth)][n = (int)((stereoMolecule.getAtomZ(i) - this.min.z) / this.gridWidth)] == null) {
                this.grid[n3][n2][n] = new TreeSet<Integer>();
            }
            if (this.grid[n3][n2][n].contains(i)) continue;
            this.removeAtom(i);
            this.grid[n3][n2][n].add(i);
        }
    }

    private void removeAtom(int n) {
        int n2 = Math.max(0, this.gridSize[0]);
        int n3 = Math.max(0, this.gridSize[1]);
        int n4 = Math.max(0, this.gridSize[2]);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = 0;
                while (n5 < n4) {
                    if (this.grid[i][n5][n5].contains(n)) {
                        this.grid[i][n5][n5].remove(n);
                    }
                    ++n4;
                }
            }
        }
    }

    public Set<Integer> getNeighbours(Molecule molecule, int n, double d) {
        return this.getNeighbours(molecule, n, d, false);
    }

    public Set<Integer> getNeighbours(Molecule molecule, int n, double d, boolean bl) {
        Set<Integer> set = this.getNeighbours(molecule.getCoordinates(n), d, bl);
        set.remove(n);
        return set;
    }

    public int[] getGridCoordinates(Coordinates coordinates) {
        int[] nArray = new int[]{(int)((coordinates.x - this.min.x) / this.gridWidth), (int)((coordinates.y - this.min.y) / this.gridWidth), (int)((coordinates.z - this.min.z) / this.gridWidth)};
        return nArray;
    }

    public Coordinates getCartCoordinates(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        Coordinates coordinates = new Coordinates();
        coordinates.x = this.min.x + (double)n * this.gridWidth;
        coordinates.y = this.min.y + (double)n2 * this.gridWidth;
        coordinates.z = this.min.z + (double)n3 * this.gridWidth;
        return coordinates;
    }

    public int[] getGridSize() {
        return this.gridSize;
    }
}

