/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.converter;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

public class AminoAcidLabeled {
    private StereoMolecule mol;
    private String name;
    private String abbreviation;

    public AminoAcidLabeled(StereoMolecule stereoMolecule, String string, String string2) {
        this.mol = stereoMolecule;
        this.name = string;
        this.abbreviation = string2;
    }

    public Molecule3D createResidue(Map<String, AtomRecord> map) {
        Molecule3D molecule3D;
        Molecule3D molecule3D2 = new Molecule3D(this.mol);
        try {
            if (this.mol.getAtoms() - map.size() != 1) {
                throw new RuntimeException();
            }
            IntStream.range(0, this.mol.getAtoms()).forEach(n -> {
                Optional<String> optional = Optional.ofNullable(this.mol.getAtomCustomLabel(n));
                StringBuilder stringBuilder = new StringBuilder(optional.orElse(" "));
                stringBuilder.setCharAt(0, this.mol.getAtomLabel(n).charAt(0));
                AtomRecord atomRecord = (AtomRecord)map.get(stringBuilder.toString());
                Coordinates coordinates = new Coordinates(atomRecord.getX(), atomRecord.getY(), atomRecord.getZ());
                molecule3D2.setAtomName(n, atomRecord.getAtomName());
                molecule3D2.setAtomAmino(n, atomRecord.getResName());
                molecule3D2.setAtomSequence(n, atomRecord.getSerialId());
                molecule3D2.setResSequence(n, atomRecord.getResNum());
                molecule3D2.setAtomAmino(n, atomRecord.getResName());
                molecule3D2.setAtomChainId(n, atomRecord.getChainID());
                molecule3D2.setAtomX(n, coordinates.x);
                molecule3D2.setAtomY(n, coordinates.y);
                molecule3D2.setAtomZ(n, coordinates.z);
            });
            molecule3D = molecule3D2;
        }
        catch (Exception exception) {
            molecule3D = null;
        }
        return molecule3D;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AminoAcidLabeled{");
        stringBuilder.append("name='").append(this.name).append('\'');
        stringBuilder.append(", abbreviation='").append(this.abbreviation).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

