/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.DWARFileParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;

public class DWARFileCreator {
    private BufferedWriter mWriter;
    private DWARFileParser mMasterCopyParser;
    private String[] mRow;
    private ArrayList<String> mColumnTitleList;
    private TreeMap<Integer, Properties> mColumnPropertiesMap;

    public DWARFileCreator(BufferedWriter bufferedWriter) {
        this.mWriter = bufferedWriter;
        this.mColumnTitleList = new ArrayList();
    }

    public void setMasterCopy(DWARFileParser dWARFileParser) {
        this.mMasterCopyParser = dWARFileParser;
        ArrayList<String> arrayList = this.mMasterCopyParser.getHeadOrTail();
        for (String string : arrayList.get(arrayList.size() - 1).split("\\t")) {
            this.mColumnTitleList.add(string);
        }
    }

    public int addStructureColumn(String string, String string2) {
        int n = this.mColumnTitleList.size();
        String string3 = this.makeUnique(string);
        this.mColumnTitleList.add(string3);
        this.addColumnProperty(n, "specialType", "idcode");
        if (string2 != null) {
            this.addColumnProperty(n, "idColumn", string2);
        }
        return n;
    }

    public int add2DCoordinatesColumn(int n) {
        return this.addStructureChildColumn("idcoordinates2D", "idcoordinates2D", n);
    }

    public int add3DCoordinatesColumn(String string, int n) {
        return this.addStructureChildColumn("idcoordinates3D", string, n);
    }

    public int addDescriptorColumn(String string, String string2, int n) {
        int n2 = this.addStructureChildColumn(string, string, n);
        this.addColumnProperty(n2, "version", string2);
        return n2;
    }

    private int addStructureChildColumn(String string, String string2, int n) {
        int n2 = this.mColumnTitleList.size();
        this.mColumnTitleList.add(this.makeUnique(string2));
        this.addColumnProperty(n2, "parent", this.mColumnTitleList.get(n));
        this.addColumnProperty(n2, "specialType", string);
        return n2;
    }

    public int addAlphanumericalColumn(String string) {
        this.mColumnTitleList.add(this.makeUnique(string));
        return this.mColumnTitleList.size() - 1;
    }

    public void addColumnProperty(int n, String string, String string2) {
        Properties properties;
        if (this.mColumnPropertiesMap == null) {
            this.mColumnPropertiesMap = new TreeMap();
        }
        if ((properties = this.mColumnPropertiesMap.get(n)) == null) {
            properties = new Properties();
            this.mColumnPropertiesMap.put(n, properties);
        }
        properties.setProperty(string, string2);
    }

    public String[] getColumnTitles() {
        return this.mColumnTitleList.toArray(new String[0]);
    }

    public Properties getColumnProperties(String string) {
        if (this.mMasterCopyParser != null) {
            return this.mMasterCopyParser.getColumnProperties(string);
        }
        for (int i = 0; i < this.mColumnTitleList.size(); ++i) {
            if (!this.mColumnTitleList.get(i).equals(string)) continue;
            return this.mColumnPropertiesMap.get(i);
        }
        return null;
    }

    public void writeHeader(int n) throws IOException {
        if (this.mMasterCopyParser == null) {
            this.mWriter.write("<datawarrior-fileinfo>");
            this.mWriter.newLine();
            this.mWriter.write("<version=\"3.3\">");
            this.mWriter.newLine();
            if (n > 0) {
                this.mWriter.write("<rowcount=\"" + n + "\">");
                this.mWriter.newLine();
            }
            this.mWriter.write("</datawarrior-fileinfo>");
            this.mWriter.newLine();
            this.writeColumnPropertiesAndTitles();
        } else {
            for (String string : this.mMasterCopyParser.getHeadOrTail()) {
                if (string.trim().matches("<rowcount=\"\\d+\">")) {
                    if (n < 0) continue;
                    string = "<rowcount=\"" + n + "\">";
                }
                if (string.trim().matches("<created=\"\\d+\">")) {
                    string = "<created=\"" + System.currentTimeMillis() + "\">";
                }
                this.mWriter.write(string);
                this.mWriter.newLine();
            }
        }
        this.mRow = new String[this.mColumnTitleList.size()];
    }

    private void writeColumnPropertiesAndTitles() throws IOException {
        if (this.mColumnPropertiesMap != null) {
            this.mWriter.write("<column properties>");
            this.mWriter.newLine();
            for (int n : this.mColumnPropertiesMap.keySet()) {
                this.mWriter.write("<columnName=\"" + this.mColumnTitleList.get(n) + "\">");
                this.mWriter.newLine();
                Properties properties = this.mColumnPropertiesMap.get(n);
                for (String string : properties.stringPropertyNames()) {
                    String string2 = properties.getProperty(string);
                    this.mWriter.write("<columnProperty=\"" + string + "\t" + string2 + "\">");
                    this.mWriter.newLine();
                }
            }
            this.mWriter.write("</column properties>");
            this.mWriter.newLine();
        }
        boolean bl = true;
        for (int n = 0; n < this.mColumnTitleList.size(); ++n) {
            if (bl) {
                bl = false;
            } else {
                this.mWriter.write("\t");
            }
            this.mWriter.write(this.mColumnTitleList.get(n));
        }
        this.mWriter.newLine();
    }

    public void setRowStructure(StereoMolecule stereoMolecule, int n, int n2) {
        Canonizer canonizer = new Canonizer(stereoMolecule);
        this.mRow[n] = canonizer.getIDCode();
        this.mRow[n2] = canonizer.getEncodedCoordinates();
    }

    public void setRowStructure(String string, int n) {
        this.mRow[n] = string;
    }

    public void setRowCoordinates(String string, int n) {
        this.mRow[n] = string;
    }

    public void setRowValue(String string, int n) {
        string = string.replaceAll("\\r?\\n|\\r", "<NL>");
        this.mRow[n] = string = string.replace("\t", "<TAB>");
    }

    public void writeCurrentRow() throws IOException {
        boolean bl = true;
        for (int i = 0; i < this.mRow.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                this.mWriter.write("\t");
            }
            if (this.mRow[i] == null) continue;
            this.mWriter.write(this.mRow[i]);
            this.mRow[i] = null;
        }
        this.mWriter.newLine();
    }

    public void writeTemplate(ArrayList<String> arrayList) throws IOException {
        if (arrayList != null && arrayList.size() != 0) {
            this.mWriter.write("<datawarrior properties>");
            this.mWriter.newLine();
            for (String string : arrayList) {
                this.mWriter.write(string);
                this.mWriter.newLine();
            }
            this.mWriter.write("<datawarrior properties>");
            this.mWriter.newLine();
        }
    }

    public void writeEnd() throws IOException {
        if (this.mMasterCopyParser != null) {
            while (this.mMasterCopyParser.advanceToNext()) {
            }
            for (String string : this.mMasterCopyParser.getHeadOrTail()) {
                this.mWriter.write(string);
                this.mWriter.newLine();
            }
        }
        this.mWriter.close();
    }

    private String makeUnique(String string) {
        string = string == null || string.trim().length() == 0 ? "Column 1" : string.trim().replaceAll("[\\x00-\\x1F]", "_");
        while (this.columnNameExists(string)) {
            int n = string.lastIndexOf(32);
            if (n == -1) {
                string = string + " 2";
                continue;
            }
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n + 1) + (n2 + 1);
            }
            catch (NumberFormatException numberFormatException) {
                string = string + " 2";
            }
        }
        return string;
    }

    private boolean columnNameExists(String string) {
        for (String string2 : this.mColumnTitleList) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

