/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.CompoundFileFilter;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.chem.io.Mol2FileParser;
import com.actelion.research.chem.io.ODEFileParser;
import com.actelion.research.chem.io.RXNFileCreator;
import com.actelion.research.chem.io.SDFileParser;
import com.actelion.research.chem.moreparsers.CDXParser;
import com.actelion.research.chem.reaction.Reaction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;

public abstract class CompoundFileHelper {
    public static final int cFileTypeMask = 0x7FFFFF;
    public static final int cFileTypeDataWarrior = 1;
    public static final int cFileTypeDataWarriorTemplate = 2;
    public static final int cFileTypeDataWarriorQuery = 4;
    public static final int cFileTypeDataWarriorMacro = 8;
    public static final int cFileTypeTextTabDelimited = 16;
    public static final int cFileTypeTextCommaSeparated = 32;
    public static final int cFileTypeTextSemicolonSeparated = 64;
    public static final int cFileTypeTextVLineSeparated = 128;
    public static final int cFileTypeTextAnyCSV = 224;
    public static final int cFileTypeTextAny = 240;
    public static final int cFileTypeSDV3 = 256;
    public static final int cFileTypeSDV2 = 512;
    public static final int cFileTypeSD = 768;
    public static final int cFileTypeRXN = 1024;
    public static final int cFileTypeSOM = 2048;
    public static final int cFileTypeJPG = 4096;
    public static final int cFileTypeGIF = 8192;
    public static final int cFileTypePNG = 16384;
    public static final int cFileTypeSVG = 32768;
    public static final int cFileTypePictureFile = 61440;
    public static final int cFileTypeRDV3 = 65536;
    public static final int cFileTypeRDV2 = 131072;
    public static final int cFileTypeRD = 196608;
    public static final int cFileTypeMOL = 262144;
    public static final int cFileTypeMOL2 = 524288;
    public static final int cFileTypePDB = 0x100000;
    public static final int cFileTypeMMTF = 0x200000;
    public static final int cFileTypeProtein = 0x300000;
    public static final int cFileTypeSDGZ = 0x400000;
    public static final int cFileTypeUnknown = -1;
    public static final int cFileTypeDirectory = -2;
    public static final int cFileTypeCompoundFiles = 787201;
    public static final String cGZipExtention = ".gz";
    public static final int cFileTypeDataWarriorCompatibleData = 4391921;
    public static final int cFileTypeDataWarriorTemplateContaining = 7;
    private static File sCurrentDirectory;
    private int mRecordCount;
    private int mErrorCount;

    protected abstract String selectOption(String var1, String var2, String[] var3);

    protected abstract void selectOptionAsync(String var1, String var2, String[] var3, ActionListener var4);

    public abstract File selectFileToOpen(String var1, int var2);

    public abstract void selectFileToOpenAsync(String var1, int var2, Consumer<File> var3);

    public abstract String selectFileToSave(String var1, int var2, String var3);

    public abstract void showMessage(String var1);

    public static File getCurrentDirectory() {
        return sCurrentDirectory;
    }

    public static void setCurrentDirectory(File file) {
        sCurrentDirectory = file;
    }

    public ArrayList<StereoMolecule> readStructuresFromFile(boolean bl) {
        File file = this.selectFileToOpen("Please select a compound file", 787201);
        return file == null ? null : this.readStructuresFromFile(file, bl);
    }

    public void readStructuresFromFileAsync(boolean bl, Consumer<ArrayList<?>> consumer) {
        this.selectFileToOpenAsync("Please select a compound file", 787201, file -> {
            if (file == null) {
                consumer.accept(null);
            } else if (bl) {
                this.readStructuresFromFileAsync((File)file, true, consumer);
            } else {
                consumer.accept(this.readStructuresFromFile((File)file, false));
            }
        });
    }

    public ArrayList<StereoMolecule> readStructuresFromFile(File file, boolean bl) {
        if (file == null) {
            return this.readStructuresFromFile(bl);
        }
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        this.readChemObjectsFromFileAsync(file, arrayList, null, null, bl, false, null);
        return arrayList;
    }

    public void readStructuresFromFileAsync(File file, boolean bl, Consumer<ArrayList<?>> consumer) {
        if (file == null) {
            this.readStructuresFromFileAsync(bl, consumer);
        } else {
            this.readChemObjectsFromFileAsync(file, new ArrayList<StereoMolecule>(), null, null, bl, false, consumer);
        }
    }

    public ArrayList<String> readIDCodesFromFile() {
        File file = this.selectFileToOpen("Please select a compound file", 787201);
        return file == null ? null : this.readIDCodesFromFile(file);
    }

    public void readIDCodesFromFileAsync(Consumer<ArrayList<?>> consumer) {
        this.selectFileToOpenAsync("Please select a compound file", 787201, file -> {
            if (file == null) {
                consumer.accept(null);
            } else {
                this.readIDCodesFromFileAsync((File)file, consumer);
            }
        });
    }

    public ArrayList<String> readIDCodesFromFile(File file) {
        if (file == null) {
            return this.readIDCodesFromFile();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readChemObjectsFromFileAsync(file, null, arrayList, null, false, false, null);
        return arrayList;
    }

    public void readIDCodesFromFileAsync(File file, Consumer<ArrayList<?>> consumer) {
        if (file == null) {
            this.readIDCodesFromFileAsync(consumer);
            return;
        }
        this.readChemObjectsFromFileAsync(file, null, new ArrayList<String>(), null, false, false, consumer);
    }

    public ArrayList<String[]> readIDCodesWithNamesFromFile(boolean bl) {
        File file = this.selectFileToOpen("Please select substance file", 262913);
        return file == null ? null : this.readIDCodesWithNamesFromFile(file, bl);
    }

    public void readIDCodesWithNamesFromFileAsync(boolean bl, Consumer<ArrayList<?>> consumer) {
        this.selectFileToOpenAsync("Please select substance file", 262913, file -> {
            if (file == null) {
                consumer.accept(null);
                return;
            }
            this.readIDCodesWithNamesFromFileAsync((File)file, bl, consumer);
        });
    }

    public ArrayList<String[]> readIDCodesWithNamesFromFile(File file, boolean bl) {
        if (file == null) {
            return this.readIDCodesWithNamesFromFile(bl);
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.readChemObjectsFromFileAsync(file, null, null, arrayList, false, bl, null);
        return arrayList;
    }

    public void readIDCodesWithNamesFromFileAsync(File file, boolean bl, Consumer<ArrayList<?>> consumer) {
        if (file == null) {
            this.readIDCodesWithNamesFromFileAsync(bl, consumer);
            return;
        }
        this.readChemObjectsFromFileAsync(file, null, null, new ArrayList<String[]>(), false, bl, consumer);
    }

    private void readChemObjectsFromFileAsync(File file, ArrayList<StereoMolecule> arrayList, ArrayList<String> arrayList2, ArrayList<String[]> arrayList3, boolean bl, boolean bl2, Consumer<ArrayList<?>> consumer) {
        Object object;
        this.mRecordCount = 0;
        this.mErrorCount = 0;
        String string = file.getName();
        int n = string.lastIndexOf(46);
        String[] stringArray = n == -1 ? "" : string.substring(n).toLowerCase();
        CompoundFileParser compoundFileParser = null;
        StereoMolecule stereoMolecule = null;
        switch (stringArray) {
            case ".cdx": 
            case ".cdxml": {
                stereoMolecule = CDXParser.parseFile(file.getAbsolutePath());
                break;
            }
            case ".mol": 
            case ".mol2": {
                if (stringArray.equals(".mol")) {
                    stereoMolecule = new MolfileParser().getCompactMolecule(file);
                    break;
                }
                try {
                    stereoMolecule = new Mol2FileParser().load(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case ".sdf": {
                compoundFileParser = new SDFileParser(file);
                break;
            }
            case ".dwar": {
                compoundFileParser = new DWARFileParser(file);
                break;
            }
            case ".ode": {
                compoundFileParser = new ODEFileParser(file);
                break;
            }
            default: {
                compoundFileParser = null;
            }
        }
        if (stereoMolecule != null && stereoMolecule.getAllAtoms() > 0) {
            if (arrayList != null) {
                arrayList.add(stereoMolecule);
                if (consumer != null) {
                    consumer.accept(arrayList);
                }
                return;
            }
            object = new Canonizer(stereoMolecule);
            String string2 = ((Canonizer)object).getIDCode();
            String string3 = ((Canonizer)object).getEncodedCoordinates();
            if (string2 != null && string3.length() != 0 && bl2) {
                string2 = string2 + " " + string3;
            }
            if (arrayList2 != null) {
                arrayList2.add(string2);
                if (consumer != null) {
                    consumer.accept(arrayList2);
                }
                return;
            }
            String[] stringArray2 = new String[]{string2, stereoMolecule.getName()};
            arrayList3.add(stringArray2);
            if (consumer != null) {
                consumer.accept(arrayList3);
            }
            return;
        }
        if (compoundFileParser == null) {
            if (consumer != null) {
                consumer.accept(null);
            }
            return;
        }
        if (arrayList3 == null && !bl) {
            this.parseChemObjects(compoundFileParser, arrayList, arrayList2, arrayList3, -1, bl2);
            return;
        }
        object = compoundFileParser.getFieldNames();
        CompoundFileParser compoundFileParser2 = compoundFileParser;
        Consumer<Integer> consumer2 = arg_0 -> this.lambda$readChemObjectsFromFileAsync$3(compoundFileParser2, file, (String[])object, arrayList, arrayList2, arrayList3, bl2, consumer, arg_0);
        if (object == null || ((Object)object).length == 0) {
            consumer2.accept(-1);
            return;
        }
        this.selectOptionAsync("Select compound name or identifier", string, (String[])object, new ActionListener((String[])object, consumer2){
            final /* synthetic */ String[] val$fieldNames;
            final /* synthetic */ Consumer val$c;
            {
                this.val$fieldNames = stringArray;
                this.val$c = consumer;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = -1;
                if (string != null) {
                    for (int i = 0; i < this.val$fieldNames.length; ++i) {
                        if (!this.val$fieldNames[i].equals(string)) continue;
                        n = i;
                        break;
                    }
                }
                this.val$c.accept(n);
            }
        });
    }

    private void parseChemObjects(CompoundFileParser compoundFileParser, ArrayList<StereoMolecule> arrayList, ArrayList<String> arrayList2, ArrayList<String[]> arrayList3, int n, boolean bl) {
        if (compoundFileParser == null) {
            ++this.mErrorCount;
            return;
        }
        while (compoundFileParser.next()) {
            Object object;
            ++this.mRecordCount;
            boolean bl2 = false;
            if (arrayList != null) {
                object = compoundFileParser.getMolecule();
                if (object != null) {
                    if (n != -1) {
                        ((Molecule)object).setName(compoundFileParser.getFieldData(n));
                    }
                    arrayList.add((StereoMolecule)object);
                } else {
                    bl2 = true;
                }
            }
            if (arrayList2 != null || arrayList3 != null) {
                String string;
                object = compoundFileParser.getIDCode();
                if (object != null && bl && (string = compoundFileParser.getCoordinates()) != null) {
                    object = ((String)object).concat(" ").concat(string);
                }
                string = null;
                if (arrayList3 != null) {
                    string = compoundFileParser.getMoleculeName();
                    if (n != -1) {
                        string = compoundFileParser.getFieldData(n);
                    }
                }
                if (object != null) {
                    if (arrayList2 != null) {
                        arrayList2.add((String)object);
                    }
                    if (arrayList3 != null) {
                        String[] stringArray = new String[]{object, string};
                        arrayList3.add(stringArray);
                    }
                } else {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            ++this.mErrorCount;
        }
    }

    public int getRecordCount() {
        return this.mRecordCount;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public static CompoundFileFilter createFileFilter(int n, boolean bl) {
        if (n == -2) {
            return new CompoundFileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            };
        }
        CompoundFileFilter compoundFileFilter = new CompoundFileFilter();
        if ((n & 1) != 0) {
            compoundFileFilter.addExtension("dwar");
            if (!bl) {
                compoundFileFilter.addExtension("ode");
            }
            compoundFileFilter.addDescription("DataWarrior data files");
        }
        if ((n & 2) != 0) {
            compoundFileFilter.addExtension("dwat");
            if (!bl) {
                compoundFileFilter.addExtension("odt");
            }
            compoundFileFilter.addDescription("DataWarrior template files");
        }
        if ((n & 4) != 0) {
            compoundFileFilter.addExtension("dwaq");
            if (!bl) {
                compoundFileFilter.addExtension("odq");
            }
            compoundFileFilter.addDescription("DataWarrior query files");
        }
        if ((n & 8) != 0) {
            compoundFileFilter.addExtension("dwam");
            compoundFileFilter.addDescription("DataWarrior macro files");
        }
        if ((n & 0x10) != 0) {
            compoundFileFilter.addExtension("tsv");
            compoundFileFilter.addExtension("txt");
            compoundFileFilter.addDescription("TAB delimited text files");
        }
        if ((n & 0xE0) != 0) {
            compoundFileFilter.addExtension("csv");
            compoundFileFilter.addDescription("Comma [,;|] separated text files");
        }
        if ((n & 0x400) != 0) {
            compoundFileFilter.addExtension("rxn");
            compoundFileFilter.addDescription("MDL reaction files");
        }
        if ((n & 0x300) != 0) {
            compoundFileFilter.addExtension("sdf");
            compoundFileFilter.addDescription("MDL SD-files");
        }
        if ((n & 0x400000) != 0) {
            compoundFileFilter.addExtension("sdf.gz");
            compoundFileFilter.addDescription("gzipped MDL SD-files)");
        }
        if ((n & 0x30000) != 0) {
            compoundFileFilter.addExtension("rdf");
            compoundFileFilter.addDescription("MDL RD-files");
        }
        if ((n & 0x800) != 0) {
            compoundFileFilter.addExtension("dwas");
            if (!bl) {
                compoundFileFilter.addExtension("som");
            }
            compoundFileFilter.addDescription("DataWarrior self organized map");
        }
        if ((n & 0x1000) != 0) {
            compoundFileFilter.addExtension("jpg");
            compoundFileFilter.addExtension("jpeg");
            compoundFileFilter.addDescription("JPEG image files");
        }
        if ((n & 0x2000) != 0) {
            compoundFileFilter.addExtension("gif");
            compoundFileFilter.addDescription("GIF image files");
        }
        if ((n & 0x4000) != 0) {
            compoundFileFilter.addExtension("png");
            compoundFileFilter.addDescription("PNG image files");
        }
        if ((n & 0x8000) != 0) {
            compoundFileFilter.addExtension("svg");
            compoundFileFilter.addDescription("scalable vector graphics files");
        }
        if (n == 4391921) {
            compoundFileFilter.setDescription("DataWarrior compatible files");
        }
        if (n == 7) {
            compoundFileFilter.setDescription("Files containing a DataWarrior template");
        }
        if (n == 61440) {
            compoundFileFilter.setDescription("Image files");
        }
        if ((n & 0x100000) != 0) {
            compoundFileFilter.addExtension("pdb");
            compoundFileFilter.addDescription("Protein Data Bank files");
        }
        if ((n & 0x200000) != 0) {
            compoundFileFilter.addExtension("mmtf");
            compoundFileFilter.addDescription("Binary Protein Data Bank files");
        }
        if ((n & 0x40000) != 0) {
            compoundFileFilter.addExtension("mol");
            compoundFileFilter.addDescription("MDL Molfiles");
        }
        if ((n & 0x80000) != 0) {
            compoundFileFilter.addExtension("mol2");
            compoundFileFilter.addDescription("Tripos Mol2 files");
        }
        return compoundFileFilter;
    }

    public static String getExtension(File file) {
        String string;
        int n = -1;
        String string2 = string = file == null ? null : file.getName();
        if (string != null) {
            n = CompoundFileHelper.getExtensionIndex(string);
        }
        return n == -1 ? null : string.substring(n + 1).toLowerCase();
    }

    private static int getExtensionIndex(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1 && string.substring(n).equalsIgnoreCase(cGZipExtention)) {
            n = string.lastIndexOf(46, n - 1);
        }
        return n > 0 && n < string.length() - 1 ? n : -1;
    }

    public static String removePathAndExtension(String string) {
        int n;
        int n2 = string.lastIndexOf(File.separatorChar);
        int n3 = n = CompoundFileHelper.getFileType(string) != -1 ? CompoundFileHelper.getExtensionIndex(string) : -1;
        if (n2 == -1) {
            return n == -1 ? string : string.substring(0, n);
        }
        return n == -1 || n < n2 ? string.substring(n2 + 1) : string.substring(n2 + 1, n);
    }

    public static String removeExtension(String string) {
        int n = CompoundFileHelper.getFileType(string) != -1 ? string.lastIndexOf(46) : -1;
        return n == -1 ? string : string.substring(0, n);
    }

    public static int getFileType(String string) {
        int n = CompoundFileHelper.getExtensionIndex(string);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(n).toLowerCase();
        if (string2.equals(".dwar") || string2.equals(".ode")) {
            return 1;
        }
        if (string2.equals(".dwat") || string2.equals(".odt")) {
            return 2;
        }
        if (string2.equals(".dwaq") || string2.equals(".odq")) {
            return 4;
        }
        if (string2.equals(".dwas") || string2.equals(".som")) {
            return 2048;
        }
        if (string2.equals(".dwam")) {
            return 8;
        }
        if (string2.equals(".txt") || string2.equals(".tsv")) {
            return 16;
        }
        if (string2.equals(".csv")) {
            return 224;
        }
        if (string2.equals(".sdf")) {
            return 768;
        }
        if (string2.equals(".sdf.gz")) {
            return 0x400000;
        }
        if (string2.equals(".rdf")) {
            return 196608;
        }
        if (string2.equals(".rxn")) {
            return 1024;
        }
        if (string2.equals(".jpg") || string2.equals(".jpeg")) {
            return 4096;
        }
        if (string2.equals(".gif")) {
            return 8192;
        }
        if (string2.equals(".png")) {
            return 16384;
        }
        if (string2.equals(".svg")) {
            return 32768;
        }
        if (string2.equals(".mol")) {
            return 262144;
        }
        if (string2.equals(".mol2")) {
            return 524288;
        }
        if (string2.equals(".pdb")) {
            return 0x100000;
        }
        if (string2.equals(".mmtf")) {
            return 0x200000;
        }
        return -1;
    }

    public ArrayList<String> getExtensionList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 1;
        while ((n2 & 0x7FFFFF) != 0) {
            if ((n2 & n) != 0) {
                for (String string : CompoundFileHelper.getExtensions(n2)) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            n2 <<= 1;
        }
        return arrayList;
    }

    public static String getExtension(int n) {
        String[] stringArray = CompoundFileHelper.getExtensions(n);
        return stringArray.length == 0 ? "" : stringArray[0];
    }

    public static String[] getExtensions(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 1: {
                arrayList.add(".dwar");
                break;
            }
            case 4: {
                arrayList.add(".dwaq");
                break;
            }
            case 2: {
                arrayList.add(".dwat");
                break;
            }
            case 8: {
                arrayList.add(".dwam");
                break;
            }
            case 16: {
                arrayList.add(".txt");
                arrayList.add(".tsv");
                break;
            }
            case 32: 
            case 64: 
            case 128: 
            case 224: {
                arrayList.add(".csv");
                break;
            }
            case 256: 
            case 512: 
            case 768: {
                arrayList.add(".sdf");
                break;
            }
            case 65536: 
            case 131072: 
            case 196608: {
                arrayList.add(".rdf");
                break;
            }
            case 1024: {
                arrayList.add(".rxn");
                break;
            }
            case 2048: {
                arrayList.add(".dwas");
                break;
            }
            case 4096: {
                arrayList.add(".jpeg");
                arrayList.add(".jpg");
                break;
            }
            case 8192: {
                arrayList.add(".gif");
                break;
            }
            case 16384: {
                arrayList.add(".png");
                break;
            }
            case 32768: {
                arrayList.add(".svg");
                break;
            }
            case 262144: {
                arrayList.add(".mol");
                break;
            }
            case 524288: {
                arrayList.add(".mol2");
                break;
            }
            case 0x100000: {
                arrayList.add(".pdb");
                break;
            }
            case 0x200000: {
                arrayList.add(".mmtf");
                break;
            }
            case 0x400000: {
                arrayList.add(".sdf.gz");
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void saveRXNFile(Reaction reaction) {
        String string = this.selectFileToSave("Select reaction file", 1024, "Untitled Reaction");
        if (string != null) {
            String string2 = ".rxn";
            int n = string.lastIndexOf(46);
            int n2 = string.lastIndexOf(File.separator);
            if (n == -1 || n < n2) {
                string = string.concat(string2);
            } else if (!string.substring(n).equalsIgnoreCase(string2)) {
                this.showMessage("uncompatible file name extension.");
                return;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string)));
                new RXNFileCreator(reaction).writeRXNfile(bufferedWriter);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                this.showMessage("IOException: " + iOException);
            }
        }
    }

    private /* synthetic */ void lambda$readChemObjectsFromFileAsync$3(CompoundFileParser compoundFileParser, File file, String[] stringArray, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, boolean bl, Consumer consumer, Integer n) {
        this.parseChemObjects(compoundFileParser instanceof SDFileParser ? new SDFileParser(file, stringArray) : compoundFileParser, arrayList, arrayList2, arrayList3, n, bl);
        if (consumer != null) {
            consumer.accept(arrayList != null ? arrayList : (arrayList2 != null ? arrayList2 : arrayList3));
        }
    }
}

