/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Molecule3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractParser {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected List<String> errors = new ArrayList<String>();
    protected boolean optimize3D = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Molecule3D> loadGroup(String string) throws Exception {
        Reader reader = null;
        try {
            Object object;
            if (string.toUpperCase().endsWith(".GZ")) {
                object = new GZIPInputStream(new FileInputStream(string));
                reader = new InputStreamReader((InputStream)object);
            } else if (string.toUpperCase().endsWith(".ZIP")) {
                object = new ZipInputStream(new FileInputStream(string));
                reader = new InputStreamReader((InputStream)object);
            } else {
                reader = new BufferedReader(new FileReader(string));
            }
            object = this.loadGroup(string, reader, -1, -1);
            int n = 0;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                Molecule3D molecule3D = (Molecule3D)object2.next();
                ++n;
                if (molecule3D == null || molecule3D.getName() != null && molecule3D.getName().length() != 0) continue;
                molecule3D.setName(new File(string).getName() + (object.size() > 1 ? "#" + n : ""));
            }
            object2 = object;
            return object2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public List<Molecule3D> loadGroup(String string, Reader reader) throws Exception {
        return this.loadGroup(string, reader, -1, -1);
    }

    public abstract List<Molecule3D> loadGroup(String var1, Reader var2, int var3, int var4) throws Exception;

    public final Molecule3D load(File file) throws Exception {
        return this.load(file.getPath());
    }

    public final Molecule3D load(String string) throws Exception {
        List<Molecule3D> list = this.loadGroup(string);
        return list.size() > 0 ? list.get(0) : null;
    }

    public final Molecule3D load(String string, Reader reader) throws Exception {
        List<Molecule3D> list = this.loadGroup(string, reader, -1, -1);
        return list.size() > 0 ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(List<Molecule3D> list, String string) throws Exception {
        Writer writer = null;
        try {
            if (string.toUpperCase().endsWith(".GZ")) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(string));
                writer = new OutputStreamWriter(gZIPOutputStream);
            } else if (string.toUpperCase().endsWith(".ZIP")) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
                writer = new OutputStreamWriter(zipOutputStream);
            } else {
                writer = new BufferedWriter(new FileWriter(string));
            }
            this.save(list, writer);
            writer.close();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Molecule3D molecule3D, String string) throws Exception {
        Writer writer = null;
        try {
            if (string.toUpperCase().endsWith(".GZ")) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(string));
                writer = new OutputStreamWriter(gZIPOutputStream);
            } else if (string.toUpperCase().endsWith(".ZIP")) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
                writer = new OutputStreamWriter(zipOutputStream);
            } else {
                writer = new FileWriter(string);
            }
            this.save(molecule3D, writer);
            writer.close();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void save(Molecule3D molecule3D, Writer writer) throws Exception {
        throw new IllegalAccessError("Not implemented");
    }

    public void save(List<Molecule3D> list, Writer writer) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        if (list.size() != 1) {
            throw new IllegalAccessError("Cannot save more than one file in  this format");
        }
        this.save(list.get(0), writer);
    }

    public static final void convertDataToPrimitiveTypes(List<Molecule3D> list) {
        if (list.size() == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Molecule3D object : list) {
            hashSet.addAll(object.getAuxiliaryInfos().keySet());
        }
        block5: for (String string : hashSet) {
            int n = 0;
            String string2 = "";
            for (Molecule3D molecule3D : list) {
                Object object = molecule3D.getAuxiliaryInfos().get(string);
                if (object == null) continue;
                if (!(object instanceof String)) continue block5;
                string2 = (String)object;
                if (n == 0) {
                    try {
                        Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
                if (n == 1) {
                    try {
                        Double.parseDouble(string2);
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
                if (n != 2) continue;
                break;
            }
            if (n == 0) {
                for (Molecule3D molecule3D : list) {
                    string2 = (String)molecule3D.getAuxiliaryInfos().get(string);
                    if (string2 == null) continue;
                    molecule3D.getAuxiliaryInfos().put(string, Integer.parseInt((String)molecule3D.getAuxiliaryInfos().get(string)));
                }
                continue;
            }
            if (n != true) continue;
            for (Molecule3D molecule3D : list) {
                string2 = (String)molecule3D.getAuxiliaryInfos().get(string);
                if (string2 == null) continue;
                molecule3D.getAuxiliaryInfos().put(string, Double.parseDouble(string2));
            }
        }
    }

    protected static void writeR(Writer writer, String string, int n) throws IOException {
        if (string == null) {
            string = "";
        }
        int n2 = Math.max(0, n - string.length());
        for (int i = 0; i < n2; ++i) {
            writer.write(32);
        }
        writer.write(string);
    }

    protected static void writeL(Writer writer, String string, int n) throws IOException {
        if (string == null) {
            string = "";
        }
        writer.write(string);
        int n2 = Math.max(0, n - string.length());
        for (int i = 0; i < n2; ++i) {
            writer.write(32);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected static boolean is3D(Molecule3D molecule3D) {
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!(Math.abs(molecule3D.getAtomZ(i)) > 0.1)) continue;
            return true;
        }
        return false;
    }

    public void setOptimize3D(boolean bl) {
        this.optimize3D = bl;
    }

    public boolean isOptimize3D() {
        return this.optimize3D;
    }
}

