/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.hyperspace;

import com.actelion.research.chem.StructureSearchDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class BitSetTree
implements Serializable {
    private static final long serialVersionUID = 2219385776457978215L;
    Node root;
    private static Random random = new Random();

    BitSetTree(Node node) {
        this.root = node;
    }

    public boolean testSubset(BitSet bitSet, Node[] nodeArray) {
        return this.root.testSubset(bitSet, nodeArray);
    }

    public static BitSetTree createTree(Collection<BitSetWithRow> collection, int n, int n2, int n3) {
        Node node = BitSetTree.split_recursively(collection, new BitSet(n), new BitSet(n), n, n2, "r", n3);
        return new BitSetTree(node);
    }

    public static BitSetTree createTree(Collection<BitSetWithRow> collection, int n, int n2) {
        Node node = BitSetTree.split_recursively(collection, new BitSet(n), new BitSet(n), n, n2, "r");
        return new BitSetTree(node);
    }

    public static Node split_recursively(Collection<BitSetWithRow> collection, BitSet bitSet, BitSet bitSet2, int n, int n2, String string) {
        return BitSetTree.split_recursively(collection, bitSet, bitSet2, n, n2, string, 20);
    }

    public static Node split_recursively(Collection<BitSetWithRow> collection, BitSet bitSet, BitSet bitSet2, int n, int n2, String string, int n3) {
        if (collection.size() <= n2) {
            return new Node(-1, bitSet, bitSet2, null, null, new ArrayList<BitSetWithRow>(collection));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, random);
        double d = 0.0;
        int n4 = -1;
        for (int i = 0; i < Math.min(arrayList.size(), n3); ++i) {
            int n5 = (Integer)arrayList.get(i);
            int n6 = 0;
            for (BitSetWithRow object2 : collection) {
                n6 += object2.bitset.get(n5) ? 1 : 0;
            }
            double d2 = 1.0 * (double)n6 / (double)collection.size();
            double bitSet5 = Math.min(d2, 1.0 - d2);
            if (bitSet5 > d) {
                n4 = n5;
                d = bitSet5;
            }
            if (d > 0.42) break;
        }
        if (n4 < 0) {
            System.out.println("wut?");
        } else {
            System.out.println("SplitScore: " + d + "  (Size=" + collection.size() + ",level=" + (bitSet.cardinality() + bitSet2.cardinality()) + ")");
        }
        ArrayList<BitSetWithRow> arrayList2 = new ArrayList<BitSetWithRow>();
        ArrayList<BitSetWithRow> arrayList3 = new ArrayList<BitSetWithRow>();
        for (BitSetWithRow bitSetWithRow : collection) {
            if (bitSetWithRow.bitset.get(n4)) {
                arrayList3.add(bitSetWithRow);
                continue;
            }
            arrayList2.add(bitSetWithRow);
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        BitSet bitSet4 = (BitSet)bitSet2.clone();
        BitSet bitSet5 = (BitSet)bitSet.clone();
        BitSet bitSet6 = (BitSet)bitSet2.clone();
        bitSet3.set(n4, true);
        bitSet6.set(n4, true);
        Node node = BitSetTree.split_recursively(arrayList2, bitSet3, bitSet4, n, n2, string + "_0");
        Node node2 = BitSetTree.split_recursively(arrayList3, bitSet5, bitSet6, n, n2, string + "_1");
        return new Node(n4, bitSet, bitSet2, node, node2, null);
    }

    public static boolean isSet(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        if (n2 >= byArray.length) {
            return false;
        }
        return (byArray[n2] >> n3 & 1) == 1;
    }

    private void collectNodes_dfs(Node node, List<Node> list) {
        list.add(node);
        if (node.left != null) {
            this.collectNodes_dfs(node.left, list);
        }
        if (node.right != null) {
            this.collectNodes_dfs(node.right, list);
        }
    }

    public static BitSetTree createFromStructureSearchDataSource(StructureSearchDataSource structureSearchDataSource, String string, int n) {
        return BitSetTree.createFromStructureSearchDataSource(structureSearchDataSource, string, n, 512, 40);
    }

    public static BitSetTree createFromStructureSearchDataSource(StructureSearchDataSource structureSearchDataSource, String string, int n, int n2, int n3) {
        int n4 = structureSearchDataSource.getDescriptorColumn(string);
        ArrayList<BitSetWithRow> arrayList = new ArrayList<BitSetWithRow>();
        for (int i = 0; i < structureSearchDataSource.getRowCount(); ++i) {
            arrayList.add(new BitSetWithRow(BitSet.valueOf((long[])structureSearchDataSource.getDescriptor(n4, i, 0, false)), i));
        }
        BitSetTree bitSetTree = BitSetTree.createTree(arrayList, n, n2, n3);
        return bitSetTree;
    }

    public static void test_bitsets2() {
        Cloneable cloneable;
        Random random = new Random();
        List<BitSetWithRow> list = BitSetTree.createRandomBitSetWithRow(random, 20000, 64, 0.6);
        BitSetTree bitSetTree = BitSetTree.createTree(new HashSet<BitSetWithRow>(list), 64, 8);
        BitSet bitSet = new BitSet(64);
        bitSet.set(13);
        bitSet.set(17);
        bitSet.set(19);
        bitSet.set(27);
        ArrayList<BitSetWithRow> arrayList = new ArrayList<BitSetWithRow>();
        for (BitSetWithRow bitSetWithRow : list) {
            cloneable = (BitSet)bitSetWithRow.bitset.clone();
            ((BitSet)cloneable).or(bitSet);
            if (!((BitSet)cloneable).equals(bitSetWithRow.bitset)) continue;
            arrayList.add(bitSetWithRow);
        }
        Node[] nodeArray = new Node[1];
        boolean bl = bitSetTree.testSubset(bitSet, nodeArray);
        cloneable = new ArrayList();
        bitSetTree.root.collectSuperSets(bitSet, (List<BitSet>)((Object)cloneable));
        if (cloneable.size() == arrayList.size()) {
            System.out.println("ok");
        } else {
            System.out.println("not ok");
        }
    }

    public static void test_fetch_supersets() {
        Random random = new Random();
        List<BitSetWithRow> list = BitSetTree.createRandomBitSetWithRow(random, 64, 16, 0.6);
        BitSetTree bitSetTree = BitSetTree.createTree(new HashSet<BitSetWithRow>(list), 16, 2);
        BitSet bitSet = list.get((int)3).bitset;
        bitSet.set(bitSet.nextSetBit(0), 0);
        Node[] nodeArray = new Node[1];
        boolean bl = bitSetTree.testSubset(bitSet, nodeArray);
        if (bl) {
            System.out.println("ok");
        } else {
            System.out.println("ERROR.. not working :(");
        }
    }

    public static void test_benchmark_a() {
        Random random = new Random();
        int n = 2048;
        List<BitSetWithRow> list = BitSetTree.createRandomBitSetWithRow(random, 200000, n, 0.6);
        System.out.println("Create tree:");
        BitSetTree bitSetTree = BitSetTree.createTree(new HashSet<BitSetWithRow>(list), n, 64);
        System.out.println("Create tree: done!");
        List<BitSetWithRow> list2 = BitSetTree.createRandomBitSetWithRow(random, 1000, n, 0.12);
        System.out.println("Start eval:");
        long l = System.currentTimeMillis();
        for (BitSetWithRow bitSetWithRow : list2) {
            Node[] nodeArray = new Node[1];
            System.out.println(bitSetTree.testSubset(bitSetWithRow.bitset, nodeArray));
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time= " + (l2 - l));
    }

    public static void test_benchmark_b() {
        Random random = new Random();
        int n = 512;
        List<BitSetWithRow> list = BitSetTree.createRandomBitSetWithRow(random, 800000, n, 0.8);
        System.out.println("Create tree:");
        BitSetTree bitSetTree = BitSetTree.createTree(new HashSet<BitSetWithRow>(list), n, 100000);
        System.out.println("Create tree: done!");
        List<BitSetWithRow> list2 = BitSetTree.createRandomBitSetWithRow(random, 100, n, 0.3);
        System.out.println("Start eval:");
        long l = System.currentTimeMillis();
        for (int i = 0; i < list2.size(); ++i) {
            BitSetWithRow bitSetWithRow = list2.get(i);
            long l2 = System.currentTimeMillis();
            Object object = new SuperSetIterator(bitSetTree.root, bitSetWithRow.bitset);
            ArrayList<BitSetWithRow> arrayList = new ArrayList<BitSetWithRow>();
            for (int j = 0; j < 2000 && ((SuperSetIterator)object).hasNext(); ++j) {
                arrayList.add(((SuperSetIterator)object).next());
            }
            long l3 = System.currentTimeMillis();
            System.out.println(i + " -> Results: " + arrayList.size());
            System.out.println("Time A: " + (l3 - l2));
            l2 = System.currentTimeMillis();
            object = new ArrayList();
            bitSetTree.root.collectSuperSetsWithRows(bitSetWithRow.bitset, (List<BitSetWithRow>)object, 2000);
            long l4 = System.currentTimeMillis();
            System.out.println(i + " -> Results: " + object.size());
            System.out.println("Time B: " + (l4 - l2));
        }
        long l5 = System.currentTimeMillis();
        System.out.println("Time= " + (l5 - l));
    }

    public static List<BitSetWithRow> createRandomBitSetWithRow(Random random, int n, int n2, double d) {
        ArrayList<BitSetWithRow> arrayList = new ArrayList<BitSetWithRow>();
        for (int i = 0; i < n; ++i) {
            BitSet bitSet = new BitSet(n2);
            for (int j = 0; j < n2; ++j) {
                bitSet.set(j, (double)random.nextFloat() < d);
            }
            arrayList.add(new BitSetWithRow(bitSet, i));
        }
        return arrayList;
    }

    public static class SuperSetIterator
    implements Iterator<BitSetWithRow> {
        Node n = null;
        BitSet q = null;
        Iterator<BitSetWithRow> current_iterator = null;
        BitSetWithRow current_next = null;
        List<Node> remaining_childs = null;

        public SuperSetIterator(Node node, BitSet bitSet) {
            this.n = node;
            this.q = bitSet;
            if (!node.isLeaf()) {
                this.remaining_childs = new ArrayList<Node>();
                if (node.left != null) {
                    this.remaining_childs.add(node.left);
                }
                if (node.right != null) {
                    this.remaining_childs.add(node.right);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current_next == null) {
                this.tryToFindNext();
            }
            return this.current_next != null;
        }

        private void tryToFindNext() {
            if (this.current_next != null) {
                return;
            }
            if (this.n.isLeaf()) {
                if (this.current_iterator == null) {
                    this.current_iterator = this.n.leaf_data.iterator();
                }
                while (this.current_iterator.hasNext()) {
                    BitSetWithRow bitSetWithRow = this.current_iterator.next();
                    BitSet bitSet = (BitSet)bitSetWithRow.bitset.clone();
                    bitSet.or(this.q);
                    if (!bitSet.equals(bitSetWithRow.bitset)) continue;
                    this.current_next = bitSetWithRow;
                    return;
                }
                this.current_next = null;
                return;
            }
            if (this.current_iterator != null) {
                if (this.current_iterator.hasNext()) {
                    this.current_next = this.current_iterator.next();
                    return;
                }
                this.current_iterator = null;
            }
            while (this.current_next == null) {
                if (this.current_iterator != null) {
                    if (this.current_iterator.hasNext()) {
                        this.current_next = this.current_iterator.next();
                        return;
                    }
                    this.current_iterator = null;
                }
                if (this.current_iterator == null) {
                    if (this.remaining_childs.size() > 0) {
                        this.current_iterator = this.remaining_childs.remove(this.remaining_childs.size() - 1).getSuperSetIterator(this.q);
                    } else {
                        this.current_next = null;
                        return;
                    }
                }
                if (this.current_iterator.hasNext()) {
                    this.current_next = this.current_iterator.next();
                    return;
                }
                this.current_next = null;
            }
        }

        @Override
        public BitSetWithRow next() {
            BitSetWithRow bitSetWithRow = this.current_next;
            this.current_next = null;
            return bitSetWithRow;
        }
    }

    public static final class Node
    implements Serializable {
        public int bit;
        BitSet bits_1;
        BitSet bits_0;
        Node left = null;
        Node right = null;
        private List<BitSetWithRow> leaf_data = null;

        public Node(int n, BitSet bitSet, BitSet bitSet2, Node node, Node node2, List<BitSetWithRow> list) {
            this.bit = n;
            this.bits_0 = bitSet;
            this.bits_1 = bitSet2;
            this.left = node;
            this.right = node2;
            this.leaf_data = list;
        }

        public boolean isLeaf() {
            return this.bit < 0;
        }

        public void setLeft(Node node) {
            this.left = node;
        }

        public void setRight(Node node) {
            this.right = node;
        }

        public int depth() {
            return this.bits_0.cardinality() + this.bits_1.cardinality();
        }

        public List<BitSetWithRow> getLeafData() {
            if (this.leaf_data != null) {
                return this.leaf_data;
            }
            return null;
        }

        public boolean testSubset(BitSet bitSet, Node[] nodeArray) {
            nodeArray[0] = null;
            if (this.bit < 0) {
                List<BitSetWithRow> list = this.getLeafData();
                if (list.isEmpty()) {
                    return false;
                }
                boolean bl = true;
                for (BitSetWithRow bitSetWithRow : list) {
                    BitSet bitSet2 = (BitSet)bitSetWithRow.bitset.clone();
                    bitSet2.or(bitSet);
                    if (!bitSet2.equals(bitSetWithRow.bitset)) continue;
                    nodeArray[0] = this;
                    return true;
                }
                return false;
            }
            BitSet bitSet3 = (BitSet)this.bits_1.clone();
            bitSet3.or(bitSet);
            if (bitSet3.equals(this.bits_1)) {
                nodeArray[0] = this;
                return true;
            }
            if (bitSet.get(this.bit)) {
                return this.right.testSubset(bitSet, nodeArray);
            }
            return this.right.testSubset(bitSet, nodeArray) || this.left.testSubset(bitSet, nodeArray);
        }

        public int[] filterRows(long[] lArray, int n) {
            ArrayList<BitSetWithRow> arrayList = new ArrayList<BitSetWithRow>();
            this.collectSuperSetsWithRows(BitSet.valueOf(lArray), arrayList, n);
            int[] nArray = arrayList.stream().mapToInt(bitSetWithRow -> bitSetWithRow.row).toArray();
            return nArray;
        }

        public void collectSuperSetsWithRows(BitSet bitSet, List<BitSetWithRow> list, int n) {
            if (list.size() >= n) {
                return;
            }
            if (this.isLeaf()) {
                long l = System.currentTimeMillis();
                List<BitSetWithRow> list2 = this.getLeafData();
                for (BitSetWithRow bitSetWithRow : list2) {
                    BitSet bitSet2 = (BitSet)bitSetWithRow.bitset.clone();
                    bitSet2.or(bitSet);
                    if (!bitSet2.equals(bitSetWithRow.bitset)) continue;
                    list.add(bitSetWithRow);
                }
                long l2 = System.currentTimeMillis();
            } else if (bitSet.get(this.bit)) {
                this.right.collectSuperSetsWithRows(bitSet, list, n);
            } else {
                this.left.collectSuperSetsWithRows(bitSet, list, n);
                this.right.collectSuperSetsWithRows(bitSet, list, n);
            }
        }

        public void collectSuperSets(BitSet bitSet, List<BitSet> list) {
            if (this.bit < 0) {
                List<BitSetWithRow> list2 = this.getLeafData();
                for (BitSetWithRow bitSetWithRow : list2) {
                    BitSet bitSet2 = (BitSet)bitSetWithRow.bitset.clone();
                    bitSet2.or(bitSet);
                    if (!bitSet2.equals(bitSetWithRow.bitset)) continue;
                    list.add(bitSetWithRow.bitset);
                }
            } else if (bitSet.get(this.bit)) {
                this.right.collectSuperSets(bitSet, list);
            } else {
                this.left.collectSuperSets(bitSet, list);
                this.right.collectSuperSets(bitSet, list);
            }
        }

        public boolean checkAllAreSuperset(BitSet bitSet) {
            if (this.bit < 0) {
                BitSet bitSet2 = (BitSet)this.bits_1.clone();
                bitSet2.or(bitSet);
                boolean bl = bitSet2.equals(this.bits_1);
                if (bl) {
                    return true;
                }
                bl = true;
                for (BitSetWithRow bitSetWithRow : this.leaf_data) {
                    BitSet bitSet3 = bitSetWithRow.bitset;
                    bitSet2 = (BitSet)bitSet3.clone();
                    bitSet2.or(bitSet);
                    if (bitSet2.equals(bitSet3)) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
            if (bitSet.get(this.bit)) {
                if (this.left == null) {
                    return true;
                }
                BitSet bitSet4 = new BitSet(bitSet.size());
                return !this.left.getSuperSetIterator(bitSet4).hasNext();
            }
            return this.right.checkAllAreSuperset(bitSet) && this.left.checkAllAreSuperset(bitSet);
        }

        public SuperSetIterator getSuperSetIterator(BitSet bitSet) {
            return new SuperSetIterator(this, bitSet);
        }

        public int countAll() {
            if (this.isLeaf()) {
                List<BitSetWithRow> list = this.getLeafData();
                return list.size();
            }
            int n = this.left != null ? this.left.countAll() : 0;
            int n2 = this.right != null ? this.right.countAll() : 0;
            return n + n2;
        }
    }

    public static class BitSetWithRow {
        public final BitSet bitset;
        public final int row;

        public BitSetWithRow(BitSet bitSet, int n) {
            this.bitset = bitSet;
            this.row = n;
        }
    }
}

