/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.forcefield.mmff.BadAtomTypeException;
import com.actelion.research.chem.forcefield.mmff.BadRingAromException;
import com.actelion.research.chem.forcefield.mmff.RingBoolean;
import com.actelion.research.chem.forcefield.mmff.type.Atom;

public final class MMFFMolecule
extends StereoMolecule {
    private RingBoolean[] mRingArom;
    private int[] mAtomTypes;
    private int[] mHydrogenMap = this.getHandleHydrogenMap();

    public MMFFMolecule(StereoMolecule stereoMolecule) throws BadAtomTypeException, BadRingAromException {
        super(stereoMolecule);
        int n;
        int n2;
        RingCollection ringCollection = this.getRingSet();
        this.mRingArom = new RingBoolean[ringCollection.getSize()];
        for (n2 = 0; n2 < this.mRingArom.length; ++n2) {
            this.mRingArom[n2] = RingBoolean.NOT_SET;
        }
        n2 = 0;
        boolean bl = true;
        while (n2 == 0 && bl) {
            n2 = 1;
            bl = false;
            for (n = 0; n < ringCollection.getSize(); ++n) {
                if (this.mRingArom[n] == RingBoolean.NOT_SET) {
                    this.mRingArom[n] = Atom.ringIsMMFFAromatic(this, n);
                    if (this.mRingArom[n] != RingBoolean.NOT_SET) {
                        bl = true;
                    }
                }
                if (this.mRingArom[n] != RingBoolean.NOT_SET) continue;
                n2 = 0;
            }
        }
        if (n2 == 0) {
            throw new BadRingAromException();
        }
        this.mAtomTypes = new int[this.getAllAtoms()];
        for (n = 0; n < this.mAtomTypes.length; ++n) {
            this.mAtomTypes[n] = -1;
            this.mAtomTypes[n] = Atom.getType(this, n);
            if (this.mAtomTypes[n] != 0) continue;
            throw new BadAtomTypeException("Couldn't assign an atom type to atom " + n + " (" + this.getAtomLabel(n) + ")");
        }
    }

    public int getAtomType(int n) {
        return this.mAtomTypes[n];
    }

    public int[] getHydrogenMap() {
        return this.mHydrogenMap;
    }

    public boolean ringIsMMFFAromatic(int n) {
        return this.mRingArom[n] == RingBoolean.TRUE;
    }

    public boolean isSetRingMMFFAromaticity(int n) {
        return this.mRingArom[n] != RingBoolean.NOT_SET;
    }
}

