/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import java.util.ArrayList;
import java.util.List;

public class BondStretch
implements EnergyTerm {
    public final int a1;
    public final int a2;
    public final double kb;
    public final double r0;

    public BondStretch(Tables tables, MMFFMolecule mMFFMolecule, int n) {
        this(tables, mMFFMolecule, mMFFMolecule.getBondAtom(0, n), mMFFMolecule.getBondAtom(1, n));
    }

    public BondStretch(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2) {
        this.a1 = n;
        this.a2 = n2;
        this.r0 = tables.bond.r0(mMFFMolecule, n, n2);
        this.kb = tables.bond.kb(mMFFMolecule, n, n2);
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = new Vector3(dArray, this.a1).distance(new Vector3(dArray, this.a2));
        double d2 = (d - this.r0) * (d - this.r0);
        return 71.96625 * this.kb * d2 * (1.0 + -2.0 * (d - this.r0) + 2.3333333333333335 * d2);
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        double d = new Vector3(dArray, this.a1).distance(new Vector3(dArray, this.a2));
        double d2 = d - this.r0;
        double d3 = 143.9325 * this.kb * d2 * (1.0 + -3.0 * d2 + 4.666666666666667 * d2 * d2);
        if (d > 0.0) {
            for (int i = 0; i < 3; ++i) {
                int n = 3 * this.a1 + i;
                dArray2[n] = dArray2[n] + d3 * (dArray[3 * this.a1 + i] - dArray[3 * this.a2 + i]) / d;
                int n2 = 3 * this.a2 + i;
                dArray2[n2] = dArray2[n2] - d3 * (dArray[3 * this.a1 + i] - dArray[3 * this.a2 + i]) / d;
            }
        }
    }

    public static List<BondStretch> findIn(Tables tables, MMFFMolecule mMFFMolecule) {
        ArrayList<BondStretch> arrayList = new ArrayList<BondStretch>();
        for (int i = 0; i < mMFFMolecule.getAllBonds(); ++i) {
            arrayList.add(new BondStretch(tables, mMFFMolecule, i));
        }
        return arrayList;
    }
}

