/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.scoring.idoscore.InteractionTerm;
import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ScoringTask {
    public static double calcScore(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray, int[] nArray2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<InteractionTerm> arrayList = new ArrayList<InteractionTerm>();
        MoleculeGrid moleculeGrid = new MoleculeGrid(stereoMolecule);
        for (int i = 0; i < stereoMolecule2.getAtoms(); ++i) {
            hashSet.addAll(moleculeGrid.getNeighbours(stereoMolecule2.getCoordinates(i), 6.0));
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (int i = 0; i < stereoMolecule2.getAtoms(); ++i) {
                Conformer conformer = new Conformer(stereoMolecule);
                Conformer object = new Conformer(stereoMolecule2);
                arrayList.add(InteractionTerm.create(conformer, object, n, i, nArray, nArray2));
            }
        }
        double d = 0.0;
        double[] dArray = new double[3 * stereoMolecule2.getAllAtoms()];
        for (InteractionTerm interactionTerm : arrayList) {
            if (interactionTerm == null) continue;
            d += interactionTerm.getFGValue(dArray);
        }
        return d;
    }

    public static double calcScore(StereoMolecule stereoMolecule, int n, Coordinates coordinates, int[] nArray) {
        double d = 0.0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        MoleculeGrid moleculeGrid = new MoleculeGrid(stereoMolecule);
        hashSet.addAll(moleculeGrid.getNeighbours(coordinates, 6.0));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            SplineFunction splineFunction = InteractionDistanceStatistics.getInstance().getFunction(nArray[n2], n);
            double d2 = coordinates.distance(stereoMolecule.getCoordinates(n2));
            d += splineFunction.getFGValue(d2)[0];
        }
        return d;
    }
}

